/*
 * Decompiled with CFR 0.152.
 */
package extdoc.jsdoc.util;

public class StringUtils {
    private static final String[] KEYWORDS = new String[]{"break", "continue", "do", "for", "import", "new", "\tthis", "void", "case", "default", "else", "function", "in", "return", "typeof", "while", "comment", "delete", "export", "if", "label", "switch", "var", "with"};

    public static ClsAttrName processLink(String str) {
        ClsAttrName res = new ClsAttrName();
        LinkStates state = LinkStates.CLS;
        int len = str.length();
        int start = 0;
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            switch (state) {
                case CLS: {
                    if (ch == '#') {
                        res.cls = str.substring(start, i);
                        start = i + 1;
                        state = LinkStates.ATTR;
                        break;
                    }
                    if (!Character.isWhitespace(ch)) break;
                    res.cls = str.substring(start, i);
                    start = i + 1;
                    state = LinkStates.SKIPWHITE;
                    break;
                }
                case ATTR: {
                    if (!Character.isWhitespace(ch)) break;
                    res.attr = str.substring(start, i);
                    state = LinkStates.SKIPWHITE;
                }
                case SKIPWHITE: {
                    if (Character.isWhitespace(ch)) break;
                    start = i;
                    state = LinkStates.NAME;
                }
            }
            if (state != LinkStates.NAME) continue;
            res.name = str.substring(start, len);
            break;
        }
        switch (state) {
            case CLS: {
                res.cls = str.substring(start, len);
                break;
            }
            case ATTR: {
                res.attr = str.substring(start, len);
            }
        }
        return res;
    }

    static String highlightQuotes(String str) {
        StringBuilder buffer = new StringBuilder();
        int len = str.length();
        boolean singleQuote = false;
        boolean doubleQuote = false;
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '\'') {
                buffer.append(singleQuote ? "'</em>" : "<em>'");
                singleQuote = !singleQuote;
                continue;
            }
            if (ch == '\"') {
                buffer.append(doubleQuote ? "\"</em>" : "<em>\"");
                doubleQuote = !doubleQuote;
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    private static boolean isKeyword(String word) {
        for (String key : KEYWORDS) {
            if (!key.equals(word)) continue;
            return true;
        }
        return false;
    }

    static String highlightKeywords(String str) {
        StringBuilder buffer = new StringBuilder();
        int len = str.length();
        boolean isPrevAlpha = false;
        int last = 0;
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            boolean isAlpha = Character.isLetter(ch);
            if (isAlpha != isPrevAlpha) {
                String word = str.substring(last, i);
                buffer.append(!isAlpha && StringUtils.isKeyword(word) ? "<b>" + word + "</b>" : word);
                last = i;
            }
            isPrevAlpha = isAlpha;
        }
        String word = str.substring(last, len);
        buffer.append(isPrevAlpha && StringUtils.isKeyword(word) ? "<b>" + word + "</b>" : word);
        return buffer.toString();
    }

    static String highlightComments(String str) {
        StringBuilder buffer = new StringBuilder();
        int len = str.length();
        boolean comment = false;
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (!comment && ch == '/' && i < len - 1 && str.charAt(i + 1) == '/') {
                buffer.append("<i>");
                comment = true;
            }
            if (comment && ch == '\n') {
                buffer.append("</i>");
                comment = false;
            }
            buffer.append(ch);
        }
        if (comment) {
            buffer.append("</i>");
        }
        return buffer.toString();
    }

    public static String highlight(String str) {
        return StringUtils.highlightQuotes(StringUtils.highlightKeywords(StringUtils.highlightComments(str)));
    }

    public static String processTokens(String input, String startToken, String endToken, TokenHandler handler) {
        StringBuilder buffer = new StringBuilder();
        int len = input.length();
        int slen = startToken.length();
        int elen = endToken.length();
        int last = 0;
        boolean token = false;
        for (int i = 0; i < len; ++i) {
            if (!token && i >= slen && input.substring(i - slen, i).equals(startToken)) {
                buffer.append(input.substring(last, i));
                last = i;
                token = true;
                continue;
            }
            if (!token || i < elen || !input.substring(i - elen, i).equals(endToken)) continue;
            buffer.append(handler.handle(input.substring(last, i - elen)));
            buffer.append(endToken);
            last = i;
            token = false;
        }
        String remain = input.substring(last, len);
        buffer.append(token ? handler.handle(remain) : remain);
        return buffer.toString();
    }

    public static String highlightCode(String str) {
        return StringUtils.processTokens(str, "<code>", "</code>", new TokenHandler(){

            @Override
            protected String handle(String content) {
                return StringUtils.highlight(content.trim());
            }
        });
    }

    public static boolean endsWith(StringBuilder sb, String str) {
        int strLen;
        int len = sb.length();
        return len >= (strLen = str.length()) && sb.substring(len - strLen).equals(str);
    }

    public static String[] separatePackage(String className) {
        String[] str = new String[2];
        String[] items = className.split("\\.");
        if (items.length == 1) {
            str[0] = "";
            str[1] = className;
        } else {
            StringBuilder pkg = new StringBuilder(items[0]);
            StringBuilder cls = new StringBuilder(items[items.length - 1]);
            for (int i = items.length - 2; i > 0; --i) {
                if (Character.isUpperCase(items[i].charAt(0))) {
                    cls.insert(0, '.');
                    cls.insert(0, items[i]);
                    continue;
                }
                for (int j = 1; j <= i; ++j) {
                    pkg.append('.');
                    pkg.append(items[j]);
                }
                break;
            }
            str[0] = pkg.toString();
            str[1] = cls.toString();
        }
        return str;
    }

    public static String[] separateByLastDot(String className) {
        int i;
        String[] str = new String[2];
        if (className == null) {
            return str;
        }
        int len = className.length();
        for (i = len - 1; i >= 0 && className.charAt(i) != '.'; --i) {
        }
        str[0] = i > 0 ? className.substring(0, i) : "";
        str[1] = className.substring(i + 1, len);
        return str;
    }

    public static String wildcardToRegex(String wildcard) {
        StringBuffer s = new StringBuffer(wildcard.length());
        s.append('^');
        int is = wildcard.length();
        block5: for (int i = 0; i < is; ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append(".*");
                    continue block5;
                }
                case '?': {
                    s.append(".");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    s.append("\\");
                    s.append(c);
                    continue block5;
                }
                default: {
                    s.append(c);
                }
            }
        }
        s.append('$');
        return s.toString();
    }

    public static class TokenHandler {
        protected String handle(String content) {
            return content;
        }
    }

    static enum LinkStates {
        CLS,
        ATTR,
        SKIPWHITE,
        NAME;

    }

    public static class ClsAttrName {
        public String cls = "";
        public String attr = "";
        public String name = "";
    }
}

