/*
 * Decompiled with CFR 0.152.
 */
package com.moxiecode.moxiedoc;

import com.moxiecode.moxiedoc.CommentBlock;
import com.moxiecode.moxiedoc.CommentParser;
import com.moxiecode.moxiedoc.IntelliSenseGenerator;
import com.moxiecode.moxiedoc.ParamTag;
import com.moxiecode.moxiedoc.ReturnTag;
import com.moxiecode.moxiedoc.SeeTag;
import com.moxiecode.moxiedoc.Tag;
import com.moxiecode.moxiedoc.util.XPathHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Processor {
    private int processedFileCount;
    private Vector<File> files = new Vector();
    private File outDir;
    private File msIntelliSenseFile;
    private Document doc;
    private File templateDir;
    private String title;
    private String eventClass;

    public void addFile(File file) {
        this.files.add(file);
    }

    public void setTemplateDir(File template_dir) {
        this.templateDir = template_dir;
    }

    public void setOutDir(File outdir) {
        this.outDir = outdir;
    }

    public void setMsIntelliSenseFile(File intelli_file) {
        this.msIntelliSenseFile = intelli_file;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setEventClass(String cls) {
        this.eventClass = cls;
    }

    public void process() throws XPathExpressionException, IOException, ParserConfigurationException, TransformerException, TransformerConfigurationException {
        CommentParser parser = new CommentParser();
        Vector<CommentBlock[]> blockArrays = new Vector<CommentBlock[]>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        this.doc = db.newDocument();
        this.doc.appendChild(this.doc.createElement("model"));
        this.processedFileCount = 0;
        for (File file : this.files) {
            CommentBlock[] blocks = parser.parse(file);
            blockArrays.add(blocks);
            this.addToXml(blocks);
            ++this.processedFileCount;
        }
        Iterator<Object> i$ = blockArrays.iterator();
        while (i$.hasNext()) {
            CommentBlock[] blocks;
            for (CommentBlock block : blocks = (CommentBlock[])i$.next()) {
                Element membersElm;
                Element targetElm;
                if (!block.hasTag("member")) continue;
                Element memberElm = this.buildMember(block);
                String memberOf = block.getTag("member").getText();
                if (memberElm == null) continue;
                Element nsElm = XPathHelper.findElement("//namespace[@fullname='" + memberOf + "']", this.doc);
                if (nsElm != null && nsElm.getAttribute("fullname").equals(memberOf)) {
                    memberElm.setAttribute("fullname", memberOf + "." + memberElm.getAttribute("name"));
                    Element membersElm2 = XPathHelper.findElement("members", nsElm);
                    if (membersElm2 == null) {
                        membersElm2 = (Element)nsElm.appendChild(this.doc.createElement("members"));
                    }
                    membersElm2.appendChild(memberElm);
                    continue;
                }
                Element classElm = XPathHelper.findElement("//class[@fullname='" + memberOf + "']", this.doc);
                if (classElm != null && classElm.getAttribute("fullname").equals(memberOf)) {
                    targetElm = XPathHelper.findElement("members", classElm);
                    if (targetElm == null) {
                        targetElm = (Element)classElm.appendChild(this.doc.createElement("members"));
                    }
                    if (classElm.hasAttribute("static")) {
                        memberElm.setAttribute("static", "true");
                    }
                    targetElm.appendChild(memberElm);
                    continue;
                }
                targetElm = this.doc.getDocumentElement();
                if (memberOf.length() > 0) {
                    memberElm.setAttribute("fullname", memberOf + "." + memberElm.getAttribute("name"));
                } else {
                    memberElm.setAttribute("fullname", memberElm.getAttribute("name"));
                }
                if (memberOf.length() > 0) {
                    targetElm = this.makeNameSpace(memberOf, false);
                }
                if ((membersElm = XPathHelper.findElement("members", targetElm)) == null) {
                    membersElm = (Element)targetElm.appendChild(this.doc.createElement("members"));
                }
                membersElm.appendChild(memberElm);
            }
        }
        for (Element classElm : XPathHelper.findElements("//class[@extends]", this.doc)) {
            Element superClassElm;
            Vector<String> superClasses = new Vector<String>();
            if (!classElm.hasAttribute("extends")) continue;
            this.findSuperClasses(classElm, superClasses);
            Element superClassesElm = (Element)classElm.appendChild(this.doc.createElement("super-classes"));
            for (String superClass : superClasses) {
                superClassElm = (Element)superClassesElm.appendChild(this.doc.createElement("class-ref"));
                superClassElm.setAttribute("class", superClass);
            }
            classElm.appendChild(superClassesElm);
            for (String superClass : superClasses) {
                superClassElm = XPathHelper.findElement("//class[@fullname='" + superClass + "']", this.doc);
                if (superClassElm == null) continue;
                Element membersElm = XPathHelper.findElement("members", classElm);
                if (membersElm == null) {
                    membersElm = (Element)classElm.appendChild(this.doc.createElement("members"));
                }
                for (Element memberElm : XPathHelper.findElements("members/*", superClassElm)) {
                    Element superMemberElm;
                    if (memberElm.hasAttribute("inherited-from") || memberElm.hasAttribute("constructor")) continue;
                    String memberName = memberElm.getAttribute("name");
                    if (XPathHelper.findElement("members/*[@name='" + memberName + "']", classElm) != null || (superMemberElm = XPathHelper.findElement("members/*[@name='" + memberName + "']", superClassElm)).hasAttribute("inherited-from")) continue;
                    Element memberRefElm = this.doc.createElement(superMemberElm.getNodeName());
                    memberRefElm.setAttribute("name", memberName);
                    memberRefElm.setAttribute("inherited-from", superClass);
                    membersElm.appendChild(memberRefElm);
                }
            }
        }
        this.serializeDocument(this.doc, new File(this.outDir, "model.xml"));
        if (this.msIntelliSenseFile != null) {
            IntelliSenseGenerator generator = new IntelliSenseGenerator(this.doc);
            generator.generateToMsFormat(this.msIntelliSenseFile, this.eventClass);
        }
        this.transform("index.xsl", "index.html", "index");
        for (Element classElm : XPathHelper.findElements("//class", this.doc)) {
            String className = classElm.getAttribute("fullname");
            this.transform("class.xsl", "class_" + className + ".html", className);
        }
        for (Element memberElm : XPathHelper.findElements("//method[@fullname]|//property[@fullname]|//event[@fullname]", this.doc)) {
            String memberFullName = memberElm.getAttribute("fullname");
            this.transform("member.xsl", "member_" + memberFullName + ".html", memberFullName);
        }
        for (File file : this.templateDir.listFiles()) {
            if (file.getName().endsWith(".xsl")) continue;
            this.copy(file, new File(this.outDir, file.getName()));
        }
    }

    public int getProcessedFileCount() {
        return this.processedFileCount;
    }

    public void copy(File src_path, File dst_path) throws IOException {
        if (!src_path.isHidden()) {
            if (src_path.isDirectory()) {
                if (!dst_path.exists()) {
                    dst_path.mkdir();
                }
                String[] files = src_path.list();
                for (int i = 0; i < files.length; ++i) {
                    this.copy(new File(src_path, files[i]), new File(dst_path, files[i]));
                }
            } else {
                int len;
                if (!src_path.exists()) {
                    throw new IOException("File or directory does not exist.");
                }
                FileInputStream in = new FileInputStream(src_path);
                FileOutputStream out = new FileOutputStream(dst_path);
                byte[] buf = new byte[4096];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
        }
    }

    private void transform(String xslt, String output, String target) throws FileNotFoundException, TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(new StreamSource(new File(this.templateDir, xslt)));
        transformer.setParameter("target", target);
        if (this.title != null) {
            transformer.setParameter("title", this.title);
        } else {
            transformer.setParameter("title", "JS Project");
        }
        transformer.transform(new DOMSource(this.doc), new StreamResult(new FileOutputStream(new File(this.outDir, output))));
    }

    private void findSuperClasses(Element class_elm, Vector<String> class_names) throws XPathExpressionException {
        if (class_elm.hasAttribute("extends")) {
            String superClassName = class_elm.getAttribute("extends");
            class_names.add(superClassName);
            Element superClassElm = XPathHelper.findElement("//class[@fullname='" + superClassName + "']", this.doc);
            if (superClassElm != null) {
                this.findSuperClasses(superClassElm, class_names);
            }
        }
    }

    private Element makeNameSpace(String class_name, boolean skip_last) throws XPathExpressionException {
        Element targetElm = this.doc.getDocumentElement();
        String[] parts = class_name.split("\\.");
        String namespace = "";
        for (int i = 0; i < parts.length - (skip_last ? 1 : 0); ++i) {
            if (i > 0) {
                namespace = namespace + ".";
            }
            namespace = namespace + parts[i];
            Element nsElm = XPathHelper.findElement("//namespace[@fullname='" + namespace + "']", this.doc);
            if (nsElm == null) {
                nsElm = this.doc.createElement("namespace");
                nsElm.setAttribute("name", parts[i]);
                nsElm.setAttribute("fullname", namespace);
                targetElm.appendChild(nsElm);
                targetElm = nsElm;
                continue;
            }
            targetElm = nsElm;
        }
        return targetElm;
    }

    private String getShortName(String str) {
        return str.replaceAll("^.*\\.", "");
    }

    private Element addClass(CommentBlock block) throws XPathExpressionException {
        String className = block.getTag("class").getText();
        Element targetElm = this.makeNameSpace(className, true);
        Element classElm = this.doc.createElement("class");
        classElm.setAttribute("name", this.getShortName(className));
        classElm.setAttribute("fullname", className);
        targetElm.appendChild(classElm);
        this.addTags(block, classElm);
        return classElm;
    }

    private void addTags(CommentBlock block, Element elm) {
        String[] boolProps;
        String[] valueProps;
        Document doc = elm.getOwnerDocument();
        for (String name : valueProps = new String[]{"name", "extends", "type", "deprecated", "version", "author"}) {
            if (!block.hasTag(name)) continue;
            elm.setAttribute(name, block.getTag(name).getText());
        }
        for (String name : boolProps = new String[]{"constructor", "static", "final", "abstract", "private", "protected", "public"}) {
            if (!block.hasTag(name)) continue;
            elm.setAttribute(name, "true");
        }
        Element descriptionElm = doc.createElement("description");
        descriptionElm.appendChild(doc.createTextNode(block.getText()));
        elm.appendChild(descriptionElm);
        String summary = block.getText().replaceAll("<[^>]+>", "").replaceAll("[\\r\\n]+", " ").trim();
        int dotIdx = summary.indexOf(46);
        if (dotIdx != -1) {
            summary = summary.substring(0, dotIdx + 1);
        }
        if (summary.length() > 120) {
            summary = summary.substring(0, 120) + "...";
        }
        elm.setAttribute("summary", summary);
        for (ParamTag paramTag : block.getParams()) {
            Element paramElm = doc.createElement("param");
            paramElm.setAttribute("name", paramTag.getParameterName());
            String[] types = paramTag.getTypes();
            if (types != null && types.length > 1) {
                for (String type : types) {
                    Element typeElm = this.doc.createElement("type");
                    typeElm.setAttribute("fullname", type);
                    paramElm.appendChild(typeElm);
                }
            } else if (types != null && types.length == 1) {
                paramElm.setAttribute("type", types[0]);
            } else if (types == null) {
                paramElm.setAttribute("type", "Object");
            }
            Element paramDescriptionElm = doc.createElement("description");
            paramDescriptionElm.appendChild(doc.createTextNode(paramTag.getText()));
            paramElm.appendChild(paramDescriptionElm);
            elm.appendChild(paramElm);
        }
        if (block.hasTag("return")) {
            ReturnTag returnTag = (ReturnTag)block.getTag("return");
            Element returnElm = doc.createElement("return");
            Element returnDescriptionElm = doc.createElement("description");
            String[] stringArray = returnTag.getTypes();
            if (stringArray != null && stringArray.length > 1) {
                for (String type : stringArray) {
                    Element typeElm = this.doc.createElement("type");
                    typeElm.setAttribute("fullname", type);
                    returnElm.appendChild(typeElm);
                }
            } else if (stringArray != null && stringArray.length == 1) {
                returnElm.setAttribute("type", stringArray[0]);
            } else if (stringArray == null) {
                returnElm.setAttribute("type", "Object");
            }
            returnDescriptionElm.appendChild(doc.createTextNode(returnTag.getText()));
            returnElm.appendChild(returnDescriptionElm);
            elm.appendChild(returnElm);
        }
        for (Tag tag : block.getExamples()) {
            Element exampleElm = doc.createElement("example");
            Element paramDescriptionElm = doc.createElement("example");
            paramDescriptionElm.appendChild(doc.createTextNode(tag.getText()));
            exampleElm.appendChild(paramDescriptionElm);
            elm.appendChild(exampleElm);
        }
        for (Tag tag : block.getSeeTags()) {
            Element seeElm = doc.createElement("see");
            if (((SeeTag)tag).getClassName().length() > 0) {
                seeElm.setAttribute("class", ((SeeTag)tag).getClassName());
            }
            if (((SeeTag)tag).getMemberName().length() > 0) {
                seeElm.setAttribute("member", ((SeeTag)tag).getMemberName());
            }
            elm.appendChild(seeElm);
        }
    }

    private Element buildMember(CommentBlock block) {
        Element memberElm = null;
        if (block.hasTag("method")) {
            memberElm = this.doc.createElement("method");
            memberElm.setAttribute("name", block.getTag("method").getText());
        }
        if (block.hasTag("event")) {
            memberElm = this.doc.createElement("event");
            memberElm.setAttribute("name", block.getTag("event").getText());
        }
        if (block.hasTag("option")) {
            memberElm = this.doc.createElement("option");
            memberElm.setAttribute("name", block.getTag("option").getText());
        }
        if (block.hasTag("property")) {
            memberElm = this.doc.createElement("property");
            memberElm.setAttribute("name", block.getTag("property").getText());
            if (!block.hasTag("type")) {
                memberElm.setAttribute("type", "Object");
            }
        }
        if (memberElm != null) {
            this.addTags(block, memberElm);
        }
        return memberElm;
    }

    private void addToXml(CommentBlock[] blocks) throws XPathExpressionException {
        Element classElm = null;
        boolean isStaticClass = false;
        for (CommentBlock block : blocks) {
            Element memberElm;
            if (block.hasTag("class")) {
                classElm = this.addClass(block);
                isStaticClass = block.hasTag("static");
                continue;
            }
            if (classElm == null || block.hasTag("member")) continue;
            Element targetElm = XPathHelper.findElement("members", classElm);
            if (targetElm == null) {
                targetElm = (Element)classElm.appendChild(this.doc.createElement("members"));
            }
            if ((memberElm = this.buildMember(block)) == null) continue;
            if (isStaticClass) {
                memberElm.setAttribute("static", "true");
            }
            targetElm.appendChild(memberElm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeDocument(Document doc, File out_file) throws TransformerException, TransformerConfigurationException, IOException {
        FileOutputStream fos = new FileOutputStream(out_file.getAbsolutePath());
        try {
            DOMSource domSource = new DOMSource(doc);
            StreamResult streamResult = new StreamResult(fos);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer serializer = tf.newTransformer();
            serializer.setOutputProperty("encoding", "UTF-8");
            serializer.setOutputProperty("indent", "yes");
            serializer.transform(domSource, streamResult);
        }
        finally {
            fos.close();
        }
    }
}

