//about - A Javascript Image filter library for the HTML5 Canvas tag. 
//author - https://github.com/arahaya/ImageFilters.js
//demo - http://www.arahaya.com/imagefilters/
var ImageFilters={};ImageFilters.utils={initSampleCanvas:function(){var t=document.createElement("canvas"),a=t.getContext("2d");t.width=0,t.height=0,this.getSampleCanvas=function(){return t},this.getSampleContext=function(){return a},this.createImageData=a.createImageData?function(t,e){return a.createImageData(t,e)}:function(t,a){return new ImageData(t,a)}},getSampleCanvas:function(){return this.initSampleCanvas(),this.getSampleCanvas()},getSampleContext:function(){return this.initSampleCanvas(),this.getSampleContext()},createImageData:function(t,a){return this.initSampleCanvas(),this.createImageData(t,a)},clamp:function(t){return t>255?255:0>t?0:t},buildMap:function(t){for(var a,e=[],i=0;256>i;i+=1)e[i]=(a=t(i))>255?255:0>a?0:0|a;return e},applyMap:function(t,a,e){for(var i=0,r=t.length;r>i;i+=4)a[i]=e[t[i]],a[i+1]=e[t[i+1]],a[i+2]=e[t[i+2]],a[i+3]=t[i+3]},mapRGB:function(t,a,e){this.applyMap(t,a,this.buildMap(e))},getPixelIndex:function(t,a,e,i,r){if(0>t||t>=e||0>a||a>=i)switch(r){case 1:t=0>t?0:t>=e?e-1:t,a=0>a?0:a>=i?i-1:a;break;case 2:t=(t%=e)<0?t+e:t,a=(a%=i)<0?a+i:a;break;default:return null}return a*e+t<<2},getPixel:function(t,a,e,i,r,n){if(0>a||a>=i||0>e||e>=r)switch(n){case 1:a=0>a?0:a>=i?i-1:a,e=0>e?0:e>=r?r-1:e;break;case 2:a=(a%=i)<0?a+i:a,e=(e%=r)<0?e+r:e;break;default:return 0}var h=e*i+a<<2;return t[h+3]<<24|t[h]<<16|t[h+1]<<8|t[h+2]},getPixelByIndex:function(t,a){return t[a+3]<<24|t[a]<<16|t[a+1]<<8|t[a+2]},copyBilinear:function(t,a,e,i,r,n,h,s){var l,u,o,g,f,c,d,m=0>a?a-1|0:0|a,I=0>e?e-1|0:0|e,v=a-m,F=e-I,p=0,w=0,D=0,x=0;if(m>=0&&i-1>m&&I>=0&&r-1>I){if(l=I*i+m<<2,!v&&!F)return n[h]=t[l],n[h+1]=t[l+1],n[h+2]=t[l+2],void(n[h+3]=t[l+3]);p=t[l+3]<<24|t[l]<<16|t[l+1]<<8|t[l+2],l+=4,w=t[l+3]<<24|t[l]<<16|t[l+1]<<8|t[l+2],l=l-8+(i<<2),D=t[l+3]<<24|t[l]<<16|t[l+1]<<8|t[l+2],l+=4,x=t[l+3]<<24|t[l]<<16|t[l+1]<<8|t[l+2]}else{if(p=this.getPixel(t,m,I,i,r,s),!v&&!F)return n[h]=p>>16&255,n[h+1]=p>>8&255,n[h+2]=255&p,void(n[h+3]=p>>24&255);w=this.getPixel(t,m+1,I,i,r,s),D=this.getPixel(t,m,I+1,i,r,s),x=this.getPixel(t,m+1,I+1,i,r,s)}u=1-v,o=1-F,g=((p>>16&255)*u+(w>>16&255)*v)*o+((D>>16&255)*u+(x>>16&255)*v)*F,f=((p>>8&255)*u+(w>>8&255)*v)*o+((D>>8&255)*u+(x>>8&255)*v)*F,c=((255&p)*u+(255&w)*v)*o+((255&D)*u+(255&x)*v)*F,d=((p>>24&255)*u+(w>>24&255)*v)*o+((D>>24&255)*u+(x>>24&255)*v)*F,n[h]=g>255?255:0>g?0:0|g,n[h+1]=f>255?255:0>f?0:0|f,n[h+2]=c>255?255:0>c?0:0|c,n[h+3]=d>255?255:0>d?0:0|d},rgbToHsl:function(t,a,e){t/=255,a/=255,e/=255;var i=t>a?t>e?t:e:a>e?a:e,r=a>t?e>t?t:e:e>a?a:e,n=i-r,h=0,s=0,l=(r+i)/2;return 0!==n&&(h=t===i?(a-e)/n+(e>a?6:0):a===i?(e-t)/n+2:(t-a)/n+4,h/=6,s=l>.5?n/(2-i-r):n/(i+r)),[h,s,l]},hslToRgb:function(t,a,e){var i,r,n,h,s,l,u=[];if(0===a)h=s=l=255*e+.5|0,u=[h,s,l];else{r=.5>=e?e*(a+1):e+a-e*a,i=2*e-r,n=t+1/3;for(var o,g=0;3>g;g+=1)0>n?n+=1:n>1&&(n-=1),o=1>6*n?i+(r-i)*n*6:1>2*n?r:2>3*n?i+(r-i)*(2/3-n)*6:i,u[g]=255*o+.5|0,n-=1/3}return u}},ImageFilters.Translate=function(t,a,e,i){},ImageFilters.Scale=function(t,a,e,i){},ImageFilters.Rotate=function(t,a,e,i,r,n){},ImageFilters.Affine=function(t,a,e,i){},ImageFilters.UnsharpMask=function(t,a){},ImageFilters.ConvolutionFilter=function(t,a,e,i,r,n,h,s,l,u){var o=t.data,g=t.width,f=t.height,c=(o.length,this.utils.createImageData(g,f)),d=c.data;r=r||1,n=n||0,h!==!1&&(h=!0),s!==!1&&(s=!0),l=l||0,u=u||0;for(var m=0,I=a>>1,v=e>>1,F=l>>16&255,p=l>>8&255,w=255&l,D=255*u,x=0;f>x;x+=1)for(var C=0;g>C;C+=1,m+=4){for(var b,B=0,M=0,S=0,R=0,y=!1,G=0,P=-I;I>=P;P+=1){var k,T=x+P;T>=0&&f>T?k=T*g:s?k=x*g:y=!0;for(var z=-v;v>=z;z+=1){var E=i[G++];if(0!==E){var N=C+z;if(N>=0&&g>N||(s?N=C:y=!0),y)B+=E*F,M+=E*p,S+=E*w,R+=E*D;else{var A=k+N<<2;B+=E*o[A],M+=E*o[A+1],S+=E*o[A+2],R+=E*o[A+3]}}}}d[m]=(b=B/r+n)>255?255:0>b?0:0|b,d[m+1]=(b=M/r+n)>255?255:0>b?0:0|b,d[m+2]=(b=S/r+n)>255?255:0>b?0:0|b,d[m+3]=h?o[m+3]:(b=R/r+n)>255?255:0>b?0:0|b}return c},ImageFilters.Binarize=function(t,a){var e=t.data,i=t.width,r=t.height,n=e.length,h=this.utils.createImageData(i,r),s=h.data;isNaN(a)&&(a=.5),a*=255;for(var l=0;n>l;l+=4){var u=e[l]+e[l+1]+e[l+2]/3;s[l]=s[l+1]=s[l+2]=a>=u?0:255,s[l+3]=255}return h},ImageFilters.BlendAdd=function(t,a,e,i){for(var r,n=t.data,h=t.width,s=t.height,l=n.length,u=this.utils.createImageData(h,s),o=u.data,g=a.data,f=0;l>f;f+=4)o[f]=(r=n[f]+g[f])>255?255:r,o[f+1]=(r=n[f+1]+g[f+1])>255?255:r,o[f+2]=(r=n[f+2]+g[f+2])>255?255:r,o[f+3]=255;return u},ImageFilters.BlendSubtract=function(t,a,e,i){for(var r,n=t.data,h=t.width,s=t.height,l=n.length,u=this.utils.createImageData(h,s),o=u.data,g=a.data,f=0;l>f;f+=4)o[f]=(r=n[f]-g[f])<0?0:r,o[f+1]=(r=n[f+1]-g[f+1])<0?0:r,o[f+2]=(r=n[f+2]-g[f+2])<0?0:r,o[f+3]=255;return u},ImageFilters.BoxBlur=function(){var t=function(t,a,e,i,r){var n,h,s,l,u,o,g,f,c,d,m,I,v,F,p=2*r+1,w=r+1,D=e-1,x=0,C=[];for(c=0,d=256*p;d>c;c+=1)C[c]=c/p|0;for(I=0;i>I;I+=1){for(n=h=s=l=0,u=I,o=x<<2,n+=w*t[o],h+=w*t[o+1],s+=w*t[o+2],l+=w*t[o+3],c=1;r>=c;c+=1)o=x+(e>c?c:D)<<2,n+=t[o],h+=t[o+1],s+=t[o+2],l+=t[o+3];for(m=0;e>m;m+=1)o=u<<2,a[o]=C[n],a[o+1]=C[h],a[o+2]=C[s],a[o+3]=C[l],v=m+w,v>D&&(v=D),F=m-r,0>F&&(F=0),g=x+v<<2,f=x+F<<2,n+=t[g]-t[f],h+=t[g+1]-t[f+1],s+=t[g+2]-t[f+2],l+=t[g+3]-t[f+3],u+=i;x+=e}};return function(a,e,i,r){for(var n=a.data,h=a.width,s=a.height,l=(n.length,this.utils.createImageData(h,s)),u=l.data,o=this.utils.createImageData(h,s),g=o.data,f=0;r>f;f+=1)t(f?u:n,g,h,s,e),t(g,u,s,h,i);return l}}(),ImageFilters.GaussianBlur=function(t,a){var e,i,r;switch(a){case 2:e=5,i=[1,1,2,1,1,1,2,4,2,1,2,4,8,4,2,1,2,4,2,1,1,1,2,1,1],r=52;break;case 3:e=7,i=[1,1,2,2,2,1,1,1,2,2,4,2,2,1,2,2,4,8,4,2,2,2,4,8,16,8,4,2,2,2,4,8,4,2,2,1,2,2,4,2,2,1,1,1,2,2,2,1,1],r=140;break;case 4:e=15,i=[2,2,3,4,5,5,6,6,6,5,5,4,3,2,2,2,3,4,5,7,7,8,8,8,7,7,5,4,3,2,3,4,6,7,9,10,10,11,10,10,9,7,6,4,3,4,5,7,9,10,12,13,13,13,12,10,9,7,5,4,5,7,9,11,13,14,15,16,15,14,13,11,9,7,5,5,7,10,12,14,16,17,18,17,16,14,12,10,7,5,6,8,10,13,15,17,19,19,19,17,15,13,10,8,6,6,8,11,13,16,18,19,20,19,18,16,13,11,8,6,6,8,10,13,15,17,19,19,19,17,15,13,10,8,6,5,7,10,12,14,16,17,18,17,16,14,12,10,7,5,5,7,9,11,13,14,15,16,15,14,13,11,9,7,5,4,5,7,9,10,12,13,13,13,12,10,9,7,5,4,3,4,6,7,9,10,10,11,10,10,9,7,6,4,3,2,3,4,5,7,7,8,8,8,7,7,5,4,3,2,2,2,3,4,5,5,6,6,6,5,5,4,3,2,2],r=2044;break;default:e=3,i=[1,2,1,2,4,2,1,2,1],r=16}return this.ConvolutionFilter(t,e,e,i,r,0,!1)},ImageFilters.StackBlur=function(){function t(){this.r=0,this.g=0,this.b=0,this.a=0,this.next=null}var a=[512,512,456,512,328,456,335,512,405,328,271,456,388,335,292,512,454,405,364,328,298,271,496,456,420,388,360,335,312,292,273,512,482,454,428,405,383,364,345,328,312,298,284,271,259,496,475,456,437,420,404,388,374,360,347,335,323,312,302,292,282,273,265,512,497,482,468,454,441,428,417,405,394,383,373,364,354,345,337,328,320,312,305,298,291,284,278,271,265,259,507,496,485,475,465,456,446,437,428,420,412,404,396,388,381,374,367,360,354,347,341,335,329,323,318,312,307,302,297,292,287,282,278,273,269,265,261,512,505,497,489,482,475,468,461,454,447,441,435,428,422,417,411,405,399,394,389,383,378,373,368,364,359,354,350,345,341,337,332,328,324,320,316,312,309,305,301,298,294,291,287,284,281,278,274,271,268,265,262,259,257,507,501,496,491,485,480,475,470,465,460,456,451,446,442,437,433,428,424,420,416,412,408,404,400,396,392,388,385,381,377,374,370,367,363,360,357,354,350,347,344,341,338,335,332,329,326,323,320,318,315,312,310,307,304,302,299,297,294,292,289,287,285,282,280,278,275,273,271,269,267,265,263,261,259],e=[9,11,12,13,13,14,14,15,15,15,15,16,16,16,16,17,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24];return function(i,r){var n,h,s,l,u,o,g,f,c,d,m,I,v,F,p,w,D,x,C,b,B,M,S,R,y,G,P,k=i.data,T=i.width,z=i.height,E=(k.length,this.Clone(i)),N=E.data,A=r+r+1,H=T-1,O=z-1,j=r+1,q=j*(j+1)/2,L=new t,U=L,J=a[r],K=e[r];for(s=1;A>s;s+=1)U=U.next=new t,s==j&&(P=U);for(U.next=L,g=o=0,h=0;z>h;h+=1){for(w=D=x=C=f=c=d=m=0,I=j*(b=N[o]),v=j*(B=N[o+1]),F=j*(M=N[o+2]),p=j*(S=N[o+3]),f+=q*b,c+=q*B,d+=q*M,m+=q*S,U=L,s=0;j>s;s+=1)U.r=b,U.g=B,U.b=M,U.a=S,U=U.next;for(s=1;j>s;s+=1)l=o+((s>H?H:s)<<2),f+=(U.r=b=N[l])*(R=j-s),c+=(U.g=B=N[l+1])*R,d+=(U.b=M=N[l+2])*R,m+=(U.a=S=N[l+3])*R,w+=b,D+=B,x+=M,C+=S,U=U.next;for(y=L,G=P,n=0;T>n;n+=1)N[o]=f*J>>K,N[o+1]=c*J>>K,N[o+2]=d*J>>K,N[o+3]=m*J>>K,f-=I,c-=v,d-=F,m-=p,I-=y.r,v-=y.g,F-=y.b,p-=y.a,l=g+((l=n+r+1)<H?l:H)<<2,w+=y.r=N[l],D+=y.g=N[l+1],x+=y.b=N[l+2],C+=y.a=N[l+3],f+=w,c+=D,d+=x,m+=C,y=y.next,I+=b=G.r,v+=B=G.g,F+=M=G.b,p+=S=G.a,w-=b,D-=B,x-=M,C-=S,G=G.next,o+=4;g+=T}for(n=0;T>n;n+=1){for(D=x=C=w=c=d=m=f=0,o=n<<2,I=j*(b=N[o]),v=j*(B=N[o+1]),F=j*(M=N[o+2]),p=j*(S=N[o+3]),f+=q*b,c+=q*B,d+=q*M,m+=q*S,U=L,s=0;j>s;s+=1)U.r=b,U.g=B,U.b=M,U.a=S,U=U.next;for(u=T,s=1;r>=s;s+=1)o=u+n<<2,f+=(U.r=b=N[o])*(R=j-s),c+=(U.g=B=N[o+1])*R,d+=(U.b=M=N[o+2])*R,m+=(U.a=S=N[o+3])*R,w+=b,D+=B,x+=M,C+=S,U=U.next,O>s&&(u+=T);for(o=n,y=L,G=P,h=0;z>h;h+=1)l=o<<2,N[l]=f*J>>K,N[l+1]=c*J>>K,N[l+2]=d*J>>K,N[l+3]=m*J>>K,f-=I,c-=v,d-=F,m-=p,I-=y.r,v-=y.g,F-=y.b,p-=y.a,l=n+((l=h+j)<O?l:O)*T<<2,f+=w+=y.r=N[l],c+=D+=y.g=N[l+1],d+=x+=y.b=N[l+2],m+=C+=y.a=N[l+3],y=y.next,I+=b=G.r,v+=B=G.g,F+=M=G.b,p+=S=G.a,w-=b,D-=B,x-=M,C-=S,G=G.next,o+=T}return E}}(),ImageFilters.Brightness=function(t,a){var e=t.data,i=t.width,r=t.height,n=(e.length,this.utils.createImageData(i,r)),h=n.data;return this.utils.mapRGB(e,h,function(t){return t+=a,t>255?255:t}),n},ImageFilters.BrightnessContrastGimp=function(t,a,e){var i=t.data,r=t.width,n=t.height,h=i.length,s=this.utils.createImageData(r,n),l=s.data,u=Math.PI/4;a/=100,e*=.99,e/=100,e=Math.tan((e+1)*u);for(var o=0,g=0;h>g;g+=4)o+=19595*i[g]+38470*i[g+1]+7471*i[g+2]>>16;return o/=h/4,this.utils.mapRGB(i,l,function(t){return 0>a?t*=1+a:a>0&&(t+=(255-t)*a),0!==e&&(t=(t-o)*e+o),t+.5|0}),s},ImageFilters.BrightnessContrastPhotoshop=function(t,a,e){var i=t.data,r=t.width,n=t.height,h=(i.length,this.utils.createImageData(r,n)),s=h.data;return a=(a+100)/100,e=(e+100)/100,this.utils.mapRGB(i,s,function(t){return t*=a,t=(t-127.5)*e+127.5,t+.5|0}),h},ImageFilters.Channels=function(t,a){var e;switch(a){case 2:e=[0,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,1,0];break;case 3:e=[0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,1,0];break;default:e=[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,1,0]}return this.ColorMatrixFilter(t,e)},ImageFilters.Clone=function(t){return this.Copy(t,this.utils.createImageData(t.width,t.height))},ImageFilters.CloneBuiltin=function(t){var a,e=t.width,i=t.height,r=this.utils.getSampleCanvas(),n=this.utils.getSampleContext();return r.width=e,r.height=i,n.putImageData(t,0,0),a=n.getImageData(0,0,e,i),r.width=0,r.height=0,a},ImageFilters.ColorMatrixFilter=function(t,a){var e,i,r,n,h,s,l=t.data,u=t.width,o=t.height,g=l.length,f=this.utils.createImageData(u,o),c=f.data,d=a[0],m=a[1],I=a[2],v=a[3],F=a[4],p=a[5],w=a[6],D=a[7],x=a[8],C=a[9],b=a[10],B=a[11],M=a[12],S=a[13],R=a[14],y=a[15],G=a[16],P=a[17],k=a[18],T=a[19];for(i=0;g>i;i+=4)r=l[i],n=l[i+1],h=l[i+2],s=l[i+3],c[i]=(e=r*d+n*m+h*I+s*v+F)>255?255:0>e?0:0|e,c[i+1]=(e=r*p+n*w+h*D+s*x+C)>255?255:0>e?0:0|e,c[i+2]=(e=r*b+n*B+h*M+s*S+R)>255?255:0>e?0:0|e,c[i+3]=(e=r*y+n*G+h*P+s*k+T)>255?255:0>e?0:0|e;return f},ImageFilters.ColorTransformFilter=function(t,a,e,i,r,n,h,s,l){var u,o,g=t.data,f=t.width,c=t.height,d=g.length,m=this.utils.createImageData(f,c),I=m.data;for(u=0;d>u;u+=4)I[u]=(o=g[u]*a+n)>255?255:0>o?0:o,I[u+1]=(o=g[u+1]*e+h)>255?255:0>o?0:o,I[u+2]=(o=g[u+2]*i+s)>255?255:0>o?0:o,I[u+3]=(o=g[u+3]*r+l)>255?255:0>o?0:o;return m},ImageFilters.Copy=function(t,a){for(var e=t.data,i=e.length,r=a.data;i--;)r[i]=e[i];return a},ImageFilters.Crop=function(t,a,e,i,r){var n,h,s,l,u=t.data,o=t.width,g=t.height,f=(u.length,this.utils.createImageData(i,r)),c=f.data,d=Math.max(a,0),m=Math.max(e,0),I=Math.min(a+i,o),v=Math.min(e+r,g),F=d-a,p=m-e;for(n=m,dstRow=p;v>n;n+=1,dstRow+=1)for(h=d,dstCol=F;I>h;h+=1,dstCol+=1)s=n*o+h<<2,l=dstRow*i+dstCol<<2,c[l]=u[s],c[l+1]=u[s+1],c[l+2]=u[s+2],c[l+3]=u[s+3];return f},ImageFilters.CropBuiltin=function(t,a,e,i,r){var n=t.width,h=t.height,s=this.utils.getSampleCanvas(),l=this.utils.getSampleContext();s.width=n,s.height=h,l.putImageData(t,0,0);var u=l.getImageData(a,e,i,r);return s.width=0,s.height=0,u},ImageFilters.Desaturate=function(t){for(var a=t.data,e=t.width,i=t.height,r=a.length,n=this.utils.createImageData(e,i),h=n.data,s=0;r>s;s+=4){var l=a[s],u=a[s+1],o=a[s+2],g=l>u?l>o?l:o:u>o?u:o,f=u>l?o>l?l:o:o>u?u:o,c=(g+f)/2+.5|0;h[s]=h[s+1]=h[s+2]=c,h[s+3]=a[s+3]}return n},ImageFilters.DisplacementMapFilter=function(t,a,e,i,r,n,h,s,l){var u=t.data,o=t.width,g=t.height,f=(u.length,ImageFilters.Clone(t)),c=f.data;e||(e=0),i||(i=0),r||(r=0),n||(n=0),h||(h=0),s||(s=0),l||(l=2);var d,m,I,v,F,p,w,D,x,C=a.width,b=a.height,B=a.data,M=C+e,S=b+i;for(D=0;o>D;D+=1)for(x=0;g>x;x+=1)d=x*o+D<<2,e>D||i>x||D>=M||x>=S?m=d:(I=(x-i)*C+(D-e)<<2,v=B[I+r],p=D+((v-128)*h>>8),F=B[I+n],w=x+((F-128)*s>>8),m=ImageFilters.utils.getPixelIndex(p+.5|0,w+.5|0,o,g,l),null===m&&(m=d)),c[d]=u[m],c[d+1]=u[m+1],c[d+2]=u[m+2],c[d+3]=u[m+3];return f},ImageFilters.Dither=function(t,a){var e=t.width,i=t.height,r=this.Clone(t),n=r.data;a=2>a?2:a>255?255:a;var h,s,l=[],u=a-1,o=0,g=0;for(s=0;a>s;s+=1)l[s]=255*s/u;h=this.utils.buildMap(function(t){var e=l[o];return g+=a,g>255&&(g-=255,o+=1),e});var f,c,d,m,I,v,F,p,w,D,x,C,b,B,M,S=e-1,R=i-1,y=7/16,G=3/16,P=5/16,k=1/16;for(c=0;i>c;c+=1)for(f=0;e>f;f+=1)d=c*e+f<<2,m=n[d],I=n[d+1],v=n[d+2],F=h[m],p=h[I],w=h[v],n[d]=F,n[d+1]=p,n[d+2]=w,D=m-F,x=I-p,C=v-w,d+=4,S>f&&(b=n[d]+y*D,B=n[d+1]+y*x,M=n[d+2]+y*C,n[d]=b>255?255:0>b?0:0|b,n[d+1]=B>255?255:0>B?0:0|B,n[d+2]=M>255?255:0>M?0:0|M),d+=e-2<<2,f>0&&R>c&&(b=n[d]+G*D,B=n[d+1]+G*x,M=n[d+2]+G*C,n[d]=b>255?255:0>b?0:0|b,n[d+1]=B>255?255:0>B?0:0|B,n[d+2]=M>255?255:0>M?0:0|M),d+=4,R>c&&(b=n[d]+P*D,B=n[d+1]+P*x,M=n[d+2]+P*C,n[d]=b>255?255:0>b?0:0|b,n[d+1]=B>255?255:0>B?0:0|B,n[d+2]=M>255?255:0>M?0:0|M),d+=4,S>f&&R>c&&(b=n[d]+k*D,B=n[d+1]+k*x,M=n[d+2]+k*C,n[d]=b>255?255:0>b?0:0|b,n[d+1]=B>255?255:0>B?0:0|B,n[d+2]=M>255?255:0>M?0:0|M);return r},ImageFilters.Edge=function(t){return this.ConvolutionFilter(t,3,3,[-1,-1,-1,-1,8,-1,-1,-1,-1])},ImageFilters.Emboss=function(t){return this.ConvolutionFilter(t,3,3,[-2,-1,0,-1,1,1,0,1,2])},ImageFilters.Enrich=function(t){return this.ConvolutionFilter(t,3,3,[0,-2,0,-2,20,-2,0,-2,0],10,-40)},ImageFilters.Flip=function(t,a){var e,i,r,n,h=t.data,s=t.width,l=t.height,u=(h.length,this.utils.createImageData(s,l)),o=u.data;for(i=0;l>i;i+=1)for(e=0;s>e;e+=1)r=i*s+e<<2,n=a?(l-i-1)*s+e<<2:i*s+(s-e-1)<<2,o[n]=h[r],o[n+1]=h[r+1],o[n+2]=h[r+2],o[n+3]=h[r+3];return u},ImageFilters.Gamma=function(t,a){var e=t.data,i=t.width,r=t.height,n=(e.length,this.utils.createImageData(i,r)),h=n.data;return this.utils.mapRGB(e,h,function(t){return t=255*Math.pow(t/255,1/a)+.5,t>255?255:t+.5|0}),n},ImageFilters.GrayScale=function(t){for(var a=t.data,e=t.width,i=t.height,r=a.length,n=this.utils.createImageData(e,i),h=n.data,s=0;r>s;s+=4){var l=19595*a[s]+38470*a[s+1]+7471*a[s+2]>>16;h[s]=h[s+1]=h[s+2]=l,h[s+3]=a[s+3]}return n},ImageFilters.HSLAdjustment=function(t,a,e,i){var r=t.data,n=t.width,h=t.height,s=r.length,l=this.utils.createImageData(n,h),u=l.data;a/=360,e/=100,i/=100;var o,g,f,c,d,m,I=this.utils.rgbToHsl,v=this.utils.hslToRgb;for(m=0;s>m;m+=4){for(c=I(r[m],r[m+1],r[m+2]),o=c[0]+a;0>o;)o+=1;for(;o>1;)o-=1;g=c[1]+c[1]*e,0>g?g=0:g>1&&(g=1),f=c[2],i>0?f+=(1-f)*i:0>i&&(f+=f*i),d=v(o,g,f),u[m]=d[0],u[m+1]=d[1],u[m+2]=d[2],u[m+3]=r[m+3]}return l},ImageFilters.Invert=function(t){var a=t.data,e=t.width,i=t.height,r=(a.length,this.utils.createImageData(e,i)),n=r.data;return this.utils.mapRGB(a,n,function(t){return 255-t}),r},ImageFilters.Mosaic=function(t,a){var e,i,r,n,h,s,l,u,o,g,f,c,d,m,I,v=t.data,F=t.width,p=t.height,w=(v.length,this.utils.createImageData(F,p)),D=w.data,x=Math.ceil(F/a),C=Math.ceil(p/a);for(e=0;C>e;e+=1)for(h=e*a,s=h+a,s>p&&(s=p),i=0;x>i;i+=1){for(r=i*a,n=r+a,n>F&&(n=F),c=d=m=I=0,f=(n-r)*(s-h),u=h;s>u;u+=1)for(o=u*F,l=r;n>l;l+=1)g=o+l<<2,c+=v[g],d+=v[g+1],m+=v[g+2],I+=v[g+3];for(c=c/f+.5|0,d=d/f+.5|0,m=m/f+.5|0,I=I/f+.5|0,u=h;s>u;u+=1)for(o=u*F,l=r;n>l;l+=1)g=o+l<<2,D[g]=c,D[g+1]=d,D[g+2]=m,D[g+3]=I}return w},ImageFilters.Oil=function(t,a,e){var i,r,n,h,s,l,u,o,g,f,c,d,m,I,v,F,p,w,D=t.data,x=t.width,C=t.height,b=(D.length,this.utils.createImageData(x,C)),B=b.data,M=0,S=[],R=[],y=[],G=[],P=[],k=[];for(r=0;C>r;r+=1)for(i=0;x>i;i+=1){for(n=0;e>n;n+=1)S[n]=R[n]=y[n]=G[n]=P[n]=k[n]=0;for(h=-a;a>=h;h+=1)if(l=r+h,!(0>l||l>=C))for(o=l*x,s=-a;a>=s;s+=1)u=i+s,0>u||u>=x||(g=o+u<<2,f=D[g],c=D[g+1],d=D[g+2],m=f*e>>8,I=c*e>>8,v=d*e>>8,G[m]+=f,P[I]+=c,k[v]+=d,S[m]+=1,R[I]+=1,y[v]+=1);for(F=p=w=0,n=1;e>n;n+=1)S[n]>S[F]&&(F=n),R[n]>R[p]&&(p=n),y[n]>y[w]&&(w=n);B[M]=G[F]/S[F]|0,B[M+1]=P[p]/R[p]|0,B[M+2]=k[w]/y[w]|0,B[M+3]=D[M+3],M+=4}return b},ImageFilters.OpacityFilter=function(t,a){for(var e=t.data,i=t.width,r=t.height,n=e.length,h=this.utils.createImageData(i,r),s=h.data,l=0;n>l;l+=4)s[l]=e[l],s[l+1]=e[l+1],s[l+2]=e[l+2],s[l+3]=a;return h},ImageFilters.Posterize=function(t,a){var e=t.data,i=t.width,r=t.height,n=(e.length,this.utils.createImageData(i,r)),h=n.data;a=2>a?2:a>255?255:a;var s,l=[],u=a-1,o=0,g=0;for(s=0;a>s;s+=1)l[s]=255*s/u;return this.utils.mapRGB(e,h,function(t){var e=l[o];return g+=a,g>255&&(g-=255,o+=1),e}),n},ImageFilters.Rescale=function(t,a){var e=t.data,i=t.width,r=t.height,n=(e.length,this.utils.createImageData(i,r)),h=n.data;return this.utils.mapRGB(e,h,function(t){return t*=a,t>255?255:t+.5|0}),n},ImageFilters.ResizeNearestNeighbor=function(t,a,e){var i,r,n,h,s=t.data,l=t.width,u=t.height,o=(s.length,this.utils.createImageData(a,e)),g=o.data,f=l/a,c=u/e,d=0;for(n=0;e>n;n+=1)for(h=(n*c|0)*l,r=0;a>r;r+=1)i=h+r*f<<2,g[d]=s[i],g[d+1]=s[i+1],g[d+2]=s[i+2],g[d+3]=s[i+3],d+=4;return o},ImageFilters.Resize=function(t,a,e){var i,r,n=t.data,h=t.width,s=t.height,l=(n.length,this.utils.createImageData(a,e)),u=l.data,o=h/a,g=s/e,f=0;for(r=0;e>r;r+=1)for(i=0;a>i;i+=1)this.utils.copyBilinear(n,i*o,r*g,h,s,u,f,0),f+=4;return l},ImageFilters.ResizeBuiltin=function(t,a,e){var i,r=t.width,n=t.height,h=this.utils.getSampleCanvas(),s=this.utils.getSampleContext();return h.width=Math.max(r,a),h.height=Math.max(n,e),s.save(),s.putImageData(t,0,0),s.scale(a/r,e/n),s.drawImage(h,0,0),i=s.getImageData(0,0,a,e),s.restore(),h.width=0,h.height=0,i},ImageFilters.Sepia=function(t){var a,e,i,r,n,h=t.data,s=t.width,l=t.height,u=h.length,o=this.utils.createImageData(s,l),g=o.data;for(r=0;u>r;r+=4)a=h[r],e=h[r+1],i=h[r+2],g[r]=(n=.393*a+.769*e+.189*i)>255?255:0>n?0:n+.5|0,g[r+1]=(n=.349*a+.686*e+.168*i)>255?255:0>n?0:n+.5|0,g[r+2]=(n=.272*a+.534*e+.131*i)>255?255:0>n?0:n+.5|0,g[r+3]=h[r+3];return o},ImageFilters.Sharpen=function(t,a){return this.ConvolutionFilter(t,3,3,[-a/16,-a/8,-a/16,-a/8,.75*a+1,-a/8,-a/16,-a/8,-a/16])},ImageFilters.Solarize=function(t){var a=t.data,e=t.width,i=t.height,r=(a.length,this.utils.createImageData(e,i)),n=r.data;return this.utils.mapRGB(a,n,function(t){return t>127?2*(t-127.5):2*(127.5-t)}),r},ImageFilters.Transpose=function(t){var a,e,i=t.data,r=t.width,n=t.height,h=(i.length,this.utils.createImageData(n,r)),s=h.data;for(y=0;y<n;y+=1)for(x=0;x<r;x+=1)a=y*r+x<<2,e=x*n+y<<2,s[e]=i[a],s[e+1]=i[a+1],s[e+2]=i[a+2],s[e+3]=i[a+3];return h},ImageFilters.Twril=function(t,a,e,i,r,n,h){var s=t.data,l=t.width,u=t.height,o=(s.length,this.utils.createImageData(l,u)),g=o.data;a=l*a,e=u*e,r*=Math.PI/180;var f,c,d,m,I,v,F,p,w,D=i*i,x=0;for(c=0;u>c;c+=1)for(f=0;l>f;f+=1)d=f-a,m=c-e,I=d*d+m*m,I>D?(g[x]=s[x],g[x+1]=s[x+1],g[x+2]=s[x+2],g[x+3]=s[x+3]):(I=Math.sqrt(I),v=Math.atan2(m,d)+r*(i-I)/i,F=a+I*Math.cos(v),p=e+I*Math.sin(v),h?this.utils.copyBilinear(s,F,p,l,u,g,x,n):(w=(p+.5|0)*l+(F+.5|0)<<2,g[x]=s[w],g[x+1]=s[w+1],g[x+2]=s[w+2],g[x+3]=s[w+3])),x+=4;return o};