// Code generated by "pipeline"; DO NOT EDIT.
package alhaitham

import (
	_ "embed"

	"fmt"
	"github.com/genshinsim/gcsim/pkg/core/action"
	"github.com/genshinsim/gcsim/pkg/core/keys"
	"github.com/genshinsim/gcsim/pkg/gcs/validation"
	"github.com/genshinsim/gcsim/pkg/model"
	"google.golang.org/protobuf/encoding/prototext"
	"slices"
)

//go:embed data_gen.textproto
var pbData []byte
var base *model.AvatarData
var paramKeysValidation = map[action.Action][]string{
	1: {"hold"},
	5: {"collision"},
	6: {"collision", "short"},
}

func init() {
	base = &model.AvatarData{}
	err := prototext.Unmarshal(pbData, base)
	if err != nil {
		panic(err)
	}
	validation.RegisterCharParamValidationFunc(keys.Alhaitham, ValidateParamKeys)
}

func ValidateParamKeys(a action.Action, keys []string) error {
	valid, ok := paramKeysValidation[a]
	if !ok {
		return nil
	}
	for _, v := range keys {
		if !slices.Contains(valid, v) {
			return fmt.Errorf("key %v is invalid for action %v", v, a.String())
		}
	}
	return nil
}

func (x *char) Data() *model.AvatarData {
	return base
}

var (
	attack = [][][]float64{
		{attack_1},
		{attack_2},
		attack_3,
		{attack_4},
		{attack_5},
	}
)

var (
	// attack: attack_1 = [0]
	attack_1 = []float64{
		0.495257,
		0.535568,
		0.57588,
		0.633468,
		0.67378,
		0.71985,
		0.783197,
		0.846544,
		0.90989,
		0.978996,
		1.048102,
		1.117207,
		1.186313,
		1.255418,
		1.324524,
	}
	// attack: attack_2 = [1]
	attack_2 = []float64{
		0.507495,
		0.548802,
		0.59011,
		0.649121,
		0.690429,
		0.737638,
		0.80255,
		0.867462,
		0.932374,
		1.003187,
		1.074,
		1.144813,
		1.215627,
		1.28644,
		1.357253,
	}
	// attack: attack_3 = [2 2]
	attack_3 = [][]float64{
		{
			0.341785,
			0.369605,
			0.397425,
			0.437167,
			0.464987,
			0.496781,
			0.540498,
			0.584215,
			0.627931,
			0.675622,
			0.723313,
			0.771004,
			0.818696,
			0.866387,
			0.914077,
		},
		{
			0.341785,
			0.369605,
			0.397425,
			0.437167,
			0.464987,
			0.496781,
			0.540498,
			0.584215,
			0.627931,
			0.675622,
			0.723313,
			0.771004,
			0.818696,
			0.866387,
			0.914077,
		},
	}
	// attack: attack_4 = [4]
	attack_4 = []float64{
		0.667678,
		0.722024,
		0.77637,
		0.854007,
		0.908353,
		0.970463,
		1.055863,
		1.141264,
		1.226665,
		1.319829,
		1.412993,
		1.506158,
		1.599322,
		1.692487,
		1.785651,
	}
	// attack: attack_5 = [5]
	attack_5 = []float64{
		0.838509,
		0.906759,
		0.97501,
		1.072511,
		1.140762,
		1.218762,
		1.326014,
		1.433265,
		1.540516,
		1.657517,
		1.774518,
		1.891519,
		2.008521,
		2.125522,
		2.242523,
	}
	// attack: charge = [6 6]
	charge = [][]float64{
		{
			0.55255,
			0.597525,
			0.6425,
			0.70675,
			0.751725,
			0.803125,
			0.8738,
			0.944475,
			1.01515,
			1.09225,
			1.16935,
			1.24645,
			1.32355,
			1.40065,
			1.47775,
		},
		{
			0.55255,
			0.597525,
			0.6425,
			0.70675,
			0.751725,
			0.803125,
			0.8738,
			0.944475,
			1.01515,
			1.09225,
			1.16935,
			1.24645,
			1.32355,
			1.40065,
			1.47775,
		},
	}
	// attack: collision = [9]
	collision = []float64{
		0.639324,
		0.691362,
		0.7434,
		0.81774,
		0.869778,
		0.92925,
		1.011024,
		1.092798,
		1.174572,
		1.26378,
		1.352988,
		1.442196,
		1.531404,
		1.620612,
		1.70982,
	}
	// attack: highPlunge = [11]
	highPlunge = []float64{
		1.596762,
		1.726731,
		1.8567,
		2.04237,
		2.172339,
		2.320875,
		2.525112,
		2.729349,
		2.933586,
		3.15639,
		3.379194,
		3.601998,
		3.824802,
		4.047606,
		4.27041,
	}
	// attack: lowPlunge = [10]
	lowPlunge = []float64{
		1.278377,
		1.382431,
		1.486485,
		1.635134,
		1.739187,
		1.858106,
		2.02162,
		2.185133,
		2.348646,
		2.527025,
		2.705403,
		2.883781,
		3.062159,
		3.240537,
		3.418915,
	}
	// skill: mirrorAtk = [3]
	mirrorAtk = []float64{
		0.672,
		0.7224,
		0.7728,
		0.84,
		0.8904,
		0.9408,
		1.008,
		1.0752,
		1.1424,
		1.2096,
		1.2768,
		1.344,
		1.428,
		1.512,
		1.596,
	}
	// skill: mirrorEm = [4]
	mirrorEm = []float64{
		1.344,
		1.4448,
		1.5456,
		1.68,
		1.7808,
		1.8816,
		2.016,
		2.1504,
		2.2848,
		2.4192,
		2.5536,
		2.688,
		2.856,
		3.024,
		3.192,
	}
	// skill: rushAtk = [0]
	rushAtk = []float64{
		1.936,
		2.0812,
		2.2264,
		2.42,
		2.5652,
		2.7104,
		2.904,
		3.0976,
		3.2912,
		3.4848,
		3.6784,
		3.872,
		4.114,
		4.356,
		4.598,
	}
	// skill: rushEm = [1]
	rushEm = []float64{
		1.5488,
		1.66496,
		1.78112,
		1.936,
		2.05216,
		2.16832,
		2.3232,
		2.47808,
		2.63296,
		2.78784,
		2.94272,
		3.0976,
		3.2912,
		3.4848,
		3.6784,
	}
	// burst: burstAtk = [0]
	burstAtk = []float64{
		1.216,
		1.3072,
		1.3984,
		1.52,
		1.6112,
		1.7024,
		1.824,
		1.9456,
		2.0672,
		2.1888,
		2.3104,
		2.432,
		2.584,
		2.736,
		2.888,
	}
	// burst: burstEm = [1]
	burstEm = []float64{
		0.9728,
		1.04576,
		1.11872,
		1.216,
		1.28896,
		1.36192,
		1.4592,
		1.55648,
		1.65376,
		1.75104,
		1.84832,
		1.9456,
		2.0672,
		2.1888,
		2.3104,
	}
)
