// Code generated by "pipeline"; DO NOT EDIT.
package aloy

import (
	_ "embed"

	"fmt"
	"github.com/genshinsim/gcsim/pkg/core/action"
	"github.com/genshinsim/gcsim/pkg/core/keys"
	"github.com/genshinsim/gcsim/pkg/gcs/validation"
	"github.com/genshinsim/gcsim/pkg/model"
	"google.golang.org/protobuf/encoding/prototext"
	"slices"
)

//go:embed data_gen.textproto
var pbData []byte
var base *model.AvatarData
var paramKeysValidation = map[action.Action][]string{
	1: {"travel", "bomblets", "bomb_delay"},
	3: {"travel"},
	7: {"hold", "travel", "weakspot"},
}

func init() {
	base = &model.AvatarData{}
	err := prototext.Unmarshal(pbData, base)
	if err != nil {
		panic(err)
	}
	validation.RegisterCharParamValidationFunc(keys.Aloy, ValidateParamKeys)
}

func ValidateParamKeys(a action.Action, keys []string) error {
	valid, ok := paramKeysValidation[a]
	if !ok {
		return nil
	}
	for _, v := range keys {
		if !slices.Contains(valid, v) {
			return fmt.Errorf("key %v is invalid for action %v", v, a.String())
		}
	}
	return nil
}

func (x *char) Data() *model.AvatarData {
	return base
}

var (
	attack = [][][]float64{
		attack_1,
		{attack_2},
		{attack_3},
		{attack_4},
	}
)

var (
	// attack: aim = [5]
	aim = []float64{
		0.4386,
		0.4743,
		0.51,
		0.561,
		0.5967,
		0.6375,
		0.6936,
		0.7497,
		0.8058,
		0.867,
		0.9282,
		0.9894,
		1.0506,
		1.1118,
		1.173,
	}
	// attack: attack_1 = [0 1]
	attack_1 = [][]float64{
		{
			0.2112,
			0.2256,
			0.24,
			0.2592,
			0.2736,
			0.2904,
			0.312,
			0.3336,
			0.3552,
			0.3768,
			0.3984,
			0.42,
			0.4416,
			0.4632,
			0.4848,
		},
		{
			0.2376,
			0.2538,
			0.27,
			0.2916,
			0.3078,
			0.3267,
			0.351,
			0.3753,
			0.3996,
			0.4239,
			0.4482,
			0.4725,
			0.4968,
			0.5211,
			0.5454,
		},
	}
	// attack: attack_2 = [2]
	attack_2 = []float64{
		0.4312,
		0.4606,
		0.49,
		0.5292,
		0.5586,
		0.5929,
		0.637,
		0.6811,
		0.7252,
		0.7693,
		0.8134,
		0.8575,
		0.9016,
		0.9457,
		0.9898,
	}
	// attack: attack_3 = [3]
	attack_3 = []float64{
		0.528,
		0.564,
		0.6,
		0.648,
		0.684,
		0.726,
		0.78,
		0.834,
		0.888,
		0.942,
		0.996,
		1.05,
		1.104,
		1.158,
		1.212,
	}
	// attack: attack_4 = [4]
	attack_4 = []float64{
		0.65648,
		0.70124,
		0.746,
		0.80568,
		0.85044,
		0.90266,
		0.9698,
		1.03694,
		1.10408,
		1.17122,
		1.23836,
		1.3055,
		1.37264,
		1.43978,
		1.50692,
	}
	// attack: fullaim = [6]
	fullaim = []float64{
		1.24,
		1.333,
		1.426,
		1.55,
		1.643,
		1.736,
		1.86,
		1.984,
		2.108,
		2.232,
		2.356,
		2.48,
		2.635,
		2.79,
		2.945,
	}
	// skill: skillAtkDecrease = [2]
	skillAtkDecrease = []float64{
		0.12,
		0.12,
		0.12,
		0.13,
		0.13,
		0.13,
		0.14,
		0.14,
		0.14,
		0.15,
		0.15,
		0.15,
		0.15,
		0.15,
		0.15,
	}
	// skill: skillBomblets = [1]
	skillBomblets = []float64{
		0.4,
		0.43,
		0.46,
		0.5,
		0.53,
		0.56,
		0.6,
		0.64,
		0.68,
		0.72,
		0.76,
		0.8,
		0.85,
		0.9,
		0.95,
	}
	// skill: skillCoilNABonus = [4 5 6]
	skillCoilNABonus = [][]float64{
		{
			0.05845,
			0.06195,
			0.06545,
			0.07,
			0.0735,
			0.077,
			0.08155,
			0.0861,
			0.09065,
			0.0952,
			0.09975,
			0.1043,
			0.10885,
			0.1134,
			0.11795,
		},
		{
			0.1169,
			0.1239,
			0.1309,
			0.14,
			0.147,
			0.154,
			0.1631,
			0.1722,
			0.1813,
			0.1904,
			0.1995,
			0.2086,
			0.2177,
			0.2268,
			0.2359,
		},
		{
			0.17535,
			0.18585,
			0.19635,
			0.21,
			0.2205,
			0.231,
			0.24465,
			0.2583,
			0.27195,
			0.2856,
			0.29925,
			0.3129,
			0.32655,
			0.3402,
			0.35385,
		},
	}
	// skill: skillMain = [0]
	skillMain = []float64{
		1.776,
		1.9092,
		2.0424,
		2.22,
		2.3532,
		2.4864,
		2.664,
		2.8416,
		3.0192,
		3.1968,
		3.3744,
		3.552,
		3.774,
		3.996,
		4.218,
	}
	// skill: skillRushingIceNABonus = [7]
	skillRushingIceNABonus = []float64{
		0.29225,
		0.30975,
		0.32725,
		0.35,
		0.3675,
		0.385,
		0.40775,
		0.4305,
		0.45325,
		0.476,
		0.49875,
		0.5215,
		0.54425,
		0.567,
		0.58975,
	}
	// burst: burst = [0]
	burst = []float64{
		3.592,
		3.8614,
		4.1308,
		4.49,
		4.7594,
		5.0288,
		5.388,
		5.7472,
		6.1064,
		6.4656,
		6.8248,
		7.184,
		7.633,
		8.082,
		8.531,
	}
)
