// Code generated by "pipeline"; DO NOT EDIT.
package amber

import (
	_ "embed"

	"fmt"
	"github.com/genshinsim/gcsim/pkg/core/action"
	"github.com/genshinsim/gcsim/pkg/core/keys"
	"github.com/genshinsim/gcsim/pkg/gcs/validation"
	"github.com/genshinsim/gcsim/pkg/model"
	"google.golang.org/protobuf/encoding/prototext"
	"slices"
)

//go:embed data_gen.textproto
var pbData []byte
var base *model.AvatarData
var paramKeysValidation = map[action.Action][]string{
	1: {"hold"},
	3: {"travel"},
	7: {"hold", "travel", "weakspot", "bunny"},
}

func init() {
	base = &model.AvatarData{}
	err := prototext.Unmarshal(pbData, base)
	if err != nil {
		panic(err)
	}
	validation.RegisterCharParamValidationFunc(keys.Amber, ValidateParamKeys)
}

func ValidateParamKeys(a action.Action, keys []string) error {
	valid, ok := paramKeysValidation[a]
	if !ok {
		return nil
	}
	for _, v := range keys {
		if !slices.Contains(valid, v) {
			return fmt.Errorf("key %v is invalid for action %v", v, a.String())
		}
	}
	return nil
}

func (x *char) Data() *model.AvatarData {
	return base
}

var (
	attack = [][]float64{
		attack_1,
		attack_2,
		attack_3,
		attack_4,
		attack_5,
	}
)

var (
	// attack: aim = [5]
	aim = []float64{
		0.4386,
		0.4743,
		0.51,
		0.561,
		0.5967,
		0.6375,
		0.6936,
		0.7497,
		0.8058,
		0.867,
		0.9282,
		0.9894,
		1.0506,
		1.1118,
		1.173,
	}
	// attack: attack_1 = [0]
	attack_1 = []float64{
		0.3612,
		0.3906,
		0.42,
		0.462,
		0.4914,
		0.525,
		0.5712,
		0.6174,
		0.6636,
		0.714,
		0.7644,
		0.8148,
		0.8652,
		0.9156,
		0.966,
	}
	// attack: attack_2 = [1]
	attack_2 = []float64{
		0.3612,
		0.3906,
		0.42,
		0.462,
		0.4914,
		0.525,
		0.5712,
		0.6174,
		0.6636,
		0.714,
		0.7644,
		0.8148,
		0.8652,
		0.9156,
		0.966,
	}
	// attack: attack_3 = [2]
	attack_3 = []float64{
		0.4644,
		0.5022,
		0.54,
		0.594,
		0.6318,
		0.675,
		0.7344,
		0.7938,
		0.8532,
		0.918,
		0.9828,
		1.0476,
		1.1124,
		1.1772,
		1.242,
	}
	// attack: attack_4 = [3]
	attack_4 = []float64{
		0.473,
		0.5115,
		0.55,
		0.605,
		0.6435,
		0.6875,
		0.748,
		0.8085,
		0.869,
		0.935,
		1.001,
		1.067,
		1.133,
		1.199,
		1.265,
	}
	// attack: attack_5 = [4]
	attack_5 = []float64{
		0.5934,
		0.6417,
		0.69,
		0.759,
		0.8073,
		0.8625,
		0.9384,
		1.0143,
		1.0902,
		1.173,
		1.2558,
		1.3386,
		1.4214,
		1.5042,
		1.587,
	}
	// attack: fullaim = [6]
	fullaim = []float64{
		1.24,
		1.333,
		1.426,
		1.55,
		1.643,
		1.736,
		1.86,
		1.984,
		2.108,
		2.232,
		2.356,
		2.48,
		2.635,
		2.79,
		2.945,
	}
	// skill: bunnyExplode = [1]
	bunnyExplode = []float64{
		1.232,
		1.3244,
		1.4168,
		1.54,
		1.6324,
		1.7248,
		1.848,
		1.9712,
		2.0944,
		2.2176,
		2.3408,
		2.464,
		2.618,
		2.772,
		2.926,
	}
	// burst: burstTick = [0]
	burstTick = []float64{
		0.2808,
		0.30186,
		0.32292,
		0.351,
		0.37206,
		0.39312,
		0.4212,
		0.44928,
		0.47736,
		0.50544,
		0.53352,
		0.5616,
		0.5967,
		0.6318,
		0.6669,
	}
)
