// Code generated by "pipeline"; DO NOT EDIT.
package chasca

import (
	_ "embed"

	"fmt"
	"github.com/genshinsim/gcsim/pkg/core/action"
	"github.com/genshinsim/gcsim/pkg/core/keys"
	"github.com/genshinsim/gcsim/pkg/gcs/validation"
	"github.com/genshinsim/gcsim/pkg/model"
	"google.golang.org/protobuf/encoding/prototext"
	"slices"
)

//go:embed data_gen.textproto
var pbData []byte
var base *model.AvatarData
var paramKeysValidation = map[action.Action][]string{
	3: {"travel"},
	6: {"collision"},
	7: {"hold", "travel", "weakspot", "bullets"},
}

func init() {
	base = &model.AvatarData{}
	err := prototext.Unmarshal(pbData, base)
	if err != nil {
		panic(err)
	}
	validation.RegisterCharParamValidationFunc(keys.Chasca, ValidateParamKeys)
}

func ValidateParamKeys(a action.Action, keys []string) error {
	valid, ok := paramKeysValidation[a]
	if !ok {
		return nil
	}
	for _, v := range keys {
		if !slices.Contains(valid, v) {
			return fmt.Errorf("key %v is invalid for action %v", v, a.String())
		}
	}
	return nil
}

func (x *char) Data() *model.AvatarData {
	return base
}

var (
	attack = [][]float64{
		attack_1,
		attack_2,
		attack_3,
		attack_4,
	}
)

var (
	// attack: aim = [4]
	aim = []float64{
		0.4386,
		0.4743,
		0.51,
		0.561,
		0.5967,
		0.6375,
		0.6936,
		0.7497,
		0.8058,
		0.867,
		0.9282,
		0.9894,
		1.0506,
		1.1118,
		1.173,
	}
	// attack: attack_1 = [0]
	attack_1 = []float64{
		0.480078,
		0.519154,
		0.55823,
		0.614053,
		0.653129,
		0.697788,
		0.759193,
		0.820598,
		0.882003,
		0.948991,
		1.015979,
		1.082966,
		1.149954,
		1.216941,
		1.283929,
	}
	// attack: attack_2 = [1]
	attack_2 = []float64{
		0.445884,
		0.482177,
		0.51847,
		0.570317,
		0.60661,
		0.648087,
		0.705119,
		0.762151,
		0.819183,
		0.881399,
		0.943615,
		1.005832,
		1.068048,
		1.130265,
		1.192481,
	}
	// attack: attack_3 = [2]
	attack_3 = []float64{
		0.296975,
		0.321148,
		0.34532,
		0.379852,
		0.404024,
		0.43165,
		0.469635,
		0.50762,
		0.545606,
		0.587044,
		0.628482,
		0.669921,
		0.711359,
		0.752798,
		0.794236,
	}
	// attack: attack_4 = [3]
	attack_4 = []float64{
		0.254672,
		0.275401,
		0.29613,
		0.325743,
		0.346472,
		0.370163,
		0.402737,
		0.435311,
		0.467885,
		0.503421,
		0.538957,
		0.574492,
		0.610028,
		0.645563,
		0.681099,
	}
	// attack: fullAim = [5]
	fullAim = []float64{
		1.24,
		1.333,
		1.426,
		1.55,
		1.643,
		1.736,
		1.86,
		1.984,
		2.108,
		2.232,
		2.356,
		2.48,
		2.635,
		2.79,
		2.945,
	}
	// attack: lowPlunge = [7]
	lowPlunge = []float64{
		1.136335,
		1.228828,
		1.32132,
		1.453452,
		1.545944,
		1.65165,
		1.796995,
		1.94234,
		2.087686,
		2.246244,
		2.404802,
		2.563361,
		2.721919,
		2.880478,
		3.039036,
	}
	// attack: plunge = [6]
	plunge = []float64{
		0.568288,
		0.614544,
		0.6608,
		0.72688,
		0.773136,
		0.826,
		0.898688,
		0.971376,
		1.044064,
		1.12336,
		1.202656,
		1.281952,
		1.361248,
		1.440544,
		1.51984,
	}
	// skill: skillNA = [1]
	skillNA = []float64{
		0.36,
		0.387,
		0.414,
		0.45,
		0.477,
		0.504,
		0.54,
		0.576,
		0.612,
		0.648,
		0.684,
		0.72,
		0.765,
		0.81,
		0.855,
	}
	// skill: skillResonance = [0]
	skillResonance = []float64{
		0.6,
		0.645,
		0.69,
		0.75,
		0.795,
		0.84,
		0.9,
		0.96,
		1.02,
		1.08,
		1.14,
		1.2,
		1.275,
		1.35,
		1.425,
	}
	// skill: skillShadowhunt = [2]
	skillShadowhunt = []float64{
		0.488,
		0.5246,
		0.5612,
		0.61,
		0.6466,
		0.6832,
		0.732,
		0.7808,
		0.8296,
		0.8784,
		0.9272,
		0.976,
		1.037,
		1.098,
		1.159,
	}
	// skill: skillShining = [3]
	skillShining = []float64{
		1.66572,
		1.790649,
		1.915578,
		2.08215,
		2.207079,
		2.332008,
		2.49858,
		2.665152,
		2.831724,
		2.998296,
		3.164868,
		3.33144,
		3.539655,
		3.74787,
		3.956085,
	}
	// burst: burstGalesplitting = [0]
	burstGalesplitting = []float64{
		0.88,
		0.946,
		1.012,
		1.1,
		1.166,
		1.232,
		1.32,
		1.408,
		1.496,
		1.584,
		1.672,
		1.76,
		1.87,
		1.98,
		2.09,
	}
	// burst: burstRadiant = [2]
	burstRadiant = []float64{
		2.068,
		2.2231,
		2.3782,
		2.585,
		2.7401,
		2.8952,
		3.102,
		3.3088,
		3.5156,
		3.7224,
		3.9292,
		4.136,
		4.3945,
		4.653,
		4.9115,
	}
	// burst: burstSoulseeker = [1]
	burstSoulseeker = []float64{
		1.034,
		1.11155,
		1.1891,
		1.2925,
		1.37005,
		1.4476,
		1.551,
		1.6544,
		1.7578,
		1.8612,
		1.9646,
		2.068,
		2.19725,
		2.3265,
		2.45575,
	}
)
