// Code generated by "pipeline"; DO NOT EDIT.
package collei

import (
	_ "embed"

	"fmt"
	"github.com/genshinsim/gcsim/pkg/core/action"
	"github.com/genshinsim/gcsim/pkg/core/keys"
	"github.com/genshinsim/gcsim/pkg/gcs/validation"
	"github.com/genshinsim/gcsim/pkg/model"
	"google.golang.org/protobuf/encoding/prototext"
	"slices"
)

//go:embed data_gen.textproto
var pbData []byte
var base *model.AvatarData
var paramKeysValidation = map[action.Action][]string{
	3: {"travel"},
	7: {"hold", "travel", "weakspot"},
}

func init() {
	base = &model.AvatarData{}
	err := prototext.Unmarshal(pbData, base)
	if err != nil {
		panic(err)
	}
	validation.RegisterCharParamValidationFunc(keys.Collei, ValidateParamKeys)
}

func ValidateParamKeys(a action.Action, keys []string) error {
	valid, ok := paramKeysValidation[a]
	if !ok {
		return nil
	}
	for _, v := range keys {
		if !slices.Contains(valid, v) {
			return fmt.Errorf("key %v is invalid for action %v", v, a.String())
		}
	}
	return nil
}

func (x *char) Data() *model.AvatarData {
	return base
}

var (
	attack = [][]float64{
		attack_1,
		attack_2,
		attack_3,
		attack_4,
	}
)

var (
	// attack: aim = [4]
	aim = []float64{
		0.4386,
		0.4743,
		0.51,
		0.561,
		0.5967,
		0.6375,
		0.6936,
		0.7497,
		0.8058,
		0.867,
		0.9282,
		0.9894,
		1.0506,
		1.1118,
		1.173,
	}
	// attack: attack_1 = [0]
	attack_1 = []float64{
		0.43602,
		0.47151,
		0.507,
		0.5577,
		0.59319,
		0.63375,
		0.68952,
		0.74529,
		0.80106,
		0.8619,
		0.92274,
		0.98358,
		1.04442,
		1.10526,
		1.1661,
	}
	// attack: attack_2 = [1]
	attack_2 = []float64{
		0.42656,
		0.46128,
		0.496,
		0.5456,
		0.58032,
		0.62,
		0.67456,
		0.72912,
		0.78368,
		0.8432,
		0.90272,
		0.96224,
		1.02176,
		1.08128,
		1.1408,
	}
	// attack: attack_3 = [2]
	attack_3 = []float64{
		0.54094,
		0.58497,
		0.629,
		0.6919,
		0.73593,
		0.78625,
		0.85544,
		0.92463,
		0.99382,
		1.0693,
		1.14478,
		1.22026,
		1.29574,
		1.37122,
		1.4467,
	}
	// attack: attack_4 = [3]
	attack_4 = []float64{
		0.68026,
		0.73563,
		0.791,
		0.8701,
		0.92547,
		0.98875,
		1.07576,
		1.16277,
		1.24978,
		1.3447,
		1.43962,
		1.53454,
		1.62946,
		1.72438,
		1.8193,
	}
	// attack: fullaim = [5]
	fullaim = []float64{
		1.24,
		1.333,
		1.426,
		1.55,
		1.643,
		1.736,
		1.86,
		1.984,
		2.108,
		2.232,
		2.356,
		2.48,
		2.635,
		2.79,
		2.945,
	}
	// skill: skill = [0]
	skill = []float64{
		1.512,
		1.6254,
		1.7388,
		1.89,
		2.0034,
		2.1168,
		2.268,
		2.4192,
		2.5704,
		2.7216,
		2.8728,
		3.024,
		3.213,
		3.402,
		3.591,
	}
	// burst: burstExplosion = [0]
	burstExplosion = []float64{
		2.01824,
		2.169608,
		2.320976,
		2.5228,
		2.674168,
		2.825536,
		3.02736,
		3.229184,
		3.431008,
		3.632832,
		3.834656,
		4.03648,
		4.28876,
		4.54104,
		4.79332,
	}
	// burst: burstLeap = [1]
	burstLeap = []float64{
		0.43248,
		0.464916,
		0.497352,
		0.5406,
		0.573036,
		0.605472,
		0.64872,
		0.691968,
		0.735216,
		0.778464,
		0.821712,
		0.86496,
		0.91902,
		0.97308,
		1.02714,
	}
)
