// Code generated by "pipeline"; DO NOT EDIT.
package cyno

import (
	_ "embed"

	"fmt"
	"github.com/genshinsim/gcsim/pkg/core/action"
	"github.com/genshinsim/gcsim/pkg/core/keys"
	"github.com/genshinsim/gcsim/pkg/gcs/validation"
	"github.com/genshinsim/gcsim/pkg/model"
	"google.golang.org/protobuf/encoding/prototext"
	"slices"
)

//go:embed data_gen.textproto
var pbData []byte
var base *model.AvatarData
var paramKeysValidation = map[action.Action][]string{
	5: {"collision"},
	6: {"collision"},
}

func init() {
	base = &model.AvatarData{}
	err := prototext.Unmarshal(pbData, base)
	if err != nil {
		panic(err)
	}
	validation.RegisterCharParamValidationFunc(keys.Cyno, ValidateParamKeys)
}

func ValidateParamKeys(a action.Action, keys []string) error {
	valid, ok := paramKeysValidation[a]
	if !ok {
		return nil
	}
	for _, v := range keys {
		if !slices.Contains(valid, v) {
			return fmt.Errorf("key %v is invalid for action %v", v, a.String())
		}
	}
	return nil
}

func (x *char) Data() *model.AvatarData {
	return base
}

var (
	attack = [][][]float64{
		{attack_1},
		{attack_2},
		attack_3,
		{attack_4},
	}
	attackB = [][][]float64{
		{attackB_1},
		{attackB_2},
		{attackB_3},
		attackB_4,
		{attackB_5},
	}
)

var (
	// attack: attack_1 = [0]
	attack_1 = []float64{
		0.492574,
		0.532667,
		0.57276,
		0.630036,
		0.670129,
		0.71595,
		0.778954,
		0.841957,
		0.904961,
		0.973692,
		1.042423,
		1.111154,
		1.179886,
		1.248617,
		1.317348,
	}
	// attack: attack_2 = [1]
	attack_2 = []float64{
		0.479209,
		0.518215,
		0.55722,
		0.612942,
		0.651947,
		0.696525,
		0.757819,
		0.819113,
		0.880408,
		0.947274,
		1.01414,
		1.081007,
		1.147873,
		1.21474,
		1.281606,
	}
	// attack: attack_3 = [2 2]
	attack_3 = [][]float64{
		{
			0.293062,
			0.316916,
			0.34077,
			0.374847,
			0.398701,
			0.425963,
			0.463447,
			0.500932,
			0.538417,
			0.579309,
			0.620201,
			0.661094,
			0.701986,
			0.742879,
			0.783771,
		},
		{
			0.293062,
			0.316916,
			0.34077,
			0.374847,
			0.398701,
			0.425963,
			0.463447,
			0.500932,
			0.538417,
			0.579309,
			0.620201,
			0.661094,
			0.701986,
			0.742879,
			0.783771,
		},
	}
	// attack: attack_4 = [4]
	attack_4 = []float64{
		0.758907,
		0.820679,
		0.88245,
		0.970695,
		1.032466,
		1.103063,
		1.200132,
		1.297202,
		1.394271,
		1.500165,
		1.606059,
		1.711953,
		1.817847,
		1.923741,
		2.029635,
	}
	// attack: charge = [5]
	charge = []float64{
		1.22378,
		1.32339,
		1.423,
		1.5653,
		1.66491,
		1.77875,
		1.93528,
		2.09181,
		2.24834,
		2.4191,
		2.58986,
		2.76062,
		2.93138,
		3.10214,
		3.2729,
	}
	// attack: collision = [7]
	collision = []float64{
		0.639324,
		0.691362,
		0.7434,
		0.81774,
		0.869778,
		0.92925,
		1.011024,
		1.092798,
		1.174572,
		1.26378,
		1.352988,
		1.442196,
		1.531404,
		1.620612,
		1.70982,
	}
	// attack: highPlunge = [9]
	highPlunge = []float64{
		1.596762,
		1.726731,
		1.8567,
		2.04237,
		2.172339,
		2.320875,
		2.525112,
		2.729349,
		2.933586,
		3.15639,
		3.379194,
		3.601998,
		3.824802,
		4.047606,
		4.27041,
	}
	// attack: lowPlunge = [8]
	lowPlunge = []float64{
		1.278377,
		1.382431,
		1.486485,
		1.635134,
		1.739187,
		1.858106,
		2.02162,
		2.185133,
		2.348646,
		2.527025,
		2.705403,
		2.883781,
		3.062159,
		3.240537,
		3.418915,
	}
	// skill: skill = [0]
	skill = []float64{
		1.304,
		1.4018,
		1.4996,
		1.63,
		1.7278,
		1.8256,
		1.956,
		2.0864,
		2.2168,
		2.3472,
		2.4776,
		2.608,
		2.771,
		2.934,
		3.097,
	}
	// skill: skillB = [1]
	skillB = []float64{
		1.568,
		1.6856,
		1.8032,
		1.96,
		2.0776,
		2.1952,
		2.352,
		2.5088,
		2.6656,
		2.8224,
		2.9792,
		3.136,
		3.332,
		3.528,
		3.724,
	}
	// burst: attackB_1 = [0]
	attackB_1 = []float64{
		0.782832,
		0.846551,
		0.91027,
		1.001297,
		1.065016,
		1.137838,
		1.237967,
		1.338097,
		1.438227,
		1.547459,
		1.656691,
		1.765924,
		1.875156,
		1.984389,
		2.093621,
	}
	// burst: attackB_2 = [1]
	attackB_2 = []float64{
		0.824688,
		0.891814,
		0.95894,
		1.054834,
		1.12196,
		1.198675,
		1.304158,
		1.409642,
		1.515125,
		1.630198,
		1.745271,
		1.860344,
		1.975416,
		2.090489,
		2.205562,
	}
	// burst: attackB_3 = [2]
	attackB_3 = []float64{
		1.046336,
		1.131503,
		1.21667,
		1.338337,
		1.423504,
		1.520837,
		1.654671,
		1.788505,
		1.922339,
		2.068339,
		2.214339,
		2.36034,
		2.50634,
		2.652341,
		2.798341,
	}
	// burst: attackB_4 = [3 3]
	attackB_4 = [][]float64{
		{
			0.516942,
			0.559018,
			0.601095,
			0.661205,
			0.703281,
			0.751369,
			0.817489,
			0.88361,
			0.94973,
			1.021861,
			1.093993,
			1.166124,
			1.238256,
			1.310387,
			1.382518,
		},
		{
			0.516942,
			0.559018,
			0.601095,
			0.661205,
			0.703281,
			0.751369,
			0.817489,
			0.88361,
			0.94973,
			1.021861,
			1.093993,
			1.166124,
			1.238256,
			1.310387,
			1.382518,
		},
	}
	// burst: attackB_5 = [5]
	attackB_5 = []float64{
		1.308447,
		1.414948,
		1.52145,
		1.673595,
		1.780096,
		1.901812,
		2.069172,
		2.236531,
		2.403891,
		2.586465,
		2.769039,
		2.951613,
		3.134187,
		3.316761,
		3.499335,
	}
	// burst: chargeB = [6]
	chargeB = []float64{
		1.0105,
		1.09275,
		1.175,
		1.2925,
		1.37475,
		1.46875,
		1.598,
		1.72725,
		1.8565,
		1.9975,
		2.1385,
		2.2795,
		2.4205,
		2.5615,
		2.7025,
	}
	// burst: collisionB = [8]
	collisionB = []float64{
		0.639324,
		0.691362,
		0.7434,
		0.81774,
		0.869778,
		0.92925,
		1.011024,
		1.092798,
		1.174572,
		1.26378,
		1.352988,
		1.442196,
		1.531404,
		1.620612,
		1.70982,
	}
	// burst: highPlungeB = [10]
	highPlungeB = []float64{
		1.596762,
		1.726731,
		1.8567,
		2.04237,
		2.172339,
		2.320875,
		2.525112,
		2.729349,
		2.933586,
		3.15639,
		3.379194,
		3.601998,
		3.824802,
		4.047606,
		4.27041,
	}
	// burst: lowPlungeB = [9]
	lowPlungeB = []float64{
		1.278377,
		1.382431,
		1.486485,
		1.635134,
		1.739187,
		1.858106,
		2.02162,
		2.185133,
		2.348646,
		2.527025,
		2.705403,
		2.883781,
		3.062159,
		3.240537,
		3.418915,
	}
)
