// Code generated by "pipeline"; DO NOT EDIT.
package diluc

import (
	_ "embed"

	"fmt"
	"github.com/genshinsim/gcsim/pkg/core/action"
	"github.com/genshinsim/gcsim/pkg/core/keys"
	"github.com/genshinsim/gcsim/pkg/gcs/validation"
	"github.com/genshinsim/gcsim/pkg/model"
	"google.golang.org/protobuf/encoding/prototext"
	"slices"
)

//go:embed data_gen.textproto
var pbData []byte
var base *model.AvatarData
var paramKeysValidation = map[action.Action][]string{
	5: {"collision"},
	6: {"collision"},
}

func init() {
	base = &model.AvatarData{}
	err := prototext.Unmarshal(pbData, base)
	if err != nil {
		panic(err)
	}
	validation.RegisterCharParamValidationFunc(keys.Diluc, ValidateParamKeys)
}

func ValidateParamKeys(a action.Action, keys []string) error {
	valid, ok := paramKeysValidation[a]
	if !ok {
		return nil
	}
	for _, v := range keys {
		if !slices.Contains(valid, v) {
			return fmt.Errorf("key %v is invalid for action %v", v, a.String())
		}
	}
	return nil
}

func (x *char) Data() *model.AvatarData {
	return base
}

var (
	attack = [][]float64{
		attack_1,
		attack_2,
		attack_3,
		attack_4,
	}
)

var (
	// attack: attack_1 = [0]
	attack_1 = []float64{
		0.89698,
		0.96999,
		1.043,
		1.1473,
		1.22031,
		1.30375,
		1.41848,
		1.53321,
		1.64794,
		1.7731,
		1.916513,
		2.085166,
		2.253819,
		2.422472,
		2.606457,
	}
	// attack: attack_2 = [1]
	attack_2 = []float64{
		0.87634,
		0.94767,
		1.019,
		1.1209,
		1.19223,
		1.27375,
		1.38584,
		1.49793,
		1.61002,
		1.7323,
		1.872412,
		2.037185,
		2.201957,
		2.366729,
		2.546481,
	}
	// attack: attack_3 = [2]
	attack_3 = []float64{
		0.98814,
		1.06857,
		1.149,
		1.2639,
		1.34433,
		1.43625,
		1.56264,
		1.68903,
		1.81542,
		1.9533,
		2.111287,
		2.297081,
		2.482874,
		2.668667,
		2.871351,
	}
	// attack: attack_4 = [3]
	attack_4 = []float64{
		1.33988,
		1.44894,
		1.558,
		1.7138,
		1.82286,
		1.9475,
		2.11888,
		2.29026,
		2.46164,
		2.6486,
		2.862825,
		3.114754,
		3.366682,
		3.618611,
		3.893442,
	}
	// attack: collision = [8]
	collision = []float64{
		0.895054,
		0.967907,
		1.04076,
		1.144836,
		1.217689,
		1.30095,
		1.415434,
		1.529917,
		1.644401,
		1.769292,
		1.894183,
		2.019074,
		2.143966,
		2.268857,
		2.393748,
	}
	// attack: highPlunge = [10]
	highPlunge = []float64{
		2.235467,
		2.417423,
		2.59938,
		2.859318,
		3.041275,
		3.249225,
		3.535157,
		3.821089,
		4.10702,
		4.418946,
		4.730872,
		5.042797,
		5.354723,
		5.666648,
		5.978574,
	}
	// attack: lowPlunge = [9]
	lowPlunge = []float64{
		1.789728,
		1.935403,
		2.081079,
		2.289187,
		2.434862,
		2.601349,
		2.830267,
		3.059186,
		3.288105,
		3.537834,
		3.787564,
		4.037293,
		4.287023,
		4.536752,
		4.786482,
	}
	// skill: skill = [0 1 2]
	skill = [][]float64{
		{
			0.944,
			1.0148,
			1.0856,
			1.18,
			1.2508,
			1.3216,
			1.416,
			1.5104,
			1.6048,
			1.6992,
			1.7936,
			1.888,
			2.006,
			2.124,
			2.242,
		},
		{
			0.976,
			1.0492,
			1.1224,
			1.22,
			1.2932,
			1.3664,
			1.464,
			1.5616,
			1.6592,
			1.7568,
			1.8544,
			1.952,
			2.074,
			2.196,
			2.318,
		},
		{
			1.288,
			1.3846,
			1.4812,
			1.61,
			1.7066,
			1.8032,
			1.932,
			2.0608,
			2.1896,
			2.3184,
			2.4472,
			2.576,
			2.737,
			2.898,
			3.059,
		},
	}
	// burst: burstDOT = [1]
	burstDOT = []float64{
		0.6,
		0.645,
		0.69,
		0.75,
		0.795,
		0.84,
		0.9,
		0.96,
		1.02,
		1.08,
		1.14,
		1.2,
		1.275,
		1.35,
		1.425,
	}
	// burst: burstExplode = [0]
	burstExplode = []float64{
		2.04,
		2.193,
		2.346,
		2.55,
		2.703,
		2.856,
		3.06,
		3.264,
		3.468,
		3.672,
		3.876,
		4.08,
		4.335,
		4.59,
		4.845,
	}
	// burst: burstInitial = [0]
	burstInitial = []float64{
		2.04,
		2.193,
		2.346,
		2.55,
		2.703,
		2.856,
		3.06,
		3.264,
		3.468,
		3.672,
		3.876,
		4.08,
		4.335,
		4.59,
		4.845,
	}
)
