// Code generated by "pipeline"; DO NOT EDIT.
package dori

import (
	_ "embed"

	"fmt"
	"github.com/genshinsim/gcsim/pkg/core/action"
	"github.com/genshinsim/gcsim/pkg/core/keys"
	"github.com/genshinsim/gcsim/pkg/gcs/validation"
	"github.com/genshinsim/gcsim/pkg/model"
	"google.golang.org/protobuf/encoding/prototext"
	"slices"
)

//go:embed data_gen.textproto
var pbData []byte
var base *model.AvatarData
var paramKeysValidation = map[action.Action][]string{
	1: {"travel"},
	2: {"c2_travel"},
	5: {"collision"},
	6: {"collision"},
}

func init() {
	base = &model.AvatarData{}
	err := prototext.Unmarshal(pbData, base)
	if err != nil {
		panic(err)
	}
	validation.RegisterCharParamValidationFunc(keys.Dori, ValidateParamKeys)
}

func ValidateParamKeys(a action.Action, keys []string) error {
	valid, ok := paramKeysValidation[a]
	if !ok {
		return nil
	}
	for _, v := range keys {
		if !slices.Contains(valid, v) {
			return fmt.Errorf("key %v is invalid for action %v", v, a.String())
		}
	}
	return nil
}

func (x *char) Data() *model.AvatarData {
	return base
}

var (
	auto = [][][]float64{
		{auto_1},
		auto_2,
		{auto_3},
	}
)

var (
	// attack: auto_1 = [0]
	auto_1 = []float64{
		0.90214,
		0.97557,
		1.049,
		1.1539,
		1.22733,
		1.31125,
		1.42664,
		1.54203,
		1.65742,
		1.7833,
		1.90918,
		2.03506,
		2.16094,
		2.28682,
		2.4127,
	}
	// attack: auto_2 = [1 2]
	auto_2 = [][]float64{
		{
			0.410736,
			0.444168,
			0.4776,
			0.52536,
			0.558792,
			0.597,
			0.649536,
			0.702072,
			0.754608,
			0.81192,
			0.869232,
			0.926544,
			0.983856,
			1.041168,
			1.09848,
		},
		{
			0.431204,
			0.466302,
			0.5014,
			0.55154,
			0.586638,
			0.62675,
			0.681904,
			0.737058,
			0.792212,
			0.85238,
			0.912548,
			0.972716,
			1.032884,
			1.093052,
			1.15322,
		},
	}
	// attack: auto_3 = [3]
	auto_3 = []float64{
		1.28398,
		1.38849,
		1.493,
		1.6423,
		1.74681,
		1.86625,
		2.03048,
		2.19471,
		2.35894,
		2.5381,
		2.71726,
		2.89642,
		3.07558,
		3.25474,
		3.4339,
	}
	// attack: collision = [8]
	collision = []float64{
		0.745878,
		0.806589,
		0.8673,
		0.95403,
		1.014741,
		1.084125,
		1.179528,
		1.274931,
		1.370334,
		1.47441,
		1.578486,
		1.682562,
		1.786638,
		1.890714,
		1.99479,
	}
	// attack: highPlunge = [10]
	highPlunge = []float64{
		1.862889,
		2.01452,
		2.16615,
		2.382765,
		2.534396,
		2.707688,
		2.945964,
		3.184241,
		3.422517,
		3.682455,
		3.942393,
		4.202331,
		4.462269,
		4.722207,
		4.982145,
	}
	// attack: lowPlunge = [9]
	lowPlunge = []float64{
		1.49144,
		1.612836,
		1.734233,
		1.907656,
		2.029052,
		2.167791,
		2.358556,
		2.549322,
		2.740087,
		2.948195,
		3.156303,
		3.364411,
		3.572519,
		3.780627,
		3.988735,
	}
	// skill: skill = [0]
	skill = []float64{
		1.4728,
		1.58326,
		1.69372,
		1.841,
		1.95146,
		2.06192,
		2.2092,
		2.35648,
		2.50376,
		2.65104,
		2.79832,
		2.9456,
		3.1297,
		3.3138,
		3.4979,
	}
	// skill: skillAfter = [1]
	skillAfter = []float64{
		0.3156,
		0.33927,
		0.36294,
		0.3945,
		0.41817,
		0.44184,
		0.4734,
		0.50496,
		0.53652,
		0.56808,
		0.59964,
		0.6312,
		0.67065,
		0.7101,
		0.74955,
	}
	// burst: burst = [0]
	burst = []float64{
		0.158824,
		0.170736,
		0.182648,
		0.19853,
		0.210442,
		0.222354,
		0.238236,
		0.254118,
		0.270001,
		0.285883,
		0.301766,
		0.317648,
		0.337501,
		0.357354,
		0.377207,
	}
	// burst: burstenergy = [3]
	burstenergy = []float64{
		1.6,
		1.7,
		1.8,
		1.9,
		2,
		2.1,
		2.2,
		2.3,
		2.4,
		2.5,
		2.5,
		2.5,
		2.5,
		2.5,
		2.5,
	}
	// burst: bursthealflat = [2]
	bursthealflat = []float64{
		641.97955,
		706.18646,
		775.7439,
		850.6519,
		930.9105,
		1016.5197,
		1107.4795,
		1203.7898,
		1305.4507,
		1412.4622,
		1524.8242,
		1642.5369,
		1765.6,
		1894.0138,
		2027.7781,
	}
	// burst: bursthealpp = [1]
	bursthealpp = []float64{
		0.0667,
		0.071702,
		0.076705,
		0.083375,
		0.088377,
		0.09338,
		0.10005,
		0.10672,
		0.11339,
		0.12006,
		0.12673,
		0.1334,
		0.141737,
		0.150075,
		0.158412,
	}
)
