// Code generated by "pipeline"; DO NOT EDIT.
package eula

import (
	_ "embed"

	"fmt"
	"github.com/genshinsim/gcsim/pkg/core/action"
	"github.com/genshinsim/gcsim/pkg/core/keys"
	"github.com/genshinsim/gcsim/pkg/gcs/validation"
	"github.com/genshinsim/gcsim/pkg/model"
	"google.golang.org/protobuf/encoding/prototext"
	"slices"
)

//go:embed data_gen.textproto
var pbData []byte
var base *model.AvatarData
var paramKeysValidation = map[action.Action][]string{
	1: {"hold"},
	5: {"collision"},
	6: {"collision"},
}

func init() {
	base = &model.AvatarData{}
	err := prototext.Unmarshal(pbData, base)
	if err != nil {
		panic(err)
	}
	validation.RegisterCharParamValidationFunc(keys.Eula, ValidateParamKeys)
}

func ValidateParamKeys(a action.Action, keys []string) error {
	valid, ok := paramKeysValidation[a]
	if !ok {
		return nil
	}
	for _, v := range keys {
		if !slices.Contains(valid, v) {
			return fmt.Errorf("key %v is invalid for action %v", v, a.String())
		}
	}
	return nil
}

func (x *char) Data() *model.AvatarData {
	return base
}

var (
	auto = [][][]float64{
		{auto_1},
		{auto_2},
		auto_3,
		{auto_4},
		auto_5,
	}
)

var (
	// attack: auto_1 = [0]
	auto_1 = []float64{
		0.897324,
		0.970362,
		1.0434,
		1.14774,
		1.220778,
		1.30425,
		1.419024,
		1.533798,
		1.648572,
		1.77378,
		1.917248,
		2.085965,
		2.254683,
		2.423401,
		2.607457,
	}
	// attack: auto_2 = [1]
	auto_2 = []float64{
		0.935508,
		1.011654,
		1.0878,
		1.19658,
		1.272726,
		1.35975,
		1.479408,
		1.599066,
		1.718724,
		1.84926,
		1.998833,
		2.17473,
		2.350627,
		2.526524,
		2.718412,
	}
	// attack: auto_3 = [2 2]
	auto_3 = [][]float64{
		{
			0.567987,
			0.614219,
			0.66045,
			0.726495,
			0.772726,
			0.825562,
			0.898212,
			0.970861,
			1.043511,
			1.122765,
			1.213577,
			1.320372,
			1.427166,
			1.533961,
			1.650465,
		},
		{
			0.567987,
			0.614219,
			0.66045,
			0.726495,
			0.772726,
			0.825562,
			0.898212,
			0.970861,
			1.043511,
			1.122765,
			1.213577,
			1.320372,
			1.427166,
			1.533961,
			1.650465,
		},
	}
	// attack: auto_4 = [3]
	auto_4 = []float64{
		1.126428,
		1.218114,
		1.3098,
		1.44078,
		1.532466,
		1.63725,
		1.781328,
		1.925406,
		2.069484,
		2.22666,
		2.406758,
		2.618552,
		2.830347,
		3.042141,
		3.27319,
	}
	// attack: auto_5 = [4 4]
	auto_5 = [][]float64{
		{
			0.718336,
			0.776806,
			0.835275,
			0.918803,
			0.977272,
			1.044094,
			1.135974,
			1.227854,
			1.319735,
			1.419968,
			1.534818,
			1.669882,
			1.804946,
			1.94001,
			2.087352,
		},
		{
			0.718336,
			0.776806,
			0.835275,
			0.918803,
			0.977272,
			1.044094,
			1.135974,
			1.227854,
			1.319735,
			1.419968,
			1.534818,
			1.669882,
			1.804946,
			1.94001,
			2.087352,
		},
	}
	// attack: collision = [9]
	collision = []float64{
		0.745878,
		0.806589,
		0.8673,
		0.95403,
		1.014741,
		1.084125,
		1.179528,
		1.274931,
		1.370334,
		1.47441,
		1.593664,
		1.733906,
		1.874149,
		2.014391,
		2.167383,
	}
	// attack: highPlunge = [11]
	highPlunge = []float64{
		1.862889,
		2.01452,
		2.16615,
		2.382765,
		2.534396,
		2.707688,
		2.945964,
		3.184241,
		3.422517,
		3.682455,
		3.980301,
		4.330567,
		4.680834,
		5.0311,
		5.413209,
	}
	// attack: lowPlunge = [10]
	lowPlunge = []float64{
		1.49144,
		1.612836,
		1.734233,
		1.907656,
		2.029052,
		2.167791,
		2.358556,
		2.549322,
		2.740087,
		2.948195,
		3.186652,
		3.467078,
		3.747503,
		4.027928,
		4.333847,
	}
	// skill: icewhirl = [2]
	icewhirl = []float64{
		0.96,
		1.032,
		1.104,
		1.2,
		1.272,
		1.344,
		1.44,
		1.536,
		1.632,
		1.728,
		1.824,
		1.92,
		2.04,
		2.16,
		2.28,
	}
	// skill: resRed = [3]
	resRed = []float64{
		0.16,
		0.17,
		0.18,
		0.19,
		0.2,
		0.21,
		0.22,
		0.23,
		0.24,
		0.25,
		0.25,
		0.25,
		0.25,
		0.25,
		0.25,
	}
	// skill: skillPress = [0]
	skillPress = []float64{
		1.464,
		1.5738,
		1.6836,
		1.83,
		1.9398,
		2.0496,
		2.196,
		2.3424,
		2.4888,
		2.6352,
		2.7816,
		2.928,
		3.111,
		3.294,
		3.477,
	}
	// burst: burstExplodeBase = [1]
	burstExplodeBase = []float64{
		3.67048,
		3.96924,
		4.268,
		4.6948,
		4.99356,
		5.335,
		5.80448,
		6.27396,
		6.74344,
		7.2556,
		7.84245,
		8.532586,
		9.222721,
		9.912857,
		10.665732,
	}
	// burst: burstExplodeStack = [2]
	burstExplodeStack = []float64{
		0.74992,
		0.81096,
		0.872,
		0.9592,
		1.02024,
		1.09,
		1.18592,
		1.28184,
		1.37776,
		1.4824,
		1.6023,
		1.743302,
		1.884305,
		2.025307,
		2.179128,
	}
	// burst: burstInitial = [0]
	burstInitial = []float64{
		2.456,
		2.6402,
		2.8244,
		3.07,
		3.2542,
		3.4384,
		3.684,
		3.9296,
		4.1752,
		4.4208,
		4.6664,
		4.912,
		5.219,
		5.526,
		5.833,
	}
	// burst: skillHold = [0]
	skillHold = []float64{
		2.456,
		2.6402,
		2.8244,
		3.07,
		3.2542,
		3.4384,
		3.684,
		3.9296,
		4.1752,
		4.4208,
		4.6664,
		4.912,
		5.219,
		5.526,
		5.833,
	}
)
