// Code generated by "pipeline"; DO NOT EDIT.
package freminet

import (
	_ "embed"

	"fmt"
	"github.com/genshinsim/gcsim/pkg/core/action"
	"github.com/genshinsim/gcsim/pkg/core/keys"
	"github.com/genshinsim/gcsim/pkg/gcs/validation"
	"github.com/genshinsim/gcsim/pkg/model"
	"google.golang.org/protobuf/encoding/prototext"
	"slices"
)

//go:embed data_gen.textproto
var pbData []byte
var base *model.AvatarData
var paramKeysValidation = map[action.Action][]string{
	5: {"collision"},
	6: {"collision"},
}

func init() {
	base = &model.AvatarData{}
	err := prototext.Unmarshal(pbData, base)
	if err != nil {
		panic(err)
	}
	validation.RegisterCharParamValidationFunc(keys.Freminet, ValidateParamKeys)
}

func ValidateParamKeys(a action.Action, keys []string) error {
	valid, ok := paramKeysValidation[a]
	if !ok {
		return nil
	}
	for _, v := range keys {
		if !slices.Contains(valid, v) {
			return fmt.Errorf("key %v is invalid for action %v", v, a.String())
		}
	}
	return nil
}

func (x *char) Data() *model.AvatarData {
	return base
}

var (
	attack = [][]float64{
		attack_1,
		attack_2,
		attack_3,
		attack_4,
	}
)

var (
	// attack: attack_1 = [0]
	attack_1 = []float64{
		0.842379,
		0.910944,
		0.97951,
		1.077461,
		1.146027,
		1.224387,
		1.332134,
		1.43988,
		1.547626,
		1.665167,
		1.782708,
		1.900249,
		2.017791,
		2.135332,
		2.252873,
	}
	// attack: attack_2 = [1]
	attack_2 = []float64{
		0.806757,
		0.872424,
		0.93809,
		1.031899,
		1.097565,
		1.172613,
		1.275802,
		1.378992,
		1.482182,
		1.594753,
		1.707324,
		1.819895,
		1.932465,
		2.045036,
		2.157607,
	}
	// attack: attack_3 = [2]
	attack_3 = []float64{
		1.01904,
		1.101985,
		1.18493,
		1.303423,
		1.386368,
		1.481162,
		1.611505,
		1.741847,
		1.872189,
		2.014381,
		2.156573,
		2.298764,
		2.440956,
		2.583147,
		2.725339,
	}
	// attack: attack_4 = [3]
	attack_4 = []float64{
		1.238047,
		1.338819,
		1.43959,
		1.583549,
		1.68432,
		1.799487,
		1.957842,
		2.116197,
		2.274552,
		2.447303,
		2.620054,
		2.792805,
		2.965555,
		3.138306,
		3.311057,
	}
	// attack: collision = [8]
	collision = []float64{
		0.745878,
		0.806589,
		0.8673,
		0.95403,
		1.014741,
		1.084125,
		1.179528,
		1.274931,
		1.370334,
		1.47441,
		1.578486,
		1.682562,
		1.786638,
		1.890714,
		1.99479,
	}
	// attack: highPlunge = [10]
	highPlunge = []float64{
		1.862889,
		2.01452,
		2.16615,
		2.382765,
		2.534396,
		2.707688,
		2.945964,
		3.184241,
		3.422517,
		3.682455,
		3.942393,
		4.202331,
		4.462269,
		4.722207,
		4.982145,
	}
	// attack: lowPlunge = [9]
	lowPlunge = []float64{
		1.49144,
		1.612836,
		1.734233,
		1.907656,
		2.029052,
		2.167791,
		2.358556,
		2.549322,
		2.740087,
		2.948195,
		3.156303,
		3.364411,
		3.572519,
		3.780627,
		3.988735,
	}
	// skill: skillAddNA = [2]
	skillAddNA = []float64{
		0.0716,
		0.07697,
		0.08234,
		0.0895,
		0.09487,
		0.10024,
		0.1074,
		0.11456,
		0.12172,
		0.12888,
		0.13604,
		0.1432,
		0.15215,
		0.1611,
		0.17005,
	}
	// skill: skillBreath = [1]
	skillBreath = []float64{
		0.144,
		0.1548,
		0.1656,
		0.18,
		0.1908,
		0.2016,
		0.216,
		0.2304,
		0.2448,
		0.2592,
		0.2736,
		0.288,
		0.306,
		0.324,
		0.342,
	}
	// skill: skillPressureCryo = [3 4 6 8 -1]
	skillPressureCryo = [][]float64{
		{
			2.0048,
			2.15516,
			2.30552,
			2.506,
			2.65636,
			2.80672,
			3.0072,
			3.20768,
			3.40816,
			3.60864,
			3.80912,
			4.0096,
			4.2602,
			4.5108,
			4.7614,
		},
		{
			1.0024,
			1.07758,
			1.15276,
			1.253,
			1.32818,
			1.40336,
			1.5036,
			1.60384,
			1.70408,
			1.80432,
			1.90456,
			2.0048,
			2.1301,
			2.2554,
			2.3807,
		},
		{
			0.70168,
			0.754306,
			0.806932,
			0.8771,
			0.929726,
			0.982352,
			1.05252,
			1.122688,
			1.192856,
			1.263024,
			1.333192,
			1.40336,
			1.49107,
			1.57878,
			1.66649,
		},
		{
			0.40096,
			0.431032,
			0.461104,
			0.5012,
			0.531272,
			0.561344,
			0.60144,
			0.641536,
			0.681632,
			0.721728,
			0.761824,
			0.80192,
			0.85204,
			0.90216,
			0.95228,
		},
		{
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
		},
	}
	// skill: skillPressurePhys = [-1 5 7 9 10]
	skillPressurePhys = [][]float64{
		{
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
			0,
		},
		{
			0.48688,
			0.523396,
			0.559912,
			0.6086,
			0.645116,
			0.681632,
			0.73032,
			0.779008,
			0.827696,
			0.876384,
			0.925072,
			0.97376,
			1.03462,
			1.09548,
			1.15634,
		},
		{
			0.85204,
			0.915943,
			0.979846,
			1.06505,
			1.128953,
			1.192856,
			1.27806,
			1.363264,
			1.448468,
			1.533672,
			1.618876,
			1.70408,
			1.810585,
			1.91709,
			2.023595,
		},
		{
			1.2172,
			1.30849,
			1.39978,
			1.5215,
			1.61279,
			1.70408,
			1.8258,
			1.94752,
			2.06924,
			2.19096,
			2.31268,
			2.4344,
			2.58655,
			2.7387,
			2.89085,
		},
		{
			2.4344,
			2.61698,
			2.79956,
			3.043,
			3.22558,
			3.40816,
			3.6516,
			3.89504,
			4.13848,
			4.38192,
			4.62536,
			4.8688,
			5.1731,
			5.4774,
			5.7817,
		},
	}
	// skill: skillThrust = [0]
	skillThrust = []float64{
		0.8304,
		0.89268,
		0.95496,
		1.038,
		1.10028,
		1.16256,
		1.2456,
		1.32864,
		1.41168,
		1.49472,
		1.57776,
		1.6608,
		1.7646,
		1.8684,
		1.9722,
	}
	// burst: burst = [0]
	burst = []float64{
		3.184,
		3.4228,
		3.6616,
		3.98,
		4.2188,
		4.4576,
		4.776,
		5.0944,
		5.4128,
		5.7312,
		6.0496,
		6.368,
		6.766,
		7.164,
		7.562,
	}
)
