// Code generated by "pipeline"; DO NOT EDIT.
package gaming

import (
	_ "embed"

	"fmt"
	"github.com/genshinsim/gcsim/pkg/core/action"
	"github.com/genshinsim/gcsim/pkg/core/keys"
	"github.com/genshinsim/gcsim/pkg/gcs/validation"
	"github.com/genshinsim/gcsim/pkg/model"
	"google.golang.org/protobuf/encoding/prototext"
	"slices"
)

//go:embed data_gen.textproto
var pbData []byte
var base *model.AvatarData
var paramKeysValidation = map[action.Action][]string{
	2: {"man_chai_delay"},
	5: {"collision", "man_chai_delay"},
	6: {"collision", "man_chai_delay"},
}

func init() {
	base = &model.AvatarData{}
	err := prototext.Unmarshal(pbData, base)
	if err != nil {
		panic(err)
	}
	validation.RegisterCharParamValidationFunc(keys.Gaming, ValidateParamKeys)
}

func ValidateParamKeys(a action.Action, keys []string) error {
	valid, ok := paramKeysValidation[a]
	if !ok {
		return nil
	}
	for _, v := range keys {
		if !slices.Contains(valid, v) {
			return fmt.Errorf("key %v is invalid for action %v", v, a.String())
		}
	}
	return nil
}

func (x *char) Data() *model.AvatarData {
	return base
}

var (
	attack = [][]float64{
		attack_1,
		attack_2,
		attack_3,
		attack_4,
	}
)

var (
	// attack: attack_1 = [0]
	attack_1 = []float64{
		0.83856,
		0.906815,
		0.97507,
		1.072577,
		1.140832,
		1.218838,
		1.326095,
		1.433353,
		1.540611,
		1.657619,
		1.774627,
		1.891636,
		2.008644,
		2.125653,
		2.242661,
	}
	// attack: attack_2 = [1]
	attack_2 = []float64{
		0.790443,
		0.854782,
		0.91912,
		1.011032,
		1.07537,
		1.1489,
		1.250003,
		1.351106,
		1.45221,
		1.562504,
		1.672798,
		1.783093,
		1.893387,
		2.003682,
		2.113976,
	}
	// attack: attack_3 = [2]
	attack_3 = []float64{
		1.06646,
		1.153265,
		1.24007,
		1.364077,
		1.450882,
		1.550088,
		1.686495,
		1.822903,
		1.959311,
		2.108119,
		2.256927,
		2.405736,
		2.554544,
		2.703353,
		2.852161,
	}
	// attack: attack_4 = [3]
	attack_4 = []float64{
		1.279491,
		1.383635,
		1.48778,
		1.636558,
		1.740703,
		1.859725,
		2.023381,
		2.187037,
		2.350692,
		2.529226,
		2.70776,
		2.886293,
		3.064827,
		3.24336,
		3.421894,
	}
	// attack: collision = [8]
	collision = []float64{
		0.641457,
		0.693668,
		0.74588,
		0.820468,
		0.87268,
		0.93235,
		1.014397,
		1.096444,
		1.17849,
		1.267996,
		1.357502,
		1.447007,
		1.536513,
		1.626018,
		1.715524,
	}
	// attack: highPlunge = [10]
	highPlunge = []float64{
		1.602085,
		1.732488,
		1.86289,
		2.049179,
		2.179581,
		2.328612,
		2.53353,
		2.738448,
		2.943366,
		3.166913,
		3.39046,
		3.614007,
		3.837553,
		4.0611,
		4.284647,
	}
	// attack: lowPlunge = [9]
	lowPlunge = []float64{
		1.282638,
		1.387039,
		1.49144,
		1.640584,
		1.744985,
		1.8643,
		2.028358,
		2.192417,
		2.356475,
		2.535448,
		2.714421,
		2.893394,
		3.072366,
		3.251339,
		3.430312,
	}
	// skill: skill = [0]
	skill = []float64{
		2.304,
		2.4768,
		2.6496,
		2.88,
		3.0528,
		3.2256,
		3.456,
		3.6864,
		3.9168,
		4.1472,
		4.3776,
		4.608,
		4.896,
		5.184,
		5.472,
	}
	// burst: burst = [0]
	burst = []float64{
		3.704,
		3.9818,
		4.2596,
		4.63,
		4.9078,
		5.1856,
		5.556,
		5.9264,
		6.2968,
		6.6672,
		7.0376,
		7.408,
		7.871,
		8.334,
		8.797,
	}
)
