// Code generated by "pipeline"; DO NOT EDIT.
package itto

import (
	_ "embed"

	"fmt"
	"github.com/genshinsim/gcsim/pkg/core/action"
	"github.com/genshinsim/gcsim/pkg/core/keys"
	"github.com/genshinsim/gcsim/pkg/gcs/validation"
	"github.com/genshinsim/gcsim/pkg/model"
	"google.golang.org/protobuf/encoding/prototext"
	"slices"
)

//go:embed data_gen.textproto
var pbData []byte
var base *model.AvatarData
var paramKeysValidation = map[action.Action][]string{
	1: {"travel", "ushihit"},
	2: {"prestack"},
	5: {"collision"},
	6: {"collision"},
}

func init() {
	base = &model.AvatarData{}
	err := prototext.Unmarshal(pbData, base)
	if err != nil {
		panic(err)
	}
	validation.RegisterCharParamValidationFunc(keys.Itto, ValidateParamKeys)
}

func ValidateParamKeys(a action.Action, keys []string) error {
	valid, ok := paramKeysValidation[a]
	if !ok {
		return nil
	}
	for _, v := range keys {
		if !slices.Contains(valid, v) {
			return fmt.Errorf("key %v is invalid for action %v", v, a.String())
		}
	}
	return nil
}

func (x *char) Data() *model.AvatarData {
	return base
}

var (
	attack = [][]float64{
		attack_1,
		attack_2,
		attack_3,
		attack_4,
	}
)

var (
	// attack: akCombo = [5]
	akCombo = []float64{
		0.9116,
		0.9858,
		1.06,
		1.166,
		1.2402,
		1.325,
		1.4416,
		1.5582,
		1.6748,
		1.802,
		1.94775,
		2.119152,
		2.290554,
		2.461956,
		2.64894,
	}
	// attack: akFinal = [6]
	akFinal = []float64{
		1.9092,
		2.0646,
		2.22,
		2.442,
		2.5974,
		2.775,
		3.0192,
		3.2634,
		3.5076,
		3.774,
		4.07925,
		4.438224,
		4.797198,
		5.156172,
		5.54778,
	}
	// attack: attack_1 = [0]
	attack_1 = []float64{
		0.792318,
		0.856809,
		0.9213,
		1.01343,
		1.077921,
		1.151625,
		1.252968,
		1.354311,
		1.455654,
		1.56621,
		1.692889,
		1.841863,
		1.990837,
		2.139811,
		2.302329,
	}
	// attack: attack_2 = [1]
	attack_2 = []float64{
		0.76368,
		0.82584,
		0.888,
		0.9768,
		1.03896,
		1.11,
		1.20768,
		1.30536,
		1.40304,
		1.5096,
		1.6317,
		1.77529,
		1.918879,
		2.062469,
		2.219112,
	}
	// attack: attack_3 = [2]
	attack_3 = []float64{
		0.916416,
		0.991008,
		1.0656,
		1.17216,
		1.246752,
		1.332,
		1.449216,
		1.566432,
		1.683648,
		1.81152,
		1.95804,
		2.130348,
		2.302655,
		2.474963,
		2.662934,
	}
	// attack: attack_4 = [3]
	attack_4 = []float64{
		1.172249,
		1.267664,
		1.36308,
		1.499388,
		1.594804,
		1.70385,
		1.853789,
		2.003728,
		2.153666,
		2.317236,
		2.504659,
		2.72507,
		2.94548,
		3.16589,
		3.406337,
	}
	// attack: collision = [8]
	collision = []float64{
		0.818335,
		0.884943,
		0.951552,
		1.046707,
		1.113316,
		1.18944,
		1.294111,
		1.398781,
		1.503452,
		1.617638,
		1.731825,
		1.846011,
		1.960197,
		2.074383,
		2.18857,
	}
	// attack: highPlunge = [10]
	highPlunge = []float64{
		2.043855,
		2.210216,
		2.376576,
		2.614234,
		2.780594,
		2.97072,
		3.232143,
		3.493567,
		3.75499,
		4.040179,
		4.325368,
		4.610557,
		4.895747,
		5.180936,
		5.466125,
	}
	// attack: lowPlunge = [9]
	lowPlunge = []float64{
		1.636323,
		1.769512,
		1.902701,
		2.092971,
		2.22616,
		2.378376,
		2.587673,
		2.79697,
		3.006267,
		3.234591,
		3.462915,
		3.69124,
		3.919564,
		4.147888,
		4.376212,
	}
	// attack: saichiSlash = [4]
	saichiSlash = []float64{
		0.90472,
		0.97836,
		1.052,
		1.1572,
		1.23084,
		1.315,
		1.43072,
		1.54644,
		1.66216,
		1.7884,
		1.93305,
		2.103158,
		2.273267,
		2.443375,
		2.628948,
	}
	// skill: skill = [0]
	skill = []float64{
		3.072,
		3.3024,
		3.5328,
		3.84,
		4.0704,
		4.3008,
		4.608,
		4.9152,
		5.2224,
		5.5296,
		5.8368,
		6.144,
		6.528,
		6.912,
		7.296,
	}
	// burst: defconv = [1]
	defconv = []float64{
		0.576,
		0.6192,
		0.6624,
		0.72,
		0.7632,
		0.8064,
		0.864,
		0.9216,
		0.9792,
		1.0368,
		1.0944,
		1.152,
		1.224,
		1.296,
		1.368,
	}
)
