// Code generated by "pipeline"; DO NOT EDIT.
package keqing

import (
	_ "embed"

	"fmt"
	"github.com/genshinsim/gcsim/pkg/core/action"
	"github.com/genshinsim/gcsim/pkg/core/keys"
	"github.com/genshinsim/gcsim/pkg/gcs/validation"
	"github.com/genshinsim/gcsim/pkg/model"
	"google.golang.org/protobuf/encoding/prototext"
	"slices"
)

//go:embed data_gen.textproto
var pbData []byte
var base *model.AvatarData
var paramKeysValidation = map[action.Action][]string{
	5: {"collision"},
	6: {"collision"},
}

func init() {
	base = &model.AvatarData{}
	err := prototext.Unmarshal(pbData, base)
	if err != nil {
		panic(err)
	}
	validation.RegisterCharParamValidationFunc(keys.Keqing, ValidateParamKeys)
}

func ValidateParamKeys(a action.Action, keys []string) error {
	valid, ok := paramKeysValidation[a]
	if !ok {
		return nil
	}
	for _, v := range keys {
		if !slices.Contains(valid, v) {
			return fmt.Errorf("key %v is invalid for action %v", v, a.String())
		}
	}
	return nil
}

func (x *char) Data() *model.AvatarData {
	return base
}

var (
	attack = [][][]float64{
		{attack_1},
		{attack_2},
		{attack_3},
		attack_4,
		{attack_5},
	}
)

var (
	// attack: attack_1 = [0]
	attack_1 = []float64{
		0.41022,
		0.44361,
		0.477,
		0.5247,
		0.55809,
		0.59625,
		0.64872,
		0.70119,
		0.75366,
		0.8109,
		0.86814,
		0.92538,
		0.98262,
		1.03986,
		1.0971,
	}
	// attack: attack_2 = [1]
	attack_2 = []float64{
		0.41022,
		0.44361,
		0.477,
		0.5247,
		0.55809,
		0.59625,
		0.64872,
		0.70119,
		0.75366,
		0.8109,
		0.86814,
		0.92538,
		0.98262,
		1.03986,
		1.0971,
	}
	// attack: attack_3 = [2]
	attack_3 = []float64{
		0.54438,
		0.58869,
		0.633,
		0.6963,
		0.74061,
		0.79125,
		0.86088,
		0.93051,
		1.00014,
		1.0761,
		1.15206,
		1.22802,
		1.30398,
		1.37994,
		1.4559,
	}
	// attack: attack_4 = [3 4]
	attack_4 = [][]float64{
		{
			0.31476,
			0.34038,
			0.366,
			0.4026,
			0.42822,
			0.4575,
			0.49776,
			0.53802,
			0.57828,
			0.6222,
			0.66612,
			0.71004,
			0.75396,
			0.79788,
			0.8418,
		},
		{
			0.344,
			0.372,
			0.4,
			0.44,
			0.468,
			0.5,
			0.544,
			0.588,
			0.632,
			0.68,
			0.728,
			0.776,
			0.824,
			0.872,
			0.92,
		},
	}
	// attack: attack_5 = [5]
	attack_5 = []float64{
		0.66994,
		0.72447,
		0.779,
		0.8569,
		0.91143,
		0.97375,
		1.05944,
		1.14513,
		1.23082,
		1.3243,
		1.41778,
		1.51126,
		1.60474,
		1.69822,
		1.7917,
	}
	// attack: charge = [6 7]
	charge = [][]float64{
		{
			0.76798,
			0.83049,
			0.893,
			0.9823,
			1.04481,
			1.11625,
			1.21448,
			1.31271,
			1.41094,
			1.5181,
			1.62526,
			1.73242,
			1.83958,
			1.94674,
			2.0539,
		},
		{
			0.86,
			0.93,
			1,
			1.1,
			1.17,
			1.25,
			1.36,
			1.47,
			1.58,
			1.7,
			1.82,
			1.94,
			2.06,
			2.18,
			2.3,
		},
	}
	// attack: collision = [9]
	collision = []float64{
		0.639324,
		0.691362,
		0.7434,
		0.81774,
		0.869778,
		0.92925,
		1.011024,
		1.092798,
		1.174572,
		1.26378,
		1.352988,
		1.442196,
		1.531404,
		1.620612,
		1.70982,
	}
	// attack: highPlunge = [11]
	highPlunge = []float64{
		1.596762,
		1.726731,
		1.8567,
		2.04237,
		2.172339,
		2.320875,
		2.525112,
		2.729349,
		2.933586,
		3.15639,
		3.379194,
		3.601998,
		3.824802,
		4.047606,
		4.27041,
	}
	// attack: lowPlunge = [10]
	lowPlunge = []float64{
		1.278377,
		1.382431,
		1.486485,
		1.635134,
		1.739187,
		1.858106,
		2.02162,
		2.185133,
		2.348646,
		2.527025,
		2.705403,
		2.883781,
		3.062159,
		3.240537,
		3.418915,
	}
	// skill: skill = [0]
	skill = []float64{
		0.504,
		0.5418,
		0.5796,
		0.63,
		0.6678,
		0.7056,
		0.756,
		0.8064,
		0.8568,
		0.9072,
		0.9576,
		1.008,
		1.071,
		1.134,
		1.197,
	}
	// skill: skillCA = [2]
	skillCA = []float64{
		0.84,
		0.903,
		0.966,
		1.05,
		1.113,
		1.176,
		1.26,
		1.344,
		1.428,
		1.512,
		1.596,
		1.68,
		1.785,
		1.89,
		1.995,
	}
	// skill: skillPress = [1]
	skillPress = []float64{
		1.68,
		1.806,
		1.932,
		2.1,
		2.226,
		2.352,
		2.52,
		2.688,
		2.856,
		3.024,
		3.192,
		3.36,
		3.57,
		3.78,
		3.99,
	}
	// burst: burstDot = [1]
	burstDot = []float64{
		0.24,
		0.258,
		0.276,
		0.3,
		0.318,
		0.336,
		0.36,
		0.384,
		0.408,
		0.432,
		0.456,
		0.48,
		0.51,
		0.54,
		0.57,
	}
	// burst: burstFinal = [2]
	burstFinal = []float64{
		1.888,
		2.0296,
		2.1712,
		2.36,
		2.5016,
		2.6432,
		2.832,
		3.0208,
		3.2096,
		3.3984,
		3.5872,
		3.776,
		4.012,
		4.248,
		4.484,
	}
	// burst: burstInitial = [0]
	burstInitial = []float64{
		0.88,
		0.946,
		1.012,
		1.1,
		1.166,
		1.232,
		1.32,
		1.408,
		1.496,
		1.584,
		1.672,
		1.76,
		1.87,
		1.98,
		2.09,
	}
)
