// Code generated by "pipeline"; DO NOT EDIT.
package kinich

import (
	_ "embed"

	"fmt"
	"github.com/genshinsim/gcsim/pkg/core/action"
	"github.com/genshinsim/gcsim/pkg/core/keys"
	"github.com/genshinsim/gcsim/pkg/gcs/validation"
	"github.com/genshinsim/gcsim/pkg/model"
	"google.golang.org/protobuf/encoding/prototext"
	"slices"
)

//go:embed data_gen.textproto
var pbData []byte
var base *model.AvatarData
var paramKeysValidation = map[action.Action][]string{
	1: {"hold", "travel", "c6-travel"},
	3: {"direction"},
}

func init() {
	base = &model.AvatarData{}
	err := prototext.Unmarshal(pbData, base)
	if err != nil {
		panic(err)
	}
	validation.RegisterCharParamValidationFunc(keys.Kinich, ValidateParamKeys)
}

func ValidateParamKeys(a action.Action, keys []string) error {
	valid, ok := paramKeysValidation[a]
	if !ok {
		return nil
	}
	for _, v := range keys {
		if !slices.Contains(valid, v) {
			return fmt.Errorf("key %v is invalid for action %v", v, a.String())
		}
	}
	return nil
}

func (x *char) Data() *model.AvatarData {
	return base
}

var (
	attack = [][]float64{
		attack_1,
		attack_2,
		attack_3,
	}
)

var (
	// attack: attack_1 = [0]
	attack_1 = []float64{
		0.98986,
		1.07043,
		1.151,
		1.2661,
		1.34667,
		1.43875,
		1.56536,
		1.69197,
		1.81858,
		1.9567,
		2.09482,
		2.23294,
		2.37106,
		2.50918,
		2.6473,
	}
	// attack: attack_2 = [1]
	attack_2 = []float64{
		0.82904,
		0.89652,
		0.964,
		1.0604,
		1.12788,
		1.205,
		1.31104,
		1.41708,
		1.52312,
		1.6388,
		1.75448,
		1.87016,
		1.98584,
		2.10152,
		2.2172,
	}
	// attack: attack_3 = [2]
	attack_3 = []float64{
		1.23496,
		1.33548,
		1.436,
		1.5796,
		1.68012,
		1.795,
		1.95296,
		2.11092,
		2.26888,
		2.4412,
		2.61352,
		2.78584,
		2.95816,
		3.13048,
		3.3028,
	}
	// attack: charge = [3]
	charge = []float64{
		0.48418,
		0.52359,
		0.563,
		0.6193,
		0.65871,
		0.70375,
		0.76568,
		0.82761,
		0.88954,
		0.9571,
		1.02466,
		1.09222,
		1.15978,
		1.22734,
		1.2949,
	}
	// attack: collision = [5]
	collision = []float64{
		0.745878,
		0.806589,
		0.8673,
		0.95403,
		1.014741,
		1.084125,
		1.179528,
		1.274931,
		1.370334,
		1.47441,
		1.578486,
		1.682562,
		1.786638,
		1.890714,
		1.99479,
	}
	// attack: highPlunge = [7]
	highPlunge = []float64{
		1.862889,
		2.01452,
		2.16615,
		2.382765,
		2.534396,
		2.707688,
		2.945964,
		3.184241,
		3.422517,
		3.682455,
		3.942393,
		4.202331,
		4.462269,
		4.722207,
		4.982145,
	}
	// attack: lowPlunge = [6]
	lowPlunge = []float64{
		1.49144,
		1.612836,
		1.734233,
		1.907656,
		2.029052,
		2.167791,
		2.358556,
		2.549322,
		2.740087,
		2.948195,
		3.156303,
		3.364411,
		3.572519,
		3.780627,
		3.988735,
	}
	// skill: loopShot = [0]
	loopShot = []float64{
		0.5728,
		0.61576,
		0.65872,
		0.716,
		0.75896,
		0.80192,
		0.8592,
		0.91648,
		0.97376,
		1.03104,
		1.08832,
		1.1456,
		1.2172,
		1.2888,
		1.3604,
	}
	// skill: scalespikerCannon = [1]
	scalespikerCannon = []float64{
		6.8744,
		7.38998,
		7.90556,
		8.593,
		9.10858,
		9.62416,
		10.3116,
		10.99904,
		11.68648,
		12.37392,
		13.06136,
		13.7488,
		14.6081,
		15.4674,
		16.3267,
	}
	// burst: burst = [0]
	burst = []float64{
		1.34,
		1.4405,
		1.541,
		1.675,
		1.7755,
		1.876,
		2.01,
		2.144,
		2.278,
		2.412,
		2.546,
		2.68,
		2.8475,
		3.015,
		3.1825,
	}
	// burst: dragonBreath = [1]
	dragonBreath = []float64{
		1.20736,
		1.297912,
		1.388464,
		1.5092,
		1.599752,
		1.690304,
		1.81104,
		1.931776,
		2.052512,
		2.173248,
		2.293984,
		2.41472,
		2.56564,
		2.71656,
		2.86748,
	}
)
