// Code generated by "pipeline"; DO NOT EDIT.
package kokomi

import (
	_ "embed"

	"fmt"
	"github.com/genshinsim/gcsim/pkg/core/action"
	"github.com/genshinsim/gcsim/pkg/core/keys"
	"github.com/genshinsim/gcsim/pkg/gcs/validation"
	"github.com/genshinsim/gcsim/pkg/model"
	"google.golang.org/protobuf/encoding/prototext"
	"slices"
)

//go:embed data_gen.textproto
var pbData []byte
var base *model.AvatarData
var paramKeysValidation = map[action.Action][]string{
	3: {"travel"},
}

func init() {
	base = &model.AvatarData{}
	err := prototext.Unmarshal(pbData, base)
	if err != nil {
		panic(err)
	}
	validation.RegisterCharParamValidationFunc(keys.Kokomi, ValidateParamKeys)
}

func ValidateParamKeys(a action.Action, keys []string) error {
	valid, ok := paramKeysValidation[a]
	if !ok {
		return nil
	}
	for _, v := range keys {
		if !slices.Contains(valid, v) {
			return fmt.Errorf("key %v is invalid for action %v", v, a.String())
		}
	}
	return nil
}

func (x *char) Data() *model.AvatarData {
	return base
}

var (
	attack = [][]float64{
		attack_1,
		attack_2,
		attack_3,
	}
)

var (
	// attack: attack_1 = [0]
	attack_1 = []float64{
		0.68376,
		0.735042,
		0.786324,
		0.8547,
		0.905982,
		0.957264,
		1.02564,
		1.094016,
		1.162392,
		1.230768,
		1.299144,
		1.36752,
		1.45299,
		1.53846,
		1.62393,
	}
	// attack: attack_2 = [1]
	attack_2 = []float64{
		0.615384,
		0.661538,
		0.707692,
		0.76923,
		0.815384,
		0.861538,
		0.923076,
		0.984614,
		1.046153,
		1.107691,
		1.16923,
		1.230768,
		1.307691,
		1.384614,
		1.461537,
	}
	// attack: attack_3 = [2]
	attack_3 = []float64{
		0.943056,
		1.013785,
		1.084514,
		1.17882,
		1.249549,
		1.320278,
		1.414584,
		1.50889,
		1.603195,
		1.697501,
		1.791806,
		1.886112,
		2.003994,
		2.121876,
		2.239758,
	}
	// attack: charge = [3]
	charge = []float64{
		1.4832,
		1.59444,
		1.70568,
		1.854,
		1.96524,
		2.07648,
		2.2248,
		2.37312,
		2.52144,
		2.66976,
		2.81808,
		2.9664,
		3.1518,
		3.3372,
		3.5226,
	}
	// skill: skillDmg = [2]
	skillDmg = []float64{
		1.091904,
		1.173797,
		1.25569,
		1.36488,
		1.446773,
		1.528666,
		1.637856,
		1.747046,
		1.856237,
		1.965427,
		2.074618,
		2.183808,
		2.320296,
		2.456784,
		2.593272,
	}
	// skill: skillHealFlat = [1]
	skillHealFlat = []float64{
		423.7063,
		466.08282,
		511.99072,
		561.43,
		614.40063,
		670.90265,
		730.9361,
		794.50085,
		861.59705,
		932.22455,
		1006.3835,
		1084.0737,
		1165.2954,
		1250.0485,
		1338.3329,
	}
	// skill: skillHealPct = [0]
	skillHealPct = []float64{
		0.044,
		0.0473,
		0.0506,
		0.055,
		0.0583,
		0.0616,
		0.066,
		0.0704,
		0.0748,
		0.0792,
		0.0836,
		0.088,
		0.0935,
		0.099,
		0.1045,
	}
	// burst: burstBonusCharge = [4]
	burstBonusCharge = []float64{
		0.06776,
		0.072842,
		0.077924,
		0.0847,
		0.089782,
		0.094864,
		0.10164,
		0.108416,
		0.115192,
		0.121968,
		0.128744,
		0.13552,
		0.14399,
		0.15246,
		0.16093,
	}
	// burst: burstBonusNormal = [3]
	burstBonusNormal = []float64{
		0.0484,
		0.05203,
		0.05566,
		0.0605,
		0.06413,
		0.06776,
		0.0726,
		0.07744,
		0.08228,
		0.08712,
		0.09196,
		0.0968,
		0.10285,
		0.1089,
		0.11495,
	}
	// burst: burstBonusSkill = [8]
	burstBonusSkill = []float64{
		0.070963,
		0.076285,
		0.081608,
		0.088704,
		0.094026,
		0.099348,
		0.106445,
		0.113541,
		0.120637,
		0.127734,
		0.13483,
		0.141926,
		0.150797,
		0.159667,
		0.168538,
	}
	// burst: burstDmg = [0]
	burstDmg = []float64{
		0.10416,
		0.111972,
		0.119784,
		0.1302,
		0.138012,
		0.145824,
		0.15624,
		0.166656,
		0.177072,
		0.187488,
		0.197904,
		0.20832,
		0.22134,
		0.23436,
		0.24738,
	}
	// burst: burstHealFlat = [2]
	burstHealFlat = []float64{
		77.03738,
		84.74218,
		93.08906,
		102.078,
		111.70901,
		121.982086,
		132.89723,
		144.45445,
		156.65373,
		169.49507,
		182.97849,
		197.10397,
		211.87152,
		227.28113,
		243.33281,
	}
	// burst: burstHealPct = [1]
	burstHealPct = []float64{
		0.00808,
		0.008686,
		0.009292,
		0.0101,
		0.010706,
		0.011312,
		0.01212,
		0.012928,
		0.013736,
		0.014544,
		0.015352,
		0.01616,
		0.01717,
		0.01818,
		0.01919,
	}
)
