// Code generated by "pipeline"; DO NOT EDIT.
package lynette

import (
	_ "embed"

	"fmt"
	"github.com/genshinsim/gcsim/pkg/core/action"
	"github.com/genshinsim/gcsim/pkg/core/keys"
	"github.com/genshinsim/gcsim/pkg/gcs/validation"
	"github.com/genshinsim/gcsim/pkg/model"
	"google.golang.org/protobuf/encoding/prototext"
	"slices"
)

//go:embed data_gen.textproto
var pbData []byte
var base *model.AvatarData
var paramKeysValidation = map[action.Action][]string{
	1: {"hold"},
	2: {"vivid_travel"},
	5: {"collision"},
	6: {"collision"},
}

func init() {
	base = &model.AvatarData{}
	err := prototext.Unmarshal(pbData, base)
	if err != nil {
		panic(err)
	}
	validation.RegisterCharParamValidationFunc(keys.Lynette, ValidateParamKeys)
}

func ValidateParamKeys(a action.Action, keys []string) error {
	valid, ok := paramKeysValidation[a]
	if !ok {
		return nil
	}
	for _, v := range keys {
		if !slices.Contains(valid, v) {
			return fmt.Errorf("key %v is invalid for action %v", v, a.String())
		}
	}
	return nil
}

func (x *char) Data() *model.AvatarData {
	return base
}

var (
	attack = [][][]float64{
		{attack_1},
		{attack_2},
		attack_3,
		{attack_4},
	}
)

var (
	// attack: attack_1 = [0]
	attack_1 = []float64{
		0.430817,
		0.465884,
		0.50095,
		0.551045,
		0.586112,
		0.626188,
		0.681292,
		0.736397,
		0.791501,
		0.851615,
		0.911729,
		0.971843,
		1.031957,
		1.092071,
		1.152185,
	}
	// attack: attack_2 = [1]
	attack_2 = []float64{
		0.376121,
		0.406736,
		0.43735,
		0.481085,
		0.511699,
		0.546687,
		0.594796,
		0.642904,
		0.691013,
		0.743495,
		0.795977,
		0.848459,
		0.900941,
		0.953423,
		1.005905,
	}
	// attack: attack_3 = [2 3]
	attack_3 = [][]float64{
		{
			0.27864,
			0.30132,
			0.324,
			0.3564,
			0.37908,
			0.405,
			0.44064,
			0.47628,
			0.51192,
			0.5508,
			0.58968,
			0.62856,
			0.66744,
			0.70632,
			0.7452,
		},
		{
			0.215929,
			0.233504,
			0.25108,
			0.276188,
			0.293764,
			0.31385,
			0.341469,
			0.369088,
			0.396706,
			0.426836,
			0.456966,
			0.487095,
			0.517225,
			0.547354,
			0.577484,
		},
	}
	// attack: attack_4 = [4]
	attack_4 = []float64{
		0.631541,
		0.682945,
		0.73435,
		0.807785,
		0.859189,
		0.917937,
		0.998716,
		1.079494,
		1.160273,
		1.248395,
		1.336517,
		1.424639,
		1.512761,
		1.600883,
		1.689005,
	}
	// attack: charge = [5 6]
	charge = [][]float64{
		{
			0.44204,
			0.47802,
			0.514,
			0.5654,
			0.60138,
			0.6425,
			0.69904,
			0.75558,
			0.81212,
			0.8738,
			0.93548,
			0.99716,
			1.05884,
			1.12052,
			1.1822,
		},
		{
			0.61404,
			0.66402,
			0.714,
			0.7854,
			0.83538,
			0.8925,
			0.97104,
			1.04958,
			1.12812,
			1.2138,
			1.29948,
			1.38516,
			1.47084,
			1.55652,
			1.6422,
		},
	}
	// attack: collision = [8]
	collision = []float64{
		0.639324,
		0.691362,
		0.7434,
		0.81774,
		0.869778,
		0.92925,
		1.011024,
		1.092798,
		1.174572,
		1.26378,
		1.352988,
		1.442196,
		1.531404,
		1.620612,
		1.70982,
	}
	// attack: highPlunge = [10]
	highPlunge = []float64{
		1.596762,
		1.726731,
		1.8567,
		2.04237,
		2.172339,
		2.320875,
		2.525112,
		2.729349,
		2.933586,
		3.15639,
		3.379194,
		3.601998,
		3.824802,
		4.047606,
		4.27041,
	}
	// attack: lowPlunge = [9]
	lowPlunge = []float64{
		1.278377,
		1.382431,
		1.486485,
		1.635134,
		1.739187,
		1.858106,
		2.02162,
		2.185133,
		2.348646,
		2.527025,
		2.705403,
		2.883781,
		3.062159,
		3.240537,
		3.418915,
	}
	// skill: skill = [0]
	skill = []float64{
		2.68,
		2.881,
		3.082,
		3.35,
		3.551,
		3.752,
		4.02,
		4.288,
		4.556,
		4.824,
		5.092,
		5.36,
		5.695,
		6.03,
		6.365,
	}
	// skill: skillAligned = [2]
	skillAligned = []float64{
		0.312,
		0.3354,
		0.3588,
		0.39,
		0.4134,
		0.4368,
		0.468,
		0.4992,
		0.5304,
		0.5616,
		0.5928,
		0.624,
		0.663,
		0.702,
		0.741,
	}
	// burst: bogglecat = [1]
	bogglecat = []float64{
		0.512,
		0.5504,
		0.5888,
		0.64,
		0.6784,
		0.7168,
		0.768,
		0.8192,
		0.8704,
		0.9216,
		0.9728,
		1.024,
		1.088,
		1.152,
		1.216,
	}
	// burst: burst = [0]
	burst = []float64{
		0.832,
		0.8944,
		0.9568,
		1.04,
		1.1024,
		1.1648,
		1.248,
		1.3312,
		1.4144,
		1.4976,
		1.5808,
		1.664,
		1.768,
		1.872,
		1.976,
	}
	// burst: vivid = [2]
	vivid = []float64{
		0.456,
		0.4902,
		0.5244,
		0.57,
		0.6042,
		0.6384,
		0.684,
		0.7296,
		0.7752,
		0.8208,
		0.8664,
		0.912,
		0.969,
		1.026,
		1.083,
	}
)
