// Code generated by "pipeline"; DO NOT EDIT.
package navia

import (
	_ "embed"

	"fmt"
	"github.com/genshinsim/gcsim/pkg/core/action"
	"github.com/genshinsim/gcsim/pkg/core/keys"
	"github.com/genshinsim/gcsim/pkg/gcs/validation"
	"github.com/genshinsim/gcsim/pkg/model"
	"google.golang.org/protobuf/encoding/prototext"
	"slices"
)

//go:embed data_gen.textproto
var pbData []byte
var base *model.AvatarData
var paramKeysValidation = map[action.Action][]string{
	1: {"hold"},
	5: {"collision"},
	6: {"collision"},
}

func init() {
	base = &model.AvatarData{}
	err := prototext.Unmarshal(pbData, base)
	if err != nil {
		panic(err)
	}
	validation.RegisterCharParamValidationFunc(keys.Navia, ValidateParamKeys)
}

func ValidateParamKeys(a action.Action, keys []string) error {
	valid, ok := paramKeysValidation[a]
	if !ok {
		return nil
	}
	for _, v := range keys {
		if !slices.Contains(valid, v) {
			return fmt.Errorf("key %v is invalid for action %v", v, a.String())
		}
	}
	return nil
}

func (x *char) Data() *model.AvatarData {
	return base
}

var (
	auto = [][][]float64{
		{auto_1},
		{auto_2},
		auto_3,
		{auto_4},
	}
)

var (
	// attack: auto_1 = [0]
	auto_1 = []float64{
		0.93519,
		1.01131,
		1.08743,
		1.196173,
		1.272293,
		1.359287,
		1.478905,
		1.598522,
		1.718139,
		1.848631,
		1.979123,
		2.109614,
		2.240106,
		2.370597,
		2.501089,
	}
	// attack: auto_2 = [1]
	auto_2 = []float64{
		0.865065,
		0.935478,
		1.00589,
		1.106479,
		1.176891,
		1.257362,
		1.36801,
		1.478658,
		1.589306,
		1.710013,
		1.83072,
		1.951427,
		2.072133,
		2.19284,
		2.313547,
	}
	// attack: auto_3 = [2 2 2]
	auto_3 = [][]float64{
		{
			0.348859,
			0.377255,
			0.40565,
			0.446215,
			0.47461,
			0.507062,
			0.551684,
			0.596306,
			0.640927,
			0.689605,
			0.738283,
			0.786961,
			0.835639,
			0.884317,
			0.932995,
		},
		{
			0.348859,
			0.377255,
			0.40565,
			0.446215,
			0.47461,
			0.507062,
			0.551684,
			0.596306,
			0.640927,
			0.689605,
			0.738283,
			0.786961,
			0.835639,
			0.884317,
			0.932995,
		},
		{
			0.348859,
			0.377255,
			0.40565,
			0.446215,
			0.47461,
			0.507062,
			0.551684,
			0.596306,
			0.640927,
			0.689605,
			0.738283,
			0.786961,
			0.835639,
			0.884317,
			0.932995,
		},
	}
	// attack: auto_4 = [3]
	auto_4 = []float64{
		1.334316,
		1.442923,
		1.55153,
		1.706683,
		1.81529,
		1.939412,
		2.110081,
		2.280749,
		2.451417,
		2.637601,
		2.823785,
		3.009968,
		3.196152,
		3.382335,
		3.568519,
	}
	// attack: collision = [8]
	collision = []float64{
		0.745878,
		0.806589,
		0.8673,
		0.95403,
		1.014741,
		1.084125,
		1.179528,
		1.274931,
		1.370334,
		1.47441,
		1.578486,
		1.682562,
		1.786638,
		1.890714,
		1.99479,
	}
	// attack: highPlunge = [10]
	highPlunge = []float64{
		1.862889,
		2.01452,
		2.16615,
		2.382765,
		2.534396,
		2.707688,
		2.945964,
		3.184241,
		3.422517,
		3.682455,
		3.942393,
		4.202331,
		4.462269,
		4.722207,
		4.982145,
	}
	// attack: lowPlunge = [9]
	lowPlunge = []float64{
		1.49144,
		1.612836,
		1.734233,
		1.907656,
		2.029052,
		2.167791,
		2.358556,
		2.549322,
		2.740087,
		2.948195,
		3.156303,
		3.364411,
		3.572519,
		3.780627,
		3.988735,
	}
	// skill: skillblade = [4]
	skillblade = []float64{
		0.36,
		0.387,
		0.414,
		0.45,
		0.477,
		0.504,
		0.54,
		0.576,
		0.612,
		0.648,
		0.684,
		0.72,
		0.765,
		0.81,
		0.855,
	}
	// skill: skillshotgun = [0]
	skillshotgun = []float64{
		3.948,
		4.2441,
		4.5402,
		4.935,
		5.2311,
		5.5272,
		5.922,
		6.3168,
		6.7116,
		7.1064,
		7.5012,
		7.896,
		8.3895,
		8.883,
		9.3765,
	}
	// burst: burst = [0 1]
	burst = [][]float64{
		{
			0.752,
			0.8084,
			0.8648,
			0.94,
			0.9964,
			1.0528,
			1.128,
			1.2032,
			1.2784,
			1.3536,
			1.4288,
			1.504,
			1.598,
			1.692,
			1.786,
		},
		{
			0.4315,
			0.463863,
			0.496225,
			0.539375,
			0.571738,
			0.6041,
			0.64725,
			0.6904,
			0.73355,
			0.7767,
			0.81985,
			0.863,
			0.916938,
			0.970875,
			1.024813,
		},
	}
)
