// Code generated by "pipeline"; DO NOT EDIT.
package ningguang

import (
	_ "embed"

	"fmt"
	"github.com/genshinsim/gcsim/pkg/core/action"
	"github.com/genshinsim/gcsim/pkg/core/keys"
	"github.com/genshinsim/gcsim/pkg/gcs/validation"
	"github.com/genshinsim/gcsim/pkg/model"
	"google.golang.org/protobuf/encoding/prototext"
	"slices"
)

//go:embed data_gen.textproto
var pbData []byte
var base *model.AvatarData
var paramKeysValidation = map[action.Action][]string{
	1: {"noscreen"},
	2: {"travel", "jade", "screen"},
	3: {"travel"},
	4: {"travel"},
}

func init() {
	base = &model.AvatarData{}
	err := prototext.Unmarshal(pbData, base)
	if err != nil {
		panic(err)
	}
	validation.RegisterCharParamValidationFunc(keys.Ningguang, ValidateParamKeys)
}

func ValidateParamKeys(a action.Action, keys []string) error {
	valid, ok := paramKeysValidation[a]
	if !ok {
		return nil
	}
	for _, v := range keys {
		if !slices.Contains(valid, v) {
			return fmt.Errorf("key %v is invalid for action %v", v, a.String())
		}
	}
	return nil
}

func (x *char) Data() *model.AvatarData {
	return base
}

var (
	// attack: attack = [0]
	attack = []float64{
		0.28,
		0.301,
		0.322,
		0.35,
		0.371,
		0.392,
		0.42,
		0.448,
		0.476,
		0.504,
		0.53312,
		0.5712,
		0.60928,
		0.64736,
		0.68544,
	}
	// attack: charge = [1]
	charge = []float64{
		1.7408,
		1.87136,
		2.00192,
		2.176,
		2.30656,
		2.43712,
		2.6112,
		2.78528,
		2.95936,
		3.13344,
		3.314483,
		3.551232,
		3.787981,
		4.02473,
		4.261478,
	}
	// attack: jade = [2]
	jade = []float64{
		0.496,
		0.5332,
		0.5704,
		0.62,
		0.6572,
		0.6944,
		0.744,
		0.7936,
		0.8432,
		0.8928,
		0.944384,
		1.01184,
		1.079296,
		1.146752,
		1.214208,
	}
	// skill: skill = [1]
	skill = []float64{
		2.304,
		2.4768,
		2.6496,
		2.88,
		3.0528,
		3.2256,
		3.456,
		3.6864,
		3.9168,
		4.1472,
		4.3776,
		4.608,
		4.896,
		5.184,
		5.472,
	}
	// burst: burst = [0]
	burst = []float64{
		0.8696,
		0.93482,
		1.00004,
		1.087,
		1.15222,
		1.21744,
		1.3044,
		1.39136,
		1.47832,
		1.56528,
		1.65224,
		1.7392,
		1.8479,
		1.9566,
		2.0653,
	}
)
