// Code generated by "pipeline"; DO NOT EDIT.
package noelle

import (
	_ "embed"

	"fmt"
	"github.com/genshinsim/gcsim/pkg/core/action"
	"github.com/genshinsim/gcsim/pkg/core/keys"
	"github.com/genshinsim/gcsim/pkg/gcs/validation"
	"github.com/genshinsim/gcsim/pkg/model"
	"google.golang.org/protobuf/encoding/prototext"
	"slices"
)

//go:embed data_gen.textproto
var pbData []byte
var base *model.AvatarData
var paramKeysValidation = map[action.Action][]string{
	2: {"extend"},
	5: {"collision"},
	6: {"collision"},
}

func init() {
	base = &model.AvatarData{}
	err := prototext.Unmarshal(pbData, base)
	if err != nil {
		panic(err)
	}
	validation.RegisterCharParamValidationFunc(keys.Noelle, ValidateParamKeys)
}

func ValidateParamKeys(a action.Action, keys []string) error {
	valid, ok := paramKeysValidation[a]
	if !ok {
		return nil
	}
	for _, v := range keys {
		if !slices.Contains(valid, v) {
			return fmt.Errorf("key %v is invalid for action %v", v, a.String())
		}
	}
	return nil
}

func (x *char) Data() *model.AvatarData {
	return base
}

var (
	attack = [][]float64{
		attack_1,
		attack_2,
		attack_3,
		attack_4,
	}
)

var (
	// attack: attack_1 = [0]
	attack_1 = []float64{
		0.7912,
		0.8556,
		0.92,
		1.012,
		1.0764,
		1.15,
		1.2512,
		1.3524,
		1.4536,
		1.564,
		1.6744,
		1.7848,
		1.8952,
		2.0056,
		2.116,
	}
	// attack: attack_2 = [1]
	attack_2 = []float64{
		0.73358,
		0.79329,
		0.853,
		0.9383,
		0.99801,
		1.06625,
		1.16008,
		1.25391,
		1.34774,
		1.4501,
		1.55246,
		1.65482,
		1.75718,
		1.85954,
		1.9619,
	}
	// attack: attack_3 = [2]
	attack_3 = []float64{
		0.86258,
		0.93279,
		1.003,
		1.1033,
		1.17351,
		1.25375,
		1.36408,
		1.47441,
		1.58474,
		1.7051,
		1.82546,
		1.94582,
		2.06618,
		2.18654,
		2.3069,
	}
	// attack: attack_4 = [3]
	attack_4 = []float64{
		1.13434,
		1.22667,
		1.319,
		1.4509,
		1.54323,
		1.64875,
		1.79384,
		1.93893,
		2.08402,
		2.2423,
		2.40058,
		2.55886,
		2.71714,
		2.87542,
		3.0337,
	}
	// attack: collision = [8]
	collision = []float64{
		0.745878,
		0.806589,
		0.8673,
		0.95403,
		1.014741,
		1.084125,
		1.179528,
		1.274931,
		1.370334,
		1.47441,
		1.578486,
		1.682562,
		1.786638,
		1.890714,
		1.99479,
	}
	// attack: highPlunge = [10]
	highPlunge = []float64{
		1.862889,
		2.01452,
		2.16615,
		2.382765,
		2.534396,
		2.707688,
		2.945964,
		3.184241,
		3.422517,
		3.682455,
		3.942393,
		4.202331,
		4.462269,
		4.722207,
		4.982145,
	}
	// attack: lowPlunge = [9]
	lowPlunge = []float64{
		1.49144,
		1.612836,
		1.734233,
		1.907656,
		2.029052,
		2.167791,
		2.358556,
		2.549322,
		2.740087,
		2.948195,
		3.156303,
		3.364411,
		3.572519,
		3.780627,
		3.988735,
	}
	// skill: healChance = [2]
	healChance = []float64{
		0.5,
		0.51,
		0.52,
		0.53,
		0.54,
		0.55,
		0.56,
		0.57,
		0.58,
		0.59,
		0.59,
		0.6,
		0.6,
		0.6,
		0.6,
	}
	// skill: shieldDef = [0]
	shieldDef = []float64{
		1.6,
		1.72,
		1.84,
		2,
		2.12,
		2.24,
		2.4,
		2.56,
		2.72,
		2.88,
		3.04,
		3.2,
		3.4,
		3.6,
		3.8,
	}
	// skill: shieldDmg = [5]
	shieldDmg = []float64{
		1.2,
		1.29,
		1.38,
		1.5,
		1.59,
		1.68,
		1.8,
		1.92,
		2.04,
		2.16,
		2.28,
		2.4,
		2.55,
		2.7,
		2.85,
	}
	// skill: shieldFlat = [6]
	shieldFlat = []float64{
		769.7851,
		846.7743,
		930.17926,
		1020,
		1116.2365,
		1218.8888,
		1327.9568,
		1443.4407,
		1565.3402,
		1693.6555,
		1828.3867,
		1969.5336,
		2117.0962,
		2271.0747,
		2431.4688,
	}
	// skill: shieldHeal = [1]
	shieldHeal = []float64{
		0.2128,
		0.22876,
		0.24472,
		0.266,
		0.28196,
		0.29792,
		0.3192,
		0.34048,
		0.36176,
		0.38304,
		0.40432,
		0.4256,
		0.4522,
		0.4788,
		0.5054,
	}
	// skill: shieldHealFlat = [7]
	shieldHealFlat = []float64{
		102.71802,
		112.99125,
		124.120575,
		136.10602,
		148.94756,
		162.64519,
		177.19893,
		192.60878,
		208.87473,
		225.99677,
		243.97491,
		262.80917,
		282.49954,
		303.046,
		324.44855,
	}
	// burst: burst = [0]
	burst = []float64{
		0.672,
		0.7224,
		0.7728,
		0.84,
		0.8904,
		0.9408,
		1.008,
		1.0752,
		1.1424,
		1.2096,
		1.2768,
		1.344,
		1.428,
		1.512,
		1.596,
	}
	// burst: burstskill = [1]
	burstskill = []float64{
		0.928,
		0.9976,
		1.0672,
		1.16,
		1.2296,
		1.2992,
		1.392,
		1.4848,
		1.5776,
		1.6704,
		1.7632,
		1.856,
		1.972,
		2.088,
		2.204,
	}
	// burst: defconv = [2]
	defconv = []float64{
		0.4,
		0.43,
		0.46,
		0.5,
		0.53,
		0.56,
		0.6,
		0.64,
		0.68,
		0.72,
		0.76,
		0.8,
		0.85,
		0.9,
		0.95,
	}
)
