// Code generated by "pipeline"; DO NOT EDIT.
package raiden

import (
	_ "embed"

	"fmt"
	"github.com/genshinsim/gcsim/pkg/core/action"
	"github.com/genshinsim/gcsim/pkg/core/keys"
	"github.com/genshinsim/gcsim/pkg/gcs/validation"
	"github.com/genshinsim/gcsim/pkg/model"
	"google.golang.org/protobuf/encoding/prototext"
	"slices"
)

//go:embed data_gen.textproto
var pbData []byte
var base *model.AvatarData
var paramKeysValidation = map[action.Action][]string{
	5: {"collision"},
	6: {"collision"},
}

func init() {
	base = &model.AvatarData{}
	err := prototext.Unmarshal(pbData, base)
	if err != nil {
		panic(err)
	}
	validation.RegisterCharParamValidationFunc(keys.Raiden, ValidateParamKeys)
}

func ValidateParamKeys(a action.Action, keys []string) error {
	valid, ok := paramKeysValidation[a]
	if !ok {
		return nil
	}
	for _, v := range keys {
		if !slices.Contains(valid, v) {
			return fmt.Errorf("key %v is invalid for action %v", v, a.String())
		}
	}
	return nil
}

func (x *char) Data() *model.AvatarData {
	return base
}

var (
	attack = [][][]float64{
		{attack_1},
		{attack_2},
		{attack_3},
		attack_4,
		{attack_5},
	}
	attackB = [][][]float64{
		{attackB_1},
		{attackB_2},
		{attackB_3},
		attackB_4,
		{attackB_5},
	}
)

var (
	// attack: attack_1 = [0]
	attack_1 = []float64{
		0.39646,
		0.42873,
		0.461,
		0.5071,
		0.53937,
		0.57625,
		0.62696,
		0.67767,
		0.72838,
		0.7837,
		0.847087,
		0.921631,
		0.996175,
		1.070719,
		1.152039,
	}
	// attack: attack_2 = [1]
	attack_2 = []float64{
		0.39732,
		0.42966,
		0.462,
		0.5082,
		0.54054,
		0.5775,
		0.62832,
		0.67914,
		0.72996,
		0.7854,
		0.848925,
		0.92363,
		0.998336,
		1.073041,
		1.154538,
	}
	// attack: attack_3 = [2]
	attack_3 = []float64{
		0.4988,
		0.5394,
		0.58,
		0.638,
		0.6786,
		0.725,
		0.7888,
		0.8526,
		0.9164,
		0.986,
		1.06575,
		1.159536,
		1.253322,
		1.347108,
		1.44942,
	}
	// attack: attack_4 = [3 3]
	attack_4 = [][]float64{
		{
			0.28982,
			0.31341,
			0.337,
			0.3707,
			0.39429,
			0.42125,
			0.45832,
			0.49539,
			0.53246,
			0.5729,
			0.619237,
			0.67373,
			0.728223,
			0.782716,
			0.842163,
		},
		{
			0.28982,
			0.31341,
			0.337,
			0.3707,
			0.39429,
			0.42125,
			0.45832,
			0.49539,
			0.53246,
			0.5729,
			0.619237,
			0.67373,
			0.728223,
			0.782716,
			0.842163,
		},
	}
	// attack: attack_5 = [5]
	attack_5 = []float64{
		0.65446,
		0.70773,
		0.761,
		0.8371,
		0.89037,
		0.95125,
		1.03496,
		1.11867,
		1.20238,
		1.2937,
		1.398338,
		1.521391,
		1.644445,
		1.767499,
		1.901739,
	}
	// attack: charge = [6]
	charge = []float64{
		0.99588,
		1.07694,
		1.158,
		1.2738,
		1.35486,
		1.4475,
		1.57488,
		1.70226,
		1.82964,
		1.9686,
		2.127825,
		2.315074,
		2.502322,
		2.689571,
		2.893842,
	}
	// attack: collision = [8]
	collision = []float64{
		0.639324,
		0.691362,
		0.7434,
		0.81774,
		0.869778,
		0.92925,
		1.011024,
		1.092798,
		1.174572,
		1.26378,
		1.352988,
		1.442196,
		1.531404,
		1.620612,
		1.70982,
	}
	// attack: highPlunge = [10]
	highPlunge = []float64{
		1.596762,
		1.726731,
		1.8567,
		2.04237,
		2.172339,
		2.320875,
		2.525112,
		2.729349,
		2.933586,
		3.15639,
		3.379194,
		3.601998,
		3.824802,
		4.047606,
		4.27041,
	}
	// attack: lowPlunge = [9]
	lowPlunge = []float64{
		1.278377,
		1.382431,
		1.486485,
		1.635134,
		1.739187,
		1.858106,
		2.02162,
		2.185133,
		2.348646,
		2.527025,
		2.705403,
		2.883781,
		3.062159,
		3.240537,
		3.418915,
	}
	// skill: skill = [0]
	skill = []float64{
		1.172,
		1.2599,
		1.3478,
		1.465,
		1.5529,
		1.6408,
		1.758,
		1.8752,
		1.9924,
		2.1096,
		2.2268,
		2.344,
		2.4905,
		2.637,
		2.7835,
	}
	// skill: skillBurstBonus = [3]
	skillBurstBonus = []float64{
		0.0022,
		0.0023,
		0.0024,
		0.0025,
		0.0026,
		0.0027,
		0.0028,
		0.0029,
		0.003,
		0.003,
		0.003,
		0.003,
		0.003,
		0.003,
		0.003,
	}
	// skill: skillTick = [1]
	skillTick = []float64{
		0.42,
		0.4515,
		0.483,
		0.525,
		0.5565,
		0.588,
		0.63,
		0.672,
		0.714,
		0.756,
		0.798,
		0.84,
		0.8925,
		0.945,
		0.9975,
	}
	// burst: attackB_1 = [4]
	attackB_1 = []float64{
		0.447374,
		0.477877,
		0.50838,
		0.54905,
		0.579553,
		0.61514,
		0.660894,
		0.706648,
		0.752402,
		0.798157,
		0.843911,
		0.889665,
		0.935419,
		0.981173,
		1.026928,
	}
	// burst: attackB_2 = [5]
	attackB_2 = []float64{
		0.43956,
		0.46953,
		0.4995,
		0.53946,
		0.56943,
		0.604395,
		0.64935,
		0.694305,
		0.73926,
		0.784215,
		0.82917,
		0.874125,
		0.91908,
		0.964035,
		1.00899,
	}
	// burst: attackB_3 = [6]
	attackB_3 = []float64{
		0.538217,
		0.574913,
		0.61161,
		0.660539,
		0.697235,
		0.740048,
		0.795093,
		0.850138,
		0.905183,
		0.960228,
		1.015273,
		1.070318,
		1.125362,
		1.180407,
		1.235452,
	}
	// burst: attackB_4 = [7 8]
	attackB_4 = [][]float64{
		{
			0.30888,
			0.32994,
			0.351,
			0.37908,
			0.40014,
			0.42471,
			0.4563,
			0.48789,
			0.51948,
			0.55107,
			0.58266,
			0.61425,
			0.64584,
			0.67743,
			0.70902,
		},
		{
			0.30976,
			0.33088,
			0.352,
			0.38016,
			0.40128,
			0.42592,
			0.4576,
			0.48928,
			0.52096,
			0.55264,
			0.58432,
			0.616,
			0.64768,
			0.67936,
			0.71104,
		},
	}
	// burst: attackB_5 = [9]
	attackB_5 = []float64{
		0.739438,
		0.789854,
		0.84027,
		0.907492,
		0.957908,
		1.016727,
		1.092351,
		1.167975,
		1.2436,
		1.319224,
		1.394848,
		1.470473,
		1.546097,
		1.621721,
		1.697345,
	}
	// burst: burstBase = [0]
	burstBase = []float64{
		4.008,
		4.3086,
		4.6092,
		5.01,
		5.3106,
		5.6112,
		6.012,
		6.4128,
		6.8136,
		7.2144,
		7.6152,
		8.016,
		8.517,
		9.018,
		9.519,
	}
	// burst: burstRestore = [16]
	burstRestore = []float64{
		1.6,
		1.7,
		1.8,
		1.9,
		2,
		2.1,
		2.2,
		2.3,
		2.4,
		2.5,
		2.5,
		2.5,
		2.5,
		2.5,
		2.5,
	}
	// burst: chargeSword = [10 11]
	chargeSword = [][]float64{
		{
			0.616,
			0.658,
			0.7,
			0.756,
			0.798,
			0.847,
			0.91,
			0.973,
			1.036,
			1.099,
			1.162,
			1.225,
			1.288,
			1.351,
			1.414,
		},
		{
			0.7436,
			0.7943,
			0.845,
			0.9126,
			0.9633,
			1.02245,
			1.0985,
			1.17455,
			1.2506,
			1.32665,
			1.4027,
			1.47875,
			1.5548,
			1.63085,
			1.7069,
		},
	}
	// burst: resolveBaseBonus = [1]
	resolveBaseBonus = []float64{
		0.03888,
		0.041796,
		0.044712,
		0.0486,
		0.051516,
		0.054432,
		0.05832,
		0.062208,
		0.066096,
		0.069984,
		0.073872,
		0.07776,
		0.08262,
		0.08748,
		0.09234,
	}
	// burst: resolveBonus = [2]
	resolveBonus = []float64{
		0.007262,
		0.007806,
		0.008351,
		0.009077,
		0.009622,
		0.010166,
		0.010892,
		0.011619,
		0.012345,
		0.013071,
		0.013797,
		0.014523,
		0.015431,
		0.016339,
		0.017246,
	}
	// burst: resolveStackGain = [3]
	resolveStackGain = []float64{
		0.15,
		0.16,
		0.16,
		0.17,
		0.17,
		0.18,
		0.18,
		0.19,
		0.19,
		0.2,
		0.2,
		0.2,
		0.2,
		0.2,
		0.2,
	}
)
