// Code generated by "pipeline"; DO NOT EDIT.
package sigewinne

import (
	_ "embed"

	"fmt"
	"github.com/genshinsim/gcsim/pkg/core/action"
	"github.com/genshinsim/gcsim/pkg/core/keys"
	"github.com/genshinsim/gcsim/pkg/gcs/validation"
	"github.com/genshinsim/gcsim/pkg/model"
	"google.golang.org/protobuf/encoding/prototext"
	"slices"
)

//go:embed data_gen.textproto
var pbData []byte
var base *model.AvatarData
var paramKeysValidation = map[action.Action][]string{
	1: {"hold"},
	2: {"ticks"},
	3: {"travel"},
	7: {"hold", "travel", "weakspot"},
	8: {"pickup_droplets"},
}

func init() {
	base = &model.AvatarData{}
	err := prototext.Unmarshal(pbData, base)
	if err != nil {
		panic(err)
	}
	validation.RegisterCharParamValidationFunc(keys.Sigewinne, ValidateParamKeys)
}

func ValidateParamKeys(a action.Action, keys []string) error {
	valid, ok := paramKeysValidation[a]
	if !ok {
		return nil
	}
	for _, v := range keys {
		if !slices.Contains(valid, v) {
			return fmt.Errorf("key %v is invalid for action %v", v, a.String())
		}
	}
	return nil
}

func (x *char) Data() *model.AvatarData {
	return base
}

var (
	attack = [][]float64{
		attack_1,
		attack_2,
		attack_3,
	}
)

var (
	// attack: aim = [6]
	aim = []float64{
		0.4386,
		0.4743,
		0.51,
		0.561,
		0.5967,
		0.6375,
		0.6936,
		0.7497,
		0.8058,
		0.867,
		0.9282,
		0.9894,
		1.0506,
		1.1118,
		1.173,
	}
	// attack: attack_1 = [0]
	attack_1 = []float64{
		0.526139,
		0.568965,
		0.61179,
		0.672969,
		0.715794,
		0.764737,
		0.832034,
		0.899331,
		0.966628,
		1.040043,
		1.113458,
		1.186873,
		1.260287,
		1.333702,
		1.407117,
	}
	// attack: attack_2 = [1]
	attack_2 = []float64{
		0.510711,
		0.552281,
		0.59385,
		0.653235,
		0.694804,
		0.742312,
		0.807636,
		0.872959,
		0.938283,
		1.009545,
		1.080807,
		1.152069,
		1.223331,
		1.294593,
		1.365855,
	}
	// attack: attack_3 = [2]
	attack_3 = []float64{
		0.78291,
		0.846635,
		0.91036,
		1.001396,
		1.065121,
		1.13795,
		1.23809,
		1.338229,
		1.438369,
		1.547612,
		1.656855,
		1.766098,
		1.875342,
		1.984585,
		2.093828,
	}
	// attack: fullaim = [7]
	fullaim = []float64{
		1.24,
		1.333,
		1.426,
		1.55,
		1.643,
		1.736,
		1.86,
		1.984,
		2.108,
		2.232,
		2.356,
		2.48,
		2.635,
		2.79,
		2.945,
	}
	// attack: miniStrationBubbleDMG = [8]
	miniStrationBubbleDMG = []float64{
		0.248,
		0.2666,
		0.2852,
		0.31,
		0.3286,
		0.3472,
		0.372,
		0.3968,
		0.4216,
		0.4464,
		0.4712,
		0.496,
		0.527,
		0.558,
		0.589,
	}
	// skill: bolsteringBubblebalmDMG = [0]
	bolsteringBubblebalmDMG = []float64{
		0.0228,
		0.02451,
		0.02622,
		0.0285,
		0.03021,
		0.03192,
		0.0342,
		0.03648,
		0.03876,
		0.04104,
		0.04332,
		0.0456,
		0.04845,
		0.0513,
		0.05415,
	}
	// skill: bolsteringBubblebalmHealingFlat = [2]
	bolsteringBubblebalmHealingFlat = []float64{
		269.6314,
		296.5983,
		325.81244,
		357.2738,
		390.98242,
		426.93826,
		465.14136,
		505.59167,
		548.28925,
		593.2341,
		640.42615,
		689.8654,
		741.55194,
		795.4857,
		851.66675,
	}
	// skill: bolsteringBubblebalmHealingPct = [1]
	bolsteringBubblebalmHealingPct = []float64{
		0.028,
		0.0301,
		0.0322,
		0.035,
		0.0371,
		0.0392,
		0.042,
		0.0448,
		0.0476,
		0.0504,
		0.0532,
		0.056,
		0.0595,
		0.063,
		0.0665,
	}
	// skill: finalBounceHealing = [3]
	finalBounceHealing = []float64{
		0.5,
		0.5,
		0.5,
		0.5,
		0.5,
		0.5,
		0.5,
		0.5,
		0.5,
		0.5,
		0.5,
		0.5,
		0.5,
		0.5,
		0.5,
	}
	// skill: surgingBladeDMG = [6]
	surgingBladeDMG = []float64{
		0.00684,
		0.007353,
		0.007866,
		0.00855,
		0.009063,
		0.009576,
		0.01026,
		0.010944,
		0.011628,
		0.012312,
		0.012996,
		0.01368,
		0.014535,
		0.01539,
		0.016245,
	}
	// skill: suringBladeInterval = [7]
	suringBladeInterval = []float64{
		10,
		10,
		10,
		10,
		10,
		10,
		10,
		10,
		10,
		10,
		10,
		10,
		10,
		10,
		10,
	}
	// burst: burstDMG = [0]
	burstDMG = []float64{
		0.117708,
		0.126536,
		0.135364,
		0.147135,
		0.155963,
		0.164791,
		0.176562,
		0.188333,
		0.200104,
		0.211874,
		0.223645,
		0.235416,
		0.250129,
		0.264843,
		0.279556,
	}
)
