// Code generated by "pipeline"; DO NOT EDIT.
package tartaglia

import (
	_ "embed"

	"fmt"
	"github.com/genshinsim/gcsim/pkg/core/action"
	"github.com/genshinsim/gcsim/pkg/core/keys"
	"github.com/genshinsim/gcsim/pkg/gcs/validation"
	"github.com/genshinsim/gcsim/pkg/model"
	"google.golang.org/protobuf/encoding/prototext"
	"slices"
)

//go:embed data_gen.textproto
var pbData []byte
var base *model.AvatarData
var paramKeysValidation = map[action.Action][]string{
	3: {"travel"},
	4: {"hitWeakPoint"},
	7: {"hold", "travel", "weakspot"},
}

func init() {
	base = &model.AvatarData{}
	err := prototext.Unmarshal(pbData, base)
	if err != nil {
		panic(err)
	}
	validation.RegisterCharParamValidationFunc(keys.Tartaglia, ValidateParamKeys)
}

func ValidateParamKeys(a action.Action, keys []string) error {
	valid, ok := paramKeysValidation[a]
	if !ok {
		return nil
	}
	for _, v := range keys {
		if !slices.Contains(valid, v) {
			return fmt.Errorf("key %v is invalid for action %v", v, a.String())
		}
	}
	return nil
}

func (x *char) Data() *model.AvatarData {
	return base
}

var (
	attack = [][]float64{
		attack_1,
		attack_2,
		attack_3,
		attack_4,
		attack_5,
		attack_6,
	}
	attackE = [][][]float64{
		{attackE_1},
		{attackE_2},
		{attackE_3},
		{attackE_4},
		{attackE_5},
		attackE_6,
	}
)

var (
	// attack: aim = [6]
	aim = []float64{
		0.4386,
		0.4743,
		0.51,
		0.561,
		0.5967,
		0.6375,
		0.6936,
		0.7497,
		0.8058,
		0.867,
		0.9282,
		0.9894,
		1.0506,
		1.1118,
		1.173,
	}
	// attack: attack_1 = [0]
	attack_1 = []float64{
		0.4128,
		0.4464,
		0.48,
		0.528,
		0.5616,
		0.6,
		0.6528,
		0.7056,
		0.7584,
		0.816,
		0.8736,
		0.9312,
		0.9888,
		1.0464,
		1.104,
	}
	// attack: attack_2 = [1]
	attack_2 = []float64{
		0.46268,
		0.50034,
		0.538,
		0.5918,
		0.62946,
		0.6725,
		0.73168,
		0.79086,
		0.85004,
		0.9146,
		0.97916,
		1.04372,
		1.10828,
		1.17284,
		1.2374,
	}
	// attack: attack_3 = [2]
	attack_3 = []float64{
		0.55384,
		0.59892,
		0.644,
		0.7084,
		0.75348,
		0.805,
		0.87584,
		0.94668,
		1.01752,
		1.0948,
		1.17208,
		1.24936,
		1.32664,
		1.40392,
		1.4812,
	}
	// attack: attack_4 = [3]
	attack_4 = []float64{
		0.57018,
		0.61659,
		0.663,
		0.7293,
		0.77571,
		0.82875,
		0.90168,
		0.97461,
		1.04754,
		1.1271,
		1.20666,
		1.28622,
		1.36578,
		1.44534,
		1.5249,
	}
	// attack: attack_5 = [4]
	attack_5 = []float64{
		0.60888,
		0.65844,
		0.708,
		0.7788,
		0.82836,
		0.885,
		0.96288,
		1.04076,
		1.11864,
		1.2036,
		1.28856,
		1.37352,
		1.45848,
		1.54344,
		1.6284,
	}
	// attack: attack_6 = [5]
	attack_6 = []float64{
		0.72756,
		0.78678,
		0.846,
		0.9306,
		0.98982,
		1.0575,
		1.15056,
		1.24362,
		1.33668,
		1.4382,
		1.53972,
		1.64124,
		1.74276,
		1.84428,
		1.9458,
	}
	// attack: fullaim = [7]
	fullaim = []float64{
		1.24,
		1.333,
		1.426,
		1.55,
		1.643,
		1.736,
		1.86,
		1.984,
		2.108,
		2.232,
		2.356,
		2.48,
		2.635,
		2.79,
		2.945,
	}
	// attack: rtBurst = [9]
	rtBurst = []float64{
		0.62,
		0.6665,
		0.713,
		0.775,
		0.8215,
		0.868,
		0.93,
		0.992,
		1.054,
		1.116,
		1.178,
		1.24,
		1.3175,
		1.395,
		1.4725,
	}
	// attack: rtFlash = [8]
	rtFlash = []float64{
		0.124,
		0.1333,
		0.1426,
		0.155,
		0.1643,
		0.1736,
		0.186,
		0.1984,
		0.2108,
		0.2232,
		0.2356,
		0.248,
		0.2635,
		0.279,
		0.2945,
	}
	// skill: attackE_1 = [1]
	attackE_1 = []float64{
		0.38872,
		0.42036,
		0.452,
		0.4972,
		0.52884,
		0.565,
		0.61472,
		0.66444,
		0.71416,
		0.7684,
		0.82264,
		0.87688,
		0.93112,
		0.98536,
		1.0396,
	}
	// skill: attackE_2 = [2]
	attackE_2 = []float64{
		0.41624,
		0.45012,
		0.484,
		0.5324,
		0.56628,
		0.605,
		0.65824,
		0.71148,
		0.76472,
		0.8228,
		0.88088,
		0.93896,
		0.99704,
		1.05512,
		1.1132,
	}
	// skill: attackE_3 = [3]
	attackE_3 = []float64{
		0.5633,
		0.60915,
		0.655,
		0.7205,
		0.76635,
		0.81875,
		0.8908,
		0.96285,
		1.0349,
		1.1135,
		1.1921,
		1.2707,
		1.3493,
		1.4279,
		1.5065,
	}
	// skill: attackE_4 = [4]
	attackE_4 = []float64{
		0.59942,
		0.64821,
		0.697,
		0.7667,
		0.81549,
		0.87125,
		0.94792,
		1.02459,
		1.10126,
		1.1849,
		1.26854,
		1.35218,
		1.43582,
		1.51946,
		1.6031,
	}
	// skill: attackE_5 = [5]
	attackE_5 = []float64{
		0.55298,
		0.59799,
		0.643,
		0.7073,
		0.75231,
		0.80375,
		0.87448,
		0.94521,
		1.01594,
		1.0931,
		1.17026,
		1.24742,
		1.32458,
		1.40174,
		1.4789,
	}
	// skill: attackE_6 = [6 7]
	attackE_6 = [][]float64{
		{
			0.35432,
			0.38316,
			0.412,
			0.4532,
			0.48204,
			0.515,
			0.56032,
			0.60564,
			0.65096,
			0.7004,
			0.74984,
			0.79928,
			0.84872,
			0.89816,
			0.9476,
		},
		{
			0.37668,
			0.40734,
			0.438,
			0.4818,
			0.51246,
			0.5475,
			0.59568,
			0.64386,
			0.69204,
			0.7446,
			0.79716,
			0.84972,
			0.90228,
			0.95484,
			1.0074,
		},
	}
	// skill: eCharge = [8 9]
	eCharge = [][]float64{
		{
			0.602,
			0.651,
			0.7,
			0.77,
			0.819,
			0.875,
			0.952,
			1.029,
			1.106,
			1.19,
			1.274,
			1.358,
			1.442,
			1.526,
			1.61,
		},
		{
			0.71982,
			0.77841,
			0.837,
			0.9207,
			0.97929,
			1.04625,
			1.13832,
			1.23039,
			1.32246,
			1.4229,
			1.52334,
			1.62378,
			1.72422,
			1.82466,
			1.9251,
		},
	}
	// skill: rtSlash = [8]
	rtSlash = []float64{
		0.602,
		0.651,
		0.7,
		0.77,
		0.819,
		0.875,
		0.952,
		1.029,
		1.106,
		1.19,
		1.274,
		1.358,
		1.442,
		1.526,
		1.61,
	}
	// skill: skill = [0]
	skill = []float64{
		0.72,
		0.774,
		0.828,
		0.9,
		0.954,
		1.008,
		1.08,
		1.152,
		1.224,
		1.296,
		1.368,
		1.44,
		1.53,
		1.62,
		1.71,
	}
	// burst: burst = [2]
	burst = []float64{
		3.784,
		4.0678,
		4.3516,
		4.73,
		5.0138,
		5.2976,
		5.676,
		6.0544,
		6.4328,
		6.8112,
		7.1896,
		7.568,
		8.041,
		8.514,
		8.987,
	}
	// burst: meleeBurst = [0]
	meleeBurst = []float64{
		4.64,
		4.988,
		5.336,
		5.8,
		6.148,
		6.496,
		6.96,
		7.424,
		7.888,
		8.352,
		8.816,
		9.28,
		9.86,
		10.44,
		11.02,
	}
	// burst: rtBlast = [1]
	rtBlast = []float64{
		1.2,
		1.29,
		1.38,
		1.5,
		1.59,
		1.68,
		1.8,
		1.92,
		2.04,
		2.16,
		2.28,
		2.4,
		2.55,
		2.7,
		2.85,
	}
)
