// Code generated by "pipeline"; DO NOT EDIT.
package tighnari

import (
	_ "embed"

	"fmt"
	"github.com/genshinsim/gcsim/pkg/core/action"
	"github.com/genshinsim/gcsim/pkg/core/keys"
	"github.com/genshinsim/gcsim/pkg/gcs/validation"
	"github.com/genshinsim/gcsim/pkg/model"
	"google.golang.org/protobuf/encoding/prototext"
	"slices"
)

//go:embed data_gen.textproto
var pbData []byte
var base *model.AvatarData
var paramKeysValidation = map[action.Action][]string{
	1: {"travel"},
	2: {"travel"},
	3: {"travel"},
	7: {"hold", "travel", "weakspot", "wreath"},
}

func init() {
	base = &model.AvatarData{}
	err := prototext.Unmarshal(pbData, base)
	if err != nil {
		panic(err)
	}
	validation.RegisterCharParamValidationFunc(keys.Tighnari, ValidateParamKeys)
}

func ValidateParamKeys(a action.Action, keys []string) error {
	valid, ok := paramKeysValidation[a]
	if !ok {
		return nil
	}
	for _, v := range keys {
		if !slices.Contains(valid, v) {
			return fmt.Errorf("key %v is invalid for action %v", v, a.String())
		}
	}
	return nil
}

func (x *char) Data() *model.AvatarData {
	return base
}

var (
	attack = [][][]float64{
		{attack_1},
		{attack_2},
		attack_3,
		{attack_4},
	}
)

var (
	// attack: aim = [4]
	aim = []float64{
		0.4386,
		0.4743,
		0.51,
		0.561,
		0.5967,
		0.6375,
		0.6936,
		0.7497,
		0.8058,
		0.867,
		0.9282,
		0.9894,
		1.0506,
		1.1118,
		1.173,
	}
	// attack: attack_1 = [0]
	attack_1 = []float64{
		0.44634,
		0.48267,
		0.519,
		0.5709,
		0.60723,
		0.64875,
		0.70584,
		0.76293,
		0.82002,
		0.8823,
		0.94458,
		1.00686,
		1.06914,
		1.13142,
		1.1937,
	}
	// attack: attack_2 = [1]
	attack_2 = []float64{
		0.41968,
		0.45384,
		0.488,
		0.5368,
		0.57096,
		0.61,
		0.66368,
		0.71736,
		0.77104,
		0.8296,
		0.88816,
		0.94672,
		1.00528,
		1.06384,
		1.1224,
	}
	// attack: attack_3 = [2 2]
	attack_3 = [][]float64{
		{
			0.26445,
			0.285975,
			0.3075,
			0.33825,
			0.359775,
			0.384375,
			0.4182,
			0.452025,
			0.48585,
			0.52275,
			0.55965,
			0.59655,
			0.63345,
			0.67035,
			0.70725,
		},
		{
			0.26445,
			0.285975,
			0.3075,
			0.33825,
			0.359775,
			0.384375,
			0.4182,
			0.452025,
			0.48585,
			0.52275,
			0.55965,
			0.59655,
			0.63345,
			0.67035,
			0.70725,
		},
	}
	// attack: attack_4 = [3]
	attack_4 = []float64{
		0.68628,
		0.74214,
		0.798,
		0.8778,
		0.93366,
		0.9975,
		1.08528,
		1.17306,
		1.26084,
		1.3566,
		1.45236,
		1.54812,
		1.64388,
		1.73964,
		1.8354,
	}
	// attack: clusterbloom = [7]
	clusterbloom = []float64{
		0.386,
		0.41495,
		0.4439,
		0.4825,
		0.51145,
		0.5404,
		0.579,
		0.6176,
		0.6562,
		0.6948,
		0.7334,
		0.772,
		0.82025,
		0.8685,
		0.91675,
	}
	// attack: fullaim = [5]
	fullaim = []float64{
		1.24,
		1.333,
		1.426,
		1.55,
		1.643,
		1.736,
		1.86,
		1.984,
		2.108,
		2.232,
		2.356,
		2.48,
		2.635,
		2.79,
		2.945,
	}
	// attack: wreath = [6]
	wreath = []float64{
		0.872,
		0.9374,
		1.0028,
		1.09,
		1.1554,
		1.2208,
		1.308,
		1.3952,
		1.4824,
		1.5696,
		1.6568,
		1.744,
		1.853,
		1.962,
		2.071,
	}
	// skill: skill = [0]
	skill = []float64{
		1.496,
		1.6082,
		1.7204,
		1.87,
		1.9822,
		2.0944,
		2.244,
		2.3936,
		2.5432,
		2.6928,
		2.8424,
		2.992,
		3.179,
		3.366,
		3.553,
	}
	// burst: burst = [0]
	burst = []float64{
		0.5562,
		0.597915,
		0.63963,
		0.69525,
		0.736965,
		0.77868,
		0.8343,
		0.88992,
		0.94554,
		1.00116,
		1.05678,
		1.1124,
		1.181925,
		1.25145,
		1.320975,
	}
	// burst: burstSecond = [1]
	burstSecond = []float64{
		0.6798,
		0.730785,
		0.78177,
		0.84975,
		0.900735,
		0.95172,
		1.0197,
		1.08768,
		1.15566,
		1.22364,
		1.29162,
		1.3596,
		1.444575,
		1.52955,
		1.614525,
	}
)
