// Code generated by "pipeline"; DO NOT EDIT.
package venti

import (
	_ "embed"

	"fmt"
	"github.com/genshinsim/gcsim/pkg/core/action"
	"github.com/genshinsim/gcsim/pkg/core/keys"
	"github.com/genshinsim/gcsim/pkg/gcs/validation"
	"github.com/genshinsim/gcsim/pkg/model"
	"google.golang.org/protobuf/encoding/prototext"
	"slices"
)

//go:embed data_gen.textproto
var pbData []byte
var base *model.AvatarData
var paramKeysValidation = map[action.Action][]string{
	1: {"hold"},
	3: {"travel"},
	7: {"hold", "travel", "weakspot"},
}

func init() {
	base = &model.AvatarData{}
	err := prototext.Unmarshal(pbData, base)
	if err != nil {
		panic(err)
	}
	validation.RegisterCharParamValidationFunc(keys.Venti, ValidateParamKeys)
}

func ValidateParamKeys(a action.Action, keys []string) error {
	valid, ok := paramKeysValidation[a]
	if !ok {
		return nil
	}
	for _, v := range keys {
		if !slices.Contains(valid, v) {
			return fmt.Errorf("key %v is invalid for action %v", v, a.String())
		}
	}
	return nil
}

func (x *char) Data() *model.AvatarData {
	return base
}

var (
	attack = [][][]float64{
		attack_1,
		{attack_2},
		{attack_3},
		attack_4,
		{attack_5},
		{attack_6},
	}
)

var (
	// attack: aim = [6]
	aim = []float64{
		0.4386,
		0.4743,
		0.51,
		0.561,
		0.5967,
		0.6375,
		0.6936,
		0.7497,
		0.8058,
		0.867,
		0.937125,
		1.019592,
		1.102059,
		1.184526,
		1.27449,
	}
	// attack: attack_1 = [0 0]
	attack_1 = [][]float64{
		{
			0.20382,
			0.22041,
			0.237,
			0.2607,
			0.27729,
			0.29625,
			0.32232,
			0.34839,
			0.37446,
			0.4029,
			0.435487,
			0.47381,
			0.512133,
			0.550456,
			0.592263,
		},
		{
			0.20382,
			0.22041,
			0.237,
			0.2607,
			0.27729,
			0.29625,
			0.32232,
			0.34839,
			0.37446,
			0.4029,
			0.435487,
			0.47381,
			0.512133,
			0.550456,
			0.592263,
		},
	}
	// attack: attack_2 = [1]
	attack_2 = []float64{
		0.44376,
		0.47988,
		0.516,
		0.5676,
		0.60372,
		0.645,
		0.70176,
		0.75852,
		0.81528,
		0.8772,
		0.94815,
		1.031587,
		1.115024,
		1.198462,
		1.289484,
	}
	// attack: attack_3 = [2]
	attack_3 = []float64{
		0.52374,
		0.56637,
		0.609,
		0.6699,
		0.71253,
		0.76125,
		0.82824,
		0.89523,
		0.96222,
		1.0353,
		1.119037,
		1.217513,
		1.315988,
		1.414463,
		1.521891,
	}
	// attack: attack_4 = [3 3]
	attack_4 = [][]float64{
		{
			0.26058,
			0.28179,
			0.303,
			0.3333,
			0.35451,
			0.37875,
			0.41208,
			0.44541,
			0.47874,
			0.5151,
			0.556762,
			0.605758,
			0.654753,
			0.703748,
			0.757197,
		},
		{
			0.26058,
			0.28179,
			0.303,
			0.3333,
			0.35451,
			0.37875,
			0.41208,
			0.44541,
			0.47874,
			0.5151,
			0.556762,
			0.605758,
			0.654753,
			0.703748,
			0.757197,
		},
	}
	// attack: attack_5 = [4]
	attack_5 = []float64{
		0.50654,
		0.54777,
		0.589,
		0.6479,
		0.68913,
		0.73625,
		0.80104,
		0.86583,
		0.93062,
		1.0013,
		1.082288,
		1.177529,
		1.27277,
		1.368011,
		1.471911,
	}
	// attack: attack_6 = [5]
	attack_6 = []float64{
		0.7095,
		0.76725,
		0.825,
		0.9075,
		0.96525,
		1.03125,
		1.122,
		1.21275,
		1.3035,
		1.4025,
		1.515937,
		1.64934,
		1.782742,
		1.916145,
		2.061675,
	}
	// attack: fullaim = [7]
	fullaim = []float64{
		1.24,
		1.333,
		1.426,
		1.55,
		1.643,
		1.736,
		1.86,
		1.984,
		2.108,
		2.232,
		2.36096,
		2.5296,
		2.69824,
		2.86688,
		3.03552,
	}
	// attack: highPlunge = [10]
	highPlunge = []float64{
		1.419344,
		1.534872,
		1.6504,
		1.81544,
		1.930968,
		2.063,
		2.244544,
		2.426088,
		2.607632,
		2.80568,
		3.003728,
		3.201776,
		3.399824,
		3.597872,
		3.79592,
	}
	// skill: skillHold = [2]
	skillHold = []float64{
		3.8,
		4.085,
		4.37,
		4.75,
		5.035,
		5.32,
		5.7,
		6.08,
		6.46,
		6.84,
		7.22,
		7.6,
		8.075,
		8.55,
		9.025,
	}
	// skill: skillPress = [0]
	skillPress = []float64{
		2.76,
		2.967,
		3.174,
		3.45,
		3.657,
		3.864,
		4.14,
		4.416,
		4.692,
		4.968,
		5.244,
		5.52,
		5.865,
		6.21,
		6.555,
	}
	// burst: burstAbsorbDot = [1]
	burstAbsorbDot = []float64{
		0.188,
		0.2021,
		0.2162,
		0.235,
		0.2491,
		0.2632,
		0.282,
		0.3008,
		0.3196,
		0.3384,
		0.3572,
		0.376,
		0.3995,
		0.423,
		0.4465,
	}
	// burst: burstDot = [0]
	burstDot = []float64{
		0.376,
		0.4042,
		0.4324,
		0.47,
		0.4982,
		0.5264,
		0.564,
		0.6016,
		0.6392,
		0.6768,
		0.7144,
		0.752,
		0.799,
		0.846,
		0.893,
	}
)
