// Code generated by "pipeline"; DO NOT EDIT.
package wriothesley

import (
	_ "embed"

	"fmt"
	"github.com/genshinsim/gcsim/pkg/core/action"
	"github.com/genshinsim/gcsim/pkg/core/keys"
	"github.com/genshinsim/gcsim/pkg/gcs/validation"
	"github.com/genshinsim/gcsim/pkg/model"
	"google.golang.org/protobuf/encoding/prototext"
	"slices"
)

//go:embed data_gen.textproto
var pbData []byte
var base *model.AvatarData
var paramKeysValidation = map[action.Action][]string{
	5: {"collision"},
	6: {"collision"},
}

func init() {
	base = &model.AvatarData{}
	err := prototext.Unmarshal(pbData, base)
	if err != nil {
		panic(err)
	}
	validation.RegisterCharParamValidationFunc(keys.Wriothesley, ValidateParamKeys)
}

func ValidateParamKeys(a action.Action, keys []string) error {
	valid, ok := paramKeysValidation[a]
	if !ok {
		return nil
	}
	for _, v := range keys {
		if !slices.Contains(valid, v) {
			return fmt.Errorf("key %v is invalid for action %v", v, a.String())
		}
	}
	return nil
}

func (x *char) Data() *model.AvatarData {
	return base
}

var (
	attack = [][][]float64{
		{attack_1},
		{attack_2},
		{attack_3},
		attack_4,
		{attack_5},
	}
)

var (
	// attack: attack_1 = [0]
	attack_1 = []float64{
		0.533596,
		0.577028,
		0.62046,
		0.682506,
		0.725938,
		0.775575,
		0.843826,
		0.912076,
		0.980327,
		1.054782,
		1.129237,
		1.203692,
		1.278148,
		1.352603,
		1.427058,
	}
	// attack: attack_2 = [1]
	attack_2 = []float64{
		0.517987,
		0.560148,
		0.60231,
		0.662541,
		0.704703,
		0.752888,
		0.819142,
		0.885396,
		0.95165,
		1.023927,
		1.096204,
		1.168481,
		1.240759,
		1.313036,
		1.385313,
	}
	// attack: attack_3 = [2]
	attack_3 = []float64{
		0.672228,
		0.726944,
		0.78166,
		0.859826,
		0.914542,
		0.977075,
		1.063058,
		1.14904,
		1.235023,
		1.328822,
		1.422621,
		1.51642,
		1.61022,
		1.704019,
		1.797818,
	}
	// attack: attack_4 = [3 3]
	attack_4 = [][]float64{
		{
			0.379041,
			0.409893,
			0.440745,
			0.48482,
			0.515672,
			0.550931,
			0.599413,
			0.647895,
			0.696377,
			0.749266,
			0.802156,
			0.855045,
			0.907935,
			0.960824,
			1.013713,
		},
		{
			0.379041,
			0.409893,
			0.440745,
			0.48482,
			0.515672,
			0.550931,
			0.599413,
			0.647895,
			0.696377,
			0.749266,
			0.802156,
			0.855045,
			0.907935,
			0.960824,
			1.013713,
		},
	}
	// attack: attack_5 = [5]
	attack_5 = []float64{
		0.90742,
		0.98128,
		1.05514,
		1.160654,
		1.234514,
		1.318925,
		1.43499,
		1.551056,
		1.667121,
		1.793738,
		1.920355,
		2.046972,
		2.173588,
		2.300205,
		2.426822,
	}
	// attack: charge = [6]
	charge = []float64{
		1.5296,
		1.64432,
		1.75904,
		1.912,
		2.02672,
		2.14144,
		2.2944,
		2.44736,
		2.60032,
		2.75328,
		2.90624,
		3.0592,
		3.2504,
		3.4416,
		3.6328,
	}
	// attack: collision = [8]
	collision = []float64{
		0.568288,
		0.614544,
		0.6608,
		0.72688,
		0.773136,
		0.826,
		0.898688,
		0.971376,
		1.044064,
		1.12336,
		1.202656,
		1.281952,
		1.361248,
		1.440544,
		1.51984,
	}
	// attack: highPlunge = [10]
	highPlunge = []float64{
		1.419344,
		1.534872,
		1.6504,
		1.81544,
		1.930968,
		2.063,
		2.244544,
		2.426088,
		2.607632,
		2.80568,
		3.003728,
		3.201776,
		3.399824,
		3.597872,
		3.79592,
	}
	// attack: lowPlunge = [9]
	lowPlunge = []float64{
		1.136335,
		1.228828,
		1.32132,
		1.453452,
		1.545944,
		1.65165,
		1.796995,
		1.94234,
		2.087686,
		2.246244,
		2.404802,
		2.563361,
		2.721919,
		2.880478,
		3.039036,
	}
	// skill: skill = [0]
	skill = []float64{
		1.431695,
		1.457545,
		1.483395,
		1.517,
		1.54285,
		1.5687,
		1.602305,
		1.63591,
		1.669515,
		1.70312,
		1.736725,
		1.77033,
		1.803935,
		1.83754,
		1.871145,
	}
	// burst: burst = [0]
	burst = []float64{
		1.272,
		1.3674,
		1.4628,
		1.59,
		1.6854,
		1.7808,
		1.908,
		2.0352,
		2.1624,
		2.2896,
		2.4168,
		2.544,
		2.703,
		2.862,
		3.021,
	}
	// burst: burstOusia = [1]
	burstOusia = []float64{
		0.424,
		0.4558,
		0.4876,
		0.53,
		0.5618,
		0.5936,
		0.636,
		0.6784,
		0.7208,
		0.7632,
		0.8056,
		0.848,
		0.901,
		0.954,
		1.007,
	}
)
