// Code generated by "pipeline"; DO NOT EDIT.
package yaemiko

import (
	_ "embed"

	"fmt"
	"github.com/genshinsim/gcsim/pkg/core/action"
	"github.com/genshinsim/gcsim/pkg/core/keys"
	"github.com/genshinsim/gcsim/pkg/gcs/validation"
	"github.com/genshinsim/gcsim/pkg/model"
	"google.golang.org/protobuf/encoding/prototext"
	"slices"
)

//go:embed data_gen.textproto
var pbData []byte
var base *model.AvatarData
var paramKeysValidation = map[action.Action][]string{
	3: {"travel"},
	5: {"collision"},
	6: {"collision"},
}

func init() {
	base = &model.AvatarData{}
	err := prototext.Unmarshal(pbData, base)
	if err != nil {
		panic(err)
	}
	validation.RegisterCharParamValidationFunc(keys.YaeMiko, ValidateParamKeys)
}

func ValidateParamKeys(a action.Action, keys []string) error {
	valid, ok := paramKeysValidation[a]
	if !ok {
		return nil
	}
	for _, v := range keys {
		if !slices.Contains(valid, v) {
			return fmt.Errorf("key %v is invalid for action %v", v, a.String())
		}
	}
	return nil
}

func (x *char) Data() *model.AvatarData {
	return base
}

var (
	attack = [][]float64{
		attack_1,
		attack_2,
		attack_3,
	}
)

var (
	// attack: attack_1 = [0]
	attack_1 = []float64{
		0.396584,
		0.426328,
		0.456072,
		0.49573,
		0.525474,
		0.555218,
		0.594876,
		0.634534,
		0.674193,
		0.713851,
		0.75351,
		0.793168,
		0.842741,
		0.892314,
		0.941887,
	}
	// attack: attack_2 = [1]
	attack_2 = []float64{
		0.385192,
		0.414081,
		0.442971,
		0.48149,
		0.510379,
		0.539269,
		0.577788,
		0.616307,
		0.654826,
		0.693346,
		0.731865,
		0.770384,
		0.818533,
		0.866682,
		0.914831,
	}
	// attack: attack_3 = [2]
	attack_3 = []float64{
		0.568888,
		0.611555,
		0.654221,
		0.71111,
		0.753777,
		0.796443,
		0.853332,
		0.910221,
		0.96711,
		1.023998,
		1.080887,
		1.137776,
		1.208887,
		1.279998,
		1.351109,
	}
	// attack: charge = [3]
	charge = []float64{
		1.428948,
		1.53612,
		1.643291,
		1.786185,
		1.893357,
		2.000528,
		2.143423,
		2.286317,
		2.429212,
		2.572107,
		2.715002,
		2.857897,
		3.036515,
		3.215134,
		3.393752,
	}
	// attack: collision = [5]
	collision = []float64{
		0.568288,
		0.614544,
		0.6608,
		0.72688,
		0.773136,
		0.826,
		0.898688,
		0.971376,
		1.044064,
		1.12336,
		1.202656,
		1.281952,
		1.361248,
		1.440544,
		1.51984,
	}
	// attack: highPlunge = [7]
	highPlunge = []float64{
		1.419344,
		1.534872,
		1.6504,
		1.81544,
		1.930968,
		2.063,
		2.244544,
		2.426088,
		2.607632,
		2.80568,
		3.003728,
		3.201776,
		3.399824,
		3.597872,
		3.79592,
	}
	// attack: lowPlunge = [6]
	lowPlunge = []float64{
		1.136335,
		1.228828,
		1.32132,
		1.453452,
		1.545944,
		1.65165,
		1.796995,
		1.94234,
		2.087686,
		2.246244,
		2.404802,
		2.563361,
		2.721919,
		2.880478,
		3.039036,
	}
	// skill: skill = [0 1 2 3]
	skill = [][]float64{
		{
			0.60672,
			0.652224,
			0.697728,
			0.7584,
			0.803904,
			0.849408,
			0.91008,
			0.970752,
			1.031424,
			1.092096,
			1.152768,
			1.21344,
			1.28928,
			1.36512,
			1.44096,
		},
		{
			0.7584,
			0.81528,
			0.87216,
			0.948,
			1.00488,
			1.06176,
			1.1376,
			1.21344,
			1.28928,
			1.36512,
			1.44096,
			1.5168,
			1.6116,
			1.7064,
			1.8012,
		},
		{
			0.948,
			1.0191,
			1.0902,
			1.185,
			1.2561,
			1.3272,
			1.422,
			1.5168,
			1.6116,
			1.7064,
			1.8012,
			1.896,
			2.0145,
			2.133,
			2.2515,
		},
		{
			1.185,
			1.273875,
			1.36275,
			1.48125,
			1.570125,
			1.659,
			1.7775,
			1.896,
			2.0145,
			2.133,
			2.2515,
			2.37,
			2.518125,
			2.66625,
			2.814375,
		},
	}
	// burst: burst = [0 1]
	burst = [][]float64{
		{
			2.6,
			2.795,
			2.99,
			3.25,
			3.445,
			3.64,
			3.9,
			4.16,
			4.42,
			4.68,
			4.94,
			5.2,
			5.525,
			5.85,
			6.175,
		},
		{
			3.33816,
			3.588522,
			3.838884,
			4.1727,
			4.423062,
			4.673424,
			5.00724,
			5.341056,
			5.674872,
			6.008688,
			6.342504,
			6.67632,
			7.09359,
			7.51086,
			7.92813,
		},
	}
)
