// Code generated by "pipeline"; DO NOT EDIT.
package yanfei

import (
	_ "embed"

	"fmt"
	"github.com/genshinsim/gcsim/pkg/core/action"
	"github.com/genshinsim/gcsim/pkg/core/keys"
	"github.com/genshinsim/gcsim/pkg/gcs/validation"
	"github.com/genshinsim/gcsim/pkg/model"
	"google.golang.org/protobuf/encoding/prototext"
	"slices"
)

//go:embed data_gen.textproto
var pbData []byte
var base *model.AvatarData
var paramKeysValidation = map[action.Action][]string{
	3: {"travel"},
	5: {"collision"},
	6: {"collision"},
}

func init() {
	base = &model.AvatarData{}
	err := prototext.Unmarshal(pbData, base)
	if err != nil {
		panic(err)
	}
	validation.RegisterCharParamValidationFunc(keys.Yanfei, ValidateParamKeys)
}

func ValidateParamKeys(a action.Action, keys []string) error {
	valid, ok := paramKeysValidation[a]
	if !ok {
		return nil
	}
	for _, v := range keys {
		if !slices.Contains(valid, v) {
			return fmt.Errorf("key %v is invalid for action %v", v, a.String())
		}
	}
	return nil
}

func (x *char) Data() *model.AvatarData {
	return base
}

var (
	attack = [][]float64{
		attack_1,
		attack_2,
		attack_3,
	}
)

var (
	// attack: attack_1 = [0]
	attack_1 = []float64{
		0.583416,
		0.627172,
		0.670928,
		0.72927,
		0.773026,
		0.816782,
		0.875124,
		0.933466,
		0.991807,
		1.050149,
		1.10849,
		1.166832,
		1.239759,
		1.312686,
		1.385613,
	}
	// attack: attack_2 = [1]
	attack_2 = []float64{
		0.521256,
		0.56035,
		0.599444,
		0.65157,
		0.690664,
		0.729758,
		0.781884,
		0.83401,
		0.886135,
		0.938261,
		0.990386,
		1.042512,
		1.107669,
		1.172826,
		1.237983,
	}
	// attack: attack_3 = [2]
	attack_3 = []float64{
		0.760128,
		0.817138,
		0.874147,
		0.95016,
		1.00717,
		1.064179,
		1.140192,
		1.216205,
		1.292218,
		1.36823,
		1.444243,
		1.520256,
		1.615272,
		1.710288,
		1.805304,
	}
	// attack: charge = [3 4 5 6 7]
	charge = [][]float64{
		{
			0.982294,
			1.041114,
			1.099934,
			1.1764,
			1.23522,
			1.29404,
			1.370506,
			1.446972,
			1.523438,
			1.599904,
			1.67637,
			1.752836,
			1.829302,
			1.905768,
			1.982234,
		},
		{
			1.15564,
			1.22484,
			1.29404,
			1.384,
			1.4532,
			1.5224,
			1.61236,
			1.70232,
			1.79228,
			1.88224,
			1.9722,
			2.06216,
			2.15212,
			2.24208,
			2.33204,
		},
		{
			1.328986,
			1.408566,
			1.488146,
			1.5916,
			1.67118,
			1.75076,
			1.854214,
			1.957668,
			2.061122,
			2.164576,
			2.26803,
			2.371484,
			2.474938,
			2.578392,
			2.681846,
		},
		{
			1.502332,
			1.592292,
			1.682252,
			1.7992,
			1.88916,
			1.97912,
			2.096068,
			2.213016,
			2.329964,
			2.446912,
			2.56386,
			2.680808,
			2.797756,
			2.914704,
			3.031652,
		},
		{
			1.675678,
			1.776018,
			1.876358,
			2.0068,
			2.10714,
			2.20748,
			2.337922,
			2.468364,
			2.598806,
			2.729248,
			2.85969,
			2.990132,
			3.120574,
			3.251016,
			3.381458,
		},
	}
	// attack: collision = [15]
	collision = []float64{
		0.568288,
		0.614544,
		0.6608,
		0.72688,
		0.773136,
		0.826,
		0.898688,
		0.971376,
		1.044064,
		1.12336,
		1.202656,
		1.281952,
		1.361248,
		1.440544,
		1.51984,
	}
	// attack: highPlunge = [17]
	highPlunge = []float64{
		1.419344,
		1.534872,
		1.6504,
		1.81544,
		1.930968,
		2.063,
		2.244544,
		2.426088,
		2.607632,
		2.80568,
		3.003728,
		3.201776,
		3.399824,
		3.597872,
		3.79592,
	}
	// attack: lowPlunge = [16]
	lowPlunge = []float64{
		1.136335,
		1.228828,
		1.32132,
		1.453452,
		1.545944,
		1.65165,
		1.796995,
		1.94234,
		2.087686,
		2.246244,
		2.404802,
		2.563361,
		2.721919,
		2.880478,
		3.039036,
	}
	// skill: skill = [0]
	skill = []float64{
		1.696,
		1.8232,
		1.9504,
		2.12,
		2.2472,
		2.3744,
		2.544,
		2.7136,
		2.8832,
		3.0528,
		3.2224,
		3.392,
		3.604,
		3.816,
		4.028,
	}
	// burst: burst = [0]
	burst = []float64{
		1.824,
		1.9608,
		2.0976,
		2.28,
		2.4168,
		2.5536,
		2.736,
		2.9184,
		3.1008,
		3.2832,
		3.4656,
		3.648,
		3.876,
		4.104,
		4.332,
	}
	// burst: burstBonus = [1]
	burstBonus = []float64{
		0.334,
		0.354,
		0.374,
		0.4,
		0.42,
		0.44,
		0.466,
		0.492,
		0.518,
		0.544,
		0.57,
		0.596,
		0.622,
		0.648,
		0.674,
	}
)
