// Code generated by "pipeline"; DO NOT EDIT.
package zhongli

import (
	_ "embed"

	"fmt"
	"github.com/genshinsim/gcsim/pkg/core/action"
	"github.com/genshinsim/gcsim/pkg/core/keys"
	"github.com/genshinsim/gcsim/pkg/gcs/validation"
	"github.com/genshinsim/gcsim/pkg/model"
	"google.golang.org/protobuf/encoding/prototext"
	"slices"
)

//go:embed data_gen.textproto
var pbData []byte
var base *model.AvatarData
var paramKeysValidation = map[action.Action][]string{
	1: {"hold", "hold_nostele"},
}

func init() {
	base = &model.AvatarData{}
	err := prototext.Unmarshal(pbData, base)
	if err != nil {
		panic(err)
	}
	validation.RegisterCharParamValidationFunc(keys.Zhongli, ValidateParamKeys)
}

func ValidateParamKeys(a action.Action, keys []string) error {
	valid, ok := paramKeysValidation[a]
	if !ok {
		return nil
	}
	for _, v := range keys {
		if !slices.Contains(valid, v) {
			return fmt.Errorf("key %v is invalid for action %v", v, a.String())
		}
	}
	return nil
}

func (x *char) Data() *model.AvatarData {
	return base
}

var (
	attack = [][]float64{
		attack_1,
		attack_2,
		attack_3,
		attack_4,
		attack_5,
		attack_6,
	}
)

var (
	// attack: attack_1 = [0]
	attack_1 = []float64{
		0.307691,
		0.332735,
		0.35778,
		0.393558,
		0.418603,
		0.447225,
		0.486581,
		0.525937,
		0.565292,
		0.608226,
		0.657421,
		0.715274,
		0.773127,
		0.83098,
		0.894092,
	}
	// attack: attack_2 = [1]
	attack_2 = []float64{
		0.311518,
		0.336874,
		0.36223,
		0.398453,
		0.423809,
		0.452788,
		0.492633,
		0.532478,
		0.572323,
		0.615791,
		0.665598,
		0.72417,
		0.782743,
		0.841315,
		0.905213,
	}
	// attack: attack_3 = [2]
	attack_3 = []float64{
		0.385762,
		0.417161,
		0.44856,
		0.493416,
		0.524815,
		0.5607,
		0.610042,
		0.659383,
		0.708725,
		0.762552,
		0.824229,
		0.896761,
		0.969293,
		1.041825,
		1.120951,
	}
	// attack: attack_4 = [3]
	attack_4 = []float64{
		0.429389,
		0.46434,
		0.49929,
		0.549219,
		0.584169,
		0.624113,
		0.679034,
		0.733956,
		0.788878,
		0.848793,
		0.917445,
		0.998181,
		1.078916,
		1.159651,
		1.247726,
	}
	// attack: attack_5 = [4]
	attack_5 = []float64{
		0.1075,
		0.11625,
		0.125,
		0.1375,
		0.14625,
		0.15625,
		0.17,
		0.18375,
		0.1975,
		0.2125,
		0.229687,
		0.2499,
		0.270112,
		0.290325,
		0.312375,
	}
	// attack: attack_6 = [5]
	attack_6 = []float64{
		0.544965,
		0.589322,
		0.63368,
		0.697048,
		0.741406,
		0.7921,
		0.861805,
		0.93151,
		1.001214,
		1.077256,
		1.164387,
		1.266853,
		1.369319,
		1.471785,
		1.583566,
	}
	// attack: charge = [6]
	charge = []float64{
		1.11026,
		1.20063,
		1.291,
		1.4201,
		1.51047,
		1.61375,
		1.75576,
		1.89777,
		2.03978,
		2.1947,
		2.372212,
		2.580967,
		2.789722,
		2.998477,
		3.226209,
	}
	// skill: shieldBase = [4]
	shieldBase = []float64{
		1232.4108,
		1355.6691,
		1489.1987,
		1633,
		1787.0728,
		1951.417,
		2126.033,
		2310.9202,
		2506.079,
		2711.5093,
		2927.2112,
		3153.1846,
		3389.4294,
		3635.946,
		3892.734,
	}
	// skill: shieldPer = [5]
	shieldPer = []float64{
		0.128,
		0.1376,
		0.1472,
		0.16,
		0.1696,
		0.1792,
		0.192,
		0.2048,
		0.2176,
		0.2304,
		0.2432,
		0.256,
		0.272,
		0.288,
		0.304,
	}
	// skill: skill = [0]
	skill = []float64{
		0.16,
		0.172,
		0.184,
		0.2,
		0.212,
		0.224,
		0.24,
		0.256,
		0.272,
		0.288,
		0.304,
		0.32,
		0.34,
		0.36,
		0.38,
	}
	// skill: skillHold = [3]
	skillHold = []float64{
		0.8,
		0.86,
		0.92,
		1,
		1.06,
		1.12,
		1.2,
		1.28,
		1.36,
		1.44,
		1.52,
		1.6,
		1.7,
		1.8,
		1.9,
	}
	// skill: skillTick = [1]
	skillTick = []float64{
		0.32,
		0.344,
		0.368,
		0.4,
		0.424,
		0.448,
		0.48,
		0.512,
		0.544,
		0.576,
		0.608,
		0.64,
		0.68,
		0.72,
		0.76,
	}
	// burst: burst = [0]
	burst = []float64{
		4.0108,
		4.4444,
		4.878,
		5.42,
		5.9078,
		6.3956,
		7.046,
		7.6964,
		8.3468,
		8.9972,
		9.6476,
		10.298,
		10.84,
		11.382,
		11.924,
	}
)
