package character

import (
	"bytes"
	"fmt"
	"go/format"
	"log"
	"os"
	"text/template"
)

type charAssetData struct {
	Data []charAssetMapping
}

type charAssetMapping struct {
	Key      string
	IconName string
}

func (g *Generator) GenerateAssetsKey(dir string) error {
	t, err := template.New("char_asset_tmpl").Parse(charAssetTmpl)
	if err != nil {
		return fmt.Errorf("failed to build template: %w", err)
	}

	var data charAssetData
	for i := range g.chars {
		v := g.chars[i]
		dm, ok := g.data[v.Key]
		if !ok {
			log.Printf("No data found for %v; skipping", v.Key)
			continue
		}
		data.Data = append(data.Data, charAssetMapping{
			Key:      v.Key,
			IconName: dm.IconName,
		})
	}

	buf := new(bytes.Buffer)
	err = t.Execute(buf, data)
	if err != nil {
		return fmt.Errorf("failed to execute character assets template: %w", err)
	}
	src := buf.Bytes()
	dst, err := format.Source(src)
	if err != nil {
		fmt.Println(string(src))
		return fmt.Errorf("failed to gofmt on generated character assets data: %w", err)
	}
	err = os.WriteFile(fmt.Sprintf("%v/avatars_gen.go", dir), dst, 0o644)
	if err != nil {
		return fmt.Errorf("failed to write avatars_gen.go: %w", err)
	}

	return nil
}

const charAssetTmpl = `// Code generated by "pipeline"; DO NOT EDIT.
package assets

var avatarMap = map[string]string{
{{ range $index, $ele := .Data -}}
"{{$ele.Key}}": "{{$ele.IconName}}",
{{ end }}
}
`
