package character

import (
	"bytes"
	"fmt"
	"go/format"
	"os"
	"strings"
	"text/template"
)

type importsData struct {
	Paths []string
}

func (g *Generator) GenerateImports(dir string) error {
	t, err := template.New("char_imports").Parse(importsTmpl)
	if err != nil {
		return fmt.Errorf("failed to build template: %w", err)
	}
	var data importsData

	for i := range g.chars {
		v := g.chars[i]
		data.Paths = append(data.Paths, strings.ReplaceAll(v.RelativePath, string(os.PathSeparator), "/"))
	}

	buf := new(bytes.Buffer)
	err = t.Execute(buf, data)
	if err != nil {
		return fmt.Errorf("failed to execute keys data template: %w", err)
	}
	src := buf.Bytes()
	dst, err := format.Source(src)
	if err != nil {
		fmt.Println(string(src))
		return fmt.Errorf("failed to gofmt on generated keys data: %w", err)
	}
	err = os.WriteFile(fmt.Sprintf("%v/imports_char_gen.go", dir), dst, 0o644)
	if err != nil {
		return fmt.Errorf("failed to write imports_char_gen.go: %w", err)
	}

	return nil
}

const importsTmpl = `// Code generated by "pipeline"; DO NOT EDIT.
package simulation

import (
{{- range $index, $ele := .Paths }}
	_ "github.com/genshinsim/gcsim/{{$ele}}"
{{- end }}
)
`
