package enemy

import (
	"bytes"
	"fmt"
	"go/format"
	"html/template"
	"os"
	"path/filepath"
)

func (g *Generator) GenerateEnemyStats(path string) error {
	t, err := template.New("enemycurves").Parse(tmplEnemyStats)
	if err != nil {
		return fmt.Errorf("failed to build template: %w", err)
	}
	buf := new(bytes.Buffer)
	err = t.Execute(buf, g.data)
	if err != nil {
		return fmt.Errorf("failed to execute template: %w", err)
	}
	src := buf.Bytes()
	dst, err := format.Source(src)
	if err != nil {
		fmt.Println(string(src))
		return fmt.Errorf("failed to gofmt on enemycurves: %w", err)
	}
	return os.WriteFile(filepath.Join(path, "model", "enemy_gen.go"), dst, 0o644)
}

func (g *Generator) GenerateEnemyShortcuts(path string) error {
	t, err := template.New("enemyshortcuts").Parse(tmplShortcuts)
	if err != nil {
		return fmt.Errorf("failed to build template: %w", err)
	}
	buf := new(bytes.Buffer)
	err = t.Execute(buf, g.data)
	if err != nil {
		return fmt.Errorf("failed to execute template: %w", err)
	}
	src := buf.Bytes()
	dst, err := format.Source(src)
	if err != nil {
		fmt.Println(string(src))
		return fmt.Errorf("failed to gofmt on enemyshortcuts: %w", err)
	}
	return os.WriteFile(filepath.Join(path, "shortcut", "enemies_gen.go"), dst, 0o644)
}

const tmplEnemyStats = `// Code generated by "pipeline"; DO NOT EDIT.
package model

var EnemyMap = map[int]*MonsterData{
{{- range .}}
	{{.Id}}: {
		Id: {{.Id}},
		Key: "{{.Key}}",
		NameTextHashMap: {{.NameTextHashMap}},
		BaseStats: &MonsterStatsData{
			BaseHp:  {{.BaseStats.BaseHp}},
			HpCurve: MonsterCurveType_{{.BaseStats.HpCurve}},
			Resist: &MonsterResistData{
				FireResist:     {{.BaseStats.Resist.FireResist}},
				GrassResist:    {{.BaseStats.Resist.GrassResist}},
				WaterResist:    {{.BaseStats.Resist.WaterResist}},
				ElectricResist: {{.BaseStats.Resist.ElectricResist}},
				WindResist:     {{.BaseStats.Resist.WindResist}},
				IceResist:      {{.BaseStats.Resist.IceResist}},
				RockResist:     {{.BaseStats.Resist.RockResist}},
				PhysicalResist: {{.BaseStats.Resist.PhysicalResist}},
			},
			FreezeResist: {{.BaseStats.FreezeResist}},
			HpDrop: []*MonsterHPDrop{
				{{- range .BaseStats.HpDrop}}
				{
					DropId:    {{.DropId}},
					HpPercent: {{.HpPercent}},
				},
				{{- end}}
			},
		},
	},
{{- end}}
}

`

var tmplShortcuts = `package shortcut

var MonsterNameToID = map[string]int{
{{- range $key, $value := .}}
	"{{$value.Key}}": {{$value.Id}},
{{- end}}
}
`
