---
title: Importing Your Own Characters
sidebar_position: 3
---

:::info
If you want to use optimized, non-personalized artifact stats according to the KQM Standard, then please check out [this guide](/guides/substat_optimizer).
:::

You have two options to import your own characters:
- Enka.Network (Enka) - *recommended*
- Genshin Optimizer (GO)

:::info
If you want to update your imported characters for changes you have made ingame or in GO, then import and add them again.
:::

## Enka.Network (Enka)

:::caution
Make sure that your Profile ingame has the desired characters with correct weapons/artifacts on display and that `Show Character Details` is enabled. 
<details>
    <summary>Click here to learn how!</summary>

1. Open the Paimon Menu.

![](char_01.png)

2. Click on the pencil on the top right of your namecard.

![](char_02.png)

3. Click on `Edit Profile`.

![](char_03.png)

4. Check that the `Character Showcase` is showing the desired characters.
5. Check that `Show Character Details` is enabled.

![](char_04.png)

</details>
:::

1. Go the [`Simulator` page on gcsim](https://gcsim.app/simulator). 
2. Click on `Tools` at the bottom.

![](char_05.png)

3. Click on `Import from Enka` in the `Tools` menu. This will open a Dialog.

![](char_06.png)

4. Paste your UID into the text box.

![](char_07.png)

:::tip
You can obtain/copy your UID from ingame.

<details>
    <summary>Click here to learn how!</summary>

1. Open the Paimon Menu.

![](char_01.png)

2. Click in the highlighted area to copy your UID to the clipboard.

![](char_08.png)

</details>
:::

5. Click on the `Fetch` button on the bottom right of the Dialog. 

![](char_09.png)

:::danger
This will overwrite any existing imports for your characters.
:::

## Genshin Optimizer (GO)

:::caution
Make sure the desired characters in GO have the correct character level/talent levels/constellation/artifacts/weapon.
:::

1. Go the [`Simulator` page on gcsim](https://gcsim.app/simulator). 
2. Click on `Tools` at the bottom.

![](char_05.png)

3. Click on `Import from GO` in the `Tools` menu. This will open a Dialog.

![](char_10.png)

4. Go to this [GO page](https://frzyc.github.io/genshin-optimizer/#/setting).
5. Copy your GO Database to the clipboard by clicking on the `Clipboard` button.

![](char_11.png)

7. Go back to the [`Simulator` page on gcsim](https://gcsim.app/simulator).
8. Paste your artifact DB into the text box.

![](char_12.png)

9. Click on the `Load` button on the bottom right of the Dialog.

![](char_13.png)

:::danger
This will overwrite any existing imports for your characters.
:::

## Add Your Own Characters To A Config

0. Import your characters via [Enka](#enkanetwork-enka) or [GO](#genshin-optimizer-go).
1. Go the [`Simulator` page on gcsim](https://gcsim.app/simulator). 

:::tip
To remove a character from the team and open up a slot, click on the ❌ at the top right of the character's card.

![](char_15.png)
:::

2. Click on the ➕ button at the top under the `Team` heading. This requires at least one open slot on the team. 

![](char_14.png)

3. Start typing the name of the desired character into the search bar.

![](char_16.png)

4. Click on the character that says something like `(Imported on ...)` at the end.

![](char_17.png)

Result:

![](char_18.png)

Repeat steps 1-4 for all the characters you want to add.
