import Card from "@site/src/components/Cards/Card";

# gcsim Guides

Get started with gcsim by checking out the following guides:

<div class="container">
    <div class="row">
        <div class="col col--6 padding--lg">
            <Card
                title="Building a Simulation from Scratch"
                text="Here we build a basic simulation of a Raiden team from scratch."
                link="/guides/building_a_simulation_basic_tutorial"
            />
        </div>
        <div class="col col--6 padding--lg">
            <Card
                title="Understanding Config Files"
                text="Learn the basic structure behind a gcsim config file."
                link="/guides/understanding_config_files"
            />
        </div>
    </div>
    <div class="row">
        <div class="col col--6 padding--lg">
            <Card
                title="Importing Your Own Characters"
                text="Learn how to import your own characters from Enka.Network or Genshin Optimizer."
                link="/guides/importing_characters"
            />
        </div>
        <div class="col col--6 padding--lg">
            <Card
                title="Importing From Existing Sim"
                text="Learn how to import from an existing simulation either from the database or from another source."
                link="/guides/importing_from_sim"
            />
        </div>
    </div>
    <div class="row">
        <div class="col col--6 padding--lg">
            <Card
                title="Installing the CLI"
                text="Learn how to install the gcsim CLI for more advanced use cases."
                link="/guides/installation"
            />
        </div>
        <div class="col col--6 padding--lg">
            <Card
                title="Using the CLI"
                text="Learn how to use the gcsim CLI to execute a gcsim config."
                link="/guides/using_cli"
            />
        </div>
    </div>
    <div class="row">
        <div class="col col--6 padding--lg">
            <Card
                title="Optimizing Artifact Substats"
                text='Learn how to use the substat optimizer to produce "optimized" substats under KQM standards.'
                link="/guides/substat_optimizer"
            />
        </div>
        <div class="col col--6 padding--lg">
            <Card
                title="Migrating from v0 to v1"
                text="Learn how to migrate your configs to gcsim v1 coming from gcsim v0."
                link="/guides/migration"
            />
        </div>
    </div>
</div>
