---
title: Optimizing Artifact Substats
sidebar_position: 7
---

## Introduction

:::info
If you want to use personalized artifact stats, then please check out [this guide](/guides/importing_characters) instead.
:::

Substat optimizer mode is a currently **experimental** feature that attempts to optimize your artifact substats given an action list and a few key inputs. 
This can be useful if:

1. You are doing theorycrafting work and want to align your calculations to a given set of standards.
2. You do not have your artifacts available from another source such as Genshin Optimizer and would like to generate some results with reasonable artifact presets.

Currently in practice, we have found the substat optimizer module to be roughly on par or slightly exceeding hand optimizing, and it generates results that yield team DPS within 1-5% of using a sheet to optimize substats instead. 
If you encounter any teams that yield unexpected results, please feel free to reach out to us on our Discord (see top right).

:::info
Note that by default the substat optimizer will assign substats that adhere to the KQM Standard. 
If you would like to use different assumptions, please refer to [this page](/reference/cli#additional-options-for-substat-optimizer--options).
:::

:::info
Due to difficulties in porting this into the website and performance reasons, the substat optimizer is only available via command line. 
:::

## Setup

### Assumptions

:::info
Please refer to [this guide](/guides/installation) for information on how to install the gcsim CLI.
:::

The following descriptions assume:
- Windows as the operating system
- CLI (`gcsim.exe`) and config file (`test.txt`) are in the same folder 
- config file is set up for substat optimization 

The file and folder names are just examples.

### Config

Before using the optimizer, you will need to set up your config. 

:::info
Please refer to the [introductory guide](/guides/building_a_simulation_basic_tutorial) and the [reference section](/reference) for more information on gcsim configs.
:::

:::danger
In order for the substat optimizer to work, you will need to split up the character's `add stats` lines into main stats and substats. 
This is especially relevant when adding stats via Enka Import or the Character Builder.

Example:
```
albedo add stats def%=0.831 def=39.36 hp=5287.88 hp%=0.0992 atk=344.08 atk%=0.0992 er=0.1102 em=39.64 cr=0.642 cd=0.7944 geo%=0.466;
```

This needs to be converted into a main stat and substat line like this that specifies the stats for flower, feather, sands, goblet and circlet:
```
albedo add stats hp=4780 atk=311 def%=0.518 geo%=0.466 cr=0.311; # main
albedo add stats hp%=0.0992 hp=507.88 atk%=0.0992 atk=33.08 def%=0.248 def=39.36 em=39.64 cr=0.331 cd=0.7944 er=0.1102; # subs
```

You can also leave out the substat line and let the substat optimizer generate it.
:::

:::danger
In order for the substat optimizer's ER heuristic to work correctly, it is strongly recommend that things like:
```
if .ayaka.burst.ready {
    ayaka burst;
}
```
are modified to look like
```
if .ayaka.burst.ready && .ayaka.energy == .ayaka.energymax  {
    ayaka burst;
}
```
Note the addition of `&& .ayaka.energy == .ayaka.energymax` to the condition.
:::

## Example

:::info
Please refer to [this guide](/guides/using_cli) for more information on how to use the gcsim CLI.
:::

Open a Powershell window in the folder where `gcsim.exe` and your `test.txt` are located by holding Shift, right clicking in the empty space of the folder and left clicking `Open PowerShell window here`:

![](substat_powershell.png)

In the Powershell window, you can run the following command:
```
./gcsim.exe -c test.txt -s -substatOptimFull
```

This will: 
- overwrite the content of the config file `test.txt` to include optimized substat lines for every character
- run gcsim on the config file 
- open the "local" gcsim viewer page with the result

If you want some details about what the optimizer is doing you can look at the output generated by the command. 
You should see something like this output in Powershell:
```
2024-01-12T22:36:54.328+0100    WARN    warning: Config found to have existing substat information. Ignoring
2024-01-12T22:36:54.329+0100    INFO    Starting ER Optimization...
2024-01-12T22:36:55.708+0100    INFO    Initial Calculated ER Liquid Substats by character:
2024-01-12T22:36:55.708+0100    INFO    yelan: 0.0551, xingqiu: 0, raiden: 0.4408, nahida: 0, 
2024-01-12T22:36:55.708+0100    INFO    Calculating optimal DMG substat distribution...
2024-01-12T22:37:15.158+0100    INFO    yelan
2024-01-12T22:37:15.158+0100    INFO    Liquid Substat Counts: hp%: 1 er: 1 cr: 10 cd: 8
2024-01-12T22:37:15.158+0100    INFO    xingqiu
2024-01-12T22:37:15.158+0100    INFO    Liquid Substat Counts: atk%: 2 cr: 8 cd: 10
2024-01-12T22:37:15.158+0100    INFO    raiden
2024-01-12T22:37:15.158+0100    INFO    Liquid Substat Counts: er: 8 em: 4 cr: 7 cd: 1
2024-01-12T22:37:15.158+0100    INFO    nahida
2024-01-12T22:37:15.158+0100    INFO    Liquid Substat Counts: em: 2 cr: 8 cd: 10
2024-01-12T22:37:15.158+0100    INFO    Fine tuning optimal ER vs DMG substat distribution...
2024-01-12T22:37:24.411+0100    INFO    yelan
2024-01-12T22:37:24.411+0100    INFO    Final Liquid Substat Counts: hp%: 1 er: 1 cr: 10 cd: 8
2024-01-12T22:37:24.411+0100    INFO    xingqiu
2024-01-12T22:37:24.411+0100    INFO    Final Liquid Substat Counts: atk%: 2 cr: 8 cd: 10
2024-01-12T22:37:24.411+0100    INFO    raiden
2024-01-12T22:37:24.411+0100    INFO    Final Liquid Substat Counts: er: 9 em: 4 cr: 7
2024-01-12T22:37:24.411+0100    INFO    nahida
2024-01-12T22:37:24.411+0100    INFO    Final Liquid Substat Counts: em: 2 cr: 8 cd: 10
2024-01-12T22:37:24.411+0100    INFO    Final config substat strings:
yelan add stats def%=0.124 def=39.36 hp=507.88 hp%=0.1488 atk=33.08 atk%=0.0992 er=0.1653 em=39.64 cr=0.3972 cd=0.662;
xingqiu add stats def%=0.124 def=39.36 hp=507.88 hp%=0.0992 atk=33.08 atk%=0.1984 er=0.1102 em=39.64 cr=0.331 cd=0.7944;
raiden add stats def%=0.124 def=39.36 hp=507.88 hp%=0.0992 atk=33.08 atk%=0.0992 er=0.6061 em=118.92 cr=0.2979 cd=0.1324;
nahida add stats def%=0.124 def=39.36 hp=507.88 hp%=0.0992 atk=33.08 atk%=0.0992 er=0.1102 em=79.28 cr=0.331 cd=0.7944;
2024-01-12T22:37:24.412+0100    INFO    Saved to the following location: opt.txt
Average duration of 91.58 seconds (min: 91.37 max: 100.37 std: 0.73)
Average 6788382.24 damage over 91.58 seconds, resulting in 74133 dps (min: 63141.41 max: 75805.02 std: 1241.52) 
Simulation completed 1000 iterations          
```

## Things To Consider

:::danger
Do not blindly trust the results and make sure to look at the summary stats and Sample tab to make sure that the team is performing as you would expect.
:::

:::tip
You do not have to remove existing substat `add stats` lines from your config.
The substat optimizer will automatically ignore and replace those lines.
:::

:::tip
The substat optimizer does not take very long to run (depending on the machine), but it will likely use a high amount of CPU during that time.
If you want to run it a bit more slowly and use fewer CPU cores, then you can change the `workers` number in the `options` line of the config. 
See the [config page in the reference section](/reference/config) for more information.
:::

:::tip
If you wish to rerun an optimized config after tweaking some of the substats in the config, simply run the command with the `-substatOptimFull` flag removed.
:::

:::info
The fine-tune step of the substat optimizer can be disabled for faster execution time but less accurate substat distribution by running it with `-options="fine_tune=0"`.
Please refer to [this page](/reference/cli#additional-options-for-substat-optimizer--options) for more information.
:::

:::info
The substat optimizer optimizes all stats for the characters which also includes ER requirements, so there is no need to use an ER calculator.
It usually generates conservative ER requirements that are higher than what an ER calculator sheet might suggest.

This is due to gcsim:
- having much more detailed energy mechanics than what can reasonably be modelled in an ER calculator
- modelling the actual particle rng (example: Fischl Oz) by running the config for many times.
:::

## Verbose Output
In the [Example](#example) above, if you also add the flag for verbose output:
```
./gcsim.exe -c test.txt -s -substatOptimFull -v
```

The substat optimizer will print additional information as it is running. You should see something like this in PowerShell:
```
2024-02-01T09:43:02.573-0700    WARN    warning: Config found to have existing substat information. Ignoring
2024-02-01T09:43:02.575-0700    WARN    Warning: 4* artifact set detected. Optimizer currently assumes that ER substats take 5* values, and all other substats take 4* values.
2024-02-01T09:43:02.575-0700    INFO    Starting ER Optimization...
2024-02-01T09:43:03.011-0700    INFO    Alhaitham: ER Needed Distribution
2024-02-01T09:43:03.011-0700    INFO     100-105  |████████████████████████████████████████████
2024-02-01T09:43:03.011-0700    INFO    Bennett: ER Needed Distribution
2024-02-01T09:43:03.011-0700    INFO     170-175  |██
2024-02-01T09:43:03.011-0700    INFO     175-180  |███████
2024-02-01T09:43:03.011-0700    INFO     180-185  |██████
2024-02-01T09:43:03.011-0700    INFO     185-190  |█████████████
2024-02-01T09:43:03.011-0700    INFO     190-195  |███████
2024-02-01T09:43:03.011-0700    INFO     195-200  |██████
2024-02-01T09:43:03.011-0700    INFO    Fischl: ER Needed Distribution
2024-02-01T09:43:03.011-0700    INFO     115-120  |████
2024-02-01T09:43:03.011-0700    INFO     120-125  |████████
2024-02-01T09:43:03.011-0700    INFO     125-130  |█████████
2024-02-01T09:43:03.011-0700    INFO     130-135  |███████
2024-02-01T09:43:03.012-0700    INFO     135-140  |█████
2024-02-01T09:43:03.012-0700    INFO     140-145  |█████
2024-02-01T09:43:03.012-0700    INFO     145-150  |██
2024-02-01T09:43:03.012-0700    INFO     150-155  |█
2024-02-01T09:43:03.012-0700    INFO    Nahida: ER Needed Distribution
2024-02-01T09:43:03.012-0700    INFO     100-105  |█████████████████
2024-02-01T09:43:03.012-0700    INFO     105-110  |████████████████
2024-02-01T09:43:03.012-0700    INFO     110-115  |████████
2024-02-01T09:43:03.012-0700    INFO     115-120  |██
2024-02-01T09:43:03.012-0700    INFO    Initial Calculated ER Liquid Substats by character:
2024-02-01T09:43:03.012-0700    INFO    alhaitham: 0, bennett: 0, fischl: 0.2755, nahida: 0,
2024-02-01T09:43:03.012-0700    INFO    Calculating optimal DMG substat distribution...
2024-02-01T09:43:03.012-0700    DEBUG   Alhaitham
2024-02-01T09:43:03.188-0700    DEBUG   Liquid Substat Counts: atk%: 5 em: 8 cr: 8 cd: 10
2024-02-01T09:43:03.364-0700    DEBUG   Liquid Substat Counts: em: 8 cr: 8 cd: 10
2024-02-01T09:43:03.557-0700    DEBUG   Liquid Substat Counts: em: 6 cr: 8 cd: 10
2024-02-01T09:43:03.727-0700    DEBUG   Liquid Substat Counts: em: 4 cr: 8 cd: 10
2024-02-01T09:43:03.896-0700    DEBUG   Liquid Substat Counts: em: 3 cr: 8 cd: 10
2024-02-01T09:43:04.066-0700    DEBUG   Liquid Substat Counts: em: 2 cr: 8 cd: 10
2024-02-01T09:43:04.066-0700    DEBUG   Bennett
2024-02-01T09:43:04.239-0700    DEBUG   Liquid Substat Counts: atk%: 5 em: 10 cr: 8 cd: 10
2024-02-01T09:43:04.410-0700    DEBUG   Liquid Substat Counts: atk%: 5 em: 10 cr: 3 cd: 10
2024-02-01T09:43:04.591-0700    DEBUG   Liquid Substat Counts: atk%: 5 em: 10 cr: 3 cd: 5
2024-02-01T09:43:04.767-0700    DEBUG   Liquid Substat Counts: atk%: 4 em: 10 cr: 3 cd: 5
2024-02-01T09:43:04.936-0700    DEBUG   Liquid Substat Counts: atk%: 4 em: 9 cr: 3 cd: 5
2024-02-01T09:43:05.106-0700    DEBUG   Liquid Substat Counts: atk%: 4 em: 9 cr: 2 cd: 5
2024-02-01T09:43:05.106-0700    DEBUG   Fischl
2024-02-01T09:43:05.278-0700    DEBUG   Liquid Substat Counts: atk%: 8 er: 5 em: 5 cr: 8 cd: 10
2024-02-01T09:43:05.453-0700    DEBUG   Liquid Substat Counts: atk%: 8 er: 5 cr: 8 cd: 10
2024-02-01T09:43:05.629-0700    DEBUG   Liquid Substat Counts: atk%: 3 er: 5 cr: 8 cd: 10
2024-02-01T09:43:05.812-0700    DEBUG   Liquid Substat Counts: atk%: 1 er: 5 cr: 8 cd: 10
2024-02-01T09:43:05.988-0700    DEBUG   Liquid Substat Counts: er: 5 cr: 8 cd: 10
2024-02-01T09:43:06.165-0700    DEBUG   Liquid Substat Counts: er: 5 cr: 7 cd: 10
2024-02-01T09:43:06.338-0700    DEBUG   Liquid Substat Counts: er: 5 cr: 6 cd: 10
2024-02-01T09:43:06.506-0700    DEBUG   Liquid Substat Counts: er: 5 cr: 5 cd: 10
2024-02-01T09:43:06.507-0700    DEBUG   Nahida
2024-02-01T09:43:06.679-0700    DEBUG   Liquid Substat Counts: atk%: 5 em: 6 cr: 8 cd: 10
2024-02-01T09:43:06.850-0700    DEBUG   Liquid Substat Counts: em: 6 cr: 8 cd: 10
2024-02-01T09:43:07.019-0700    DEBUG   Liquid Substat Counts: em: 6 cr: 6 cd: 10
2024-02-01T09:43:07.190-0700    DEBUG   Liquid Substat Counts: em: 5 cr: 6 cd: 10
2024-02-01T09:43:07.361-0700    DEBUG   Liquid Substat Counts: em: 5 cr: 5 cd: 10
2024-02-01T09:43:07.361-0700    INFO    alhaitham
2024-02-01T09:43:07.361-0700    INFO    Liquid Substat Counts: em: 2 cr: 8 cd: 10
2024-02-01T09:43:07.362-0700    INFO    bennett
2024-02-01T09:43:07.362-0700    INFO    Liquid Substat Counts: atk%: 4 em: 9 cr: 2 cd: 5
2024-02-01T09:43:07.362-0700    INFO    fischl
2024-02-01T09:43:07.362-0700    INFO    Liquid Substat Counts: er: 5 cr: 5 cd: 10
2024-02-01T09:43:07.362-0700    INFO    nahida
2024-02-01T09:43:07.362-0700    INFO    Liquid Substat Counts: em: 5 cr: 5 cd: 10
2024-02-01T09:43:07.362-0700    INFO    Fine tuning optimal ER vs DMG substat distribution...
2024-02-01T09:43:09.470-0700    INFO    alhaitham
2024-02-01T09:43:09.470-0700    INFO    Final Liquid Substat Counts: em: 2 cr: 8 cd: 10
2024-02-01T09:43:09.470-0700    INFO    bennett
2024-02-01T09:43:09.470-0700    INFO    Final Liquid Substat Counts: atk%: 4 em: 9 cr: 2 cd: 5
2024-02-01T09:43:09.470-0700    INFO    fischl
2024-02-01T09:43:09.470-0700    INFO    Final Liquid Substat Counts: er: 4 cr: 6 cd: 10
2024-02-01T09:43:09.470-0700    INFO    nahida
2024-02-01T09:43:09.470-0700    INFO    Final Liquid Substat Counts: em: 5 cr: 5 cd: 10
2024-02-01T09:43:09.470-0700    INFO    Final config substat strings:
alhaitham add stats def%=0.124 def=39.36 hp=507.88 hp%=0.0992 atk=33.08 atk%=0.0992 er=0.1102 em=79.28 cr=0.331 cd=0.7944;
bennett add stats def%=0.124 def=39.36 hp=507.88 hp%=0.0992 atk=33.08 atk%=0.2976 er=0.1102 em=218.02 cr=0.1324 cd=0.4634;
fischl add stats def%=0.124 def=39.36 hp=507.88 hp%=0.0992 atk=33.08 atk%=0.0992 er=0.3306 em=39.64 cr=0.2648 cd=0.7944;
nahida add stats def%=0.124 def=39.36 hp=507.88 hp%=0.0992 atk=33.08 atk%=0.0992 er=0.1102 em=138.74 cr=0.2317 cd=0.7944;
2024-02-01T09:43:09.471-0700    INFO    Saved to the following location: .\test.txt
Average duration of 101.21 seconds (min: 100.85 max: 114.57 std: 0.53)
Average 7215548.82 damage over 101.21 seconds, resulting in 71292 dps (min: 59069.69 max: 76743.87 std: 1845.95)
Simulation completed 1000 iterations   
```

Note the additional ER graphs showing how the ER req is distributed for each character, and the progress of the substat [gradient descent](https://en.wikipedia.org/wiki/Gradient_descent).
