type Props = {
  className?: string;
};

export function IconAtk(props: Props) {
  return (
    <svg className={props.className} viewBox="0 0 14 13.977">
      <path d="M7.78,1.621,9.423,3.264l1.928-1.927L11.326.219A.228.228,0,0,1,11.554,0h2.2a.228.228,0,0,1,.228.228c-.121,2.661.556,2.457-1.337,2.4L10.712,4.553,12.356,6.2a.228.228,0,0,1,0,.322c-1.167,1.208-.775.907-1.892-.106L3.313,13.564A.457.457,0,0,1,3,13.7a21.32,21.32,0,0,1-2.954.239,21.172,21.172,0,0,1,.238-2.954.451.451,0,0,1,.134-.318L7.564,3.513l-.838-.838a.229.229,0,0,1,0-.323l.732-.731A.228.228,0,0,1,7.78,1.621Z" />
    </svg>
  );
}

export function IconCD(props: Props) {
  return (
    <svg className={props.className} viewBox="0 0 480 512">
      <path d="M106.75 215.06L1.2 370.95c-3.08 5 .1 11.5 5.93 12.14l208.26 22.07-108.64-190.1zM7.41 315.43L82.7 193.08 6.06 147.1c-2.67-1.6-6.06.32-6.06 3.43v162.81c0 4.03 5.29 5.53 7.41 2.09zM18.25 423.6l194.4 87.66c5.3 2.45 11.35-1.43 11.35-7.26v-65.67l-203.55-22.3c-4.45-.5-6.23 5.59-2.2 7.57zm81.22-257.78L179.4 22.88c4.34-7.06-3.59-15.25-10.78-11.14L17.81 110.35c-2.47 1.62-2.39 5.26.13 6.78l81.53 48.69zM240 176h109.21L253.63 7.62C250.5 2.54 245.25 0 240 0s-10.5 2.54-13.63 7.62L130.79 176H240zm233.94-28.9l-76.64 45.99 75.29 122.35c2.11 3.44 7.41 1.94 7.41-2.1V150.53c0-3.11-3.39-5.03-6.06-3.43zm-93.41 18.72l81.53-48.7c2.53-1.52 2.6-5.16.13-6.78l-150.81-98.6c-7.19-4.11-15.12 4.08-10.78 11.14l79.93 142.94zm79.02 250.21L256 438.32v65.67c0 5.84 6.05 9.71 11.35 7.26l194.4-87.66c4.03-1.97 2.25-8.06-2.2-7.56zm-86.3-200.97l-108.63 190.1 208.26-22.07c5.83-.65 9.01-7.14 5.93-12.14L373.25 215.06zM240 208H139.57L240 383.75 340.43 208H240z" />
    </svg>
  );
}

export function IconCR(props: Props) {
  return (
    <svg className={props.className} viewBox="0 0 14 14">
      <path d="M0,14,3.5,6.236,1.973,1.464,7.255,3.5,14,0,10.5,7.255l1.527,4.772L7.255,10.5,0,14" />
    </svg>
  );
}

export function IconDef(props: Props) {
  return (
    <svg className={props.className} viewBox="0 0 12.883 14">
      <path d="M12.883.726a.291.291,0,0,0-.175-.268C12.3.286,10.944,0,6.442,0S.584.286.176.458A.291.291,0,0,0,0,.727v7.44a.868.868,0,0,0,.125.453c1.579,2.6,5.347,4.855,6.161,5.339a.292.292,0,0,0,.3,0c.789-.482,4.559-2.688,6.168-5.335a.868.868,0,0,0,.127-.455ZM6.441,11.968C6.5,11.981,2.882,9.951,1.617,7.6V1.565s0-.452,4.824-.452Z" />
    </svg>
  );
}

export function IconEM(props: Props) {
  return (
    <svg className={props.className} viewBox="0 0 14 13.113">
      <path d="M8.076,7.71l-.017-.049A4.335,4.335,0,0,0,7.3,6.353a4.431,4.431,0,0,0-.325-.346A2.113,2.113,0,1,0,7,1.781a2.144,2.144,0,0,0-1.838,3.18,4.374,4.374,0,0,0-1.2-.168,4.42,4.42,0,0,0-.755.066l-.038.007C1.836-.682,10.7-2.114,10.962,3.9A3.985,3.985,0,0,1,8.076,7.71Zm3.662-2.137a3.949,3.949,0,0,0-.626-.235,4.473,4.473,0,0,1-1.105,1.7h.031A2.113,2.113,0,1,1,7.925,9.151,4.09,4.09,0,0,0,7.9,8.706,3.968,3.968,0,0,0,6.037,5.775l-.19-.11A3.963,3.963,0,1,0,6.492,12.2c.082-.068.16-.14.236-.214L6.7,11.949a4.367,4.367,0,0,1-.891-1.765A2.112,2.112,0,1,1,4.926,7.27q.1.051.189.111a2.111,2.111,0,0,1,.942,1.49,2.159,2.159,0,0,1,.018.28,3.963,3.963,0,1,0,5.663-3.578Z" />
    </svg>
  );
}

export function IconER(props: Props) {
  // <svg className={props.className} viewBox="0 0 14 13.282">
  //   <path d="M14,6.641A6.642,6.642,0,0,1,.928,8.3h0L0,8.737.961,4.8l.012.012L2.392,6.3l1.37,1.433-1.23.143A4.981,4.981,0,1,0,7.359,1.66V0A6.641,6.641,0,0,1,14,6.641Z" />
  // </svg>
  return (
    <span className={props.className + " w-4 h-4 relative inline-block"}>
      <svg
        className=" origin-center absolute top-0 bottom-0 left-0 right-0"
        viewBox="0 0 14 13.282"
      >
        <path d="M14,6.641A6.642,6.642,0,0,1,.928,8.3h0L0,8.737.961,4.8l.012.012L2.392,6.3l1.37,1.433-1.23.143A4.981,4.981,0,1,0,7.359,1.66V0A6.641,6.641,0,0,1,14,6.641Z"></path>
      </svg>
      <svg
        className=" origin-center absolute top-0 bottom-0 left-0 right-0 fill-gray-400"
        viewBox="0 0 14 13.282"
      >
        <path d="M2.392,6.3.973,4.813A6.643,6.643,0,0,1,7.359,0V1.66A4.98,4.98,0,0,0,2.392,6.3Z"></path>
      </svg>
    </span>
  );
}

export function IconHP(props: Props) {
  return (
    <svg className={props.className} viewBox="0 0 11.104 14">
      <path d="M2.052,7.654A.978.978,0,0,1,2.5,7.083c1.511-.85,3.586,2.117,6.544.548C10.971,13.714.151,13.878,2.052,7.654ZM5.552,14C2.177,14-1.2,11.579.416,6.74A18.543,18.543,0,0,1,5.121.213.748.748,0,0,1,5.552,0a.751.751,0,0,1,.431.212A18.543,18.543,0,0,1,10.688,6.74C12.3,11.579,8.927,14,5.552,14Zm.22-12.19a.639.639,0,0,0-.22-.075h0a.649.649,0,0,0-.221.075c-1.71,1.324-4.08,5.282-3.941,7.4a4.019,4.019,0,0,0,4.162,3.543h0A4.019,4.019,0,0,0,9.714,9.215C9.853,7.092,7.483,3.134,5.772,1.81Z" />
    </svg>
  );
}

export function IconPercent(props: Props) {
  return (
    <svg className={props.className} viewBox="0 0 384 512">
      <path d="M374.6 73.39c-12.5-12.5-32.75-12.5-45.25 0l-320 320c-12.5 12.5-12.5 32.75 0 45.25C15.63 444.9 23.81 448 32 448s16.38-3.125 22.62-9.375l320-320C387.1 106.1 387.1 85.89 374.6 73.39zM64 192c35.3 0 64-28.72 64-64S99.3 64.01 64 64.01S0 92.73 0 128S28.7 192 64 192zM320 320c-35.3 0-64 28.72-64 64s28.7 64 64 64s64-28.72 64-64S355.3 320 320 320z" />
    </svg>
  );
}

export function IconPhysical(props: Props) {
  return (
    <svg className={props.className} viewBox="0 0 14 13.962">
      <path
        fill="currentColor"
        d="M11.511,7.88,9.022,9.54v1.77l2.489-1.66L14,11.31V9.54Zm0,2.434-2.489,1.66v1.771l2.489-1.66L14,13.745V11.974ZM7.45,1.619l-.731.731a.228.228,0,0,0,0,.322l.837.837L.412,10.652a.458.458,0,0,0-.133.318A21.292,21.292,0,0,0,.04,13.922a21.435,21.435,0,0,0,2.952-.239.458.458,0,0,0,.318-.133l7.143-7.144c1.116,1.012.725,1.313,1.89.106a.228.228,0,0,0,0-.322L10.7,4.549l1.926-1.926c1.89.06,1.215.263,1.335-2.395A.228.228,0,0,0,13.734,0H11.542a.228.228,0,0,0-.228.219l.025,1.116L9.413,3.261,7.772,1.619A.228.228,0,0,0,7.45,1.619Z"
      ></path>
    </svg>
  );
}

export function IconAnemo(props: Props) {
  return (
    <svg className={props.className} viewBox="0 0 14 13.857">
      <path
        fill="currentColor"
        d="M.2,4.834c.764,1.2,1.813,2.475,3.362,2.434,1.025-.067,2.374.224,2.679,1.359.313.865-.825,1.982-1.513,1.124-.108-.187-.039-.3.173-.326,1,.021,1.348-1.12.4-1.513-.813-.1-1.548.527-2.329.707C.791,9.247-.524,6.656.2,4.834Zm9.912,2.429c-1.056-.074-2.449.563-2.375,1.786a.973.973,0,0,0,1.1.984c.316.013.724-.546.294-.612-1.621,0-1.022-2.1.346-1.4a5.222,5.222,0,0,0,2.343.687c1.8-.177,2.572-2.3,1.989-3.859C12.938,6.152,11.852,7.446,10.112,7.263Zm-2.42-.772A7.516,7.516,0,0,0,9.918,5.63,3.067,3.067,0,0,0,9.286.018,5.143,5.143,0,0,1,7.692,6.491ZM6.349,6.477A5.071,5.071,0,0,1,4.734,0,3.075,3.075,0,0,0,3.612,5.287a7.944,7.944,0,0,0,2.7,1.235Zm5.342-.089c-1.143.656-2.594.363-3.651,1.217a1.557,1.557,0,0,0,.07,2.768c.234.1.462.206.689.014.223-.167.4-.162.721-.012a9.094,9.094,0,0,0-2.513,3.482,9.217,9.217,0,0,0-2.523-3.478.605.605,0,0,1,.726,0c.6.347,1.443-.4,1.555-1C7.012,8.2,5.829,7.273,4.783,7.049c-.512-.121-1.038-.182-1.55-.3C.866,6.266.51,3.868,1.669,2.034c.668,4.9,4,3.555,5.332,6.26,1.321-2.671,4.678-1.382,5.345-6.261C13.157,3.449,13.4,5.556,11.691,6.388Zm-4.12,5.191L7,11.2l-.572.385.58.972ZM7,10.066a1.592,1.592,0,0,1-1,.911.925.925,0,0,0,.991-.272c.426.327.794.417,1.046.255A1.561,1.561,0,0,1,7,10.066Z"
      ></path>
    </svg>
  );
}

export function IconGeo(props: Props) {
  return (
    <svg className={props.className} viewBox="0 0 13.029 14">
      <path
        fill="currentColor"
        d="M6.633,6.009c-.5.538-.953,1.041-1.42,1.537a.23.23,0,0,0-.061.286A4.5,4.5,0,0,0,6.507,9.551a.181.181,0,0,0,.164-.009c.388-.257.785-.5,1.151-.788A16.081,16.081,0,0,0,9.963,6.761c.181.366.382.7.518,1.063.2.535.356,1.088.535,1.632a.293.293,0,0,1-.061.286,12.277,12.277,0,0,1-1.768,1.985c-.839.755-1.714,1.47-2.574,2.2A1.2,1.2,0,0,1,6.505,14c-.5-.411-1.02-.817-1.519-1.243A29.249,29.249,0,0,1,2.138,9.983,16.778,16.778,0,0,1,.043,7.137a.245.245,0,0,1,0-.279A10.138,10.138,0,0,1,1.389,5.1a25.247,25.247,0,0,0,5.158,8.241,12.37,12.37,0,0,0,2.98-4.617l-.036-.03L6.558,11.157c-.04-.032-.081-.061-.117-.1A13.544,13.544,0,0,1,3.879,7.693a.249.249,0,0,1,.051-.356c.5-.442,1-.89,1.5-1.325.226-.194.473-.365.736-.566Zm.228,2.545c.263-.2.51-.372.736-.566.506-.435,1-.883,1.5-1.325a.251.251,0,0,0,.051-.356A13.523,13.523,0,0,0,6.588,2.938c-.036-.034-.077-.063-.116-.1L3.539,5.306,3.5,5.276A12.345,12.345,0,0,1,6.483.659,25.245,25.245,0,0,1,11.64,8.9a10.138,10.138,0,0,0,1.345-1.758.244.244,0,0,0,0-.279,16.724,16.724,0,0,0-2.1-2.846A29.136,29.136,0,0,0,8.043,1.243C7.545.817,7.028.411,6.524,0c-.05.033-.082.049-.108.071-.86.732-1.734,1.447-2.573,2.2A12.23,12.23,0,0,0,2.075,4.258a.293.293,0,0,0-.062.286c.179.544.334,1.1.536,1.632.136.361.336.7.517,1.063A16.2,16.2,0,0,1,5.207,5.246c.366-.285.764-.531,1.151-.788a.181.181,0,0,1,.164-.009A4.5,4.5,0,0,1,7.877,6.168a.231.231,0,0,1-.06.286c-.468.5-.926,1-1.421,1.537Z"
      ></path>
    </svg>
  );
}
export function IconElectro(props: Props) {
  return (
    <svg className={props.className} viewBox="0 0 14 13.996">
      <path
        fill="currentColor"
        d="M4.533,13.505a6.911,6.911,0,0,0,3.024-.468c-.237-.073-.459-.134-.675-.209s-.432-.159-.643-.252A3.907,3.907,0,0,1,4,10.333a3.449,3.449,0,0,1-.128-1.82c.117.139.222.277.341.4a1.044,1.044,0,0,0,1.01.32A1.571,1.571,0,0,0,6.5,7.879a2.422,2.422,0,0,0-2.083-2.8A2.993,2.993,0,0,0,1.2,7.231,7.083,7.083,0,0,0,.874,9.417c-.005.309,0,.618,0,.9A7.089,7.089,0,0,1,.012,6.581,6.949,6.949,0,0,1,2.691,1.5c-.26.472-.519.917-.752,1.374a3.664,3.664,0,0,0-.412,1.521c.207-.193.385-.361.566-.524A4.657,4.657,0,0,1,4.248,2.71,3.573,3.573,0,0,1,7.323,3.5l-.442.09A1.213,1.213,0,0,0,6,5.283,2.008,2.008,0,0,0,7.719,6.624a2.575,2.575,0,0,0,2.873-2.561,3.33,3.33,0,0,0-1.1-2.508A7.781,7.781,0,0,0,7.289.09C7.237.066,7.185.039,7.108,0A7,7,0,0,1,14,5.915c-.282-.45-.544-.9-.836-1.328A3.743,3.743,0,0,0,12.055,3.5c.079.371.171.721.226,1.077a4.086,4.086,0,0,1-.792,3.364A3.554,3.554,0,0,1,9.98,8.958a.115.115,0,0,1-.049,0c.062-.2.134-.389.184-.587A1.091,1.091,0,0,0,9.59,7.135a1.68,1.68,0,0,0-1.765-.046A2.357,2.357,0,0,0,6.657,10.05a2.745,2.745,0,0,0,2.377,1.878,4.373,4.373,0,0,0,2.462-.5c.465-.215.9-.5,1.344-.759.056-.032.108-.071.18-.119A6.922,6.922,0,0,1,4.533,13.505Z"
      ></path>
    </svg>
  );
}
export function IconHydro(props: Props) {
  return (
    <svg className={props.className} viewBox="0 0 14 13.95">
      <path
        fill="currentColor"
        d="M2.922,12.219c.108.055.181.092.253.13a7.943,7.943,0,0,0,3.891.963,3.753,3.753,0,0,0,.486-7.464,3.6,3.6,0,0,0-1.691.132.938.938,0,0,1-.716-1.732,4.3,4.3,0,0,1,1.481-.366,4.912,4.912,0,0,1,5.048,3.446,4.933,4.933,0,0,1-2.517,5.764c4.218-1.543,4.723-7.809.812-10.017a5.342,5.342,0,0,0-3.437-.829A5.506,5.506,0,0,0,2.883,4.021a6.606,6.606,0,0,0-.417.524.873.873,0,0,1-.927.337.929.929,0,0,1-.781-.638.881.881,0,0,1,.1-.684A6.158,6.158,0,0,1,2.221,1.839,7.091,7.091,0,0,1,6.135.055a6.933,6.933,0,0,1,6.848,3.359c2.683,4.1-.263,9.987-5.094,10.472a6.838,6.838,0,0,1-3.241-.343A3.994,3.994,0,0,1,2.922,12.219ZM8.438,12.1a2.044,2.044,0,0,1-2.35.064,1.5,1.5,0,0,1-.007-2.613.949.949,0,0,1,1.433.505c.77,2.06,2.637.147,1.424-1.246a2.385,2.385,0,0,0-2.17-.95,2.486,2.486,0,1,0,.784,4.891A2.393,2.393,0,0,0,9.073,11.6C8.862,11.766,8.663,11.951,8.438,12.1ZM2.21,9.495a.663.663,0,1,0,.663.663A.663.663,0,0,0,2.21,9.495ZM.958,6.107a.958.958,0,1,0,.957.957A.958.958,0,0,0,.958,6.107Z"
      ></path>
    </svg>
  );
}
export function IconPyro(props: Props) {
  return (
    <svg className={props.className} viewBox="0 0 11.479 14">
      <path
        fill="currentColor"
        d="M5.853,14C4.311,12.53,2.374,11.75.692,10.523c-1.471-1.1-.268-3.047.586-4.163A17.969,17.969,0,0,0,3.031,3.838c-.007,1.6,1.56,2.152,2.781,2.709C3.509,6.412,1.548,9.1,3.385,10.92c-1.873-.773-2.7-2.455-1.3-4.17a2.113,2.113,0,0,0-.535,3.662c1.332.9,2.865,1.483,4.153,2.461a.2.2,0,0,0,.187.019C7.13,12,8.5,11.315,9.811,10.543c1.654-.887,1.47-2.773-.154-3.583,1.455,2.82-1.213,4.942-3.9,4.745C2.832,11.491,2.676,8.531,5.131,9a1.39,1.39,0,0,0-.682,1.5c.526,1.495,2.954.974,3.81.031,1.095-1.027.327-3.031-.979-3.6-1.492-.7-4.443-1.527-3.3-3.737C4.676,2.109,5.49,1.385,5.617,0,6.05.581,7.06,1.719,6.857,2.452c-.24.72-1.085.982-1.348,1.71a1.334,1.334,0,0,0,.578,1.824c-1.018-1.09.09-2.409,1.15-2.981A3.3,3.3,0,0,0,8.373,7.061c-.725-1.6-1.347-1.64-.128-3.408a4.575,4.575,0,0,0,1.806,2.766c2.057,1.807,1.9,3.731-.521,5.067A16.689,16.689,0,0,0,5.853,14Zm.541-3.5C10.185,9.076,5.44,5.335,4.03,8.493,5.446,7.684,7.387,8.92,6.394,10.5Z"
      ></path>{" "}
    </svg>
  );
}

export function IconCryo(props: Props) {
  return (
    <svg className={props.className} viewBox="0 0 12.086 14">
      <path
        fill="currentColor"
        d="M0,3.52A19.776,19.776,0,0,1,1.911,6.8a6.152,6.152,0,0,0,.128-.624A6.476,6.476,0,0,1,5.5,6.7,6.479,6.479,0,0,1,3.316,3.96a6.308,6.308,0,0,0,.477-.423A19.8,19.8,0,0,1,0,3.52ZM4.411,6.067a7.469,7.469,0,0,0-2.4-.573,3.548,3.548,0,0,0-.2-.933h0a3.559,3.559,0,0,0,.909-.289A7.478,7.478,0,0,0,4.411,6.067ZM0,10.48A19.776,19.776,0,0,0,1.911,7.2a6.152,6.152,0,0,1,.128.624A6.476,6.476,0,0,0,5.5,7.3,6.479,6.479,0,0,0,3.316,10.04a6.308,6.308,0,0,1,.477.423A19.8,19.8,0,0,0,0,10.48ZM4.411,7.933a7.469,7.469,0,0,1-2.4.573,3.548,3.548,0,0,1-.2.933h0a3.559,3.559,0,0,1,.909.289A7.478,7.478,0,0,1,4.411,7.933ZM6.043,14a19.768,19.768,0,0,0-1.882-3.293,6.161,6.161,0,0,1,.605.2A6.467,6.467,0,0,0,6.043,7.649,6.478,6.478,0,0,0,7.32,10.908a6.251,6.251,0,0,1,.6-.2A19.768,19.768,0,0,0,6.043,14Zm0-5.094a7.461,7.461,0,0,1-.7,2.368,3.577,3.577,0,0,1,.705.643h0a3.561,3.561,0,0,1,.706-.643A7.48,7.48,0,0,1,6.043,8.906Zm6.043,1.574A19.85,19.85,0,0,1,10.175,7.2a6.215,6.215,0,0,0-.127.624A6.479,6.479,0,0,1,6.586,7.3,6.486,6.486,0,0,1,8.771,10.04a6.112,6.112,0,0,0-.477.423A19.783,19.783,0,0,1,12.086,10.48ZM7.675,7.933a7.473,7.473,0,0,0,2.4.573,3.548,3.548,0,0,0,.2.933h0a3.562,3.562,0,0,0-.91.289A7.478,7.478,0,0,0,7.675,7.933ZM12.086,3.52A19.85,19.85,0,0,0,10.175,6.8a6.215,6.215,0,0,1-.127-.624A6.479,6.479,0,0,0,6.586,6.7,6.486,6.486,0,0,0,8.771,3.96a6.112,6.112,0,0,1-.477-.423A19.783,19.783,0,0,0,12.086,3.52ZM7.675,6.067a7.473,7.473,0,0,1,2.4-.573,3.548,3.548,0,0,1,.2-.933h0a3.562,3.562,0,0,1-.91-.289A7.478,7.478,0,0,1,7.675,6.067ZM6.043,0A19.768,19.768,0,0,1,4.161,3.293a6.161,6.161,0,0,0,.605-.2A6.467,6.467,0,0,1,6.043,6.351,6.478,6.478,0,0,1,7.32,3.092a6.251,6.251,0,0,0,.6.2A19.768,19.768,0,0,1,6.043,0Zm0,5.094a7.461,7.461,0,0,0-.7-2.368,3.577,3.577,0,0,0,.705-.643h0a3.561,3.561,0,0,0,.706.643A7.48,7.48,0,0,0,6.043,5.094Zm.1,2.038,1.044.92-.071.817-.744-.347L6.1,7.157a.163.163,0,0,1-.115,0L5.711,8.522l-.743.347L4.9,8.052l1.044-.92a.165.165,0,0,1-.062-.1l-1.314.443-.672-.471.672-.47,1.312.442a.17.17,0,0,1,.056-.1L4.9,5.961l.071-.817.743.347.272,1.352a.166.166,0,0,1,.12,0l.272-1.352.744-.347.071.817-1.037.913a.165.165,0,0,1,.056.1l1.313-.442.672.47-.672.471L6.208,7.034A.165.165,0,0,1,6.146,7.132Z"
      ></path>
    </svg>
  );
}

export function IconDendro(props: Props) {
  return (
    <svg className={props.className} viewBox="0 0 300 300">
      <path
        fill="currentColor"
        d="M172.23 78.43L157.05 96.1l-15.19-17.67A24 24 0 01139.77 50l17.28-27.35L174.32 50a24 24 0 01-2.09 28.43z"
      />
      <path
        fill="currentColor"
        d="M268.12 172.71l-.78.57.59.51c-6.93 39.22-38.21 56.42-56 64.94-20.11 9.62-54.86 29.44-54.86 52.75 0-23.31-34.76-43.13-54.87-52.75-17.8-8.52-49.08-25.72-56-64.93l.6-.52-.8-.58a93.47 93.47 0 01-1.21-15.29c0-51 40.52-73.45 65.87-73.45 19.14 0 33 11.45 38.59 17.07a5.05 5.05 0 01.65 6.34l-4.07 6.25a2.42 2.42 0 01-3.93.18c-5.31-6.66-21.2-22.14-48.9-11.8-20.71 7.75-33.67 27-33.67 50s14.21 56.43 51.41 70.22c37.2 13.79 46.31 36.08 46.31 36.08s9.11-22.29 46.31-36.08S254.77 175 254.77 152s-13-42.21-33.65-49.94c-27.72-10.36-43.62 5.12-48.9 11.78a2.42 2.42 0 01-3.93-.18l-4.07-6.25a5.07 5.07 0 01.65-6.34C170.51 95.41 184.33 84 203.46 84c25.36 0 65.87 22.44 65.87 73.45a93.51 93.51 0 01-1.21 15.26z"
      />
      <path
        fill="currentColor"
        d="M46.76 173.28l-.6.52c-.07-.36-.14-.73-.19-1.1z"
      />
      <path
        fill="currentColor"
        d="M140.75 206.42c-31.67-27.84-39-46.35-31.82-63s27.13-9.94 27.13-9.94c-17.07-17.7-31.49-14.39-39.49-9.91a26.73 26.73 0 00-11 12c-6.5 13.75-.57 27.06 9.45 38.36-6.32.52-14.13 3.24-18.63 12.44 0 0 4.65-4.77 11-5.6 6.35-.83 12.7-1.17 17.62 2.8 16.31 13.8 35.74 22.85 35.74 22.85z"
      />
      <path
        fill="currentColor"
        d="M60.87 92.75a16.77 16.77 0 00-15.94-14.59l-20.36-.83 4.77 16.8a18.22 18.22 0 0020 13.08l13.14-1.81z"
      />
      <path
        fill="currentColor"
        d="M46.76 173.28l-.6.52-7.89 6.83a12 12 0 01-14.52.94l-10-6.6 10.47-7.71a12 12 0 0114.23 0L46 172.7z"
      />
      <path
        fill="currentColor"
        d="M268.12 172.71c-.05.36-.12.72-.19 1.08l-.59-.51z"
      />
      <path
        fill="currentColor"
        d="M173.35 206.42c31.66-27.84 39-46.35 31.81-63-7.19-16.65-27.16-9.97-27.16-9.97 17.07-17.7 31.49-14.39 39.5-9.91a26.73 26.73 0 0111 12c6.49 13.75.57 27.06-9.45 38.36 6.32.52 14.12 3.24 18.63 12.44 0 0-4.65-4.77-11-5.6-6.35-.83-12.7-1.17-17.62 2.8-16.28 13.83-35.71 22.88-35.71 22.88z"
      />
      <path
        fill="currentColor"
        d="M253.22 92.75a16.79 16.79 0 0115.94-14.59l20.37-.83-4.77 16.8a18.24 18.24 0 01-20 13.08l-13.14-1.81z"
      />
      <path
        fill="currentColor"
        d="M300.3 175l-10 6.6a12 12 0 01-14.51-.94l-7.9-6.84-.59-.51.78-.57 7.48-5.48a12 12 0 0114.24 0z"
      />
    </svg>
  );
}

export function IconHeal(props: Props) {
  return (
    <svg className={props.className} viewBox="0 0 14 14">
      <path
        fill="currentColor"
        d="M14,4.765v4.47a.589.589,0,0,1-.588.589H9.824v3.588A.589.589,0,0,1,9.235,14H4.765a.589.589,0,0,1-.589-.588V9.824H.588A.589.589,0,0,1,0,9.235V4.765a.589.589,0,0,1,.588-.589H4.176V.588A.589.589,0,0,1,4.765,0h4.47a.589.589,0,0,1,.589.588V4.176h3.588A.589.589,0,0,1,14,4.765Z"
      ></path>
    </svg>
  );
}
