/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;

@BugPattern(name="AssistedInjectAndInjectOnConstructors", summary="@AssistedInject and @Inject should not be used on different constructors in the same class.", explanation="Mixing @Inject and @AssistedInject leads to confusing code and the documentation specifies not to do it. See http://google-guice.googlecode.com/git/javadoc/com/google/inject/assistedinject/AssistedInject.html", category=BugPattern.Category.INJECT, severity=BugPattern.SeverityLevel.WARNING, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class InjectAssistedInjectAndInjectOnConstructors
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    private static final String GUICE_INJECT_ANNOTATION = "com.google.inject.Inject";
    private static final String JAVAX_INJECT_ANNOTATION = "javax.inject.Inject";
    private static final String ASSISTED_INJECT_ANNOTATION = "com.google.inject.assistedinject.AssistedInject";
    private MultiMatcher<ClassTree, MethodTree> constructorWithInjectMatcher = Matchers.constructor(ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.anyOf(Matchers.hasAnnotation("com.google.inject.Inject"), Matchers.hasAnnotation("javax.inject.Inject")));
    private MultiMatcher<ClassTree, MethodTree> constructorWithAssistedInjectMatcher = Matchers.constructor(ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.hasAnnotation("com.google.inject.assistedinject.AssistedInject"));
    private Matcher<ClassTree> constructorsWithInjectAndAssistedInjectMatcher = Matchers.allOf(this.constructorWithInjectMatcher, this.constructorWithAssistedInjectMatcher);

    @Override
    public final Description matchAnnotation(AnnotationTree annotationTree, VisitorState state) {
        ClassTree enclosingClass;
        Symbol annotationSymbol;
        Tree modified = state.getPath().getParentPath().getParentPath().getLeaf();
        if (ASTHelpers.getSymbol(modified).isConstructor() && ((annotationSymbol = ASTHelpers.getSymbol(annotationTree)).equals(state.getSymbolFromString(JAVAX_INJECT_ANNOTATION)) || annotationSymbol.equals(state.getSymbolFromString(GUICE_INJECT_ANNOTATION)) || annotationSymbol.equals(state.getSymbolFromString(ASSISTED_INJECT_ANNOTATION))) && this.constructorsWithInjectAndAssistedInjectMatcher.matches(enclosingClass = (ClassTree)state.getPath().getParentPath().getParentPath().getParentPath().getLeaf(), state)) {
            return this.describeMatch(annotationTree, SuggestedFix.delete(annotationTree));
        }
        return Description.NO_MATCH;
    }
}

