/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ClassTree;

@BugPattern(name="JUnitAmbiguousTestClass", summary="Test class inherits from JUnit 3's TestCase but has JUnit 4 @Test annotations.", explanation="JUnit 3 uses inheritance, whereas JUnit 4 uses composition. Mixing these two design patterns historically has been a source of test bugs and unexpected behavior (e.g.: teardown logic and/or verification does not run). Error Prone also cannot infer whether the test class runs with JUnit 3 or JUnit 4. Thus, even if the test class runs with JUnit 4, Error Prone will not run additional checks which can catch common errors with JUnit 4 test classes. Either use only JUnit 4 and remove the inheritance from TestCase, or use only JUnit 3 and remove the @Test annotations. ", category=BugPattern.Category.JUNIT, maturity=BugPattern.MaturityLevel.MATURE, severity=BugPattern.SeverityLevel.WARNING)
public class JUnitAmbiguousTestClass
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<ClassTree> matcher = Matchers.allOf(JUnitMatchers.isTestCaseDescendant, JUnitMatchers.hasJUnit4TestCases);

    @Override
    public Description matchClass(ClassTree classTree, VisitorState state) {
        return matcher.matches(classTree, state) ? this.describeMatch(classTree) : Description.NO_MATCH;
    }
}

