/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import java.util.EnumSet;
import java.util.Set;

@BugPattern(name="ProtoFieldNullComparison", summary="Protobuf fields cannot be null", explanation="This checker looks for comparisons of protocol buffer fields with null. If a proto field is not specified, its field accessor will return a non-null default value. Thus, the result of calling one of these accessors can never be null, and comparisons like these often indicate a nearby error.\n\nIf you meant to check whether an optional field has been set, you should use the hasField() method instead.", category=BugPattern.Category.ONE_OFF, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.MATURE)
public class ProtoFieldNullComparison
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    private static final String PROTO_SUPER_CLASS = "com.google.protobuf.GeneratedMessage";
    private static final Matcher<ExpressionTree> protoMessageReceiverMatcher = Matchers.instanceMethod().onDescendantOf("com.google.protobuf.GeneratedMessage");
    private static final String LIST_INTERFACE = "java.util.List";
    private static final Matcher<Tree> returnsListMatcher = Matchers.isCastableTo("java.util.List");
    private static final Set<Tree.Kind> COMPARISON_OPERATORS = EnumSet.of(Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO);
    private static final Matcher<BinaryTree> MATCHER = new Matcher<BinaryTree>(){

        @Override
        public boolean matches(BinaryTree tree, VisitorState state) {
            if (!COMPARISON_OPERATORS.contains((Object)tree.getKind())) {
                return false;
            }
            ExpressionTree leftOperand = tree.getLeftOperand();
            ExpressionTree rightOperand = tree.getRightOperand();
            return ProtoFieldNullComparison.isNull(rightOperand) && ProtoFieldNullComparison.isProtoMessageGetInvocation(leftOperand, state) || ProtoFieldNullComparison.isNull(leftOperand) && ProtoFieldNullComparison.isProtoMessageGetInvocation(rightOperand, state);
        }
    };

    private static boolean isNull(ExpressionTree tree) {
        return tree.getKind() == Tree.Kind.NULL_LITERAL;
    }

    private static boolean isProtoMessageGetInvocation(ExpressionTree tree, VisitorState state) {
        return (ProtoFieldNullComparison.isGetMethodInvocation(tree, state) || ProtoFieldNullComparison.isGetListMethodInvocation(tree, state)) && ProtoFieldNullComparison.receiverIsProtoMessage(tree, state);
    }

    private static boolean isFieldGetMethod(String methodName) {
        return methodName.startsWith("get");
    }

    private static String getMethodName(ExpressionTree tree) {
        MethodInvocationTree method = (MethodInvocationTree)tree;
        ExpressionTree expressionTree = method.getMethodSelect();
        JCTree.JCFieldAccess access = (JCTree.JCFieldAccess)expressionTree;
        return access.sym.getQualifiedName().toString();
    }

    private static boolean isGetListMethodInvocation(ExpressionTree tree, VisitorState state) {
        if (tree.getKind() == Tree.Kind.METHOD_INVOCATION) {
            MethodInvocationTree method = (MethodInvocationTree)tree;
            if (!method.getArguments().isEmpty()) {
                return false;
            }
            if (!returnsListMatcher.matches(method, state)) {
                return false;
            }
            ExpressionTree expressionTree = method.getMethodSelect();
            if (expressionTree instanceof JCTree.JCFieldAccess) {
                JCTree.JCFieldAccess access = (JCTree.JCFieldAccess)expressionTree;
                String methodName = access.sym.getQualifiedName().toString();
                return ProtoFieldNullComparison.isFieldGetMethod(methodName);
            }
            return true;
        }
        return false;
    }

    private static boolean isGetMethodInvocation(ExpressionTree tree, VisitorState state) {
        if (tree.getKind() == Tree.Kind.METHOD_INVOCATION) {
            MethodInvocationTree method = (MethodInvocationTree)tree;
            if (!method.getArguments().isEmpty()) {
                return false;
            }
            if (returnsListMatcher.matches(method, state)) {
                return false;
            }
            ExpressionTree expressionTree = method.getMethodSelect();
            if (expressionTree instanceof JCTree.JCFieldAccess) {
                JCTree.JCFieldAccess access = (JCTree.JCFieldAccess)expressionTree;
                String methodName = access.sym.getQualifiedName().toString();
                return ProtoFieldNullComparison.isFieldGetMethod(methodName);
            }
            return true;
        }
        return false;
    }

    private static boolean receiverIsProtoMessage(ExpressionTree tree, VisitorState state) {
        return protoMessageReceiverMatcher.matches((MethodInvocationTree)tree, state);
    }

    private static String replaceLast(String text, String pattern, String replacement) {
        StringBuilder builder = new StringBuilder(text);
        int lastIndexOf = builder.lastIndexOf(pattern);
        return builder.replace(lastIndexOf, lastIndexOf + pattern.length(), replacement).toString();
    }

    private static String createReplacement(BinaryTree tree, VisitorState state) {
        ExpressionTree leftOperand = tree.getLeftOperand();
        ExpressionTree rightOperand = tree.getRightOperand();
        ExpressionTree methodInvocation = ProtoFieldNullComparison.isNull(leftOperand) ? rightOperand : leftOperand;
        if (ProtoFieldNullComparison.isGetMethodInvocation(methodInvocation, state)) {
            String methodName = ProtoFieldNullComparison.getMethodName(methodInvocation);
            String hasMethod = methodName.replaceFirst("get", "has");
            String replacement = ProtoFieldNullComparison.replaceLast(methodInvocation.toString(), methodName, hasMethod);
            replacement = tree.getKind() == Tree.Kind.EQUAL_TO ? "!" + replacement : replacement;
            return replacement;
        }
        String replacement = methodInvocation + ".isEmpty()";
        return tree.getKind() == Tree.Kind.EQUAL_TO ? replacement : "!" + replacement;
    }

    @Override
    public Description matchBinary(BinaryTree tree, VisitorState state) {
        return MATCHER.matches(tree, state) ? this.describeMatch(tree, SuggestedFix.replace(tree, ProtoFieldNullComparison.createReplacement(tree, state))) : Description.NO_MATCH;
    }
}

