/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractSuppressWarningsMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.AnnotationTree;
import java.util.List;

@BugPattern(name="SuppressWarningsDeprecated", summary="Suppressing \"deprecated\" is probably a typo for \"deprecation\"", explanation="To suppress warnings to deprecated methods, you should add the annotation\n`@SuppressWarnings(\"deprecation\")`\nand not\n`@SuppressWarnings(\"deprecated\")`", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.MATURE)
public class SuppressWarningsDeprecated
extends AbstractSuppressWarningsMatcher {
    private static final Matcher<AnnotationTree> matcher = Matchers.allOf(Matchers.isType("java.lang.SuppressWarnings"), Matchers.hasArgumentWithValue("value", Matchers.stringLiteral("deprecated")));

    @Override
    public final Description matchAnnotation(AnnotationTree annotationTree, VisitorState state) {
        if (matcher.matches(annotationTree, state)) {
            return this.describeMatch(annotationTree, this.getSuggestedFix(annotationTree));
        }
        return Description.NO_MATCH;
    }

    @Override
    protected void processSuppressWarningsValues(List<String> values) {
        for (int i = 0; i < values.size(); ++i) {
            if (!values.get(i).equals("deprecated")) continue;
            values.set(i, "deprecation");
        }
    }
}

