/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Verify;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;

@BugPattern(name="UnnecessaryTypeArgument", summary="Non-generic methods should not be invoked with type arguments", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.MATURE)
public class UnnecessaryTypeArgument
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return this.check(tree, tree.getTypeArguments(), state);
    }

    @Override
    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        return this.check(tree, tree.getTypeArguments(), state);
    }

    private Description check(Tree tree, java.util.List<? extends Tree> arguments, VisitorState state) {
        Symbol sym = ASTHelpers.getSymbol(tree);
        if (!(sym instanceof Symbol.MethodSymbol)) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)sym;
        int expected = ((List)methodSymbol.getTypeParameters()).size();
        int actual = arguments.size();
        if (actual <= expected) {
            return Description.NO_MATCH;
        }
        for (Symbol.MethodSymbol superMethod : ASTHelpers.findSuperMethods(methodSymbol, state.getTypes())) {
            if (((List)superMethod.getTypeParameters()).isEmpty()) continue;
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, this.buildFix(tree, arguments, state));
    }

    private Fix buildFix(Tree tree, java.util.List<? extends Tree> arguments, VisitorState state) {
        int lower;
        JCTree node = (JCTree)tree;
        int startAbsolute = node.getStartPosition();
        int upper = state.getEndPosition((JCTree)arguments.get(arguments.size() - 1)) - startAbsolute;
        String source = state.getSourceForNode(node);
        for (lower = ((JCTree)arguments.get(0)).getStartPosition() - startAbsolute; lower >= 0 && source.charAt(lower) != '<'; --lower) {
        }
        while (upper < source.length() && source.charAt(upper) != '>') {
            ++upper;
        }
        Verify.verify((source.charAt(lower) == '<' && source.charAt(upper) == '>' ? 1 : 0) != 0);
        Fix fix = SuggestedFix.replace(startAbsolute + lower, startAbsolute + upper + 1, "");
        return fix;
    }
}

