/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.common.base.Joiner;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.GuardedByExpression;
import com.google.errorprone.bugpatterns.threadsafety.GuardedByValidator;
import com.google.errorprone.bugpatterns.threadsafety.HeldLockAnalyzer;
import com.google.errorprone.bugpatterns.threadsafety.HeldLockSet;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;

@BugPattern(name="GuardedByChecker", altNames={"GuardedBy"}, summary="Checks for unguarded accesses to fields and methods with @GuardedBy annotations", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.MATURE)
public class GuardedByChecker
extends GuardedByValidator
implements BugChecker.VariableTreeMatcher,
BugChecker.MethodTreeMatcher {
    private static final String JUC_READ_WRITE_LOCK = "java.util.concurrent.locks.ReadWriteLock";

    @Override
    public Description matchMethod(MethodTree tree, final VisitorState state) {
        if (ASTHelpers.getSymbol(tree).isConstructor()) {
            return Description.NO_MATCH;
        }
        HeldLockAnalyzer.analyze(state, new HeldLockAnalyzer.LockEventListener(){

            @Override
            public void handleGuardedAccess(ExpressionTree tree, GuardedByExpression guard, HeldLockSet live) {
                GuardedByChecker.this.report(GuardedByChecker.this.checkGuardedAccess(tree, guard, live, state), state);
            }
        });
        return GuardedByValidator.validate(this, tree, state);
    }

    @Override
    public Description matchVariable(VariableTree tree, VisitorState state) {
        return GuardedByValidator.validate(this, tree, state);
    }

    protected Description checkGuardedAccess(Tree tree, GuardedByExpression guard, HeldLockSet locks, VisitorState state) {
        if (GuardedByChecker.isRWLock(guard, state)) {
            return Description.NO_MATCH;
        }
        if (locks.allLocks().contains(guard)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(this.buildMessage(guard, locks)).build();
    }

    private String buildMessage(GuardedByExpression guard, HeldLockSet locks) {
        StringBuilder message = new StringBuilder();
        message.append(String.format("This access should be guarded by '%s'", guard));
        int heldLocks = locks.allLocks().size();
        if (heldLocks == 0) {
            message.append(", which is not currently held");
        } else {
            message.append(String.format("; instead found: '%s'", Joiner.on((String)"', '").join(locks.allLocks())));
        }
        String content = message.toString();
        return content;
    }

    private static boolean isRWLock(GuardedByExpression guard, VisitorState state) {
        Type guardType = guard.type();
        if (guardType == null) {
            return false;
        }
        Symbol rwLockSymbol = state.getSymbolFromString(JUC_READ_WRITE_LOCK);
        if (rwLockSymbol == null) {
            return false;
        }
        return state.getTypes().isSubtype(guardType, rwLockSymbol.type);
    }

    private void report(Description description, VisitorState state) {
        if (description == null || description == Description.NO_MATCH) {
            return;
        }
        state.reportMatch(description);
    }
}

