/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.util.concurrent.ListenableFuture;
import dagger.Binds;
import dagger.internal.codegen.AutoValue_Key;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.MapKeys;
import dagger.internal.codegen.MapType;
import dagger.internal.codegen.SetType;
import dagger.internal.codegen.SimpleAnnotationMirror;
import dagger.internal.codegen.SourceElement;
import dagger.producers.Produced;
import dagger.producers.Producer;
import dagger.producers.Production;
import dagger.producers.internal.ProductionImplementation;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.inject.Provider;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;

abstract class Key {
    Key() {
    }

    abstract Optional<Equivalence.Wrapper<AnnotationMirror>> wrappedQualifier();

    abstract Equivalence.Wrapper<TypeMirror> wrappedType();

    abstract Optional<SourceElement> bindingMethod();

    Optional<AnnotationMirror> qualifier() {
        return Key.unwrapOptionalEquivalence(this.wrappedQualifier());
    }

    TypeMirror type() {
        return (TypeMirror)this.wrappedType().get();
    }

    private static TypeMirror normalize(Types types, TypeMirror type) {
        TypeKind kind = type.getKind();
        return kind.isPrimitive() ? types.boxedClass((PrimitiveType)type).asType() : type;
    }

    private Key withType(Types types, TypeMirror newType) {
        return new AutoValue_Key(this.wrappedQualifier(), (Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap((Object)Key.normalize(types, newType)), this.bindingMethod());
    }

    private Key withBindingMethod(SourceElement bindingMethod) {
        return new AutoValue_Key(this.wrappedQualifier(), this.wrappedType(), (Optional<SourceElement>)Optional.of((Object)bindingMethod));
    }

    Key withoutBindingMethod() {
        return new AutoValue_Key(this.wrappedQualifier(), this.wrappedType(), (Optional<SourceElement>)Optional.absent());
    }

    boolean isValidMembersInjectionKey() {
        return !this.qualifier().isPresent() && !this.type().getKind().equals((Object)TypeKind.WILDCARD);
    }

    boolean isValidImplicitProvisionKey(final Types types) {
        if (this.qualifier().isPresent()) {
            return false;
        }
        return this.type().accept(new SimpleTypeVisitor6<Boolean, Void>(){

            @Override
            protected Boolean defaultAction(TypeMirror e, Void p) {
                return false;
            }

            @Override
            public Boolean visitDeclared(DeclaredType type, Void ignored) {
                TypeElement element = MoreElements.asType(type.asElement());
                if (!element.getKind().equals((Object)ElementKind.CLASS) || element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    return false;
                }
                for (TypeMirror typeMirror : type.getTypeArguments()) {
                    if (typeMirror.getKind() == TypeKind.DECLARED) continue;
                    return false;
                }
                return MoreTypes.asDeclared(element.asType()).getTypeArguments().isEmpty() || !types.isSameType(types.erasure(element.asType()), Key.this.type());
            }
        }, null);
    }

    public String toString() {
        return MoreObjects.toStringHelper(Key.class).omitNullValues().add("qualifier", this.qualifier().orNull()).add("type", (Object)this.type()).add("bindingMethod", this.bindingMethod().orNull()).toString();
    }

    static <T extends HasKey> ImmutableSetMultimap<Key, T> indexByKey(Iterable<T> haveKeys) {
        return ImmutableSetMultimap.copyOf((Multimap)Multimaps.index(haveKeys, (Function)new Function<HasKey, Key>(){

            public Key apply(HasKey hasKey) {
                return hasKey.key();
            }
        }));
    }

    private static <T> Optional<Equivalence.Wrapper<T>> wrapOptionalInEquivalence(Equivalence<T> equivalence, Optional<T> optional) {
        return optional.isPresent() ? Optional.of((Object)equivalence.wrap(optional.get())) : Optional.absent();
    }

    private static <T> Optional<T> unwrapOptionalEquivalence(Optional<Equivalence.Wrapper<T>> wrappedOptional) {
        return wrappedOptional.isPresent() ? Optional.of((Object)((Equivalence.Wrapper)wrappedOptional.get()).get()) : Optional.absent();
    }

    static final class Factory {
        private final Types types;
        private final Elements elements;

        Factory(Types types, Elements elements) {
            this.types = (Types)Preconditions.checkNotNull((Object)types);
            this.elements = (Elements)Preconditions.checkNotNull((Object)elements);
        }

        private TypeElement getSetElement() {
            return this.elements.getTypeElement(Set.class.getCanonicalName());
        }

        private TypeElement getMapElement() {
            return this.elements.getTypeElement(Map.class.getCanonicalName());
        }

        private TypeElement getProviderElement() {
            return this.elements.getTypeElement(Provider.class.getCanonicalName());
        }

        private TypeElement getProducerElement() {
            return this.elements.getTypeElement(Producer.class.getCanonicalName());
        }

        private TypeElement getClassElement(Class<?> cls) {
            return this.elements.getTypeElement(cls.getCanonicalName());
        }

        Key forComponentMethod(ExecutableElement componentMethod) {
            Preconditions.checkNotNull((Object)componentMethod);
            Preconditions.checkArgument((boolean)componentMethod.getKind().equals((Object)ElementKind.METHOD));
            TypeMirror returnType = Key.normalize(this.types, componentMethod.getReturnType());
            return this.forMethod(componentMethod, returnType);
        }

        Key forProductionComponentMethod(ExecutableElement componentMethod) {
            TypeMirror returnType;
            Preconditions.checkNotNull((Object)componentMethod);
            Preconditions.checkArgument((boolean)componentMethod.getKind().equals((Object)ElementKind.METHOD));
            TypeMirror keyType = returnType = Key.normalize(this.types, componentMethod.getReturnType());
            if (MoreTypes.isTypeOf(ListenableFuture.class, returnType)) {
                keyType = (TypeMirror)Iterables.getOnlyElement(MoreTypes.asDeclared(returnType).getTypeArguments());
            }
            return this.forMethod(componentMethod, keyType);
        }

        Key forSubcomponentBuilderMethod(ExecutableElement subcomponentBuilderMethod, DeclaredType declaredContainer) {
            Preconditions.checkNotNull((Object)subcomponentBuilderMethod);
            Preconditions.checkArgument((boolean)subcomponentBuilderMethod.getKind().equals((Object)ElementKind.METHOD));
            ExecutableType resolvedMethod = MoreTypes.asExecutable(this.types.asMemberOf(declaredContainer, subcomponentBuilderMethod));
            TypeMirror returnType = Key.normalize(this.types, resolvedMethod.getReturnType());
            return this.forMethod(subcomponentBuilderMethod, returnType);
        }

        Key forProvidesMethod(SourceElement sourceElement) {
            return this.forProvidesOrProducesMethod(sourceElement, this.getProviderElement());
        }

        Key forProducesMethod(SourceElement sourceElement) {
            return this.forProvidesOrProducesMethod(sourceElement, this.getProducerElement());
        }

        private Key forProvidesOrProducesMethod(SourceElement sourceElement, TypeElement frameworkType) {
            Preconditions.checkArgument((boolean)sourceElement.element().getKind().equals((Object)ElementKind.METHOD));
            ExecutableElement method = MoreElements.asExecutable(sourceElement.element());
            ExecutableType methodType = MoreTypes.asExecutable(sourceElement.asMemberOfContributingType(this.types));
            ContributionType contributionType = ContributionType.fromBindingMethod(method);
            TypeMirror returnType = Key.normalize(this.types, methodType.getReturnType());
            if (frameworkType.equals(this.getProducerElement()) && MoreTypes.isTypeOf(ListenableFuture.class, returnType)) {
                returnType = (TypeMirror)Iterables.getOnlyElement(MoreTypes.asDeclared(returnType).getTypeArguments());
            }
            TypeMirror keyType = this.providesOrProducesKeyType(returnType, method, contributionType, frameworkType);
            Key key = this.forMethod(method, keyType);
            return contributionType.equals((Object)ContributionType.UNIQUE) ? key : key.withBindingMethod(sourceElement);
        }

        Key forMultibindingsMethod(BindingType bindingType, ExecutableType executableType, ExecutableElement method) {
            Preconditions.checkArgument((boolean)method.getKind().equals((Object)ElementKind.METHOD), (String)"%s must be a method", (Object[])new Object[]{method});
            TypeElement factoryType = this.elements.getTypeElement(bindingType.frameworkClass().getCanonicalName());
            TypeMirror returnType = Key.normalize(this.types, executableType.getReturnType());
            TypeMirror keyType = MapType.isMap(returnType) ? this.mapOfFrameworkType(MapType.from(returnType).keyType(), factoryType, MapType.from(returnType).valueType()) : returnType;
            return this.forMethod(method, keyType);
        }

        Key forBindsMethod(SourceElement bindsMethodElement) {
            ExecutableElement method = MoreElements.asExecutable(bindsMethodElement.element());
            ExecutableType methodType = MoreTypes.asExecutable(bindsMethodElement.asMemberOfContributingType(this.types));
            Preconditions.checkArgument((boolean)MoreElements.isAnnotationPresent(method, Binds.class));
            TypeMirror returnType = Key.normalize(this.types, methodType.getReturnType());
            return this.forMethod(method, returnType);
        }

        Key forBindParameter(SourceElement bindsMethodElement) {
            ExecutableElement method = MoreElements.asExecutable(bindsMethodElement.element());
            VariableElement parameterElement = (VariableElement)Iterables.getOnlyElement(method.getParameters());
            ExecutableType methodType = MoreTypes.asExecutable(bindsMethodElement.asMemberOfContributingType(this.types));
            Preconditions.checkArgument((boolean)MoreElements.isAnnotationPresent(method, Binds.class));
            TypeMirror parameterType = (TypeMirror)Iterables.getOnlyElement(methodType.getParameterTypes());
            return this.forQualifiedType(InjectionAnnotations.getQualifier(parameterElement), parameterType);
        }

        private TypeMirror providesOrProducesKeyType(TypeMirror returnType, ExecutableElement method, ContributionType contributionType, TypeElement frameworkType) {
            switch (contributionType) {
                case UNIQUE: {
                    return returnType;
                }
                case SET: {
                    return this.types.getDeclaredType(this.getSetElement(), returnType);
                }
                case MAP: {
                    return this.mapOfFrameworkType(this.mapKeyType(method), frameworkType, returnType);
                }
                case SET_VALUES: {
                    Preconditions.checkArgument((boolean)SetType.isSet(returnType));
                    return returnType;
                }
            }
            throw new AssertionError();
        }

        private TypeMirror mapOfFrameworkType(TypeMirror keyType, TypeElement frameworkType, TypeMirror valueType) {
            return this.types.getDeclaredType(this.getMapElement(), keyType, this.types.getDeclaredType(frameworkType, valueType));
        }

        private TypeMirror mapKeyType(ExecutableElement method) {
            AnnotationMirror mapKeyAnnotation = (AnnotationMirror)MapKeys.getMapKey(method).get();
            return MapKeys.unwrapValue(mapKeyAnnotation).isPresent() ? MapKeys.getUnwrappedMapKeyType(mapKeyAnnotation.getAnnotationType(), this.types) : mapKeyAnnotation.getAnnotationType();
        }

        private Key forMethod(ExecutableElement method, TypeMirror keyType) {
            return new AutoValue_Key((Optional<Equivalence.Wrapper<AnnotationMirror>>)Key.wrapOptionalInEquivalence(AnnotationMirrors.equivalence(), InjectionAnnotations.getQualifier(method)), (Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap((Object)keyType), (Optional<SourceElement>)Optional.absent());
        }

        Key forInjectConstructorWithResolvedType(TypeMirror type) {
            return new AutoValue_Key((Optional<Equivalence.Wrapper<AnnotationMirror>>)Optional.absent(), (Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap((Object)type), (Optional<SourceElement>)Optional.absent());
        }

        Key forComponent(TypeMirror type) {
            return new AutoValue_Key((Optional<Equivalence.Wrapper<AnnotationMirror>>)Optional.absent(), (Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap((Object)Key.normalize(this.types, type)), (Optional<SourceElement>)Optional.absent());
        }

        Key forMembersInjectedType(TypeMirror type) {
            return new AutoValue_Key((Optional<Equivalence.Wrapper<AnnotationMirror>>)Optional.absent(), (Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap((Object)Key.normalize(this.types, type)), (Optional<SourceElement>)Optional.absent());
        }

        Key forQualifiedType(Optional<AnnotationMirror> qualifier, TypeMirror type) {
            return new AutoValue_Key((Optional<Equivalence.Wrapper<AnnotationMirror>>)Key.wrapOptionalInEquivalence(AnnotationMirrors.equivalence(), qualifier), (Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap((Object)Key.normalize(this.types, type)), (Optional<SourceElement>)Optional.absent());
        }

        Key forProductionExecutor() {
            return this.forQualifiedType((Optional<AnnotationMirror>)Optional.of((Object)SimpleAnnotationMirror.of(this.getClassElement(Production.class))), this.getClassElement(Executor.class).asType());
        }

        Key forProductionImplementationExecutor() {
            return this.forQualifiedType((Optional<AnnotationMirror>)Optional.of((Object)SimpleAnnotationMirror.of(this.getClassElement(ProductionImplementation.class))), this.getClassElement(Executor.class).asType());
        }

        Optional<Key> implicitMapProviderKeyFrom(Key possibleMapKey) {
            return this.maybeWrapMapValue(possibleMapKey, Provider.class);
        }

        Optional<Key> implicitMapProducerKeyFrom(Key possibleMapKey) {
            return this.maybeRewrapMapValue(possibleMapKey, Produced.class, Producer.class).or(this.maybeWrapMapValue(possibleMapKey, Producer.class));
        }

        private Optional<Key> maybeRewrapMapValue(Key possibleMapKey, Class<?> currentWrappingClass, Class<?> newWrappingClass) {
            MapType mapType;
            Preconditions.checkArgument((!currentWrappingClass.equals(newWrappingClass) ? 1 : 0) != 0);
            if (MapType.isMap(possibleMapKey.type()) && (mapType = MapType.from(possibleMapKey.type())).valuesAreTypeOf(currentWrappingClass)) {
                TypeElement wrappingElement = this.getClassElement(newWrappingClass);
                if (wrappingElement == null) {
                    return Optional.absent();
                }
                DeclaredType wrappedValueType = this.types.getDeclaredType(wrappingElement, mapType.unwrappedValueType(currentWrappingClass));
                DeclaredType wrappedMapType = this.types.getDeclaredType(this.getMapElement(), mapType.keyType(), wrappedValueType);
                return Optional.of((Object)possibleMapKey.withType(this.types, wrappedMapType));
            }
            return Optional.absent();
        }

        private Optional<Key> maybeWrapMapValue(Key possibleMapKey, Class<?> wrappingClass) {
            MapType mapType;
            if (MapType.isMap(possibleMapKey.type()) && !(mapType = MapType.from(possibleMapKey.type())).valuesAreTypeOf(wrappingClass)) {
                TypeElement wrappingElement = this.getClassElement(wrappingClass);
                if (wrappingElement == null) {
                    return Optional.absent();
                }
                DeclaredType wrappedValueType = this.types.getDeclaredType(wrappingElement, mapType.valueType());
                DeclaredType wrappedMapType = this.types.getDeclaredType(this.getMapElement(), mapType.keyType(), wrappedValueType);
                return Optional.of((Object)possibleMapKey.withType(this.types, wrappedMapType));
            }
            return Optional.absent();
        }

        Optional<Key> implicitSetKeyFromProduced(Key possibleSetOfProducedKey) {
            TypeMirror argType;
            if (MoreTypes.isType(possibleSetOfProducedKey.type()) && MoreTypes.isTypeOf(Set.class, possibleSetOfProducedKey.type()) && MoreTypes.isType(argType = MoreTypes.asDeclared(possibleSetOfProducedKey.type()).getTypeArguments().get(0)) && MoreTypes.isTypeOf(Produced.class, argType)) {
                TypeMirror producedArgType = MoreTypes.asDeclared(argType).getTypeArguments().get(0);
                DeclaredType setType = this.types.getDeclaredType(this.getSetElement(), producedArgType);
                return Optional.of((Object)possibleSetOfProducedKey.withType(this.types, setType));
            }
            return Optional.absent();
        }
    }

    static interface HasKey {
        public Key key();
    }
}

