/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import dagger.MapKey;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.SourceFiles;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreTypes;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;

final class MapKeys {
    private static final SimpleTypeVisitor6<CodeBlock, CodeBlock> ARRAY_LITERAL_PREFIX = new SimpleTypeVisitor6<CodeBlock, CodeBlock>(){

        @Override
        public CodeBlock visitArray(ArrayType t, CodeBlock p) {
            return CodeBlock.of("new $T[] $L", RAW_TYPE_NAME.visit(t.getComponentType()), p);
        }

        @Override
        protected CodeBlock defaultAction(TypeMirror e, CodeBlock p) {
            return p;
        }
    };
    private static final SimpleTypeVisitor6<TypeName, Void> RAW_TYPE_NAME = new SimpleTypeVisitor6<TypeName, Void>(){

        @Override
        public TypeName visitDeclared(DeclaredType t, Void p) {
            return ClassName.get(MoreTypes.asTypeElement(t));
        }

        @Override
        protected TypeName defaultAction(TypeMirror e, Void p) {
            return TypeName.get(e);
        }
    };

    static Optional<? extends AnnotationMirror> getMapKey(Element bindingElement) {
        ImmutableSet<? extends AnnotationMirror> mapKeys = MapKeys.getMapKeys(bindingElement);
        return mapKeys.isEmpty() ? Optional.absent() : Optional.of((Object)Iterables.getOnlyElement(mapKeys));
    }

    static ImmutableSet<? extends AnnotationMirror> getMapKeys(Element bindingElement) {
        return AnnotationMirrors.getAnnotatedAnnotations(bindingElement, MapKey.class);
    }

    static Optional<? extends AnnotationValue> unwrapValue(AnnotationMirror mapKey) {
        MapKey mapKeyAnnotation = mapKey.getAnnotationType().asElement().getAnnotation(MapKey.class);
        Preconditions.checkArgument((mapKeyAnnotation != null ? 1 : 0) != 0, (String)"%s is not annotated with @MapKey", (Object[])new Object[]{mapKey.getAnnotationType()});
        return mapKeyAnnotation.unwrapValue() ? Optional.of((Object)Iterables.getOnlyElement(mapKey.getElementValues().values())) : Optional.absent();
    }

    public static DeclaredType getUnwrappedMapKeyType(final DeclaredType mapKeyAnnotationType, final Types types) {
        Preconditions.checkArgument((MoreTypes.asTypeElement(mapKeyAnnotationType).getKind() == ElementKind.ANNOTATION_TYPE ? 1 : 0) != 0, (String)"%s is not an annotation type", (Object[])new Object[]{mapKeyAnnotationType});
        final ExecutableElement onlyElement = (ExecutableElement)Iterables.getOnlyElement(ElementFilter.methodsIn(mapKeyAnnotationType.asElement().getEnclosedElements()));
        SimpleTypeVisitor6<DeclaredType, Void> keyTypeElementVisitor = new SimpleTypeVisitor6<DeclaredType, Void>(){

            @Override
            public DeclaredType visitArray(ArrayType t, Void p) {
                String string = String.valueOf(mapKeyAnnotationType);
                String string2 = String.valueOf(onlyElement.getSimpleName());
                throw new IllegalArgumentException(new StringBuilder(20 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".").append(string2).append(" cannot be an array").toString());
            }

            @Override
            public DeclaredType visitPrimitive(PrimitiveType t, Void p) {
                return MoreTypes.asDeclared(types.boxedClass(t).asType());
            }

            @Override
            public DeclaredType visitDeclared(DeclaredType t, Void p) {
                return t;
            }
        };
        return (DeclaredType)keyTypeElementVisitor.visit(onlyElement.getReturnType());
    }

    public static ClassName getMapKeyCreatorClassName(TypeElement mapKeyType) {
        ClassName mapKeyTypeName = ClassName.get(mapKeyType);
        return mapKeyTypeName.topLevelClassName().peerClass(String.valueOf(SourceFiles.classFileName(mapKeyTypeName)).concat("Creator"));
    }

    static CodeBlock getMapKeyExpression(Element bindingElement) {
        AnnotationMirror mapKey = (AnnotationMirror)MapKeys.getMapKey(bindingElement).get();
        ClassName mapKeyCreator = MapKeys.getMapKeyCreatorClassName(MoreTypes.asTypeElement(mapKey.getAnnotationType()));
        Optional<? extends AnnotationValue> unwrappedValue = MapKeys.unwrapValue(mapKey);
        if (unwrappedValue.isPresent()) {
            return (CodeBlock)new MapKeyExpressionExceptArrays(mapKeyCreator).visit((AnnotationValue)unwrappedValue.get(), unwrappedValue.get());
        }
        return MapKeys.annotationExpression(mapKey, new MapKeyExpression(mapKeyCreator));
    }

    private static CodeBlock annotationExpression(AnnotationMirror mapKeyAnnotation, final MapKeyExpression mapKeyExpression) {
        return CodeBlock.of("$T.create$L($L)", mapKeyExpression.mapKeyCreator, mapKeyAnnotation.getAnnotationType().asElement().getSimpleName(), CodeBlocks.makeParametersCodeBlock(Iterables.transform(AnnotationMirrors.getAnnotationValuesWithDefaults(mapKeyAnnotation).entrySet(), (Function)new Function<Map.Entry<ExecutableElement, AnnotationValue>, CodeBlock>(){

            public CodeBlock apply(Map.Entry<ExecutableElement, AnnotationValue> entry) {
                return (CodeBlock)ARRAY_LITERAL_PREFIX.visit(entry.getKey().getReturnType(), mapKeyExpression.visit(entry.getValue(), entry.getValue()));
            }
        })));
    }

    private MapKeys() {
    }

    private static class MapKeyExpressionExceptArrays
    extends MapKeyExpression {
        MapKeyExpressionExceptArrays(ClassName mapKeyCreator) {
            super(mapKeyCreator);
        }

        @Override
        public CodeBlock visitArray(List<? extends AnnotationValue> values, AnnotationValue p) {
            throw new IllegalArgumentException("Cannot unwrap arrays");
        }
    }

    private static class MapKeyExpression
    extends SimpleAnnotationValueVisitor6<CodeBlock, AnnotationValue> {
        final ClassName mapKeyCreator;

        MapKeyExpression(ClassName mapKeyCreator) {
            this.mapKeyCreator = mapKeyCreator;
        }

        @Override
        public CodeBlock visitEnumConstant(VariableElement c, AnnotationValue p) {
            return CodeBlock.of("$T.$L", TypeName.get(c.getEnclosingElement().asType()), c.getSimpleName());
        }

        @Override
        public CodeBlock visitAnnotation(AnnotationMirror a, AnnotationValue p) {
            return MapKeys.annotationExpression(a, this);
        }

        @Override
        public CodeBlock visitType(TypeMirror t, AnnotationValue p) {
            return CodeBlock.of("$T.class", TypeName.get(t));
        }

        @Override
        public CodeBlock visitString(String s, AnnotationValue p) {
            return CodeBlock.of("$S", s);
        }

        @Override
        public CodeBlock visitByte(byte b, AnnotationValue p) {
            return CodeBlock.of("(byte) $L", b);
        }

        @Override
        public CodeBlock visitChar(char c, AnnotationValue p) {
            return CodeBlock.of("$L", p);
        }

        @Override
        public CodeBlock visitDouble(double d, AnnotationValue p) {
            return CodeBlock.of("$LD", d);
        }

        @Override
        public CodeBlock visitFloat(float f, AnnotationValue p) {
            return CodeBlock.of("$LF", Float.valueOf(f));
        }

        @Override
        public CodeBlock visitInt(int i, AnnotationValue p) {
            return CodeBlock.of("(int) $L", i);
        }

        @Override
        public CodeBlock visitLong(long i, AnnotationValue p) {
            return CodeBlock.of("$LL", i);
        }

        @Override
        public CodeBlock visitShort(short s, AnnotationValue p) {
            return CodeBlock.of("(short) $L", s);
        }

        @Override
        protected CodeBlock defaultAction(Object o, AnnotationValue p) {
            return CodeBlock.of("$L", o);
        }

        @Override
        public CodeBlock visitArray(List<? extends AnnotationValue> values, AnnotationValue p) {
            ImmutableList.Builder codeBlocks = ImmutableList.builder();
            for (int i = 0; i < values.size(); ++i) {
                codeBlocks.add(this.visit(values.get(i), p));
            }
            return CodeBlock.of("{$L}", CodeBlocks.makeParametersCodeBlock((Iterable<CodeBlock>)codeBlocks.build()));
        }
    }
}

