/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.Accessibility;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.SetType;
import dagger.internal.codegen.TypeNames;
import javax.lang.model.type.TypeMirror;

abstract class MemberSelect {
    private final ClassName owningClass;
    private final boolean staticMember;

    static MemberSelect localField(ClassName owningClass, String fieldName) {
        return new LocalField(owningClass, fieldName);
    }

    static MemberSelect staticMethod(ClassName owningClass, CodeBlock methodInvocationCodeBlock) {
        return new StaticMethod(owningClass, methodInvocationCodeBlock);
    }

    static MemberSelect noOpMembersInjector(TypeMirror type) {
        return new ParameterizedStaticMethod(TypeNames.MEMBERS_INJECTORS, (ImmutableList<TypeMirror>)ImmutableList.of((Object)type), CodeBlock.of("noOp()", new Object[0]), TypeNames.MEMBERS_INJECTOR);
    }

    static MemberSelect emptyFrameworkMapFactory(ClassName frameworkMapFactoryClass, TypeMirror keyType, TypeMirror unwrappedValueType) {
        Preconditions.checkArgument((frameworkMapFactoryClass.equals(TypeNames.MAP_PROVIDER_FACTORY) || frameworkMapFactoryClass.equals(TypeNames.MAP_OF_PRODUCER_PRODUCER) ? 1 : 0) != 0, (String)"frameworkMapFactoryClass must be MapProviderFactory or MapOfProducerProducer: %s", (Object[])new Object[]{frameworkMapFactoryClass});
        return new ParameterizedStaticMethod(frameworkMapFactoryClass, (ImmutableList<TypeMirror>)ImmutableList.of((Object)keyType, (Object)unwrappedValueType), CodeBlock.of("empty()", new Object[0]), frameworkMapFactoryClass);
    }

    static MemberSelect emptySetProvider(ClassName setFactoryType, SetType setType) {
        return new ParameterizedStaticMethod(setFactoryType, (ImmutableList<TypeMirror>)ImmutableList.of((Object)setType.elementType()), CodeBlock.of("create()", new Object[0]), TypeNames.SET);
    }

    MemberSelect(ClassName owningClass, boolean staticMemeber) {
        this.owningClass = owningClass;
        this.staticMember = staticMemeber;
    }

    ClassName owningClass() {
        return this.owningClass;
    }

    boolean staticMember() {
        return this.staticMember;
    }

    abstract CodeBlock getExpressionFor(ClassName var1);

    private static final class ParameterizedStaticMethod
    extends MemberSelect {
        final ImmutableList<TypeMirror> typeParameters;
        final CodeBlock methodCodeBlock;
        final ClassName rawReturnType;

        ParameterizedStaticMethod(ClassName owningClass, ImmutableList<TypeMirror> typeParameters, CodeBlock methodCodeBlock, ClassName rawReturnType) {
            super(owningClass, true);
            this.typeParameters = typeParameters;
            this.methodCodeBlock = methodCodeBlock;
            this.rawReturnType = rawReturnType;
        }

        @Override
        CodeBlock getExpressionFor(ClassName usingClass) {
            boolean accessible = true;
            for (TypeMirror typeParameter : this.typeParameters) {
                accessible &= Accessibility.isTypeAccessibleFrom(typeParameter, usingClass.packageName());
            }
            if (accessible) {
                return CodeBlock.of("$T.<$L>$L", this.owningClass(), CodeBlocks.makeParametersCodeBlock(CodeBlocks.toCodeBlocks(this.typeParameters)), this.methodCodeBlock);
            }
            return CodeBlock.of("(($T) $T.$L)", this.rawReturnType, this.owningClass(), this.methodCodeBlock);
        }
    }

    private static final class StaticMethod
    extends MemberSelect {
        final CodeBlock methodCodeBlock;

        StaticMethod(ClassName owningClass, CodeBlock methodCodeBlock) {
            super(owningClass, true);
            this.methodCodeBlock = (CodeBlock)Preconditions.checkNotNull((Object)methodCodeBlock);
        }

        @Override
        CodeBlock getExpressionFor(ClassName usingClass) {
            return this.owningClass().equals(usingClass) ? this.methodCodeBlock : CodeBlock.of("$T.$L", this.owningClass(), this.methodCodeBlock);
        }
    }

    private static final class LocalField
    extends MemberSelect {
        final String fieldName;

        LocalField(ClassName owningClass, String fieldName) {
            super(owningClass, false);
            this.fieldName = (String)Preconditions.checkNotNull((Object)fieldName);
        }

        @Override
        CodeBlock getExpressionFor(ClassName usingClass) {
            return this.owningClass().equals(usingClass) ? CodeBlock.of("$L", this.fieldName) : CodeBlock.of("$T.this.$L", this.owningClass(), this.fieldName);
        }
    }
}

