/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import dagger.internal.codegen.InjectFieldValidator;
import dagger.internal.codegen.InjectMethodValidator;
import dagger.internal.codegen.ValidationReport;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

final class MembersInjectedTypeValidator {
    private final InjectFieldValidator fieldValidator;
    private final InjectMethodValidator methodValidator;

    MembersInjectedTypeValidator(InjectFieldValidator fieldValidator, InjectMethodValidator methodValidator) {
        this.fieldValidator = fieldValidator;
        this.methodValidator = methodValidator;
    }

    ValidationReport<TypeElement> validate(TypeElement typeElement) {
        ValidationReport<TypeElement> validationReport;
        ValidationReport.Builder<TypeElement> builder = ValidationReport.about(typeElement);
        for (VariableElement variableElement : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
            ValidationReport<VariableElement> report2;
            if (!MoreElements.isAnnotationPresent(variableElement, Inject.class) || (report2 = this.fieldValidator.validate(variableElement)).isClean()) continue;
            builder.addSubreport(report2);
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            ValidationReport<ExecutableElement> report;
            if (!MoreElements.isAnnotationPresent(executableElement, Inject.class) || (report = this.methodValidator.validate(executableElement)).isClean()) continue;
            builder.addSubreport(report);
        }
        TypeMirror superclass = typeElement.getSuperclass();
        if (!superclass.getKind().equals((Object)TypeKind.NONE) && !(validationReport = this.validate(MoreTypes.asTypeElement(superclass))).isClean()) {
            builder.addSubreport(validationReport);
        }
        return builder.build();
    }
}

