/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import dagger.internal.codegen.BindsMethodValidator;
import dagger.internal.codegen.FactoryGenerator;
import dagger.internal.codegen.ModuleValidator;
import dagger.internal.codegen.ProvidesMethodValidator;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.SourceFileGenerationException;
import dagger.internal.codegen.ValidationReport;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

final class ModuleProcessingStep
implements BasicAnnotationProcessor.ProcessingStep {
    private final Messager messager;
    private final ModuleValidator moduleValidator;
    private final ProvidesMethodValidator providesMethodValidator;
    private final BindsMethodValidator bindsMethodValidator;
    private final ProvisionBinding.Factory provisionBindingFactory;
    private final FactoryGenerator factoryGenerator;
    private final Set<Element> processedModuleElements = Sets.newLinkedHashSet();

    ModuleProcessingStep(Messager messager, ModuleValidator moduleValidator, ProvidesMethodValidator providesMethodValidator, ProvisionBinding.Factory provisionBindingFactory, BindsMethodValidator bindsMethodValidator, FactoryGenerator factoryGenerator) {
        this.messager = messager;
        this.moduleValidator = moduleValidator;
        this.providesMethodValidator = providesMethodValidator;
        this.bindsMethodValidator = bindsMethodValidator;
        this.provisionBindingFactory = provisionBindingFactory;
        this.factoryGenerator = factoryGenerator;
    }

    public Set<Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(Module.class, Provides.class, Binds.class);
    }

    @Override
    public Set<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        ImmutableSet<ExecutableElement> validProvidesMethods = this.validateProvidesMethods(elementsByAnnotation);
        ImmutableSet<ExecutableElement> validBindsMethods = this.validateBindsMethods(elementsByAnnotation);
        for (Element moduleElement : Sets.difference((Set)elementsByAnnotation.get(Module.class), this.processedModuleElements)) {
            ValidationReport<TypeElement> report = this.moduleValidator.validate(MoreElements.asType(moduleElement));
            report.printMessagesTo(this.messager);
            if (report.isClean()) {
                ImmutableSet.Builder moduleProvidesMethodsBuilder = ImmutableSet.builder();
                ImmutableSet.Builder moduleBindsMethodsBuilder = ImmutableSet.builder();
                List<ExecutableElement> moduleMethods = ElementFilter.methodsIn(moduleElement.getEnclosedElements());
                for (ExecutableElement methodElement : moduleMethods) {
                    if (MoreElements.isAnnotationPresent(methodElement, Provides.class)) {
                        moduleProvidesMethodsBuilder.add((Object)methodElement);
                    }
                    if (!MoreElements.isAnnotationPresent(methodElement, Binds.class)) continue;
                    moduleBindsMethodsBuilder.add((Object)methodElement);
                }
                ImmutableSet moduleProvidesMethods = moduleProvidesMethodsBuilder.build();
                ImmutableSet moduleBindsMethods = moduleBindsMethodsBuilder.build();
                if (Sets.difference((Set)moduleProvidesMethods, validProvidesMethods).isEmpty() && Sets.difference((Set)moduleBindsMethods, validBindsMethods).isEmpty()) {
                    ImmutableSet bindings = FluentIterable.from((Iterable)moduleProvidesMethods).transform((Function)new Function<ExecutableElement, ProvisionBinding>(){

                        public ProvisionBinding apply(ExecutableElement providesMethod) {
                            return ModuleProcessingStep.this.provisionBindingFactory.forProvidesMethod(providesMethod, MoreElements.asType(providesMethod.getEnclosingElement()));
                        }
                    }).toSet();
                    try {
                        for (ProvisionBinding binding : bindings) {
                            this.factoryGenerator.generate(binding);
                        }
                    }
                    catch (SourceFileGenerationException e) {
                        e.printMessageTo(this.messager);
                    }
                }
            }
            this.processedModuleElements.add(moduleElement);
        }
        return ImmutableSet.of();
    }

    private ImmutableSet<ExecutableElement> validateBindsMethods(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        ImmutableSet.Builder validBindsMethodsBuilder = ImmutableSet.builder();
        for (Element bindElement : elementsByAnnotation.get(Binds.class)) {
            if (!bindElement.getKind().equals((Object)ElementKind.METHOD)) continue;
            ExecutableElement bindsMethodElement = (ExecutableElement)bindElement;
            ValidationReport<ExecutableElement> methodReport = this.bindsMethodValidator.validate(bindsMethodElement);
            methodReport.printMessagesTo(this.messager);
            if (!methodReport.isClean()) continue;
            validBindsMethodsBuilder.add((Object)bindsMethodElement);
        }
        return validBindsMethodsBuilder.build();
    }

    private ImmutableSet<ExecutableElement> validateProvidesMethods(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        ImmutableSet.Builder validProvidesMethodsBuilder = ImmutableSet.builder();
        for (Element providesElement : elementsByAnnotation.get(Provides.class)) {
            if (!providesElement.getKind().equals((Object)ElementKind.METHOD)) continue;
            ExecutableElement providesMethodElement = (ExecutableElement)providesElement;
            ValidationReport<ExecutableElement> methodReport = this.providesMethodValidator.validate(providesMethodElement);
            methodReport.printMessagesTo(this.messager);
            if (!methodReport.isClean()) continue;
            validProvidesMethodsBuilder.add((Object)providesMethodElement);
        }
        return validProvidesMethodsBuilder.build();
    }
}

