      module MO_EXP_PROD_LOSS_MOD

implicit none
character(len=128), parameter :: version     = '$Id: moz.mat.F90,v 19.0 2012/01/06 20:34:12 fms Exp $'
character(len=128), parameter :: tagname     = '$Name: siena_201207 $'
logical                       :: module_is_initialized = .false.

      contains

      subroutine exp_prod_loss( prod, loss, y, rxt, het_rates )

      use CHEM_MODS_MOD, only : clscnt1, rxntot, hetcnt
      use MO_GRID_MOD,   only : pcnstm1

      implicit none

!--------------------------------------------------------------------
!     ... Dummy args                                                                      
!--------------------------------------------------------------------
      real, dimension(:,:), intent(out) :: &
            prod, &
            loss
      real, intent(in)    ::  y(:,:)
      real, intent(in)    ::  rxt(:,:)
      real, intent(in)    ::  het_rates(:,:)


!--------------------------------------------------------------------
!       ... Loss and production for Explicit method
!--------------------------------------------------------------------

      loss(:,1) = ((rxt(:,47) +rxt(:,48))* y(:,3) + rxt(:,4))* y(:,4)
      prod(:,1) = 0.
      loss(:,2) = (rxt(:,64)* y(:,3) +rxt(:,63)* y(:,17) +rxt(:,191)* y(:,72)) &
                 * y(:,12)
      prod(:,2) = 0.
      loss(:,3) = ((rxt(:,72) +rxt(:,73))* y(:,17))* y(:,16)
      prod(:,3) = 0.
      loss(:,4) = (rxt(:,100)* y(:,17))* y(:,29)
      prod(:,4) = 0.
      loss(:,5) = (rxt(:,144)* y(:,17))* y(:,42)
      prod(:,5) = 0.
      loss(:,6) = (rxt(:,74)* y(:,3) +rxt(:,83)* y(:,17))* y(:,61)
      prod(:,6) =.050*rxt(:,64)*y(:,12)*y(:,3)
      loss(:,7) = 0.
      prod(:,7) = 0.
      loss(:,8) = (rxt(:,46)* y(:,3) + (rxt(:,56) +rxt(:,217))* y(:,11) +rxt(:,218) &
                 * y(:,71) +rxt(:,223)* y(:,78) + rxt(:,14))* y(:,84)
      prod(:,8) = (rxt(:,63)*y(:,12) +rxt(:,83)*y(:,61) +rxt(:,100)*y(:,29) + &
                 rxt(:,144)*y(:,42))*y(:,17)

      end subroutine exp_prod_loss

      end module MO_EXP_PROD_LOSS_MOD

      module MO_IMP_PROD_LOSS_MOD

      contains

      subroutine imp_prod_loss( prod, loss, y, rxt, het_rates )

      use CHEM_MODS_MOD, only : clscnt4, rxntot, hetcnt, clsze
      use MO_GRID_MOD,   only : pcnstm1

      implicit none

!--------------------------------------------------------------------
!     ... Dummy args                                                                      
!--------------------------------------------------------------------
      real, dimension(:), intent(out) :: &
            prod, &
            loss
      real, intent(in)    ::  y(:)
      real, intent(in)    ::  rxt(:)
      real, intent(in)    ::  het_rates(:)



!--------------------------------------------------------------------
!       ... Loss and production for Implicit method
!--------------------------------------------------------------------


         loss(67) = (rxt(43)* y(2) +rxt(50)* y(6) +rxt(52)* y(7) +rxt(77)* y(17) &
                  +rxt(78)* y(18) +rxt(85)* y(20) +rxt(99)* y(21) +rxt(110)* y(30) &
                  +rxt(119)* y(34) +rxt(121)* y(35) +rxt(138)* y(41) +rxt(161)* y(57) &
                  +rxt(186)* y(72) +rxt(200)* y(79) +rxt(184)* y(83) + rxt(2) &
                  + rxt(3))* y(1)
         prod(67) = (.100*rxt(99)*y(21) +.200*rxt(119)*y(34) +.200*rxt(121)*y(35)) &
                 *y(1) + (.300*rxt(94)*y(25) +.300*rxt(131)*y(38))*y(18) +rxt(42)*y(2)
         loss(15) = ((rxt(47) +rxt(48))* y(4) +rxt(64)* y(12) +rxt(74)* y(61) +rxt(46) &
                 * y(84) + rxt(44) + rxt(45))* y(3)
         prod(15) =rxt(2)*y(1)
         loss(68) = (rxt(43)* y(1) +rxt(213)* y(6) +rxt(51)* y(7) +rxt(75)* y(17) &
                  +rxt(76)* y(18) +rxt(190)* y(71) +rxt(187)* y(73) +rxt(205)* y(76) &
                  + rxt(42))* y(2)
         prod(68) = (rxt(142) +rxt(143)*y(6) +rxt(214)*y(7))*y(5) + (rxt(3) + &
                 .765*rxt(138)*y(41))*y(1) + (rxt(44) +rxt(45))*y(3) +rxt(5)*y(6) &
                  +rxt(6)*y(7) +.890*rxt(9)*y(8) +rxt(82)*y(17)*y(17) +rxt(40)*y(80)
         loss(14) = (rxt(143)* y(6) +rxt(214)* y(7) + rxt(142))* y(5)
         prod(14) =rxt(5)*y(6)
         loss(70) = (rxt(50)* y(1) +rxt(213)* y(2) +rxt(143)* y(5) +rxt(59)* y(8) &
                  +rxt(65)* y(13) +rxt(49)* y(18) +rxt(87)* y(22) +rxt(92)* y(25) &
                  +rxt(113)* y(33) + (rxt(122) +rxt(123))* y(36) +rxt(129)* y(38) &
                  +rxt(101)* y(39) +rxt(145)* y(43) +rxt(107)* y(51) +rxt(150)* y(54) &
                  +rxt(155)* y(56) +rxt(164)* y(58) +rxt(188)* y(73) +rxt(204)* y(80) &
                  + rxt(5))* y(6)
         prod(70) = (rxt(6) +rxt(51)*y(2) +rxt(211)*y(8))*y(7) +2.000*rxt(47)*y(4) &
                 *y(3) +rxt(142)*y(5) +.110*rxt(9)*y(8)
         loss(76) = (rxt(52)* y(1) +rxt(51)* y(2) +rxt(214)* y(5) +rxt(54)* y(8) &
                  +rxt(57)* y(17) +rxt(60)* y(18) +rxt(93)* y(25) +rxt(135)* y(38) &
                  +rxt(189)* y(73) +rxt(201)* y(80) + rxt(6))* y(7)
         prod(76) = (rxt(49)*y(18) +rxt(50)*y(1) +2.000*rxt(59)*y(8) +rxt(65)*y(13) + &
                 rxt(87)*y(22) +rxt(92)*y(25) +rxt(101)*y(39) +rxt(107)*y(51) + &
                 .920*rxt(113)*y(33) +rxt(122)*y(36) +rxt(129)*y(38) +rxt(145)*y(43) + &
                 rxt(150)*y(54) +1.206*rxt(155)*y(56) +rxt(164)*y(58) + &
                 rxt(188)*y(73) +rxt(204)*y(80) +rxt(213)*y(2))*y(6) + (.890*rxt(9) + &
                 rxt(53)*y(18) +rxt(114)*y(33) +rxt(124)*y(36) +rxt(130)*y(38) + &
                 rxt(139)*y(41) +1.206*rxt(156)*y(56) +rxt(162)*y(57) + &
                 rxt(165)*y(58) +rxt(181)*y(65) +2.000*rxt(212)*y(8))*y(8) &
                  + (rxt(10) +rxt(62) +rxt(61)*y(17))*y(10) + (rxt(7) +rxt(55) + &
                 rxt(216)*y(69))*y(11) + (rxt(30) +.400*rxt(160)*y(17) + &
                 .400*rxt(161)*y(1))*y(57) + (.600*rxt(19) +rxt(97))*y(27) &
                  + (rxt(20) +rxt(136))*y(32) +rxt(8)*y(9) +rxt(153)*y(28)*y(17) &
                  +.206*rxt(157)*y(56)*y(18)
         loss(65) = (rxt(59)* y(6) + (rxt(54) +rxt(211))* y(7) + 2.*rxt(212)* y(8) &
                  +rxt(70)* y(15) +rxt(53)* y(18) +rxt(86)* y(20) +rxt(154)* y(21) &
                  +rxt(91)* y(23) +rxt(114)* y(33) +rxt(124)* y(36) +rxt(130)* y(38) &
                  +rxt(139)* y(41) +rxt(159)* y(55) +rxt(156)* y(56) +rxt(162)* y(57) &
                  +rxt(165)* y(58) +rxt(181)* y(65) + rxt(9) + rxt(141))* y(8)
         prod(65) = (rxt(58)*y(9) +.500*rxt(174)*y(32) +rxt(175)*y(27))*y(17) &
                  + (rxt(7) +rxt(55))*y(11) + (rxt(34) +rxt(190)*y(2))*y(71) &
                  +rxt(52)*y(7)*y(1) +.400*rxt(19)*y(27) +rxt(37)*y(78)
         loss(39) = (rxt(58)* y(17) + rxt(8))* y(9)
         prod(39) = (rxt(141) +rxt(70)*y(15) +rxt(91)*y(23) +rxt(159)*y(55))*y(8) &
                  + (2.000*rxt(140) +2.000*rxt(56)*y(84) +2.000*rxt(217)*y(84) + &
                 rxt(216)*y(69))*y(11) + (rxt(218)*y(84) +rxt(219)*y(69))*y(71) &
                  +rxt(57)*y(17)*y(7) +rxt(223)*y(84)*y(78)
         loss(19) = (rxt(61)* y(17) + rxt(10) + rxt(62))* y(10)
         prod(19) =rxt(60)*y(18)*y(7)
         loss(29) = (rxt(216)* y(69) + (rxt(56) +rxt(217))* y(84) + rxt(7) + rxt(55) &
                  + rxt(140))* y(11)
         prod(29) =rxt(54)*y(8)*y(7)
         loss(64) = (rxt(65)* y(6) + 2.*(rxt(66) +rxt(67))* y(13) +rxt(68)* y(18) &
                  +rxt(95)* y(25) +rxt(116)* y(33) +rxt(126)* y(36) +rxt(132)* y(38) &
                  +rxt(103)* y(39) +rxt(147)* y(43) +rxt(167)* y(58))* y(13)
         prod(64) = (rxt(92)*y(6) +.900*rxt(95)*y(13) +2.000*rxt(98)*y(25) + &
                 rxt(117)*y(33) +rxt(127)*y(36) +rxt(133)*y(38) +rxt(168)*y(58))*y(25) &
                  + (rxt(63)*y(17) +.750*rxt(64)*y(3) +rxt(191)*y(72))*y(12) &
                  +.310*rxt(85)*y(20)*y(1) +.700*rxt(69)*y(17)*y(14) +rxt(16)*y(23) &
                  +rxt(18)*y(26) +.400*rxt(19)*y(27) +.300*rxt(23)*y(34) +rxt(27) &
                 *y(45)
         loss(25) = (rxt(69)* y(17) + rxt(11))* y(14)
         prod(25) =rxt(68)*y(18)*y(13)
         loss(74) = (rxt(70)* y(8) +rxt(71)* y(17) +rxt(196)* y(72) +rxt(207)* y(79) &
                  + rxt(12) + rxt(13))* y(15)
         prod(74) = (rxt(65)*y(6) +2.000*rxt(66)*y(13) +rxt(67)*y(13) +rxt(95)*y(25) + &
                 .700*rxt(103)*y(39) +1.200*rxt(116)*y(33) +.880*rxt(126)*y(36) + &
                 2.000*rxt(132)*y(38) +rxt(147)*y(43) +.700*rxt(167)*y(58))*y(13) &
                  + (.540*rxt(85)*y(20) +.600*rxt(99)*y(21) +rxt(110)*y(30) + &
                 .800*rxt(119)*y(34) +.700*rxt(121)*y(35) +1.326*rxt(138)*y(41))*y(1) &
                  + (rxt(87)*y(22) +.550*rxt(113)*y(33) +.250*rxt(122)*y(36) + &
                 rxt(129)*y(38) +rxt(150)*y(54) +.072*rxt(155)*y(56))*y(6) &
                  + (.300*rxt(69)*y(14) +.500*rxt(96)*y(26) +.500*rxt(106)*y(30) + &
                 rxt(172)*y(47) +.500*rxt(174)*y(32) +rxt(175)*y(27))*y(17) &
                  + (.600*rxt(114)*y(33) +.250*rxt(124)*y(36) +rxt(130)*y(38) + &
                 .072*rxt(156)*y(56))*y(8) + (.600*rxt(117)*y(33) + &
                 .250*rxt(127)*y(36) +rxt(133)*y(38))*y(25) +.250*rxt(64)*y(12)*y(3) &
                  +rxt(11)*y(14) +.008*rxt(157)*y(56)*y(18) +rxt(17)*y(24) &
                  +1.340*rxt(21)*y(35) +2.000*rxt(134)*y(38)*y(38) +rxt(26)*y(46) &
                  +rxt(33)*y(49) +rxt(32)*y(50) +2.000*rxt(109)*y(52) +rxt(30)*y(57) &
                  +.690*rxt(31)*y(60)
         loss(75) = (rxt(77)* y(1) +rxt(75)* y(2) +rxt(57)* y(7) +rxt(58)* y(9) &
                  +rxt(61)* y(10) +rxt(63)* y(12) +rxt(69)* y(14) +rxt(71)* y(15) &
                  + (rxt(72) +rxt(73))* y(16) + 2.*(rxt(82) +rxt(197))* y(17) +rxt(81) &
                 * y(18) +rxt(80)* y(19) +rxt(84)* y(20) +rxt(111)* y(21) +rxt(90) &
                 * y(23) +rxt(89)* y(24) +rxt(96)* y(26) +rxt(175)* y(27) +rxt(153) &
                 * y(28) +rxt(100)* y(29) +rxt(106)* y(30) +rxt(112)* y(31) +rxt(174) &
                 * y(32) +rxt(118)* y(34) +rxt(120)* y(35) +rxt(128)* y(37) +rxt(105) &
                 * y(40) +rxt(137)* y(41) +rxt(144)* y(42) +rxt(148)* y(44) +rxt(149) &
                 * y(45) +rxt(152)* y(46) +rxt(172)* y(47) +rxt(173)* y(48) +rxt(177) &
                 * y(49) +rxt(176)* y(50) +rxt(163)* y(53) +rxt(158)* y(55) +rxt(160) &
                 * y(57) +rxt(169)* y(59) +rxt(171)* y(60) +rxt(83)* y(61) +rxt(178) &
                 * y(63) + (rxt(179) +rxt(180))* y(65) +rxt(183)* y(66) +rxt(192) &
                 * y(69) + (rxt(195) +rxt(210))* y(73) +rxt(208)* y(77))* y(17)
         prod(75) = (rxt(78)*y(18) +.330*rxt(85)*y(20) +.270*rxt(99)*y(21) + &
                 .120*rxt(110)*y(30) +.080*rxt(119)*y(34) +.215*rxt(121)*y(35) + &
                 1.156*rxt(138)*y(41) +rxt(184)*y(83))*y(1) + (.300*rxt(69)*y(14) + &
                 .500*rxt(89)*y(24) +.500*rxt(105)*y(40) +.100*rxt(128)*y(37))*y(17) &
                  + (2.000*rxt(46)*y(84) +.750*rxt(64)*y(12) +rxt(74)*y(61))*y(3) &
                  + (rxt(49)*y(6) +rxt(53)*y(8) +rxt(76)*y(2))*y(18) + (rxt(38) + &
                 rxt(205)*y(2))*y(76) +rxt(8)*y(9) +rxt(11)*y(14) +2.000*rxt(15)*y(19) &
                  +rxt(17)*y(24) +rxt(18)*y(26) +.660*rxt(22)*y(35) +rxt(24)*y(40) &
                  +rxt(25)*y(44) +rxt(26)*y(46) +rxt(29)*y(59) +rxt(35)*y(70)
         loss(71) = (rxt(78)* y(1) +rxt(76)* y(2) +rxt(49)* y(6) +rxt(60)* y(7) &
                  +rxt(53)* y(8) +rxt(68)* y(13) +rxt(81)* y(17) + 2.*rxt(79)* y(18) &
                  +rxt(88)* y(22) +rxt(94)* y(25) +rxt(115)* y(33) +rxt(125)* y(36) &
                  +rxt(131)* y(38) +rxt(102)* y(39) +rxt(146)* y(43) +rxt(151)* y(54) &
                  +rxt(157)* y(56) +rxt(166)* y(58) +rxt(193)* y(72) +rxt(194)* y(73) &
                  +rxt(206)* y(79) +rxt(203)* y(80))* y(18)
         prod(71) = (rxt(72)*y(16) +rxt(83)*y(61) +rxt(71)*y(15) +rxt(77)*y(1) + &
                 rxt(80)*y(19) +.250*rxt(106)*y(30) +.200*rxt(128)*y(37) + &
                 rxt(160)*y(57) +rxt(172)*y(47) +rxt(173)*y(48) +.500*rxt(174)*y(32) + &
                 rxt(176)*y(50) +.600*rxt(177)*y(49) +rxt(195)*y(73))*y(17) &
                  + (rxt(65)*y(6) +2.000*rxt(66)*y(13) +.900*rxt(95)*y(25) + &
                 rxt(103)*y(39) +rxt(116)*y(33) +.730*rxt(126)*y(36) +rxt(132)*y(38) + &
                 rxt(147)*y(43) +rxt(167)*y(58))*y(13) + (.190*rxt(85)*y(20) + &
                 .060*rxt(99)*y(21) +.120*rxt(110)*y(30) +.060*rxt(119)*y(34) + &
                 .275*rxt(121)*y(35) +.102*rxt(138)*y(41) +rxt(161)*y(57))*y(1) &
                  + (rxt(87)*y(22) +rxt(101)*y(39) +rxt(113)*y(33) + &
                 .470*rxt(122)*y(36) +rxt(145)*y(43) +.794*rxt(155)*y(56) + &
                 1.500*rxt(164)*y(58))*y(6) + (rxt(70)*y(15) +rxt(114)*y(33) + &
                 .470*rxt(124)*y(36) +.794*rxt(156)*y(56) +rxt(162)*y(57) + &
                 1.500*rxt(165)*y(58))*y(8) + (rxt(12) +rxt(196)*y(72) + &
                 rxt(207)*y(79))*y(15) + (rxt(117)*y(33) +.470*rxt(127)*y(36) + &
                 1.500*rxt(168)*y(58))*y(25) + (.200*rxt(64)*y(12) +rxt(74)*y(61)) &
                 *y(3) + (rxt(10) +rxt(62))*y(10) + (rxt(108) +rxt(109))*y(52) &
                  +rxt(11)*y(14) +.794*rxt(157)*y(56)*y(18) +rxt(16)*y(23) +rxt(17) &
                 *y(24) +1.340*rxt(21)*y(35) +1.200*rxt(104)*y(39)*y(39) +rxt(24) &
                 *y(40) +rxt(25)*y(44) +2.000*rxt(33)*y(49) +rxt(32)*y(50) +rxt(28) &
                 *y(55) +rxt(30)*y(57) +rxt(31)*y(60) +rxt(185)*y(83)
         loss(10) = (rxt(80)* y(17) + rxt(15))* y(19)
         prod(10) =rxt(197)*y(17)*y(17) +rxt(79)*y(18)*y(18)
         loss(50) = (rxt(85)* y(1) +rxt(86)* y(8) +rxt(84)* y(17))* y(20)
         prod(50) = (.070*rxt(99)*y(21) +.119*rxt(138)*y(41))*y(1) +.700*rxt(23)*y(34)
         loss(47) = (rxt(99)* y(1) +rxt(154)* y(8) +rxt(111)* y(17))* y(21)
         prod(47) = 0.
         loss(41) = (rxt(87)* y(6) +rxt(88)* y(18))* y(22)
         prod(41) = (rxt(84)*y(20) +.500*rxt(89)*y(24))*y(17)
         loss(51) = (rxt(91)* y(8) +rxt(90)* y(17) + rxt(16))* y(23)
         prod(51) = (rxt(87)*y(22) +rxt(101)*y(39) +.270*rxt(145)*y(43))*y(6) &
                  + (.500*rxt(85)*y(20) +.040*rxt(119)*y(34))*y(1) &
                  + (.500*rxt(105)*y(40) +rxt(173)*y(48))*y(17) &
                  + (.800*rxt(103)*y(13) +1.600*rxt(104)*y(39))*y(39) +rxt(17)*y(24) &
                  +rxt(24)*y(40)
         loss(32) = (rxt(89)* y(17) + rxt(17))* y(24)
         prod(32) =rxt(88)*y(22)*y(18)
         loss(62) = (rxt(92)* y(6) +rxt(93)* y(7) +rxt(95)* y(13) +rxt(94)* y(18) &
                  + 2.*rxt(98)* y(25) +rxt(117)* y(33) +rxt(127)* y(36) +rxt(168) &
                 * y(58))* y(25)
         prod(62) = (rxt(91)*y(23) +.530*rxt(124)*y(36) +rxt(130)*y(38) + &
                 rxt(159)*y(55))*y(8) + (.530*rxt(122)*y(36) +rxt(129)*y(38) + &
                 rxt(150)*y(54))*y(6) + (rxt(90)*y(23) +.500*rxt(96)*y(26) + &
                 rxt(158)*y(55))*y(17) + (.260*rxt(126)*y(36) +rxt(132)*y(38))*y(13) &
                  + (.600*rxt(19) +rxt(97))*y(27) +.530*rxt(127)*y(36)*y(25) &
                  +.300*rxt(23)*y(34) +1.340*rxt(21)*y(35) +2.000*rxt(134)*y(38)*y(38) &
                  +rxt(27)*y(45) +rxt(26)*y(46) +rxt(32)*y(50) +rxt(28)*y(55)
         loss(30) = (rxt(96)* y(17) + rxt(18))* y(26)
         prod(30) = (.700*rxt(94)*y(25) +.700*rxt(131)*y(38))*y(18)
         loss(33) = (rxt(175)* y(17) + rxt(19) + rxt(97))* y(27)
         prod(33) =rxt(93)*y(25)*y(7)
         loss(17) = (rxt(153)* y(17))* y(28)
         prod(17) =rxt(86)*y(20)*y(8)
         loss(20) = (rxt(110)* y(1) +rxt(106)* y(17))* y(30)
         prod(20) = 0.
         loss(6) = (rxt(112)* y(17))* y(31)
         prod(6) = 0.
         loss(35) = (rxt(174)* y(17) + rxt(20) + rxt(136))* y(32)
         prod(35) =rxt(135)*y(38)*y(7)
         loss(60) = (rxt(113)* y(6) +rxt(114)* y(8) +rxt(116)* y(13) +rxt(115)* y(18) &
                  +rxt(117)* y(25))* y(33)
         prod(60) = (rxt(111)*y(21) +1.640*rxt(137)*y(41) +.500*rxt(171)*y(60))*y(17) &
                  +1.700*rxt(139)*y(41)*y(8)
         loss(58) = (rxt(119)* y(1) +rxt(118)* y(17) + rxt(23))* y(34)
         prod(58) = (.320*rxt(113)*y(6) +.350*rxt(114)*y(8) +.260*rxt(116)*y(13) + &
                 .350*rxt(117)*y(25))*y(33) + (.039*rxt(155)*y(6) + &
                 .039*rxt(156)*y(8) +.039*rxt(157)*y(18))*y(56) &
                  + (.200*rxt(99)*y(21) +.442*rxt(138)*y(41))*y(1) +.402*rxt(31)*y(60)
         loss(56) = (rxt(121)* y(1) +rxt(120)* y(17) + rxt(21) + rxt(22))* y(35)
         prod(56) = (.230*rxt(113)*y(6) +.250*rxt(114)*y(8) +.190*rxt(116)*y(13) + &
                 .250*rxt(117)*y(25))*y(33) + (.167*rxt(155)*y(6) + &
                 .167*rxt(156)*y(8) +.167*rxt(157)*y(18))*y(56) &
                  + (.400*rxt(99)*y(21) +1.122*rxt(138)*y(41))*y(1) +.288*rxt(31) &
                 *y(60)
         loss(61) = ((rxt(122) +rxt(123))* y(6) +rxt(124)* y(8) +rxt(126)* y(13) &
                  +rxt(125)* y(18) +rxt(127)* y(25))* y(36)
         prod(61) = (rxt(118)*y(34) +.500*rxt(120)*y(35) +.200*rxt(128)*y(37))*y(17)
         loss(21) = (rxt(128)* y(17))* y(37)
         prod(21) =rxt(125)*y(36)*y(18)
         loss(63) = (rxt(129)* y(6) +rxt(135)* y(7) +rxt(130)* y(8) +rxt(132)* y(13) &
                  +rxt(131)* y(18) +rxt(133)* y(25) + 2.*rxt(134)* y(38))* y(38)
         prod(63) = (.500*rxt(120)*y(35) +.500*rxt(128)*y(37) +.800*rxt(177)*y(49)) &
                 *y(17) + (rxt(20) +rxt(136))*y(32) +.200*rxt(99)*y(21)*y(1) &
                  +.660*rxt(21)*y(35)
         loss(40) = (rxt(101)* y(6) +rxt(103)* y(13) +rxt(102)* y(18) + 2.*rxt(104) &
                 * y(39))* y(39)
         prod(40) = (rxt(100)*y(29) +.500*rxt(105)*y(40))*y(17)
         loss(22) = (rxt(105)* y(17) + rxt(24))* y(40)
         prod(22) =rxt(102)*y(39)*y(18)
         loss(48) = (rxt(138)* y(1) +rxt(139)* y(8) +rxt(137)* y(17))* y(41)
         prod(48) = 0.
         loss(45) = (rxt(145)* y(6) +rxt(147)* y(13) +rxt(146)* y(18))* y(43)
         prod(45) = (rxt(144)*y(42) +1.330*rxt(112)*y(31) +rxt(148)*y(44))*y(17)
         loss(23) = (rxt(148)* y(17) + rxt(25))* y(44)
         prod(23) =rxt(146)*y(43)*y(18)
         loss(37) = (rxt(149)* y(17) + rxt(27))* y(45)
         prod(37) = (.820*rxt(145)*y(6) +.820*rxt(147)*y(13))*y(43) &
                  +.100*rxt(137)*y(41)*y(17) +.820*rxt(25)*y(44)
         loss(24) = (rxt(152)* y(17) + rxt(26))* y(46)
         prod(24) =rxt(151)*y(54)*y(18)
         loss(34) = (rxt(172)* y(17))* y(47)
         prod(34) = (rxt(67)*y(13) +.300*rxt(103)*y(39) +.250*rxt(116)*y(33) + &
                 .250*rxt(126)*y(36) +.300*rxt(167)*y(58))*y(13)
         loss(18) = (rxt(173)* y(17))* y(48)
         prod(18) = (.200*rxt(103)*y(13) +.400*rxt(104)*y(39))*y(39)
         loss(42) = (rxt(177)* y(17) + rxt(33))* y(49)
         prod(42) = (.530*rxt(122)*y(6) +.530*rxt(124)*y(8) +.260*rxt(126)*y(13) + &
                 .530*rxt(127)*y(25))*y(36) + (.250*rxt(164)*y(6) + &
                 .250*rxt(165)*y(8) +.100*rxt(167)*y(13) +.250*rxt(168)*y(25))*y(58) &
                  +rxt(108)*y(52)
         loss(55) = (rxt(176)* y(17) + rxt(32))* y(50)
         prod(55) = (.220*rxt(122)*y(6) +.220*rxt(124)*y(8) +.230*rxt(126)*y(13) + &
                 .220*rxt(127)*y(25))*y(36) + (.250*rxt(164)*y(6) + &
                 .250*rxt(165)*y(8) +.100*rxt(167)*y(13) +.250*rxt(168)*y(25))*y(58) &
                  + (.500*rxt(89)*y(24) +.500*rxt(174)*y(32))*y(17)
         loss(28) = (rxt(107)* y(6))* y(51)
         prod(28) =.750*rxt(106)*y(30)*y(17)
         loss(11) = ( + rxt(108) + rxt(109))* y(52)
         prod(11) =rxt(107)*y(51)*y(6)
         loss(31) = (rxt(163)* y(17))* y(53)
         prod(31) = (.370*rxt(113)*y(6) +.400*rxt(114)*y(8) +.300*rxt(116)*y(13) + &
                 .400*rxt(117)*y(25))*y(33) + (.400*rxt(160)*y(17) + &
                 .400*rxt(161)*y(1))*y(57)
         loss(44) = (rxt(150)* y(6) +rxt(151)* y(18))* y(54)
         prod(44) = (rxt(149)*y(45) +rxt(152)*y(46))*y(17)
         loss(54) = (rxt(159)* y(8) +rxt(158)* y(17) + rxt(28))* y(55)
         prod(54) = (.250*rxt(122)*y(6) +.250*rxt(124)*y(8) +.240*rxt(126)*y(13) + &
                 .250*rxt(127)*y(25))*y(36) + (.250*rxt(164)*y(6) + &
                 .250*rxt(165)*y(8) +.100*rxt(167)*y(13) +.250*rxt(168)*y(25))*y(58) &
                  + (.950*rxt(119)*y(34) +.800*rxt(121)*y(35))*y(1) &
                  + (rxt(153)*y(28) +rxt(176)*y(50))*y(17)
         loss(43) = (rxt(155)* y(6) +rxt(156)* y(8) +rxt(157)* y(18))* y(56)
         prod(43) =rxt(154)*y(21)*y(8)
         loss(52) = (rxt(161)* y(1) +rxt(162)* y(8) +rxt(160)* y(17) + rxt(30))* y(57)
         prod(52) = (.080*rxt(113)*y(33) +rxt(123)*y(36) +.794*rxt(155)*y(56))*y(6) &
                  + (.794*rxt(156)*y(8) +.794*rxt(157)*y(18))*y(56)
         loss(59) = (rxt(164)* y(6) +rxt(165)* y(8) +rxt(167)* y(13) +rxt(166)* y(18) &
                  +rxt(168)* y(25))* y(58)
         prod(59) = (rxt(163)*y(53) +rxt(169)*y(59) +.500*rxt(171)*y(60))*y(17)
         loss(12) = ((rxt(169) +rxt(170))* y(17) + rxt(29))* y(59)
         prod(12) =rxt(166)*y(58)*y(18)
         loss(36) = (rxt(171)* y(17) + rxt(31))* y(60)
         prod(36) =rxt(115)*y(33)*y(18)
         loss(8) = (rxt(178)* y(17))* y(63)
         prod(8) = (rxt(179)*y(17) +.750*rxt(180)*y(17) +rxt(181)*y(8))*y(65)
         loss(1) = 0.
         prod(1) =rxt(178)*y(63)*y(17)
         loss(13) = (rxt(181)* y(8) + (rxt(179) +rxt(180))* y(17))* y(65)
         prod(13) = 0.
         loss(5) = (rxt(183)* y(17) + rxt(182))* y(66)
         prod(5) = 0.
         loss(2) = 0.
         prod(2) = 0.
         loss(3) = 0.
         prod(3) =rxt(182)*y(66)
         loss(69) = (rxt(216)* y(11) +rxt(192)* y(17) +rxt(215)* y(70) +rxt(219) &
                 * y(71) +rxt(220)* y(76))* y(69)
         prod(69) = (rxt(191)*y(12) +rxt(193)*y(18) +rxt(196)*y(15))*y(72) &
                  +rxt(210)*y(73)*y(17)
         loss(38) = (rxt(215)* y(69) +rxt(221)* y(77) + rxt(35))* y(70)
         prod(38) =rxt(194)*y(73)*y(18) +rxt(218)*y(84)*y(71)
         loss(46) = (rxt(190)* y(2) +rxt(219)* y(69) +rxt(218)* y(84) + rxt(34)) &
                 * y(71)
         prod(46) =rxt(189)*y(73)*y(7)
         loss(57) = (rxt(186)* y(1) +rxt(191)* y(12) +rxt(196)* y(15) +rxt(193)* y(18) &
                 )* y(72)
         prod(57) = (rxt(187)*y(2) +rxt(188)*y(6) +rxt(195)*y(17) +rxt(202)*y(80)) &
                 *y(73) + (rxt(192)*y(17) +rxt(216)*y(11))*y(69) +rxt(35)*y(70) &
                  +rxt(34)*y(71) +2.000*rxt(36)*y(74) +2.000*rxt(41)*y(75) +rxt(39) &
                 *y(81)
         loss(66) = (rxt(187)* y(2) +rxt(188)* y(6) +rxt(189)* y(7) + (rxt(195) + &
                 rxt(210))* y(17) +rxt(194)* y(18) + 2.*rxt(198)* y(73) + (rxt(202) + &
                 rxt(209))* y(80))* y(73)
         prod(66) =rxt(186)*y(72)*y(1) +rxt(190)*y(71)*y(2) +2.000*rxt(199)*y(74)
         loss(7) = ( + rxt(36) + rxt(199))* y(74)
         prod(7) =rxt(198)*y(73)*y(73)
         loss(9) = ( + rxt(41))* y(75)
         prod(9) = (rxt(215)*y(70) +rxt(219)*y(71))*y(69)
         loss(49) = (rxt(205)* y(2) +rxt(220)* y(69) +rxt(222)* y(77) + rxt(38)) &
                 * y(76)
         prod(49) =rxt(203)*y(80)*y(18) +rxt(223)*y(84)*y(78)
         loss(53) = (rxt(208)* y(17) +rxt(221)* y(70) +rxt(222)* y(76))* y(77)
         prod(53) = (rxt(206)*y(18) +rxt(207)*y(15))*y(79)
         loss(16) = (rxt(223)* y(84) + rxt(37))* y(78)
         prod(16) =rxt(201)*y(80)*y(7)
         loss(72) = (rxt(200)* y(1) +rxt(207)* y(15) +rxt(206)* y(18))* y(79)
         prod(72) = (rxt(40) +rxt(202)*y(73) +rxt(204)*y(6))*y(80) + (rxt(38) + &
                 2.000*rxt(222)*y(77))*y(76) +rxt(208)*y(77)*y(17) +rxt(37)*y(78) &
                  +rxt(39)*y(81)
         loss(73) = (rxt(204)* y(6) +rxt(201)* y(7) +rxt(203)* y(18) + (rxt(202) + &
                 rxt(209))* y(73) + rxt(40))* y(80)
         prod(73) =rxt(200)*y(79)*y(1) +rxt(205)*y(76)*y(2)
         loss(26) = ( + rxt(39))* y(81)
         prod(26) =rxt(220)*y(76)*y(69) +rxt(221)*y(77)*y(70) +rxt(209)*y(80)*y(73)
         loss(4) = ( + rxt(224))* y(82)
         prod(4) =rxt(63)*y(17)*y(12)
         loss(27) = (rxt(184)* y(1) + rxt(185))* y(83)
         prod(27) = (rxt(73)*y(16) +rxt(75)*y(2))*y(17) +.200*rxt(64)*y(12)*y(3) &
                  +rxt(12)*y(15)

      end subroutine imp_prod_loss

      end module MO_IMP_PROD_LOSS_MOD

      module MO_RODAS_PROD_LOSS_MOD

      contains

      subroutine rodas_prod_loss( prod, loss, y, rxt, het_rates )

      use CHEM_MODS_MOD, only : clscnt5, rxntot, hetcnt, clsze
      use MO_GRID_MOD,   only : pcnstm1

      implicit none

!--------------------------------------------------------------------
!     ... Dummy args                                                                      
!--------------------------------------------------------------------
      real, dimension(:), intent(out) :: &
            prod, &
            loss
      real, intent(in)    ::  y(:)
      real, intent(in)    ::  rxt(:)
      real, intent(in)    ::  het_rates(:)


      end subroutine rodas_prod_loss

      end module MO_RODAS_PROD_LOSS_MOD

      module MO_INDPRD_MOD

      private
      public :: indprd

      contains

      subroutine indprd( class, prod, y, extfrc, rxt )

      implicit none

!--------------------------------------------------------------------
!       ... Dummy arguments
!--------------------------------------------------------------------
      integer, intent(in) :: class
      real, intent(in)    :: y(:,:)
      real, intent(in)    :: rxt(:,:)
      real, intent(in)    :: extfrc(:,:)
      real, intent(inout) :: prod(:,:)

!--------------------------------------------------------------------
!       ... "Independent" production for Explicit species
!--------------------------------------------------------------------
      if( class == 1 ) then
         prod(:,1) =rxt(:,214)*y(:,7)*y(:,5)
                                                                                          
         prod(:,2) =.080*rxt(:,85)*y(:,20)*y(:,1)
                                                                                          
         prod(:,3) = (.560*rxt(:,85)*y(:,20) +.300*rxt(:,99)*y(:,21) + &
                 .500*rxt(:,110)*y(:,30) +.050*rxt(:,119)*y(:,34) + &
                 .200*rxt(:,121)*y(:,35) +.323*rxt(:,138)*y(:,41))*y(:,1) &
                  + (rxt(:,12) +rxt(:,13) +rxt(:,70)*y(:,8) +rxt(:,71)*y(:,17) + &
                 rxt(:,196)*y(:,72) +rxt(:,207)*y(:,79))*y(:,15) &
                  + (.220*rxt(:,122)*y(:,6) +.220*rxt(:,124)*y(:,8) + &
                 .110*rxt(:,126)*y(:,13) +.220*rxt(:,127)*y(:,25))*y(:,36) &
                  + (rxt(:,164)*y(:,6) +rxt(:,165)*y(:,8) +.400*rxt(:,167)*y(:,13) + &
                 rxt(:,168)*y(:,25))*y(:,58) + (rxt(:,28) +rxt(:,158)*y(:,17) + &
                 rxt(:,159)*y(:,8))*y(:,55) + (rxt(:,33) +.400*rxt(:,177)*y(:,17)) &
                 *y(:,49) +rxt(:,16)*y(:,23) +.700*rxt(:,23)*y(:,34) +1.340*rxt(:,22) &
                 *y(:,35) +rxt(:,30)*y(:,57)
 
         prod(:,4) = 0.

         prod(:,5) = 0.
 
         prod(:,6) =rxt(:,13)*y(:,15)
 
         prod(:,7) = 0.
 
         prod(:,8) = (rxt(:,58)*y(:,9) +rxt(:,61)*y(:,10) +rxt(:,69)*y(:,14) + &
                 rxt(:,71)*y(:,15) +rxt(:,80)*y(:,19) +rxt(:,81)*y(:,18) + &
                 rxt(:,82)*y(:,17) +rxt(:,89)*y(:,24) +rxt(:,90)*y(:,23) + &
                 rxt(:,96)*y(:,26) +.500*rxt(:,120)*y(:,35) +rxt(:,148)*y(:,44) + &
                 rxt(:,149)*y(:,45) +rxt(:,152)*y(:,46) +rxt(:,158)*y(:,55) + &
                 rxt(:,169)*y(:,59) +rxt(:,170)*y(:,59) +rxt(:,183)*y(:,66) + &
                 rxt(:,192)*y(:,69) +rxt(:,208)*y(:,77))*y(:,17) &
                  + (rxt(:,215)*y(:,70) +rxt(:,220)*y(:,76))*y(:,69) &
                  + (rxt(:,221)*y(:,70) +rxt(:,222)*y(:,76))*y(:,77)
                                                                                          
!--------------------------------------------------------------------
!       ... "Independent" production for Implicit species
!--------------------------------------------------------------------
      else if( class == 4 ) then
         prod(:,67) = 0.
                                                                                          
         prod(:,15) =rxt(:,4)*y(:,4)
                                                                                          
         prod(:,68) =2.000*rxt(:,1)
                                                                                          
         prod(:,14) = 0.
                                                                                          
         prod(:,70) = 0.
                                                                                          
         prod(:,76) = 0.
                                                                                          
         prod(:,65) = 0.
                                                                                          
         prod(:,39) = 0.
                                                                                          
         prod(:,19) = 0.
                                                                                          
         prod(:,29) = 0.
                                                                                          
         prod(:,64) = 0.
                                                                                          
         prod(:,25) = 0.
                                                                                          
         prod(:,74) = 0.
                                                                                          
         prod(:,75) =rxt(:,14)*y(:,84)
                                                                                          
         prod(:,71) = 0.
                                                                                          
         prod(:,10) = 0.
                                                                                          
         prod(:,50) = 0.
                                                                                          
         prod(:,47) = 0.
                                                                                          
         prod(:,41) = 0.
                                                                                          
         prod(:,51) = 0.
                                                                                          
         prod(:,32) = 0.
                                                                                          
         prod(:,62) = 0.
                                                                                          
         prod(:,30) = 0.
                                                                                          
         prod(:,33) = 0.
                                                                                          
         prod(:,17) = 0.
                                                                                          
         prod(:,20) = 0.
                                                                                          
         prod(:,6) = 0.
                                                                                          
         prod(:,35) = 0.
                                                                                          
         prod(:,60) = 0.
                                                                                          
         prod(:,58) = 0.
                                                                                          
         prod(:,56) = 0.
                                                                                          
         prod(:,61) = 0.
                                                                                          
         prod(:,21) = 0.
                                                                                          
         prod(:,63) = 0.
                                                                                          
         prod(:,40) = 0.
                                                                                          
         prod(:,22) = 0.
                                                                                          
         prod(:,48) = 0.
                                                                                          
         prod(:,45) = 0.
                                                                                          
         prod(:,23) = 0.
                                                                                          
         prod(:,37) = 0.
                                                                                          
         prod(:,24) = 0.
                                                                                          
         prod(:,34) = 0.
                                                                                          
         prod(:,18) = 0.
                                                                                          
         prod(:,42) = 0.
                                                                                          
         prod(:,55) = 0.
                                                                                          
         prod(:,28) = 0.
                                                                                          
         prod(:,11) = 0.
                                                                                          
         prod(:,31) = 0.
                                                                                          
         prod(:,44) = 0.
                                                                                          
         prod(:,54) = 0.
                                                                                          
         prod(:,43) = 0.
                                                                                          
         prod(:,52) = 0.
                                                                                          
         prod(:,59) = 0.
                                                                                          
         prod(:,12) = 0.
                                                                                          
         prod(:,36) = 0.
                                                                                          
         prod(:,8) = 0.
                                                                                          
         prod(:,1) = 0.
                                                                                          
         prod(:,13) = 0.
                                                                                          
         prod(:,5) = 0.
                                                                                          
         prod(:,2) = 0.
                                                                                          
         prod(:,3) = 0.
                                                                                          
         prod(:,69) = 0.
                                                                                          
         prod(:,38) = 0.
                                                                                          
         prod(:,46) = 0.
                                                                                          
         prod(:,57) = 0.
                                                                                          
         prod(:,66) = 0.
                                                                                          
         prod(:,7) = 0.
                                                                                          
         prod(:,9) = 0.
                                                                                          
         prod(:,49) = 0.
                                                                                          
         prod(:,53) = 0.
                                                                                          
         prod(:,16) = 0.
                                                                                          
         prod(:,72) = 0.
                                                                                          
         prod(:,73) = 0.
                                                                                          
         prod(:,26) = 0.
                                                                                          
         prod(:,4) = 0.
                                                                                          
         prod(:,27) =rxt(:,14)*y(:,84)
                                                                                          
      end if                                                                              
                                                                                          
      end subroutine INDPRD                                                               
                                                                                          
      end module MO_INDPRD_MOD                                                                

      module MO_IMP_LIN_MATRIX_MOD

      contains

      subroutine imp_linmat01( mat, y, rxt, het_rates )
!----------------------------------------------
!       ... Linear Matrix entries for Implicit species
!----------------------------------------------

      use MO_GRID_MOD,   only : pcnstm1
      use CHEM_MODS_MOD, only : rxntot, hetcnt, imp_nzcnt, clsze

      implicit none

!----------------------------------------------
!       ... Dummy args
!----------------------------------------------
      real, intent(in)    ::  y(pcnstm1)
      real, intent(in)    ::  rxt(rxntot)
      real, intent(in)    ::  het_rates(hetcnt)
      real, intent(inout) ::  mat(imp_nzcnt)

         mat(560) = -( rxt(2) + rxt(3) )
         mat(578) = rxt(42)

         mat(38) = -( rxt(44) + rxt(45) + rxt(46)*y(84) + rxt(47)*y(4) + rxt(48)*y(4) &
                      + rxt(64)*y(12) + rxt(74)*y(61) )
         mat(536) = rxt(2)

         mat(579) = -( rxt(42) )
         mat(561) = rxt(3)
         mat(637) = rxt(5)
         mat(821) = rxt(6)
         mat(510) = .890*rxt(9)
         mat(715) = rxt(40)
         mat(41) = rxt(44) + rxt(45)
         mat(35) = rxt(142)

         mat(34) = -( rxt(142) )
         mat(611) = rxt(5)

         mat(639) = -( rxt(5) )
         mat(823) = rxt(6)
         mat(512) = .110*rxt(9)
         mat(36) = rxt(142)
         mat(42) = 2.000*rxt(47)*y(4)

         mat(829) = -( rxt(6) )
         mat(113) = rxt(7) + rxt(55)
         mat(172) = rxt(8)
         mat(516) = .890*rxt(9)
         mat(62) = rxt(10) + rxt(62)
         mat(135) = .600*rxt(19) + rxt(97)
         mat(147) = rxt(20) + rxt(136)
         mat(311) = rxt(30)

         mat(507) = -( rxt(9) + rxt(141) )
         mat(111) = rxt(7) + rxt(55)
         mat(132) = .400*rxt(19)
         mat(233) = rxt(34)
         mat(49) = rxt(37)

         mat(169) = -( rxt(8) )
         mat(109) = 2.000*rxt(140) + 2.000*rxt(56)*y(84) + 2.000*rxt(217)*y(84)
         mat(488) = rxt(141)
         mat(229) = rxt(218)*y(84)
         mat(47) = rxt(223)*y(84)

         mat(59) = -( rxt(10) + rxt(62) )

         mat(108) = -( rxt(7) + rxt(55) + rxt(140) + rxt(56)*y(84) + rxt(217)*y(84) )

         mat(298) = rxt(16)
         mat(116) = rxt(18)
         mat(131) = .400*rxt(19)
         mat(362) = .300*rxt(23)
         mat(159) = rxt(27)
         mat(790) = rxt(63)*y(12)
         mat(40) = .750*rxt(64)*y(12)
         mat(349) = rxt(191)*y(12)

         mat(89) = -( rxt(11) )

         mat(738) = -( rxt(12) + rxt(13) )
         mat(92) = rxt(11)
         mat(127) = rxt(17)
         mat(345) = 1.340*rxt(21)
         mat(87) = rxt(26)
         mat(309) = rxt(30)
         mat(154) = .690*rxt(31)
         mat(334) = rxt(32)
         mat(196) = rxt(33)
         mat(25) = 2.000*rxt(109)
         mat(44) = .250*rxt(64)*y(12)

         mat(801) = -( rxt(63)*y(12) + rxt(72)*y(16) + rxt(73)*y(16) + rxt(83)*y(61) &
                      + rxt(100)*y(29) + rxt(144)*y(42) )
         mat(171) = rxt(8)
         mat(93) = rxt(11)
         mat(21) = 2.000*rxt(15)
         mat(128) = rxt(17)
         mat(118) = rxt(18)
         mat(346) = .660*rxt(22)
         mat(78) = rxt(24)
         mat(83) = rxt(25)
         mat(88) = rxt(26)
         mat(28) = rxt(29)
         mat(168) = rxt(35)
         mat(280) = rxt(38)
         mat(45) = 2.000*rxt(46)*y(84) + .750*rxt(64)*y(12) + rxt(74)*y(61)

         mat(60) = rxt(10) + rxt(62)
         mat(91) = rxt(11)
         mat(735) = rxt(12)
         mat(300) = rxt(16)
         mat(126) = rxt(17)
         mat(344) = 1.340*rxt(21)
         mat(77) = rxt(24)
         mat(82) = rxt(25)
         mat(326) = rxt(28)
         mat(308) = rxt(30)
         mat(153) = rxt(31)
         mat(333) = rxt(32)
         mat(195) = 2.000*rxt(33)
         mat(24) = rxt(108) + rxt(109)
         mat(99) = rxt(185)
         mat(43) = .200*rxt(64)*y(12) + rxt(74)*y(61)
         mat(797) = rxt(72)*y(16) + rxt(83)*y(61)

         mat(19) = -( rxt(15) )

         mat(355) = .700*rxt(23)



         mat(296) = -( rxt(16) )
         mat(124) = rxt(17)
         mat(76) = rxt(24)

         mat(122) = -( rxt(17) )

         mat(130) = .600*rxt(19) + rxt(97)
         mat(340) = 1.340*rxt(21)
         mat(361) = .300*rxt(23)
         mat(86) = rxt(26)
         mat(158) = rxt(27)
         mat(324) = rxt(28)
         mat(331) = rxt(32)

         mat(114) = -( rxt(18) )

         mat(129) = -( rxt(19) + rxt(97) )




         mat(140) = -( rxt(20) + rxt(136) )


         mat(359) = -( rxt(23) )
         mat(150) = .402*rxt(31)

         mat(338) = -( rxt(21) + rxt(22) )
         mat(149) = .288*rxt(31)



         mat(142) = rxt(20) + rxt(136)
         mat(341) = .660*rxt(21)

         mat(769) = rxt(100)*y(29)

         mat(74) = -( rxt(24) )


         mat(773) = rxt(144)*y(42)

         mat(79) = -( rxt(25) )

         mat(156) = -( rxt(27) )
         mat(80) = .820*rxt(25)

         mat(84) = -( rxt(26) )



         mat(193) = -( rxt(33) )
         mat(23) = rxt(108)

         mat(330) = -( rxt(32) )


         mat(22) = -( rxt(108) + rxt(109) )



         mat(323) = -( rxt(28) )


         mat(304) = -( rxt(30) )


         mat(26) = -( rxt(29) )

         mat(148) = -( rxt(31) )




         mat(6) = -( rxt(182) )


         mat(5) = rxt(182)

         mat(352) = rxt(191)*y(12)

         mat(163) = -( rxt(35) )
         mat(228) = rxt(218)*y(84)

         mat(230) = -( rxt(34) + rxt(218)*y(84) )

         mat(348) = -( rxt(191)*y(12) )
         mat(232) = rxt(34)
         mat(165) = rxt(35)
         mat(12) = 2.000*rxt(36)
         mat(95) = rxt(39)
         mat(18) = 2.000*rxt(41)

         mat(13) = 2.000*rxt(199)

         mat(11) = -( rxt(36) + rxt(199) )

         mat(17) = -( rxt(41) )

         mat(273) = -( rxt(38) )
         mat(48) = rxt(223)*y(84)


         mat(46) = -( rxt(37) + rxt(223)*y(84) )

         mat(50) = rxt(37)
         mat(278) = rxt(38)
         mat(96) = rxt(39)
         mat(719) = rxt(40)

         mat(720) = -( rxt(40) )

         mat(94) = -( rxt(39) )

         mat(4) = -( rxt(224) )
         mat(742) = rxt(63)*y(12)

         mat(97) = -( rxt(185) )
         mat(724) = rxt(12)
         mat(39) = .200*rxt(64)*y(12)
         mat(758) = rxt(73)*y(16)


      end subroutine imp_linmat01

      subroutine imp_linmat( mat, y, rxt, het_rates )
!----------------------------------------------
!       ... Linear Matrix entries for Implicit species
!----------------------------------------------

      use MO_GRID_MOD,   only : pcnstm1
      use CHEM_MODS_MOD, only : rxntot, hetcnt, imp_nzcnt, clsze

      implicit none

!----------------------------------------------
!       ... Dummy args
!----------------------------------------------
      real, intent(in)    ::  y(pcnstm1)
      real, intent(in)    ::  rxt(rxntot)
      real, intent(in)    ::  het_rates(hetcnt)
      real, intent(inout) ::  mat(imp_nzcnt)

      call imp_linmat01( mat, y, rxt, het_rates )

      end subroutine imp_linmat

      end module MO_IMP_LIN_MATRIX_MOD

      module MO_ROD_LIN_MATRIX_MOD

      contains

      subroutine rod_linmat( mat, y, rxt, het_rates )
!----------------------------------------------
!       ... Linear Matrix entries for Implicit species
!----------------------------------------------

      use MO_GRID_MOD,   only : pcnstm1
      use CHEM_MODS_MOD, only : rxntot, hetcnt, rod_nzcnt, clsze

      implicit none

!----------------------------------------------
!       ... Dummy args
!----------------------------------------------
      real, intent(in)    ::  y(pcnstm1)
      real, intent(in)    ::  rxt(rxntot)
      real, intent(in)    ::  het_rates(hetcnt)
      real, intent(inout) ::  mat(rod_nzcnt)


      end subroutine rod_linmat

      end module MO_ROD_LIN_MATRIX_MOD

      module MO_IMP_NLN_MATRIX_MOD

      contains

      subroutine imp_nlnmat01( mat, y, rxt )

      use MO_GRID_MOD,   only : pcnstm1
      use CHEM_MODS_MOD, only : rxntot, imp_nzcnt, clsze

      implicit none

!----------------------------------------------
!       ... Dummy args
!----------------------------------------------
      real, intent(in)    ::  y(pcnstm1)
      real, intent(in)    ::  rxt(rxntot)
      real, intent(inout) ::  mat(imp_nzcnt)


!----------------------------------------------
!       ... Local variables
!----------------------------------------------

!----------------------------------------------
!       ... Complete matrix entries Implicit species
!----------------------------------------------

         mat(560) = -(rxt(43)*y(2) + rxt(50)*y(6) + rxt(52)*y(7) + rxt(77)*y(17) &
                      + rxt(78)*y(18) + rxt(85)*y(20) + rxt(99)*y(21) + rxt(110)*y(30) &
                      + rxt(119)*y(34) + rxt(121)*y(35) + rxt(138)*y(41) + rxt(161) &
                      *y(57) + rxt(184)*y(83) + rxt(186)*y(72) + rxt(200)*y(79))
         mat(578) = -rxt(43)*y(1)
         mat(636) = -rxt(50)*y(1)
         mat(820) = -rxt(52)*y(1)
         mat(793) = -rxt(77)*y(1)
         mat(680) = -rxt(78)*y(1)
         mat(289) = -rxt(85)*y(1)
         mat(249) = -rxt(99)*y(1)
         mat(65) = -rxt(110)*y(1)
         mat(364) = -rxt(119)*y(1)
         mat(343) = -rxt(121)*y(1)
         mat(265) = -rxt(138)*y(1)
         mat(307) = -rxt(161)*y(1)
         mat(98) = -rxt(184)*y(1)
         mat(351) = -rxt(186)*y(1)
         mat(695) = -rxt(200)*y(1)

         mat(560) = mat(560) + .100*rxt(99)*y(21) + .200*rxt(119)*y(34)  &
                      + .200*rxt(121)*y(35)
         mat(680) = mat(680) + .300*rxt(94)*y(25) + .300*rxt(131)*y(38)
         mat(249) = mat(249) + .100*rxt(99)*y(1)
         mat(437) = .300*rxt(94)*y(18)
         mat(364) = mat(364) + .200*rxt(119)*y(1)
         mat(343) = mat(343) + .200*rxt(121)*y(1)
         mat(450) = .300*rxt(131)*y(18)


         mat(579) = -(rxt(43)*y(1) + rxt(51)*y(7) + rxt(75)*y(17) + rxt(76)*y(18) &
                      + rxt(187)*y(73) + rxt(190)*y(71) + rxt(205)*y(76) + rxt(213) &
                      *y(6))
         mat(561) = -rxt(43)*y(2)
         mat(821) = -rxt(51)*y(2)
         mat(794) = -rxt(75)*y(2)
         mat(681) = -rxt(76)*y(2)
         mat(527) = -rxt(187)*y(2)
         mat(235) = -rxt(190)*y(2)
         mat(276) = -rxt(205)*y(2)
         mat(637) = -rxt(213)*y(2)

         mat(561) = mat(561) + .765*rxt(138)*y(41)
         mat(35) = rxt(143)*y(6) + rxt(214)*y(7)
         mat(637) = mat(637) + rxt(143)*y(5)
         mat(821) = mat(821) + rxt(214)*y(5)
         mat(794) = mat(794) + 2.000*rxt(82)*y(17)
         mat(266) = .765*rxt(138)*y(1)

         mat(34) = -(rxt(143)*y(6) + rxt(214)*y(7))
         mat(611) = -rxt(143)*y(5)
         mat(803) = -rxt(214)*y(5)

         mat(639) = -(rxt(49)*y(18) + rxt(50)*y(1) + rxt(59)*y(8) + rxt(65)*y(13) &
                      + rxt(87)*y(22) + rxt(92)*y(25) + rxt(101)*y(39) + rxt(107) &
                      *y(51) + rxt(113)*y(33) + (rxt(122) + rxt(123)) * y(36) + rxt(129) &
                      *y(38) + rxt(143)*y(5) + rxt(145)*y(43) + rxt(150)*y(54) + rxt(155) &
                      *y(56) + rxt(164)*y(58) + rxt(188)*y(73) + rxt(204)*y(80) &
                      + rxt(213)*y(2))
         mat(683) = -rxt(49)*y(6)
         mat(563) = -rxt(50)*y(6)
         mat(512) = -rxt(59)*y(6)
         mat(478) = -rxt(65)*y(6)
         mat(188) = -rxt(87)*y(6)
         mat(438) = -rxt(92)*y(6)
         mat(179) = -rxt(101)*y(6)
         mat(104) = -rxt(107)*y(6)
         mat(399) = -rxt(113)*y(6)
         mat(417) = -(rxt(122) + rxt(123)) * y(6)
         mat(451) = -rxt(129)*y(6)
         mat(36) = -rxt(143)*y(6)
         mat(222) = -rxt(145)*y(6)
         mat(210) = -rxt(150)*y(6)
         mat(203) = -rxt(155)*y(6)
         mat(380) = -rxt(164)*y(6)
         mat(529) = -rxt(188)*y(6)
         mat(717) = -rxt(204)*y(6)
         mat(581) = -rxt(213)*y(6)

         mat(581) = mat(581) + rxt(51)*y(7)
         mat(823) = rxt(51)*y(2) + rxt(211)*y(8)
         mat(512) = mat(512) + rxt(211)*y(7)

         mat(829) = -(rxt(51)*y(2) + rxt(52)*y(1) + rxt(54)*y(8) + rxt(57)*y(17) &
                      + rxt(60)*y(18) + rxt(93)*y(25) + rxt(135)*y(38) + rxt(189) &
                      *y(73) + rxt(201)*y(80) + rxt(214)*y(5))
         mat(587) = -rxt(51)*y(7)
         mat(569) = -rxt(52)*y(7)
         mat(516) = -rxt(54)*y(7)
         mat(802) = -rxt(57)*y(7)
         mat(689) = -rxt(60)*y(7)
         mat(442) = -rxt(93)*y(7)
         mat(455) = -rxt(135)*y(7)
         mat(535) = -rxt(189)*y(7)
         mat(723) = -rxt(201)*y(7)
         mat(37) = -rxt(214)*y(7)

         mat(569) = mat(569) + rxt(50)*y(6) + .400*rxt(161)*y(57)
         mat(587) = mat(587) + rxt(213)*y(6)
         mat(645) = rxt(50)*y(1) + rxt(213)*y(2) + 2.000*rxt(59)*y(8) + rxt(65)*y(13)  &
                      + rxt(49)*y(18) + rxt(87)*y(22) + rxt(92)*y(25) + .920*rxt(113) &
                      *y(33) + rxt(122)*y(36) + rxt(129)*y(38) + rxt(101)*y(39)  &
                      + rxt(145)*y(43) + rxt(107)*y(51) + rxt(150)*y(54)  &
                      + 1.206*rxt(155)*y(56) + rxt(164)*y(58) + rxt(188)*y(73)  &
                      + rxt(204)*y(80)
         mat(516) = mat(516) + 2.000*rxt(59)*y(6) + 4.000*rxt(212)*y(8) + rxt(53) &
                      *y(18) + rxt(114)*y(33) + rxt(124)*y(36) + rxt(130)*y(38)  &
                      + rxt(139)*y(41) + 1.206*rxt(156)*y(56) + rxt(162)*y(57)  &
                      + rxt(165)*y(58) + rxt(181)*y(65)
         mat(62) = rxt(61)*y(17)
         mat(113) = rxt(216)*y(69)
         mat(482) = rxt(65)*y(6)
         mat(802) = mat(802) + rxt(61)*y(10) + rxt(153)*y(28) + .400*rxt(160)*y(57)
         mat(689) = mat(689) + rxt(49)*y(6) + rxt(53)*y(8) + .206*rxt(157)*y(56)
         mat(192) = rxt(87)*y(6)
         mat(442) = mat(442) + rxt(92)*y(6)
         mat(54) = rxt(153)*y(17)
         mat(403) = .920*rxt(113)*y(6) + rxt(114)*y(8)
         mat(421) = rxt(122)*y(6) + rxt(124)*y(8)
         mat(455) = mat(455) + rxt(129)*y(6) + rxt(130)*y(8)
         mat(183) = rxt(101)*y(6)
         mat(271) = rxt(139)*y(8)
         mat(226) = rxt(145)*y(6)
         mat(107) = rxt(107)*y(6)
         mat(214) = rxt(150)*y(6)
         mat(206) = 1.206*rxt(155)*y(6) + 1.206*rxt(156)*y(8) + .206*rxt(157)*y(18)
         mat(311) = .400*rxt(161)*y(1) + rxt(162)*y(8) + .400*rxt(160)*y(17)
         mat(384) = rxt(164)*y(6) + rxt(165)*y(8)
         mat(33) = rxt(181)*y(8)
         mat(609) = rxt(216)*y(11)
         mat(535) = mat(535) + rxt(188)*y(6)
         mat(723) = mat(723) + rxt(204)*y(6)

         mat(507) = -(rxt(53)*y(18) + (rxt(54) + rxt(211)) * y(7) + rxt(59)*y(6) &
                      + rxt(70)*y(15) + rxt(86)*y(20) + rxt(91)*y(23) + rxt(114)*y(33) &
                      + rxt(124)*y(36) + rxt(130)*y(38) + rxt(139)*y(41) + rxt(154) &
                      *y(21) + rxt(156)*y(56) + rxt(159)*y(55) + rxt(162)*y(57) &
                      + rxt(165)*y(58) + rxt(181)*y(65) + 4.*rxt(212)*y(8))
         mat(678) = -rxt(53)*y(8)
         mat(818) = -(rxt(54) + rxt(211)) * y(8)
         mat(634) = -rxt(59)*y(8)
         mat(729) = -rxt(70)*y(8)
         mat(288) = -rxt(86)*y(8)
         mat(299) = -rxt(91)*y(8)
         mat(397) = -rxt(114)*y(8)
         mat(415) = -rxt(124)*y(8)
         mat(449) = -rxt(130)*y(8)
         mat(264) = -rxt(139)*y(8)
         mat(248) = -rxt(154)*y(8)
         mat(202) = -rxt(156)*y(8)
         mat(325) = -rxt(159)*y(8)
         mat(306) = -rxt(162)*y(8)
         mat(379) = -rxt(165)*y(8)
         mat(31) = -rxt(181)*y(8)

         mat(558) = rxt(52)*y(7)
         mat(576) = rxt(190)*y(71)
         mat(818) = mat(818) + rxt(52)*y(1)
         mat(170) = rxt(58)*y(17)
         mat(791) = rxt(58)*y(9) + rxt(175)*y(27) + .500*rxt(174)*y(32)
         mat(132) = rxt(175)*y(17)
         mat(143) = .500*rxt(174)*y(17)
         mat(233) = rxt(190)*y(2)

         mat(169) = -(rxt(58)*y(17))
         mat(768) = -rxt(58)*y(9)

         mat(809) = rxt(57)*y(17)
         mat(488) = rxt(70)*y(15) + rxt(91)*y(23) + rxt(159)*y(55)
         mat(109) = rxt(216)*y(69)
         mat(725) = rxt(70)*y(8)
         mat(768) = mat(768) + rxt(57)*y(7)
         mat(295) = rxt(91)*y(8)
         mat(322) = rxt(159)*y(8)
         mat(592) = rxt(216)*y(11) + rxt(219)*y(71)
         mat(229) = rxt(219)*y(69)

         mat(59) = -(rxt(61)*y(17))
         mat(751) = -rxt(61)*y(10)

         mat(805) = rxt(60)*y(18)
         mat(648) = rxt(60)*y(7)

         mat(108) = -(rxt(216)*y(69))
         mat(590) = -rxt(216)*y(11)

         mat(806) = rxt(54)*y(8)
         mat(486) = rxt(54)*y(7)

         mat(475) = -(rxt(65)*y(6) + (4.*rxt(66) + 4.*rxt(67)) * y(13) + rxt(68)*y(18) &
                      + rxt(95)*y(25) + rxt(103)*y(39) + rxt(116)*y(33) + rxt(126) &
                      *y(36) + rxt(132)*y(38) + rxt(147)*y(43) + rxt(167)*y(58))
         mat(633) = -rxt(65)*y(13)
         mat(677) = -rxt(68)*y(13)
         mat(435) = -rxt(95)*y(13)
         mat(178) = -rxt(103)*y(13)
         mat(396) = -rxt(116)*y(13)
         mat(414) = -rxt(126)*y(13)
         mat(448) = -rxt(132)*y(13)
         mat(221) = -rxt(147)*y(13)
         mat(378) = -rxt(167)*y(13)

         mat(557) = .310*rxt(85)*y(20)
         mat(633) = mat(633) + rxt(92)*y(25)
         mat(475) = mat(475) + .900*rxt(95)*y(25)
         mat(90) = .700*rxt(69)*y(17)
         mat(790) = .700*rxt(69)*y(14)
         mat(287) = .310*rxt(85)*y(1)
         mat(435) = mat(435) + rxt(92)*y(6) + .900*rxt(95)*y(13) + 4.000*rxt(98)*y(25)  &
                      + rxt(117)*y(33) + rxt(127)*y(36) + rxt(133)*y(38) + rxt(168) &
                      *y(58)
         mat(396) = mat(396) + rxt(117)*y(25)
         mat(414) = mat(414) + rxt(127)*y(25)
         mat(448) = mat(448) + rxt(133)*y(25)
         mat(378) = mat(378) + rxt(168)*y(25)

         mat(89) = -(rxt(69)*y(17))
         mat(757) = -rxt(69)*y(14)

         mat(457) = rxt(68)*y(18)
         mat(653) = rxt(68)*y(13)

         mat(738) = -(rxt(70)*y(8) + rxt(71)*y(17) + rxt(196)*y(72) + rxt(207)*y(79))
         mat(514) = -rxt(70)*y(15)
         mat(800) = -rxt(71)*y(15)
         mat(354) = -rxt(196)*y(15)
         mat(702) = -rxt(207)*y(15)

         mat(567) = .540*rxt(85)*y(20) + .600*rxt(99)*y(21) + rxt(110)*y(30)  &
                      + .800*rxt(119)*y(34) + .700*rxt(121)*y(35) + 1.326*rxt(138) &
                      *y(41)
         mat(643) = rxt(65)*y(13) + rxt(87)*y(22) + .550*rxt(113)*y(33)  &
                      + .250*rxt(122)*y(36) + rxt(129)*y(38) + rxt(150)*y(54)  &
                      + .072*rxt(155)*y(56)
         mat(514) = mat(514) + .600*rxt(114)*y(33) + .250*rxt(124)*y(36) + rxt(130) &
                      *y(38) + .072*rxt(156)*y(56)
         mat(480) = rxt(65)*y(6) + (4.000*rxt(66)+2.000*rxt(67))*y(13) + rxt(95)*y(25)  &
                      + 1.200*rxt(116)*y(33) + .880*rxt(126)*y(36) + 2.000*rxt(132) &
                      *y(38) + .700*rxt(103)*y(39) + rxt(147)*y(43) + .700*rxt(167) &
                      *y(58)
         mat(92) = .300*rxt(69)*y(17)
         mat(800) = mat(800) + .300*rxt(69)*y(14) + .500*rxt(96)*y(26) + rxt(175) &
                      *y(27) + .500*rxt(106)*y(30) + .500*rxt(174)*y(32) + rxt(172) &
                      *y(47)
         mat(687) = .008*rxt(157)*y(56)
         mat(292) = .540*rxt(85)*y(1)
         mat(252) = .600*rxt(99)*y(1)
         mat(190) = rxt(87)*y(6)
         mat(440) = rxt(95)*y(13) + .600*rxt(117)*y(33) + .250*rxt(127)*y(36)  &
                      + rxt(133)*y(38)
         mat(117) = .500*rxt(96)*y(17)
         mat(133) = rxt(175)*y(17)
         mat(67) = rxt(110)*y(1) + .500*rxt(106)*y(17)
         mat(145) = .500*rxt(174)*y(17)
         mat(401) = .550*rxt(113)*y(6) + .600*rxt(114)*y(8) + 1.200*rxt(116)*y(13)  &
                      + .600*rxt(117)*y(25)
         mat(367) = .800*rxt(119)*y(1)
         mat(345) = .700*rxt(121)*y(1)
         mat(419) = .250*rxt(122)*y(6) + .250*rxt(124)*y(8) + .880*rxt(126)*y(13)  &
                      + .250*rxt(127)*y(25)
         mat(453) = rxt(129)*y(6) + rxt(130)*y(8) + 2.000*rxt(132)*y(13) + rxt(133) &
                      *y(25) + 4.000*rxt(134)*y(38)
         mat(181) = .700*rxt(103)*y(13)
         mat(269) = 1.326*rxt(138)*y(1)
         mat(224) = rxt(147)*y(13)
         mat(138) = rxt(172)*y(17)
         mat(212) = rxt(150)*y(6)
         mat(205) = .072*rxt(155)*y(6) + .072*rxt(156)*y(8) + .008*rxt(157)*y(18)
         mat(382) = .700*rxt(167)*y(13)


      end subroutine imp_nlnmat01

      subroutine imp_nlnmat02( mat, y, rxt )

      use MO_GRID_MOD,   only : pcnstm1
      use CHEM_MODS_MOD, only : rxntot, imp_nzcnt, clsze

      implicit none

!----------------------------------------------
!       ... Dummy args
!----------------------------------------------
      real, intent(in)    ::  y(pcnstm1)
      real, intent(in)    ::  rxt(rxntot)
      real, intent(inout) ::  mat(imp_nzcnt)


!----------------------------------------------
!       ... Local variables
!----------------------------------------------

!----------------------------------------------
!       ... Complete matrix entries Implicit species
!----------------------------------------------

         mat(801) = -(rxt(57)*y(7) + rxt(58)*y(9) + rxt(61)*y(10) + rxt(69)*y(14) &
                      + rxt(71)*y(15) + rxt(75)*y(2) + rxt(77)*y(1) + rxt(80)*y(19) &
                      + rxt(81)*y(18) + (4.*rxt(82) + 4.*rxt(197)) * y(17) + rxt(84) &
                      *y(20) + rxt(89)*y(24) + rxt(90)*y(23) + rxt(96)*y(26) + rxt(105) &
                      *y(40) + rxt(106)*y(30) + rxt(111)*y(21) + rxt(112)*y(31) &
                      + rxt(118)*y(34) + rxt(120)*y(35) + rxt(128)*y(37) + rxt(137) &
                      *y(41) + rxt(148)*y(44) + rxt(149)*y(45) + rxt(152)*y(46) &
                      + rxt(153)*y(28) + rxt(158)*y(55) + rxt(160)*y(57) + rxt(163) &
                      *y(53) + rxt(169)*y(59) + rxt(171)*y(60) + rxt(172)*y(47) &
                      + rxt(173)*y(48) + rxt(174)*y(32) + rxt(175)*y(27) + rxt(176) &
                      *y(50) + rxt(177)*y(49) + rxt(178)*y(63) + (rxt(179) + rxt(180) &
                      ) * y(65) + rxt(183)*y(66) + rxt(192)*y(69) + (rxt(195) + rxt(210) &
                      ) * y(73) + rxt(208)*y(77))
         mat(828) = -rxt(57)*y(17)
         mat(171) = -rxt(58)*y(17)
         mat(61) = -rxt(61)*y(17)
         mat(93) = -rxt(69)*y(17)
         mat(739) = -rxt(71)*y(17)
         mat(586) = -rxt(75)*y(17)
         mat(568) = -rxt(77)*y(17)
         mat(21) = -rxt(80)*y(17)
         mat(688) = -rxt(81)*y(17)
         mat(293) = -rxt(84)*y(17)
         mat(128) = -rxt(89)*y(17)
         mat(301) = -rxt(90)*y(17)
         mat(118) = -rxt(96)*y(17)
         mat(78) = -rxt(105)*y(17)
         mat(68) = -rxt(106)*y(17)
         mat(253) = -rxt(111)*y(17)
         mat(10) = -rxt(112)*y(17)
         mat(368) = -rxt(118)*y(17)
         mat(346) = -rxt(120)*y(17)
         mat(73) = -rxt(128)*y(17)
         mat(270) = -rxt(137)*y(17)
         mat(83) = -rxt(148)*y(17)
         mat(160) = -rxt(149)*y(17)
         mat(88) = -rxt(152)*y(17)
         mat(53) = -rxt(153)*y(17)
         mat(327) = -rxt(158)*y(17)
         mat(310) = -rxt(160)*y(17)
         mat(121) = -rxt(163)*y(17)
         mat(28) = -rxt(169)*y(17)
         mat(155) = -rxt(171)*y(17)
         mat(139) = -rxt(172)*y(17)
         mat(58) = -rxt(173)*y(17)
         mat(146) = -rxt(174)*y(17)
         mat(134) = -rxt(175)*y(17)
         mat(335) = -rxt(176)*y(17)
         mat(197) = -rxt(177)*y(17)
         mat(16) = -rxt(178)*y(17)
         mat(32) = -(rxt(179) + rxt(180)) * y(17)
         mat(7) = -rxt(183)*y(17)
         mat(608) = -rxt(192)*y(17)
         mat(534) = -(rxt(195) + rxt(210)) * y(17)
         mat(321) = -rxt(208)*y(17)

         mat(568) = mat(568) + rxt(78)*y(18) + .330*rxt(85)*y(20) + .270*rxt(99)*y(21)  &
                      + .120*rxt(110)*y(30) + .080*rxt(119)*y(34) + .215*rxt(121) &
                      *y(35) + 1.156*rxt(138)*y(41) + rxt(184)*y(83)
         mat(586) = mat(586) + rxt(76)*y(18) + rxt(205)*y(76)
         mat(644) = rxt(49)*y(18)
         mat(515) = rxt(53)*y(18)
         mat(93) = mat(93) + .300*rxt(69)*y(17)
         mat(801) = mat(801) + .300*rxt(69)*y(14) + .500*rxt(89)*y(24) + .100*rxt(128) &
                      *y(37) + .500*rxt(105)*y(40)
         mat(688) = mat(688) + rxt(78)*y(1) + rxt(76)*y(2) + rxt(49)*y(6) + rxt(53) &
                      *y(8)
         mat(293) = mat(293) + .330*rxt(85)*y(1)
         mat(253) = mat(253) + .270*rxt(99)*y(1)
         mat(128) = mat(128) + .500*rxt(89)*y(17)
         mat(68) = mat(68) + .120*rxt(110)*y(1)
         mat(368) = mat(368) + .080*rxt(119)*y(1)
         mat(346) = mat(346) + .215*rxt(121)*y(1)
         mat(73) = mat(73) + .100*rxt(128)*y(17)
         mat(78) = mat(78) + .500*rxt(105)*y(17)
         mat(270) = mat(270) + 1.156*rxt(138)*y(1)
         mat(280) = rxt(205)*y(2)
         mat(100) = rxt(184)*y(1)

         mat(684) = -(rxt(49)*y(6) + rxt(53)*y(8) + rxt(60)*y(7) + rxt(68)*y(13) &
                      + rxt(76)*y(2) + rxt(78)*y(1) + 4.*rxt(79)*y(18) + rxt(81)*y(17) &
                      + rxt(88)*y(22) + rxt(94)*y(25) + rxt(102)*y(39) + rxt(115) &
                      *y(33) + rxt(125)*y(36) + rxt(131)*y(38) + rxt(146)*y(43) &
                      + rxt(151)*y(54) + rxt(157)*y(56) + rxt(166)*y(58) + rxt(193) &
                      *y(72) + rxt(194)*y(73) + rxt(203)*y(80) + rxt(206)*y(79))
         mat(640) = -rxt(49)*y(18)
         mat(513) = -rxt(53)*y(18)
         mat(824) = -rxt(60)*y(18)
         mat(479) = -rxt(68)*y(18)
         mat(582) = -rxt(76)*y(18)
         mat(564) = -rxt(78)*y(18)
         mat(797) = -rxt(81)*y(18)
         mat(189) = -rxt(88)*y(18)
         mat(439) = -rxt(94)*y(18)
         mat(180) = -rxt(102)*y(18)
         mat(400) = -rxt(115)*y(18)
         mat(418) = -rxt(125)*y(18)
         mat(452) = -rxt(131)*y(18)
         mat(223) = -rxt(146)*y(18)
         mat(211) = -rxt(151)*y(18)
         mat(204) = -rxt(157)*y(18)
         mat(381) = -rxt(166)*y(18)
         mat(353) = -rxt(193)*y(18)
         mat(530) = -rxt(194)*y(18)
         mat(718) = -rxt(203)*y(18)
         mat(699) = -rxt(206)*y(18)

         mat(564) = mat(564) + rxt(77)*y(17) + .190*rxt(85)*y(20) + .060*rxt(99)*y(21)  &
                      + .120*rxt(110)*y(30) + .060*rxt(119)*y(34) + .275*rxt(121) &
                      *y(35) + .102*rxt(138)*y(41) + rxt(161)*y(57)
         mat(640) = mat(640) + rxt(65)*y(13) + rxt(87)*y(22) + rxt(113)*y(33)  &
                      + .470*rxt(122)*y(36) + rxt(101)*y(39) + rxt(145)*y(43)  &
                      + .794*rxt(155)*y(56) + 1.500*rxt(164)*y(58)
         mat(513) = mat(513) + rxt(70)*y(15) + rxt(114)*y(33) + .470*rxt(124)*y(36)  &
                      + .794*rxt(156)*y(56) + rxt(162)*y(57) + 1.500*rxt(165)*y(58)
         mat(479) = mat(479) + rxt(65)*y(6) + 4.000*rxt(66)*y(13) + .900*rxt(95)*y(25)  &
                      + rxt(116)*y(33) + .730*rxt(126)*y(36) + rxt(132)*y(38)  &
                      + rxt(103)*y(39) + rxt(147)*y(43) + rxt(167)*y(58)
         mat(735) = rxt(70)*y(8) + rxt(71)*y(17) + rxt(196)*y(72) + rxt(207)*y(79)
         mat(797) = mat(797) + rxt(77)*y(1) + rxt(71)*y(15) + rxt(80)*y(19)  &
                      + .250*rxt(106)*y(30) + .500*rxt(174)*y(32) + .200*rxt(128) &
                      *y(37) + rxt(172)*y(47) + rxt(173)*y(48) + .600*rxt(177)*y(49)  &
                      + rxt(176)*y(50) + rxt(160)*y(57) + rxt(195)*y(73)
         mat(684) = mat(684) + .794*rxt(157)*y(56)
         mat(20) = rxt(80)*y(17)
         mat(291) = .190*rxt(85)*y(1)
         mat(251) = .060*rxt(99)*y(1)
         mat(189) = mat(189) + rxt(87)*y(6)
         mat(439) = mat(439) + .900*rxt(95)*y(13) + rxt(117)*y(33) + .470*rxt(127) &
                      *y(36) + 1.500*rxt(168)*y(58)
         mat(66) = .120*rxt(110)*y(1) + .250*rxt(106)*y(17)
         mat(144) = .500*rxt(174)*y(17)
         mat(400) = mat(400) + rxt(113)*y(6) + rxt(114)*y(8) + rxt(116)*y(13)  &
                      + rxt(117)*y(25)
         mat(366) = .060*rxt(119)*y(1)
         mat(344) = .275*rxt(121)*y(1)
         mat(418) = mat(418) + .470*rxt(122)*y(6) + .470*rxt(124)*y(8) + .730*rxt(126) &
                      *y(13) + .470*rxt(127)*y(25)
         mat(72) = .200*rxt(128)*y(17)
         mat(452) = mat(452) + rxt(132)*y(13)
         mat(180) = mat(180) + rxt(101)*y(6) + rxt(103)*y(13) + 2.400*rxt(104)*y(39)
         mat(268) = .102*rxt(138)*y(1)
         mat(223) = mat(223) + rxt(145)*y(6) + rxt(147)*y(13)
         mat(137) = rxt(172)*y(17)
         mat(57) = rxt(173)*y(17)
         mat(195) = .600*rxt(177)*y(17)
         mat(333) = rxt(176)*y(17)
         mat(204) = mat(204) + .794*rxt(155)*y(6) + .794*rxt(156)*y(8) + .794*rxt(157) &
                      *y(18)
         mat(308) = rxt(161)*y(1) + rxt(162)*y(8) + rxt(160)*y(17)
         mat(381) = mat(381) + 1.500*rxt(164)*y(6) + 1.500*rxt(165)*y(8) + rxt(167) &
                      *y(13) + 1.500*rxt(168)*y(25)
         mat(353) = mat(353) + rxt(196)*y(15)
         mat(530) = mat(530) + rxt(195)*y(17)
         mat(699) = mat(699) + rxt(207)*y(15)

         mat(19) = -(rxt(80)*y(17))
         mat(746) = -rxt(80)*y(19)

         mat(746) = mat(746) + 2.000*rxt(197)*y(17)
         mat(646) = 2.000*rxt(79)*y(18)

         mat(283) = -(rxt(84)*y(17) + rxt(85)*y(1) + rxt(86)*y(8))
         mat(776) = -rxt(84)*y(20)
         mat(544) = -rxt(85)*y(20)
         mat(493) = -rxt(86)*y(20)

         mat(544) = mat(544) + .070*rxt(99)*y(21) + .119*rxt(138)*y(41)
         mat(242) = .070*rxt(99)*y(1)
         mat(258) = .119*rxt(138)*y(1)

         mat(241) = -(rxt(99)*y(1) + rxt(111)*y(17) + rxt(154)*y(8))
         mat(542) = -rxt(99)*y(21)
         mat(774) = -rxt(111)*y(21)
         mat(491) = -rxt(154)*y(21)

         mat(185) = -(rxt(87)*y(6) + rxt(88)*y(18))
         mat(616) = -rxt(87)*y(22)
         mat(660) = -rxt(88)*y(22)

         mat(770) = rxt(84)*y(20) + .500*rxt(89)*y(24)
         mat(282) = rxt(84)*y(17)
         mat(123) = .500*rxt(89)*y(17)

         mat(296) = -(rxt(90)*y(17) + rxt(91)*y(8))
         mat(777) = -rxt(90)*y(23)
         mat(494) = -rxt(91)*y(23)

         mat(545) = .500*rxt(85)*y(20) + .040*rxt(119)*y(34)
         mat(621) = rxt(87)*y(22) + rxt(101)*y(39) + .270*rxt(145)*y(43)
         mat(465) = .800*rxt(103)*y(39)
         mat(777) = mat(777) + .500*rxt(105)*y(40) + rxt(173)*y(48)
         mat(284) = .500*rxt(85)*y(1)
         mat(186) = rxt(87)*y(6)
         mat(356) = .040*rxt(119)*y(1)
         mat(177) = rxt(101)*y(6) + .800*rxt(103)*y(13) + 3.200*rxt(104)*y(39)
         mat(76) = .500*rxt(105)*y(17)
         mat(219) = .270*rxt(145)*y(6)
         mat(56) = rxt(173)*y(17)

         mat(122) = -(rxt(89)*y(17))
         mat(762) = -rxt(89)*y(24)

         mat(655) = rxt(88)*y(22)
         mat(184) = rxt(88)*y(18)

         mat(433) = -(rxt(92)*y(6) + rxt(93)*y(7) + rxt(94)*y(18) + rxt(95)*y(13) &
                      + 4.*rxt(98)*y(25) + rxt(117)*y(33) + rxt(127)*y(36) + rxt(168) &
                      *y(58))
         mat(631) = -rxt(92)*y(25)
         mat(815) = -rxt(93)*y(25)
         mat(675) = -rxt(94)*y(25)
         mat(473) = -rxt(95)*y(25)
         mat(394) = -rxt(117)*y(25)
         mat(412) = -rxt(127)*y(25)
         mat(376) = -rxt(168)*y(25)

         mat(631) = mat(631) + .530*rxt(122)*y(36) + rxt(129)*y(38) + rxt(150)*y(54)
         mat(504) = rxt(91)*y(23) + .530*rxt(124)*y(36) + rxt(130)*y(38) + rxt(159) &
                      *y(55)
         mat(473) = mat(473) + .260*rxt(126)*y(36) + rxt(132)*y(38)
         mat(788) = rxt(90)*y(23) + .500*rxt(96)*y(26) + rxt(158)*y(55)
         mat(297) = rxt(91)*y(8) + rxt(90)*y(17)
         mat(433) = mat(433) + .530*rxt(127)*y(36)
         mat(115) = .500*rxt(96)*y(17)
         mat(412) = mat(412) + .530*rxt(122)*y(6) + .530*rxt(124)*y(8) + .260*rxt(126) &
                      *y(13) + .530*rxt(127)*y(25)
         mat(446) = rxt(129)*y(6) + rxt(130)*y(8) + rxt(132)*y(13) + 4.000*rxt(134) &
                      *y(38)
         mat(209) = rxt(150)*y(6)
         mat(324) = rxt(159)*y(8) + rxt(158)*y(17)


      end subroutine imp_nlnmat02

      subroutine imp_nlnmat03( mat, y, rxt )

      use MO_GRID_MOD,   only : pcnstm1
      use CHEM_MODS_MOD, only : rxntot, imp_nzcnt

      implicit none

!----------------------------------------------
!       ... Dummy args
!----------------------------------------------
      real, intent(in)    ::  y(pcnstm1)
      real, intent(in)    ::  rxt(rxntot)
      real, intent(inout) ::  mat(imp_nzcnt)


!----------------------------------------------
!       ... Local variables
!----------------------------------------------

!----------------------------------------------
!       ... Complete matrix entries Implicit species
!----------------------------------------------

         mat(114) = -(rxt(96)*y(17))
         mat(760) = -rxt(96)*y(26)

         mat(654) = .700*rxt(94)*y(25) + .700*rxt(131)*y(38)
         mat(422) = .700*rxt(94)*y(18)
         mat(443) = .700*rxt(131)*y(18)

         mat(129) = -(rxt(175)*y(17))
         mat(763) = -rxt(175)*y(27)

         mat(807) = rxt(93)*y(25)
         mat(424) = rxt(93)*y(7)

         mat(51) = -(rxt(153)*y(17))
         mat(749) = -rxt(153)*y(28)

         mat(485) = rxt(86)*y(20)
         mat(281) = rxt(86)*y(8)

         mat(63) = -(rxt(106)*y(17) + rxt(110)*y(1))
         mat(752) = -rxt(106)*y(30)
         mat(537) = -rxt(110)*y(30)

         mat(8) = -(rxt(112)*y(17))
         mat(744) = -rxt(112)*y(31)

         mat(140) = -(rxt(174)*y(17))
         mat(765) = -rxt(174)*y(32)

         mat(808) = rxt(135)*y(38)
         mat(444) = rxt(135)*y(7)

         mat(392) = -(rxt(113)*y(6) + rxt(114)*y(8) + rxt(115)*y(18) + rxt(116)*y(13) &
                      + rxt(117)*y(25))
         mat(629) = -rxt(113)*y(33)
         mat(502) = -rxt(114)*y(33)
         mat(673) = -rxt(115)*y(33)
         mat(471) = -rxt(116)*y(33)
         mat(431) = -rxt(117)*y(33)

         mat(502) = mat(502) + 1.700*rxt(139)*y(41)
         mat(786) = rxt(111)*y(21) + 1.640*rxt(137)*y(41) + .500*rxt(171)*y(60)
         mat(246) = rxt(111)*y(17)
         mat(261) = 1.700*rxt(139)*y(8) + 1.640*rxt(137)*y(17)
         mat(152) = .500*rxt(171)*y(17)

         mat(359) = -(rxt(118)*y(17) + rxt(119)*y(1))
         mat(784) = -rxt(118)*y(34)
         mat(551) = -rxt(119)*y(34)

         mat(551) = mat(551) + .200*rxt(99)*y(21) + .442*rxt(138)*y(41)
         mat(627) = .320*rxt(113)*y(33) + .039*rxt(155)*y(56)
         mat(500) = .350*rxt(114)*y(33) + .039*rxt(156)*y(56)
         mat(469) = .260*rxt(116)*y(33)
         mat(671) = .039*rxt(157)*y(56)
         mat(245) = .200*rxt(99)*y(1)
         mat(429) = .350*rxt(117)*y(33)
         mat(390) = .320*rxt(113)*y(6) + .350*rxt(114)*y(8) + .260*rxt(116)*y(13)  &
                      + .350*rxt(117)*y(25)
         mat(260) = .442*rxt(138)*y(1)
         mat(201) = .039*rxt(155)*y(6) + .039*rxt(156)*y(8) + .039*rxt(157)*y(18)

         mat(338) = -(rxt(120)*y(17) + rxt(121)*y(1))
         mat(782) = -rxt(120)*y(35)
         mat(549) = -rxt(121)*y(35)

         mat(549) = mat(549) + .400*rxt(99)*y(21) + 1.122*rxt(138)*y(41)
         mat(625) = .230*rxt(113)*y(33) + .167*rxt(155)*y(56)
         mat(498) = .250*rxt(114)*y(33) + .167*rxt(156)*y(56)
         mat(468) = .190*rxt(116)*y(33)
         mat(669) = .167*rxt(157)*y(56)
         mat(244) = .400*rxt(99)*y(1)
         mat(428) = .250*rxt(117)*y(33)
         mat(389) = .230*rxt(113)*y(6) + .250*rxt(114)*y(8) + .190*rxt(116)*y(13)  &
                      + .250*rxt(117)*y(25)
         mat(259) = 1.122*rxt(138)*y(1)
         mat(200) = .167*rxt(155)*y(6) + .167*rxt(156)*y(8) + .167*rxt(157)*y(18)

         mat(411) = -((rxt(122) + rxt(123)) * y(6) + rxt(124)*y(8) + rxt(125)*y(18) &
                      + rxt(126)*y(13) + rxt(127)*y(25))
         mat(630) = -(rxt(122) + rxt(123)) * y(36)
         mat(503) = -rxt(124)*y(36)
         mat(674) = -rxt(125)*y(36)
         mat(472) = -rxt(126)*y(36)
         mat(432) = -rxt(127)*y(36)

         mat(787) = rxt(118)*y(34) + .500*rxt(120)*y(35) + .200*rxt(128)*y(37)
         mat(360) = rxt(118)*y(17)
         mat(339) = .500*rxt(120)*y(17)
         mat(70) = .200*rxt(128)*y(17)

         mat(69) = -(rxt(128)*y(17))
         mat(753) = -rxt(128)*y(37)

         mat(649) = rxt(125)*y(36)
         mat(404) = rxt(125)*y(18)

         mat(447) = -(rxt(129)*y(6) + rxt(130)*y(8) + rxt(131)*y(18) + rxt(132)*y(13) &
                      + rxt(133)*y(25) + 4.*rxt(134)*y(38) + rxt(135)*y(7))
         mat(632) = -rxt(129)*y(38)
         mat(505) = -rxt(130)*y(38)
         mat(676) = -rxt(131)*y(38)
         mat(474) = -rxt(132)*y(38)
         mat(434) = -rxt(133)*y(38)
         mat(816) = -rxt(135)*y(38)

         mat(556) = .200*rxt(99)*y(21)
         mat(789) = .500*rxt(120)*y(35) + .500*rxt(128)*y(37) + .800*rxt(177)*y(49)
         mat(247) = .200*rxt(99)*y(1)
         mat(341) = .500*rxt(120)*y(17)
         mat(71) = .500*rxt(128)*y(17)
         mat(194) = .800*rxt(177)*y(17)

         mat(176) = -(rxt(101)*y(6) + rxt(102)*y(18) + rxt(103)*y(13) + 4.*rxt(104) &
                      *y(39))
         mat(615) = -rxt(101)*y(39)
         mat(659) = -rxt(102)*y(39)
         mat(461) = -rxt(103)*y(39)

         mat(769) = .500*rxt(105)*y(40)
         mat(75) = .500*rxt(105)*y(17)

         mat(74) = -(rxt(105)*y(17))
         mat(754) = -rxt(105)*y(40)

         mat(650) = rxt(102)*y(39)
         mat(174) = rxt(102)*y(18)

         mat(257) = -(rxt(137)*y(17) + rxt(138)*y(1) + rxt(139)*y(8))
         mat(775) = -rxt(137)*y(41)
         mat(543) = -rxt(138)*y(41)
         mat(492) = -rxt(139)*y(41)

         mat(218) = -(rxt(145)*y(6) + rxt(146)*y(18) + rxt(147)*y(13))
         mat(620) = -rxt(145)*y(43)
         mat(663) = -rxt(146)*y(43)
         mat(464) = -rxt(147)*y(43)

         mat(773) = 1.330*rxt(112)*y(31) + rxt(148)*y(44)
         mat(9) = 1.330*rxt(112)*y(17)
         mat(81) = rxt(148)*y(17)

         mat(79) = -(rxt(148)*y(17))
         mat(755) = -rxt(148)*y(44)

         mat(651) = rxt(146)*y(43)
         mat(215) = rxt(146)*y(18)

         mat(156) = -(rxt(149)*y(17))
         mat(767) = -rxt(149)*y(45)

         mat(614) = .820*rxt(145)*y(43)
         mat(460) = .820*rxt(147)*y(43)
         mat(767) = mat(767) + .100*rxt(137)*y(41)
         mat(255) = .100*rxt(137)*y(17)
         mat(216) = .820*rxt(145)*y(6) + .820*rxt(147)*y(13)

         mat(84) = -(rxt(152)*y(17))
         mat(756) = -rxt(152)*y(46)

         mat(652) = rxt(151)*y(54)
         mat(207) = rxt(151)*y(18)

         mat(136) = -(rxt(172)*y(17))
         mat(764) = -rxt(172)*y(47)

         mat(459) = 2.000*rxt(67)*y(13) + .250*rxt(116)*y(33) + .250*rxt(126)*y(36)  &
                      + .300*rxt(103)*y(39) + .300*rxt(167)*y(58)
         mat(386) = .250*rxt(116)*y(13)
         mat(405) = .250*rxt(126)*y(13)
         mat(175) = .300*rxt(103)*y(13)
         mat(371) = .300*rxt(167)*y(13)

         mat(55) = -(rxt(173)*y(17))
         mat(750) = -rxt(173)*y(48)

         mat(456) = .200*rxt(103)*y(39)
         mat(173) = .200*rxt(103)*y(13) + .800*rxt(104)*y(39)

         mat(193) = -(rxt(177)*y(17))
         mat(771) = -rxt(177)*y(49)

         mat(617) = .530*rxt(122)*y(36) + .250*rxt(164)*y(58)
         mat(489) = .530*rxt(124)*y(36) + .250*rxt(165)*y(58)
         mat(462) = .260*rxt(126)*y(36) + .100*rxt(167)*y(58)
         mat(425) = .530*rxt(127)*y(36) + .250*rxt(168)*y(58)
         mat(406) = .530*rxt(122)*y(6) + .530*rxt(124)*y(8) + .260*rxt(126)*y(13)  &
                      + .530*rxt(127)*y(25)
         mat(372) = .250*rxt(164)*y(6) + .250*rxt(165)*y(8) + .100*rxt(167)*y(13)  &
                      + .250*rxt(168)*y(25)

         mat(330) = -(rxt(176)*y(17))
         mat(781) = -rxt(176)*y(50)

         mat(624) = .220*rxt(122)*y(36) + .250*rxt(164)*y(58)
         mat(497) = .220*rxt(124)*y(36) + .250*rxt(165)*y(58)
         mat(467) = .230*rxt(126)*y(36) + .100*rxt(167)*y(58)
         mat(781) = mat(781) + .500*rxt(89)*y(24) + .500*rxt(174)*y(32)
         mat(125) = .500*rxt(89)*y(17)
         mat(427) = .220*rxt(127)*y(36) + .250*rxt(168)*y(58)
         mat(141) = .500*rxt(174)*y(17)
         mat(409) = .220*rxt(122)*y(6) + .220*rxt(124)*y(8) + .230*rxt(126)*y(13)  &
                      + .220*rxt(127)*y(25)
         mat(374) = .250*rxt(164)*y(6) + .250*rxt(165)*y(8) + .100*rxt(167)*y(13)  &
                      + .250*rxt(168)*y(25)

         mat(102) = -(rxt(107)*y(6))
         mat(612) = -rxt(107)*y(51)

         mat(759) = .750*rxt(106)*y(30)
         mat(64) = .750*rxt(106)*y(17)


         mat(610) = rxt(107)*y(51)
         mat(101) = rxt(107)*y(6)

         mat(119) = -(rxt(163)*y(17))
         mat(761) = -rxt(163)*y(53)

         mat(540) = .400*rxt(161)*y(57)
         mat(613) = .370*rxt(113)*y(33)
         mat(487) = .400*rxt(114)*y(33)
         mat(458) = .300*rxt(116)*y(33)
         mat(761) = mat(761) + .400*rxt(160)*y(57)
         mat(423) = .400*rxt(117)*y(33)
         mat(385) = .370*rxt(113)*y(6) + .400*rxt(114)*y(8) + .300*rxt(116)*y(13)  &
                      + .400*rxt(117)*y(25)
         mat(303) = .400*rxt(161)*y(1) + .400*rxt(160)*y(17)

         mat(208) = -(rxt(150)*y(6) + rxt(151)*y(18))
         mat(619) = -rxt(150)*y(54)
         mat(662) = -rxt(151)*y(54)

         mat(772) = rxt(149)*y(45) + rxt(152)*y(46)
         mat(157) = rxt(149)*y(17)
         mat(85) = rxt(152)*y(17)

         mat(323) = -(rxt(158)*y(17) + rxt(159)*y(8))
         mat(780) = -rxt(158)*y(55)
         mat(496) = -rxt(159)*y(55)

         mat(547) = .950*rxt(119)*y(34) + .800*rxt(121)*y(35)
         mat(623) = .250*rxt(122)*y(36) + .250*rxt(164)*y(58)
         mat(496) = mat(496) + .250*rxt(124)*y(36) + .250*rxt(165)*y(58)
         mat(466) = .240*rxt(126)*y(36) + .100*rxt(167)*y(58)
         mat(780) = mat(780) + rxt(153)*y(28) + rxt(176)*y(50)
         mat(426) = .250*rxt(127)*y(36) + .250*rxt(168)*y(58)
         mat(52) = rxt(153)*y(17)
         mat(357) = .950*rxt(119)*y(1)
         mat(337) = .800*rxt(121)*y(1)
         mat(408) = .250*rxt(122)*y(6) + .250*rxt(124)*y(8) + .240*rxt(126)*y(13)  &
                      + .250*rxt(127)*y(25)
         mat(329) = rxt(176)*y(17)
         mat(373) = .250*rxt(164)*y(6) + .250*rxt(165)*y(8) + .100*rxt(167)*y(13)  &
                      + .250*rxt(168)*y(25)


      end subroutine imp_nlnmat03

      subroutine imp_nlnmat04( mat, y, rxt )

      use MO_GRID_MOD,   only : pcnstm1
      use CHEM_MODS_MOD, only : rxntot, imp_nzcnt

      implicit none

!----------------------------------------------
!       ... Dummy args
!----------------------------------------------
      real, intent(in)    ::  y(pcnstm1)
      real, intent(in)    ::  rxt(rxntot)
      real, intent(inout) ::  mat(imp_nzcnt)


!----------------------------------------------
!       ... Local variables
!----------------------------------------------

!----------------------------------------------
!       ... Complete matrix entries Implicit species
!----------------------------------------------

         mat(198) = -(rxt(155)*y(6) + rxt(156)*y(8) + rxt(157)*y(18))
         mat(618) = -rxt(155)*y(56)
         mat(490) = -rxt(156)*y(56)
         mat(661) = -rxt(157)*y(56)

         mat(490) = mat(490) + rxt(154)*y(21)
         mat(240) = rxt(154)*y(8)

         mat(304) = -(rxt(160)*y(17) + rxt(161)*y(1) + rxt(162)*y(8))
         mat(778) = -rxt(160)*y(57)
         mat(546) = -rxt(161)*y(57)
         mat(495) = -rxt(162)*y(57)

         mat(622) = .080*rxt(113)*y(33) + rxt(123)*y(36) + .794*rxt(155)*y(56)
         mat(495) = mat(495) + .794*rxt(156)*y(56)
         mat(666) = .794*rxt(157)*y(56)
         mat(388) = .080*rxt(113)*y(6)
         mat(407) = rxt(123)*y(6)
         mat(199) = .794*rxt(155)*y(6) + .794*rxt(156)*y(8) + .794*rxt(157)*y(18)

         mat(375) = -(rxt(164)*y(6) + rxt(165)*y(8) + rxt(166)*y(18) + rxt(167)*y(13) &
                      + rxt(168)*y(25))
         mat(628) = -rxt(164)*y(58)
         mat(501) = -rxt(165)*y(58)
         mat(672) = -rxt(166)*y(58)
         mat(470) = -rxt(167)*y(58)
         mat(430) = -rxt(168)*y(58)

         mat(785) = rxt(163)*y(53) + rxt(169)*y(59) + .500*rxt(171)*y(60)
         mat(120) = rxt(163)*y(17)
         mat(27) = rxt(169)*y(17)
         mat(151) = .500*rxt(171)*y(17)

         mat(26) = -((rxt(169) + rxt(170)) * y(17))
         mat(747) = -(rxt(169) + rxt(170)) * y(59)

         mat(647) = rxt(166)*y(58)
         mat(370) = rxt(166)*y(18)

         mat(148) = -(rxt(171)*y(17))
         mat(766) = -rxt(171)*y(60)

         mat(656) = rxt(115)*y(33)
         mat(387) = rxt(115)*y(18)

         mat(15) = -(rxt(178)*y(17))
         mat(745) = -rxt(178)*y(63)

         mat(483) = rxt(181)*y(65)
         mat(745) = mat(745) + (rxt(179)+.750*rxt(180))*y(65)
         mat(29) = rxt(181)*y(8) + (rxt(179)+.750*rxt(180))*y(17)


         mat(741) = rxt(178)*y(63)
         mat(14) = rxt(178)*y(17)

         mat(30) = -((rxt(179) + rxt(180)) * y(17) + rxt(181)*y(8))
         mat(748) = -(rxt(179) + rxt(180)) * y(65)
         mat(484) = -rxt(181)*y(65)

         mat(6) = -(rxt(183)*y(17))
         mat(743) = -rxt(183)*y(66)



         mat(602) = -(rxt(192)*y(17) + rxt(215)*y(70) + rxt(216)*y(11) + rxt(219) &
                      *y(71) + rxt(220)*y(76))
         mat(795) = -rxt(192)*y(69)
         mat(166) = -rxt(215)*y(69)
         mat(112) = -rxt(216)*y(69)
         mat(236) = -rxt(219)*y(69)
         mat(277) = -rxt(220)*y(69)

         mat(733) = rxt(196)*y(72)
         mat(795) = mat(795) + rxt(210)*y(73)
         mat(682) = rxt(193)*y(72)
         mat(352) = rxt(196)*y(15) + rxt(193)*y(18)
         mat(528) = rxt(210)*y(17)

         mat(163) = -(rxt(215)*y(69) + rxt(221)*y(77))
         mat(591) = -rxt(215)*y(70)
         mat(313) = -rxt(221)*y(70)

         mat(658) = rxt(194)*y(73)
         mat(519) = rxt(194)*y(18)

         mat(230) = -(rxt(190)*y(2) + rxt(219)*y(69))
         mat(571) = -rxt(190)*y(71)
         mat(593) = -rxt(219)*y(71)

         mat(810) = rxt(189)*y(73)
         mat(520) = rxt(189)*y(7)

         mat(348) = -(rxt(186)*y(1) + rxt(193)*y(18) + rxt(196)*y(15))
         mat(550) = -rxt(186)*y(72)
         mat(670) = -rxt(193)*y(72)
         mat(727) = -rxt(196)*y(72)

         mat(574) = rxt(187)*y(73)
         mat(626) = rxt(188)*y(73)
         mat(110) = rxt(216)*y(69)
         mat(783) = rxt(192)*y(69) + rxt(195)*y(73)
         mat(596) = rxt(216)*y(11) + rxt(192)*y(17)
         mat(522) = rxt(187)*y(2) + rxt(188)*y(6) + rxt(195)*y(17) + rxt(202)*y(80)
         mat(710) = rxt(202)*y(73)

         mat(525) = -(rxt(187)*y(2) + rxt(188)*y(6) + rxt(189)*y(7) + rxt(194)*y(18) &
                      + (rxt(195) + rxt(210)) * y(17) + 4.*rxt(198)*y(73) + (rxt(202) &
                      + rxt(209)) * y(80))
         mat(577) = -rxt(187)*y(73)
         mat(635) = -rxt(188)*y(73)
         mat(819) = -rxt(189)*y(73)
         mat(679) = -rxt(194)*y(73)
         mat(792) = -(rxt(195) + rxt(210)) * y(73)
         mat(713) = -(rxt(202) + rxt(209)) * y(73)

         mat(559) = rxt(186)*y(72)
         mat(577) = mat(577) + rxt(190)*y(71)
         mat(234) = rxt(190)*y(2)
         mat(350) = rxt(186)*y(1)


         mat(517) = 2.000*rxt(198)*y(73)


         mat(588) = rxt(215)*y(70) + rxt(219)*y(71)
         mat(161) = rxt(215)*y(69)
         mat(227) = rxt(219)*y(69)

         mat(273) = -(rxt(205)*y(2) + rxt(220)*y(69) + rxt(222)*y(77))
         mat(572) = -rxt(205)*y(76)
         mat(594) = -rxt(220)*y(76)
         mat(314) = -rxt(222)*y(76)

         mat(664) = rxt(203)*y(80)
         mat(708) = rxt(203)*y(18)

         mat(315) = -(rxt(208)*y(17) + rxt(221)*y(70) + rxt(222)*y(76))
         mat(779) = -rxt(208)*y(77)
         mat(164) = -rxt(221)*y(77)
         mat(274) = -rxt(222)*y(77)

         mat(726) = rxt(207)*y(79)
         mat(667) = rxt(206)*y(79)
         mat(690) = rxt(207)*y(15) + rxt(206)*y(18)


         mat(804) = rxt(201)*y(80)
         mat(705) = rxt(201)*y(7)

         mat(700) = -(rxt(200)*y(1) + rxt(206)*y(18) + rxt(207)*y(15))
         mat(565) = -rxt(200)*y(79)
         mat(685) = -rxt(206)*y(79)
         mat(736) = -rxt(207)*y(79)

         mat(641) = rxt(204)*y(80)
         mat(798) = rxt(208)*y(77)
         mat(531) = rxt(202)*y(80)
         mat(278) = 2.000*rxt(222)*y(77)
         mat(319) = rxt(208)*y(17) + 2.000*rxt(222)*y(76)
         mat(719) = rxt(204)*y(6) + rxt(202)*y(73)

         mat(720) = -(rxt(201)*y(7) + (rxt(202) + rxt(209)) * y(73) + rxt(203)*y(18) &
                      + rxt(204)*y(6))
         mat(826) = -rxt(201)*y(80)
         mat(532) = -(rxt(202) + rxt(209)) * y(80)
         mat(686) = -rxt(203)*y(80)
         mat(642) = -rxt(204)*y(80)

         mat(566) = rxt(200)*y(79)
         mat(584) = rxt(205)*y(76)
         mat(279) = rxt(205)*y(2)
         mat(701) = rxt(200)*y(1)


         mat(589) = rxt(220)*y(76)
         mat(162) = rxt(221)*y(77)
         mat(518) = rxt(209)*y(80)
         mat(272) = rxt(220)*y(69)
         mat(312) = rxt(221)*y(70)
         mat(706) = rxt(209)*y(73)


         mat(97) = -(rxt(184)*y(1))
         mat(538) = -rxt(184)*y(83)

         mat(570) = rxt(75)*y(17)
         mat(758) = rxt(75)*y(2)


      end subroutine imp_nlnmat04

      subroutine imp_nlnmat_finit( mat, lmat, dti )

      use MO_GRID_MOD,   only : pcnstm1
      use CHEM_MODS_MOD, only : rxntot, imp_nzcnt, clsze

      implicit none

!----------------------------------------------
!       ... Dummy args
!----------------------------------------------
      real, intent(in)    ::  dti
      real, intent(in)    ::  lmat(imp_nzcnt)
      real, intent(inout) ::  mat(imp_nzcnt)


!----------------------------------------------
!       ... Local variables
!----------------------------------------------

!----------------------------------------------
!       ... Complete matrix entries Implicit species
!----------------------------------------------

         mat(   4) = lmat(   4)
         mat(   5) = lmat(   5)
         mat(   6) = mat(   6) + lmat(   6)
         mat(  11) = lmat(  11)
         mat(  12) = lmat(  12)
         mat(  13) = lmat(  13)
         mat(  17) = lmat(  17)
         mat(  18) = lmat(  18)
         mat(  19) = mat(  19) + lmat(  19)
         mat(  21) = mat(  21) + lmat(  21)
         mat(  22) = lmat(  22)
         mat(  23) = lmat(  23)
         mat(  24) = lmat(  24)
         mat(  25) = lmat(  25)
         mat(  26) = mat(  26) + lmat(  26)
         mat(  28) = mat(  28) + lmat(  28)
         mat(  34) = mat(  34) + lmat(  34)
         mat(  35) = mat(  35) + lmat(  35)
         mat(  36) = mat(  36) + lmat(  36)
         mat(  38) = lmat(  38)
         mat(  39) = lmat(  39)
         mat(  40) = lmat(  40)
         mat(  41) = lmat(  41)
         mat(  42) = lmat(  42)
         mat(  43) = lmat(  43)
         mat(  44) = lmat(  44)
         mat(  45) = lmat(  45)
         mat(  46) = lmat(  46)
         mat(  47) = lmat(  47)
         mat(  48) = lmat(  48)
         mat(  49) = lmat(  49)
         mat(  50) = lmat(  50)
         mat(  59) = mat(  59) + lmat(  59)
         mat(  60) = lmat(  60)
         mat(  62) = mat(  62) + lmat(  62)
         mat(  74) = mat(  74) + lmat(  74)
         mat(  76) = mat(  76) + lmat(  76)
         mat(  77) = lmat(  77)
         mat(  78) = mat(  78) + lmat(  78)
         mat(  79) = mat(  79) + lmat(  79)
         mat(  80) = lmat(  80)
         mat(  82) = lmat(  82)
         mat(  83) = mat(  83) + lmat(  83)
         mat(  84) = mat(  84) + lmat(  84)
         mat(  86) = lmat(  86)
         mat(  87) = lmat(  87)
         mat(  88) = mat(  88) + lmat(  88)
         mat(  89) = mat(  89) + lmat(  89)
         mat(  91) = lmat(  91)
         mat(  92) = mat(  92) + lmat(  92)
         mat(  93) = mat(  93) + lmat(  93)
         mat(  94) = lmat(  94)
         mat(  95) = lmat(  95)
         mat(  96) = lmat(  96)
         mat(  97) = mat(  97) + lmat(  97)
         mat(  99) = lmat(  99)
         mat( 108) = mat( 108) + lmat( 108)
         mat( 109) = mat( 109) + lmat( 109)
         mat( 111) = lmat( 111)
         mat( 113) = mat( 113) + lmat( 113)
         mat( 114) = mat( 114) + lmat( 114)
         mat( 116) = lmat( 116)
         mat( 118) = mat( 118) + lmat( 118)
         mat( 122) = mat( 122) + lmat( 122)
         mat( 124) = lmat( 124)
         mat( 126) = lmat( 126)
         mat( 127) = lmat( 127)
         mat( 128) = mat( 128) + lmat( 128)
         mat( 129) = mat( 129) + lmat( 129)
         mat( 130) = lmat( 130)
         mat( 131) = lmat( 131)
         mat( 132) = mat( 132) + lmat( 132)
         mat( 135) = lmat( 135)
         mat( 140) = mat( 140) + lmat( 140)
         mat( 142) = lmat( 142)
         mat( 147) = lmat( 147)
         mat( 148) = mat( 148) + lmat( 148)
         mat( 149) = lmat( 149)
         mat( 150) = lmat( 150)
         mat( 153) = lmat( 153)
         mat( 154) = lmat( 154)
         mat( 156) = mat( 156) + lmat( 156)
         mat( 158) = lmat( 158)
         mat( 159) = lmat( 159)
         mat( 163) = mat( 163) + lmat( 163)
         mat( 165) = lmat( 165)
         mat( 168) = lmat( 168)
         mat( 169) = mat( 169) + lmat( 169)
         mat( 171) = mat( 171) + lmat( 171)
         mat( 172) = lmat( 172)
         mat( 193) = mat( 193) + lmat( 193)
         mat( 195) = mat( 195) + lmat( 195)
         mat( 196) = lmat( 196)
         mat( 228) = lmat( 228)
         mat( 229) = mat( 229) + lmat( 229)
         mat( 230) = mat( 230) + lmat( 230)
         mat( 232) = lmat( 232)
         mat( 233) = mat( 233) + lmat( 233)
         mat( 273) = mat( 273) + lmat( 273)
         mat( 278) = mat( 278) + lmat( 278)
         mat( 280) = mat( 280) + lmat( 280)
         mat( 296) = mat( 296) + lmat( 296)
         mat( 298) = lmat( 298)
         mat( 300) = lmat( 300)
         mat( 304) = mat( 304) + lmat( 304)
         mat( 308) = mat( 308) + lmat( 308)
         mat( 309) = lmat( 309)
         mat( 311) = mat( 311) + lmat( 311)
         mat( 323) = mat( 323) + lmat( 323)
         mat( 324) = mat( 324) + lmat( 324)
         mat( 326) = lmat( 326)
         mat( 330) = mat( 330) + lmat( 330)
         mat( 331) = lmat( 331)
         mat( 333) = mat( 333) + lmat( 333)
         mat( 334) = lmat( 334)
         mat( 338) = mat( 338) + lmat( 338)
         mat( 340) = lmat( 340)
         mat( 341) = mat( 341) + lmat( 341)
         mat( 344) = mat( 344) + lmat( 344)
         mat( 345) = mat( 345) + lmat( 345)
         mat( 346) = mat( 346) + lmat( 346)
         mat( 348) = mat( 348) + lmat( 348)
         mat( 349) = lmat( 349)
         mat( 352) = mat( 352) + lmat( 352)
         mat( 355) = lmat( 355)
         mat( 359) = mat( 359) + lmat( 359)
         mat( 361) = lmat( 361)
         mat( 362) = lmat( 362)
         mat( 488) = mat( 488) + lmat( 488)
         mat( 507) = mat( 507) + lmat( 507)
         mat( 510) = lmat( 510)
         mat( 512) = mat( 512) + lmat( 512)
         mat( 516) = mat( 516) + lmat( 516)
         mat( 536) = lmat( 536)
         mat( 560) = mat( 560) + lmat( 560)
         mat( 561) = mat( 561) + lmat( 561)
         mat( 578) = mat( 578) + lmat( 578)
         mat( 579) = mat( 579) + lmat( 579)
         mat( 611) = mat( 611) + lmat( 611)
         mat( 637) = mat( 637) + lmat( 637)
         mat( 639) = mat( 639) + lmat( 639)
         mat( 715) = lmat( 715)
         mat( 719) = mat( 719) + lmat( 719)
         mat( 720) = mat( 720) + lmat( 720)
         mat( 724) = lmat( 724)
         mat( 735) = mat( 735) + lmat( 735)
         mat( 738) = mat( 738) + lmat( 738)
         mat( 742) = lmat( 742)
         mat( 758) = mat( 758) + lmat( 758)
         mat( 769) = mat( 769) + lmat( 769)
         mat( 773) = mat( 773) + lmat( 773)
         mat( 790) = mat( 790) + lmat( 790)
         mat( 797) = mat( 797) + lmat( 797)
         mat( 801) = mat( 801) + lmat( 801)
         mat( 821) = mat( 821) + lmat( 821)
         mat( 823) = mat( 823) + lmat( 823)
         mat( 829) = mat( 829) + lmat( 829)
         mat(   1) = 0.
         mat(   2) = 0.
         mat(   3) = 0.
         mat( 103) = 0.
         mat( 105) = 0.
         mat( 106) = 0.
         mat( 167) = 0.
         mat( 182) = 0.
         mat( 187) = 0.
         mat( 191) = 0.
         mat( 213) = 0.
         mat( 217) = 0.
         mat( 220) = 0.
         mat( 225) = 0.
         mat( 231) = 0.
         mat( 237) = 0.
         mat( 238) = 0.
         mat( 239) = 0.
         mat( 243) = 0.
         mat( 250) = 0.
         mat( 254) = 0.
         mat( 256) = 0.
         mat( 262) = 0.
         mat( 263) = 0.
         mat( 267) = 0.
         mat( 275) = 0.
         mat( 285) = 0.
         mat( 286) = 0.
         mat( 290) = 0.
         mat( 294) = 0.
         mat( 302) = 0.
         mat( 305) = 0.
         mat( 316) = 0.
         mat( 317) = 0.
         mat( 318) = 0.
         mat( 320) = 0.
         mat( 328) = 0.
         mat( 332) = 0.
         mat( 336) = 0.
         mat( 342) = 0.
         mat( 347) = 0.
         mat( 358) = 0.
         mat( 363) = 0.
         mat( 365) = 0.
         mat( 369) = 0.
         mat( 377) = 0.
         mat( 383) = 0.
         mat( 391) = 0.
         mat( 393) = 0.
         mat( 395) = 0.
         mat( 398) = 0.
         mat( 402) = 0.
         mat( 410) = 0.
         mat( 413) = 0.
         mat( 416) = 0.
         mat( 420) = 0.
         mat( 436) = 0.
         mat( 441) = 0.
         mat( 445) = 0.
         mat( 454) = 0.
         mat( 463) = 0.
         mat( 476) = 0.
         mat( 477) = 0.
         mat( 481) = 0.
         mat( 499) = 0.
         mat( 506) = 0.
         mat( 508) = 0.
         mat( 509) = 0.
         mat( 511) = 0.
         mat( 521) = 0.
         mat( 523) = 0.
         mat( 524) = 0.
         mat( 526) = 0.
         mat( 533) = 0.
         mat( 539) = 0.
         mat( 541) = 0.
         mat( 548) = 0.
         mat( 552) = 0.
         mat( 553) = 0.
         mat( 554) = 0.
         mat( 555) = 0.
         mat( 562) = 0.
         mat( 573) = 0.
         mat( 575) = 0.
         mat( 580) = 0.
         mat( 583) = 0.
         mat( 585) = 0.
         mat( 595) = 0.
         mat( 597) = 0.
         mat( 598) = 0.
         mat( 599) = 0.
         mat( 600) = 0.
         mat( 601) = 0.
         mat( 603) = 0.
         mat( 604) = 0.
         mat( 605) = 0.
         mat( 606) = 0.
         mat( 607) = 0.
         mat( 638) = 0.
         mat( 657) = 0.
         mat( 665) = 0.
         mat( 668) = 0.
         mat( 691) = 0.
         mat( 692) = 0.
         mat( 693) = 0.
         mat( 694) = 0.
         mat( 696) = 0.
         mat( 697) = 0.
         mat( 698) = 0.
         mat( 703) = 0.
         mat( 704) = 0.
         mat( 707) = 0.
         mat( 709) = 0.
         mat( 711) = 0.
         mat( 712) = 0.
         mat( 714) = 0.
         mat( 716) = 0.
         mat( 721) = 0.
         mat( 722) = 0.
         mat( 728) = 0.
         mat( 730) = 0.
         mat( 731) = 0.
         mat( 732) = 0.
         mat( 734) = 0.
         mat( 737) = 0.
         mat( 740) = 0.
         mat( 796) = 0.
         mat( 799) = 0.
         mat( 811) = 0.
         mat( 812) = 0.
         mat( 813) = 0.
         mat( 814) = 0.
         mat( 817) = 0.
         mat( 822) = 0.
         mat( 825) = 0.
         mat( 827) = 0.
         mat(   1) = -dti
         mat(   2) = -dti
         mat(   3) = -dti
         mat(   4) = mat(   4) - dti
         mat(   6) = mat(   6) - dti
         mat(   8) = mat(   8) - dti
         mat(  11) = mat(  11) - dti
         mat(  15) = mat(  15) - dti
         mat(  17) = mat(  17) - dti
         mat(  19) = mat(  19) - dti
         mat(  22) = mat(  22) - dti
         mat(  26) = mat(  26) - dti
         mat(  30) = mat(  30) - dti
         mat(  34) = mat(  34) - dti
         mat(  38) = mat(  38) - dti
         mat(  46) = mat(  46) - dti
         mat(  51) = mat(  51) - dti
         mat(  55) = mat(  55) - dti
         mat(  59) = mat(  59) - dti
         mat(  63) = mat(  63) - dti
         mat(  69) = mat(  69) - dti
         mat(  74) = mat(  74) - dti
         mat(  79) = mat(  79) - dti
         mat(  84) = mat(  84) - dti
         mat(  89) = mat(  89) - dti
         mat(  94) = mat(  94) - dti
         mat(  97) = mat(  97) - dti
         mat( 102) = mat( 102) - dti
         mat( 108) = mat( 108) - dti
         mat( 114) = mat( 114) - dti
         mat( 119) = mat( 119) - dti
         mat( 122) = mat( 122) - dti
         mat( 129) = mat( 129) - dti
         mat( 136) = mat( 136) - dti
         mat( 140) = mat( 140) - dti
         mat( 148) = mat( 148) - dti
         mat( 156) = mat( 156) - dti
         mat( 163) = mat( 163) - dti
         mat( 169) = mat( 169) - dti
         mat( 176) = mat( 176) - dti
         mat( 185) = mat( 185) - dti
         mat( 193) = mat( 193) - dti
         mat( 198) = mat( 198) - dti
         mat( 208) = mat( 208) - dti
         mat( 218) = mat( 218) - dti
         mat( 230) = mat( 230) - dti
         mat( 241) = mat( 241) - dti
         mat( 257) = mat( 257) - dti
         mat( 273) = mat( 273) - dti
         mat( 283) = mat( 283) - dti
         mat( 296) = mat( 296) - dti
         mat( 304) = mat( 304) - dti
         mat( 315) = mat( 315) - dti
         mat( 323) = mat( 323) - dti
         mat( 330) = mat( 330) - dti
         mat( 338) = mat( 338) - dti
         mat( 348) = mat( 348) - dti
         mat( 359) = mat( 359) - dti
         mat( 375) = mat( 375) - dti
         mat( 392) = mat( 392) - dti
         mat( 411) = mat( 411) - dti
         mat( 433) = mat( 433) - dti
         mat( 447) = mat( 447) - dti
         mat( 475) = mat( 475) - dti
         mat( 507) = mat( 507) - dti
         mat( 525) = mat( 525) - dti
         mat( 560) = mat( 560) - dti
         mat( 579) = mat( 579) - dti
         mat( 602) = mat( 602) - dti
         mat( 639) = mat( 639) - dti
         mat( 684) = mat( 684) - dti
         mat( 700) = mat( 700) - dti
         mat( 720) = mat( 720) - dti
         mat( 738) = mat( 738) - dti
         mat( 801) = mat( 801) - dti
         mat( 829) = mat( 829) - dti

      end subroutine imp_nlnmat_finit

      subroutine imp_nlnmat( mat, y, rxt, lmat, dti )

      use MO_GRID_MOD,   only : pcnstm1
      use CHEM_MODS_MOD, only : rxntot, imp_nzcnt, clsze

      implicit none

!----------------------------------------------
!       ... Dummy args
!----------------------------------------------
      real, intent(in)    ::  dti
      real, intent(in)    ::  lmat(imp_nzcnt)
      real, intent(in)    ::  y(pcnstm1)
      real, intent(in)    ::  rxt(rxntot)
      real, intent(inout) ::  mat(imp_nzcnt)

      call imp_nlnmat01( mat, y, rxt )
      call imp_nlnmat02( mat, y, rxt )
      call imp_nlnmat03( mat, y, rxt )
      call imp_nlnmat04( mat, y, rxt )
      call imp_nlnmat_finit( mat, lmat, dti )

      end subroutine imp_nlnmat

      end module MO_IMP_NLN_MATRIX_MOD

      module MO_ROD_NLN_MATRIX_MOD

      contains

      subroutine rod_nlnmat( mat, y, rxt, lmat, dti )

      use MO_GRID_MOD,   only : pcnstm1
      use CHEM_MODS_MOD, only : rxntot, rod_nzcnt, clsze

      implicit none

!----------------------------------------------
!       ... Dummy args
!----------------------------------------------
      real, intent(in)    ::  dti
      real, intent(in)    ::  lmat(rod_nzcnt)
      real, intent(in)    ::  y(pcnstm1)
      real, intent(in)    ::  rxt(rxntot)
      real, intent(inout) ::  mat(rod_nzcnt)


      end subroutine rod_nlnmat

      end module MO_ROD_NLN_MATRIX_MOD

      module MO_IMP_FACTOR_MOD

      contains
                                                                        
      subroutine imp_lu_fac01( lu )
                                                                        
      use CHEM_MODS_MOD, only : imp_nzcnt, clsze
                                                                        
      implicit none
                                                                        
!-----------------------------------------------------------------------
!       ... Dummy args
!-----------------------------------------------------------------------
      real, intent(inout) ::   lu(imp_nzcnt)
                                                                        
         lu(1) = 1. / lu(1)
                                                                        
         lu(2) = 1. / lu(2)
                                                                        
         lu(3) = 1. / lu(3)
                                                                        
         lu(4) = 1. / lu(4)
                                                                        
         lu(6) = 1. / lu(6)
         lu(7) = lu(7) * lu(6)
         lu(801) = lu(801) - lu(7) * lu(743)
                                                                        
         lu(8) = 1. / lu(8)
         lu(9) = lu(9) * lu(8)
         lu(10) = lu(10) * lu(8)
         lu(773) = lu(773) - lu(9) * lu(744)
         lu(801) = lu(801) - lu(10) * lu(744)
                                                                        
         lu(11) = 1. / lu(11)
         lu(12) = lu(12) * lu(11)
         lu(13) = lu(13) * lu(11)
         lu(522) = lu(522) - lu(12) * lu(517)
         lu(525) = lu(525) - lu(13) * lu(517)
                                                                        
         lu(15) = 1. / lu(15)
         lu(16) = lu(16) * lu(15)
         lu(32) = lu(32) - lu(16) * lu(29)
         lu(515) = lu(515) - lu(16) * lu(483)
         lu(801) = lu(801) - lu(16) * lu(745)
                                                                        
         lu(17) = 1. / lu(17)
         lu(18) = lu(18) * lu(17)
         lu(165) = lu(165) - lu(18) * lu(161)
         lu(232) = lu(232) - lu(18) * lu(227)
         lu(596) = lu(596) - lu(18) * lu(588)
                                                                        
         lu(19) = 1. / lu(19)
         lu(20) = lu(20) * lu(19)
         lu(21) = lu(21) * lu(19)
         lu(684) = lu(684) - lu(20) * lu(646)
         lu(688) = lu(688) - lu(21) * lu(646)
         lu(797) = lu(797) - lu(20) * lu(746)
         lu(801) = lu(801) - lu(21) * lu(746)
                                                                        
         lu(22) = 1. / lu(22)
         lu(23) = lu(23) * lu(22)
         lu(24) = lu(24) * lu(22)
         lu(25) = lu(25) * lu(22)
         lu(103) = - lu(23) * lu(101)
         lu(105) = - lu(24) * lu(101)
         lu(106) = - lu(25) * lu(101)
         lu(617) = lu(617) - lu(23) * lu(610)
         lu(640) = lu(640) - lu(24) * lu(610)
         lu(643) = lu(643) - lu(25) * lu(610)
                                                                        
         lu(26) = 1. / lu(26)
         lu(27) = lu(27) * lu(26)
         lu(28) = lu(28) * lu(26)
         lu(375) = lu(375) - lu(27) * lu(370)
         lu(383) = - lu(28) * lu(370)
         lu(672) = lu(672) - lu(27) * lu(647)
         lu(688) = lu(688) - lu(28) * lu(647)
         lu(785) = lu(785) - lu(27) * lu(747)
         lu(801) = lu(801) - lu(28) * lu(747)
                                                                        
         lu(30) = 1. / lu(30)
         lu(31) = lu(31) * lu(30)
         lu(32) = lu(32) * lu(30)
         lu(33) = lu(33) * lu(30)
         lu(507) = lu(507) - lu(31) * lu(484)
         lu(515) = lu(515) - lu(32) * lu(484)
         lu(516) = lu(516) - lu(33) * lu(484)
         lu(791) = lu(791) - lu(31) * lu(748)
         lu(801) = lu(801) - lu(32) * lu(748)
         lu(802) = lu(802) - lu(33) * lu(748)
                                                                        
         lu(34) = 1. / lu(34)
         lu(35) = lu(35) * lu(34)
         lu(36) = lu(36) * lu(34)
         lu(37) = lu(37) * lu(34)
         lu(637) = lu(637) - lu(35) * lu(611)
         lu(639) = lu(639) - lu(36) * lu(611)
         lu(645) = lu(645) - lu(37) * lu(611)
         lu(821) = lu(821) - lu(35) * lu(803)
         lu(823) = lu(823) - lu(36) * lu(803)
         lu(829) = lu(829) - lu(37) * lu(803)
                                                                        
         lu(38) = 1. / lu(38)
         lu(39) = lu(39) * lu(38)
         lu(40) = lu(40) * lu(38)
         lu(41) = lu(41) * lu(38)
         lu(42) = lu(42) * lu(38)
         lu(43) = lu(43) * lu(38)
         lu(44) = lu(44) * lu(38)
         lu(45) = lu(45) * lu(38)
         lu(538) = lu(538) - lu(39) * lu(536)
         lu(557) = lu(557) - lu(40) * lu(536)
         lu(561) = lu(561) - lu(41) * lu(536)
         lu(563) = lu(563) - lu(42) * lu(536)
         lu(564) = lu(564) - lu(43) * lu(536)
         lu(567) = lu(567) - lu(44) * lu(536)
         lu(568) = lu(568) - lu(45) * lu(536)
                                                                        
         lu(46) = 1. / lu(46)
         lu(47) = lu(47) * lu(46)
         lu(48) = lu(48) * lu(46)
         lu(49) = lu(49) * lu(46)
         lu(50) = lu(50) * lu(46)
         lu(707) = - lu(47) * lu(705)
         lu(708) = lu(708) - lu(48) * lu(705)
         lu(712) = - lu(49) * lu(705)
         lu(719) = lu(719) - lu(50) * lu(705)
         lu(809) = lu(809) - lu(47) * lu(804)
         lu(811) = - lu(48) * lu(804)
         lu(818) = lu(818) - lu(49) * lu(804)
         lu(825) = - lu(50) * lu(804)
                                                                        
                                                                        
      end subroutine imp_lu_fac01
                                                                        
      subroutine imp_lu_fac02( lu )
                                                                        
      use CHEM_MODS_MOD, only : imp_nzcnt, clsze
                                                                        
      implicit none
                                                                        
!-----------------------------------------------------------------------
!       ... Dummy args
!-----------------------------------------------------------------------
      real, intent(inout) ::   lu(imp_nzcnt)
                                                                        
         lu(51) = 1. / lu(51)
         lu(52) = lu(52) * lu(51)
         lu(53) = lu(53) * lu(51)
         lu(54) = lu(54) * lu(51)
         lu(285) = - lu(52) * lu(281)
         lu(293) = lu(293) - lu(53) * lu(281)
         lu(294) = - lu(54) * lu(281)
         lu(496) = lu(496) - lu(52) * lu(485)
         lu(515) = lu(515) - lu(53) * lu(485)
         lu(516) = lu(516) - lu(54) * lu(485)
         lu(780) = lu(780) - lu(52) * lu(749)
         lu(801) = lu(801) - lu(53) * lu(749)
         lu(802) = lu(802) - lu(54) * lu(749)
                                                                        
         lu(55) = 1. / lu(55)
         lu(56) = lu(56) * lu(55)
         lu(57) = lu(57) * lu(55)
         lu(58) = lu(58) * lu(55)
         lu(177) = lu(177) - lu(56) * lu(173)
         lu(180) = lu(180) - lu(57) * lu(173)
         lu(182) = - lu(58) * lu(173)
         lu(465) = lu(465) - lu(56) * lu(456)
         lu(479) = lu(479) - lu(57) * lu(456)
         lu(481) = - lu(58) * lu(456)
         lu(777) = lu(777) - lu(56) * lu(750)
         lu(797) = lu(797) - lu(57) * lu(750)
         lu(801) = lu(801) - lu(58) * lu(750)
                                                                        
         lu(59) = 1. / lu(59)
         lu(60) = lu(60) * lu(59)
         lu(61) = lu(61) * lu(59)
         lu(62) = lu(62) * lu(59)
         lu(684) = lu(684) - lu(60) * lu(648)
         lu(688) = lu(688) - lu(61) * lu(648)
         lu(689) = lu(689) - lu(62) * lu(648)
         lu(797) = lu(797) - lu(60) * lu(751)
         lu(801) = lu(801) - lu(61) * lu(751)
         lu(802) = lu(802) - lu(62) * lu(751)
         lu(824) = lu(824) - lu(60) * lu(805)
         lu(828) = lu(828) - lu(61) * lu(805)
         lu(829) = lu(829) - lu(62) * lu(805)
                                                                        
         lu(63) = 1. / lu(63)
         lu(64) = lu(64) * lu(63)
         lu(65) = lu(65) * lu(63)
         lu(66) = lu(66) * lu(63)
         lu(67) = lu(67) * lu(63)
         lu(68) = lu(68) * lu(63)
         lu(539) = - lu(64) * lu(537)
         lu(560) = lu(560) - lu(65) * lu(537)
         lu(564) = lu(564) - lu(66) * lu(537)
         lu(567) = lu(567) - lu(67) * lu(537)
         lu(568) = lu(568) - lu(68) * lu(537)
         lu(759) = lu(759) - lu(64) * lu(752)
         lu(793) = lu(793) - lu(65) * lu(752)
         lu(797) = lu(797) - lu(66) * lu(752)
         lu(800) = lu(800) - lu(67) * lu(752)
         lu(801) = lu(801) - lu(68) * lu(752)
                                                                        
         lu(69) = 1. / lu(69)
         lu(70) = lu(70) * lu(69)
         lu(71) = lu(71) * lu(69)
         lu(72) = lu(72) * lu(69)
         lu(73) = lu(73) * lu(69)
         lu(411) = lu(411) - lu(70) * lu(404)
         lu(413) = - lu(71) * lu(404)
         lu(418) = lu(418) - lu(72) * lu(404)
         lu(420) = - lu(73) * lu(404)
         lu(674) = lu(674) - lu(70) * lu(649)
         lu(676) = lu(676) - lu(71) * lu(649)
         lu(684) = lu(684) - lu(72) * lu(649)
         lu(688) = lu(688) - lu(73) * lu(649)
         lu(787) = lu(787) - lu(70) * lu(753)
         lu(789) = lu(789) - lu(71) * lu(753)
         lu(797) = lu(797) - lu(72) * lu(753)
         lu(801) = lu(801) - lu(73) * lu(753)
                                                                        
         lu(74) = 1. / lu(74)
         lu(75) = lu(75) * lu(74)
         lu(76) = lu(76) * lu(74)
         lu(77) = lu(77) * lu(74)
         lu(78) = lu(78) * lu(74)
         lu(176) = lu(176) - lu(75) * lu(174)
         lu(177) = lu(177) - lu(76) * lu(174)
         lu(180) = lu(180) - lu(77) * lu(174)
         lu(182) = lu(182) - lu(78) * lu(174)
         lu(659) = lu(659) - lu(75) * lu(650)
         lu(665) = - lu(76) * lu(650)
         lu(684) = lu(684) - lu(77) * lu(650)
         lu(688) = lu(688) - lu(78) * lu(650)
         lu(769) = lu(769) - lu(75) * lu(754)
         lu(777) = lu(777) - lu(76) * lu(754)
         lu(797) = lu(797) - lu(77) * lu(754)
         lu(801) = lu(801) - lu(78) * lu(754)
                                                                        
         lu(79) = 1. / lu(79)
         lu(80) = lu(80) * lu(79)
         lu(81) = lu(81) * lu(79)
         lu(82) = lu(82) * lu(79)
         lu(83) = lu(83) * lu(79)
         lu(216) = lu(216) - lu(80) * lu(215)
         lu(218) = lu(218) - lu(81) * lu(215)
         lu(223) = lu(223) - lu(82) * lu(215)
         lu(225) = - lu(83) * lu(215)
         lu(657) = - lu(80) * lu(651)
         lu(663) = lu(663) - lu(81) * lu(651)
         lu(684) = lu(684) - lu(82) * lu(651)
         lu(688) = lu(688) - lu(83) * lu(651)
         lu(767) = lu(767) - lu(80) * lu(755)
         lu(773) = lu(773) - lu(81) * lu(755)
         lu(797) = lu(797) - lu(82) * lu(755)
         lu(801) = lu(801) - lu(83) * lu(755)
                                                                        
         lu(84) = 1. / lu(84)
         lu(85) = lu(85) * lu(84)
         lu(86) = lu(86) * lu(84)
         lu(87) = lu(87) * lu(84)
         lu(88) = lu(88) * lu(84)
         lu(208) = lu(208) - lu(85) * lu(207)
         lu(209) = lu(209) - lu(86) * lu(207)
         lu(212) = lu(212) - lu(87) * lu(207)
         lu(213) = - lu(88) * lu(207)
         lu(662) = lu(662) - lu(85) * lu(652)
         lu(675) = lu(675) - lu(86) * lu(652)
         lu(687) = lu(687) - lu(87) * lu(652)
         lu(688) = lu(688) - lu(88) * lu(652)
         lu(772) = lu(772) - lu(85) * lu(756)
         lu(788) = lu(788) - lu(86) * lu(756)
         lu(800) = lu(800) - lu(87) * lu(756)
         lu(801) = lu(801) - lu(88) * lu(756)
                                                                        
         lu(89) = 1. / lu(89)
         lu(90) = lu(90) * lu(89)
         lu(91) = lu(91) * lu(89)
         lu(92) = lu(92) * lu(89)
         lu(93) = lu(93) * lu(89)
         lu(475) = lu(475) - lu(90) * lu(457)
         lu(479) = lu(479) - lu(91) * lu(457)
         lu(480) = lu(480) - lu(92) * lu(457)
         lu(481) = lu(481) - lu(93) * lu(457)
         lu(677) = lu(677) - lu(90) * lu(653)
         lu(684) = lu(684) - lu(91) * lu(653)
         lu(687) = lu(687) - lu(92) * lu(653)
         lu(688) = lu(688) - lu(93) * lu(653)
         lu(790) = lu(790) - lu(90) * lu(757)
         lu(797) = lu(797) - lu(91) * lu(757)
         lu(800) = lu(800) - lu(92) * lu(757)
         lu(801) = lu(801) - lu(93) * lu(757)
                                                                        
                                                                        
      end subroutine imp_lu_fac02
                                                                        
      subroutine imp_lu_fac03( lu )
                                                                        
      use CHEM_MODS_MOD, only : imp_nzcnt, clsze
                                                                        
      implicit none
                                                                        
!-----------------------------------------------------------------------
!       ... Dummy args
!-----------------------------------------------------------------------
      real, intent(inout) ::   lu(imp_nzcnt)
                                                                        
         lu(94) = 1. / lu(94)
         lu(95) = lu(95) * lu(94)
         lu(96) = lu(96) * lu(94)
         lu(165) = lu(165) - lu(95) * lu(162)
         lu(167) = - lu(96) * lu(162)
         lu(275) = - lu(95) * lu(272)
         lu(278) = lu(278) - lu(96) * lu(272)
         lu(316) = - lu(95) * lu(312)
         lu(319) = lu(319) - lu(96) * lu(312)
         lu(522) = lu(522) - lu(95) * lu(518)
         lu(531) = lu(531) - lu(96) * lu(518)
         lu(596) = lu(596) - lu(95) * lu(589)
         lu(605) = - lu(96) * lu(589)
         lu(710) = lu(710) - lu(95) * lu(706)
         lu(719) = lu(719) - lu(96) * lu(706)
                                                                        
         lu(97) = 1. / lu(97)
         lu(98) = lu(98) * lu(97)
         lu(99) = lu(99) * lu(97)
         lu(100) = lu(100) * lu(97)
         lu(560) = lu(560) - lu(98) * lu(538)
         lu(564) = lu(564) - lu(99) * lu(538)
         lu(568) = lu(568) - lu(100) * lu(538)
         lu(578) = lu(578) - lu(98) * lu(570)
         lu(582) = lu(582) - lu(99) * lu(570)
         lu(586) = lu(586) - lu(100) * lu(570)
         lu(731) = - lu(98) * lu(724)
         lu(735) = lu(735) - lu(99) * lu(724)
         lu(739) = lu(739) - lu(100) * lu(724)
         lu(793) = lu(793) - lu(98) * lu(758)
         lu(797) = lu(797) - lu(99) * lu(758)
         lu(801) = lu(801) - lu(100) * lu(758)
                                                                        
         lu(102) = 1. / lu(102)
         lu(103) = lu(103) * lu(102)
         lu(104) = lu(104) * lu(102)
         lu(105) = lu(105) * lu(102)
         lu(106) = lu(106) * lu(102)
         lu(107) = lu(107) * lu(102)
         lu(541) = - lu(103) * lu(539)
         lu(563) = lu(563) - lu(104) * lu(539)
         lu(564) = lu(564) - lu(105) * lu(539)
         lu(567) = lu(567) - lu(106) * lu(539)
         lu(569) = lu(569) - lu(107) * lu(539)
         lu(617) = lu(617) - lu(103) * lu(612)
         lu(639) = lu(639) - lu(104) * lu(612)
         lu(640) = lu(640) - lu(105) * lu(612)
         lu(643) = lu(643) - lu(106) * lu(612)
         lu(645) = lu(645) - lu(107) * lu(612)
         lu(771) = lu(771) - lu(103) * lu(759)
         lu(796) = - lu(104) * lu(759)
         lu(797) = lu(797) - lu(105) * lu(759)
         lu(800) = lu(800) - lu(106) * lu(759)
         lu(802) = lu(802) - lu(107) * lu(759)
                                                                        
         lu(108) = 1. / lu(108)
         lu(109) = lu(109) * lu(108)
         lu(110) = lu(110) * lu(108)
         lu(111) = lu(111) * lu(108)
         lu(112) = lu(112) * lu(108)
         lu(113) = lu(113) * lu(108)
         lu(488) = lu(488) - lu(109) * lu(486)
         lu(499) = - lu(110) * lu(486)
         lu(507) = lu(507) - lu(111) * lu(486)
         lu(511) = - lu(112) * lu(486)
         lu(516) = lu(516) - lu(113) * lu(486)
         lu(592) = lu(592) - lu(109) * lu(590)
         lu(596) = lu(596) - lu(110) * lu(590)
         lu(598) = - lu(111) * lu(590)
         lu(602) = lu(602) - lu(112) * lu(590)
         lu(609) = lu(609) - lu(113) * lu(590)
         lu(809) = lu(809) - lu(109) * lu(806)
         lu(814) = - lu(110) * lu(806)
         lu(818) = lu(818) - lu(111) * lu(806)
         lu(822) = - lu(112) * lu(806)
         lu(829) = lu(829) - lu(113) * lu(806)
                                                                        
         lu(114) = 1. / lu(114)
         lu(115) = lu(115) * lu(114)
         lu(116) = lu(116) * lu(114)
         lu(117) = lu(117) * lu(114)
         lu(118) = lu(118) * lu(114)
         lu(433) = lu(433) - lu(115) * lu(422)
         lu(435) = lu(435) - lu(116) * lu(422)
         lu(440) = lu(440) - lu(117) * lu(422)
         lu(441) = - lu(118) * lu(422)
         lu(446) = lu(446) - lu(115) * lu(443)
         lu(448) = lu(448) - lu(116) * lu(443)
         lu(453) = lu(453) - lu(117) * lu(443)
         lu(454) = - lu(118) * lu(443)
         lu(675) = lu(675) - lu(115) * lu(654)
         lu(677) = lu(677) - lu(116) * lu(654)
         lu(687) = lu(687) - lu(117) * lu(654)
         lu(688) = lu(688) - lu(118) * lu(654)
         lu(788) = lu(788) - lu(115) * lu(760)
         lu(790) = lu(790) - lu(116) * lu(760)
         lu(800) = lu(800) - lu(117) * lu(760)
         lu(801) = lu(801) - lu(118) * lu(760)
                                                                        
         lu(119) = 1. / lu(119)
         lu(120) = lu(120) * lu(119)
         lu(121) = lu(121) * lu(119)
         lu(305) = - lu(120) * lu(303)
         lu(310) = lu(310) - lu(121) * lu(303)
         lu(391) = - lu(120) * lu(385)
         lu(402) = - lu(121) * lu(385)
         lu(430) = lu(430) - lu(120) * lu(423)
         lu(441) = lu(441) - lu(121) * lu(423)
         lu(470) = lu(470) - lu(120) * lu(458)
         lu(481) = lu(481) - lu(121) * lu(458)
         lu(501) = lu(501) - lu(120) * lu(487)
         lu(515) = lu(515) - lu(121) * lu(487)
         lu(552) = - lu(120) * lu(540)
         lu(568) = lu(568) - lu(121) * lu(540)
         lu(628) = lu(628) - lu(120) * lu(613)
         lu(644) = lu(644) - lu(121) * lu(613)
         lu(785) = lu(785) - lu(120) * lu(761)
         lu(801) = lu(801) - lu(121) * lu(761)
                                                                        
         lu(122) = 1. / lu(122)
         lu(123) = lu(123) * lu(122)
         lu(124) = lu(124) * lu(122)
         lu(125) = lu(125) * lu(122)
         lu(126) = lu(126) * lu(122)
         lu(127) = lu(127) * lu(122)
         lu(128) = lu(128) * lu(122)
         lu(185) = lu(185) - lu(123) * lu(184)
         lu(186) = lu(186) - lu(124) * lu(184)
         lu(187) = - lu(125) * lu(184)
         lu(189) = lu(189) - lu(126) * lu(184)
         lu(190) = lu(190) - lu(127) * lu(184)
         lu(191) = - lu(128) * lu(184)
         lu(660) = lu(660) - lu(123) * lu(655)
         lu(665) = lu(665) - lu(124) * lu(655)
         lu(668) = - lu(125) * lu(655)
         lu(684) = lu(684) - lu(126) * lu(655)
         lu(687) = lu(687) - lu(127) * lu(655)
         lu(688) = lu(688) - lu(128) * lu(655)
         lu(770) = lu(770) - lu(123) * lu(762)
         lu(777) = lu(777) - lu(124) * lu(762)
         lu(781) = lu(781) - lu(125) * lu(762)
         lu(797) = lu(797) - lu(126) * lu(762)
         lu(800) = lu(800) - lu(127) * lu(762)
         lu(801) = lu(801) - lu(128) * lu(762)
                                                                        
                                                                        
      end subroutine imp_lu_fac03
                                                                        
      subroutine imp_lu_fac04( lu )
                                                                        
      use CHEM_MODS_MOD, only : imp_nzcnt, clsze
                                                                        
      implicit none
                                                                        
!-----------------------------------------------------------------------
!       ... Dummy args
!-----------------------------------------------------------------------
      real, intent(inout) ::   lu(imp_nzcnt)
                                                                        
         lu(129) = 1. / lu(129)
         lu(130) = lu(130) * lu(129)
         lu(131) = lu(131) * lu(129)
         lu(132) = lu(132) * lu(129)
         lu(133) = lu(133) * lu(129)
         lu(134) = lu(134) * lu(129)
         lu(135) = lu(135) * lu(129)
         lu(433) = lu(433) - lu(130) * lu(424)
         lu(435) = lu(435) - lu(131) * lu(424)
         lu(436) = - lu(132) * lu(424)
         lu(440) = lu(440) - lu(133) * lu(424)
         lu(441) = lu(441) - lu(134) * lu(424)
         lu(442) = lu(442) - lu(135) * lu(424)
         lu(788) = lu(788) - lu(130) * lu(763)
         lu(790) = lu(790) - lu(131) * lu(763)
         lu(791) = lu(791) - lu(132) * lu(763)
         lu(800) = lu(800) - lu(133) * lu(763)
         lu(801) = lu(801) - lu(134) * lu(763)
         lu(802) = lu(802) - lu(135) * lu(763)
         lu(815) = lu(815) - lu(130) * lu(807)
         lu(817) = - lu(131) * lu(807)
         lu(818) = lu(818) - lu(132) * lu(807)
         lu(827) = - lu(133) * lu(807)
         lu(828) = lu(828) - lu(134) * lu(807)
         lu(829) = lu(829) - lu(135) * lu(807)
                                                                        
         lu(136) = 1. / lu(136)
         lu(137) = lu(137) * lu(136)
         lu(138) = lu(138) * lu(136)
         lu(139) = lu(139) * lu(136)
         lu(180) = lu(180) - lu(137) * lu(175)
         lu(181) = lu(181) - lu(138) * lu(175)
         lu(182) = lu(182) - lu(139) * lu(175)
         lu(381) = lu(381) - lu(137) * lu(371)
         lu(382) = lu(382) - lu(138) * lu(371)
         lu(383) = lu(383) - lu(139) * lu(371)
         lu(400) = lu(400) - lu(137) * lu(386)
         lu(401) = lu(401) - lu(138) * lu(386)
         lu(402) = lu(402) - lu(139) * lu(386)
         lu(418) = lu(418) - lu(137) * lu(405)
         lu(419) = lu(419) - lu(138) * lu(405)
         lu(420) = lu(420) - lu(139) * lu(405)
         lu(479) = lu(479) - lu(137) * lu(459)
         lu(480) = lu(480) - lu(138) * lu(459)
         lu(481) = lu(481) - lu(139) * lu(459)
         lu(797) = lu(797) - lu(137) * lu(764)
         lu(800) = lu(800) - lu(138) * lu(764)
         lu(801) = lu(801) - lu(139) * lu(764)
                                                                        
         lu(140) = 1. / lu(140)
         lu(141) = lu(141) * lu(140)
         lu(142) = lu(142) * lu(140)
         lu(143) = lu(143) * lu(140)
         lu(144) = lu(144) * lu(140)
         lu(145) = lu(145) * lu(140)
         lu(146) = lu(146) * lu(140)
         lu(147) = lu(147) * lu(140)
         lu(445) = - lu(141) * lu(444)
         lu(447) = lu(447) - lu(142) * lu(444)
         lu(449) = lu(449) - lu(143) * lu(444)
         lu(452) = lu(452) - lu(144) * lu(444)
         lu(453) = lu(453) - lu(145) * lu(444)
         lu(454) = lu(454) - lu(146) * lu(444)
         lu(455) = lu(455) - lu(147) * lu(444)
         lu(781) = lu(781) - lu(141) * lu(765)
         lu(789) = lu(789) - lu(142) * lu(765)
         lu(791) = lu(791) - lu(143) * lu(765)
         lu(797) = lu(797) - lu(144) * lu(765)
         lu(800) = lu(800) - lu(145) * lu(765)
         lu(801) = lu(801) - lu(146) * lu(765)
         lu(802) = lu(802) - lu(147) * lu(765)
         lu(813) = - lu(141) * lu(808)
         lu(816) = lu(816) - lu(142) * lu(808)
         lu(818) = lu(818) - lu(143) * lu(808)
         lu(824) = lu(824) - lu(144) * lu(808)
         lu(827) = lu(827) - lu(145) * lu(808)
         lu(828) = lu(828) - lu(146) * lu(808)
         lu(829) = lu(829) - lu(147) * lu(808)
                                                                        
         lu(148) = 1. / lu(148)
         lu(149) = lu(149) * lu(148)
         lu(150) = lu(150) * lu(148)
         lu(151) = lu(151) * lu(148)
         lu(152) = lu(152) * lu(148)
         lu(153) = lu(153) * lu(148)
         lu(154) = lu(154) * lu(148)
         lu(155) = lu(155) * lu(148)
         lu(389) = lu(389) - lu(149) * lu(387)
         lu(390) = lu(390) - lu(150) * lu(387)
         lu(391) = lu(391) - lu(151) * lu(387)
         lu(392) = lu(392) - lu(152) * lu(387)
         lu(400) = lu(400) - lu(153) * lu(387)
         lu(401) = lu(401) - lu(154) * lu(387)
         lu(402) = lu(402) - lu(155) * lu(387)
         lu(669) = lu(669) - lu(149) * lu(656)
         lu(671) = lu(671) - lu(150) * lu(656)
         lu(672) = lu(672) - lu(151) * lu(656)
         lu(673) = lu(673) - lu(152) * lu(656)
         lu(684) = lu(684) - lu(153) * lu(656)
         lu(687) = lu(687) - lu(154) * lu(656)
         lu(688) = lu(688) - lu(155) * lu(656)
         lu(782) = lu(782) - lu(149) * lu(766)
         lu(784) = lu(784) - lu(150) * lu(766)
         lu(785) = lu(785) - lu(151) * lu(766)
         lu(786) = lu(786) - lu(152) * lu(766)
         lu(797) = lu(797) - lu(153) * lu(766)
         lu(800) = lu(800) - lu(154) * lu(766)
         lu(801) = lu(801) - lu(155) * lu(766)
                                                                        
         lu(156) = 1. / lu(156)
         lu(157) = lu(157) * lu(156)
         lu(158) = lu(158) * lu(156)
         lu(159) = lu(159) * lu(156)
         lu(160) = lu(160) * lu(156)
         lu(217) = - lu(157) * lu(216)
         lu(220) = - lu(158) * lu(216)
         lu(221) = lu(221) - lu(159) * lu(216)
         lu(225) = lu(225) - lu(160) * lu(216)
         lu(256) = - lu(157) * lu(255)
         lu(262) = - lu(158) * lu(255)
         lu(263) = - lu(159) * lu(255)
         lu(270) = lu(270) - lu(160) * lu(255)
         lu(463) = - lu(157) * lu(460)
         lu(473) = lu(473) - lu(158) * lu(460)
         lu(475) = lu(475) - lu(159) * lu(460)
         lu(481) = lu(481) - lu(160) * lu(460)
         lu(619) = lu(619) - lu(157) * lu(614)
         lu(631) = lu(631) - lu(158) * lu(614)
         lu(633) = lu(633) - lu(159) * lu(614)
         lu(644) = lu(644) - lu(160) * lu(614)
         lu(662) = lu(662) - lu(157) * lu(657)
         lu(675) = lu(675) - lu(158) * lu(657)
         lu(677) = lu(677) - lu(159) * lu(657)
         lu(688) = lu(688) - lu(160) * lu(657)
         lu(772) = lu(772) - lu(157) * lu(767)
         lu(788) = lu(788) - lu(158) * lu(767)
         lu(790) = lu(790) - lu(159) * lu(767)
         lu(801) = lu(801) - lu(160) * lu(767)
                                                                        
         lu(163) = 1. / lu(163)
         lu(164) = lu(164) * lu(163)
         lu(165) = lu(165) * lu(163)
         lu(166) = lu(166) * lu(163)
         lu(167) = lu(167) * lu(163)
         lu(168) = lu(168) * lu(163)
         lu(231) = - lu(164) * lu(228)
         lu(232) = lu(232) - lu(165) * lu(228)
         lu(236) = lu(236) - lu(166) * lu(228)
         lu(237) = - lu(167) * lu(228)
         lu(238) = - lu(168) * lu(228)
         lu(315) = lu(315) - lu(164) * lu(313)
         lu(316) = lu(316) - lu(165) * lu(313)
         lu(318) = - lu(166) * lu(313)
         lu(319) = lu(319) - lu(167) * lu(313)
         lu(321) = lu(321) - lu(168) * lu(313)
         lu(521) = - lu(164) * lu(519)
         lu(522) = lu(522) - lu(165) * lu(519)
         lu(528) = lu(528) - lu(166) * lu(519)
         lu(531) = lu(531) - lu(167) * lu(519)
         lu(534) = lu(534) - lu(168) * lu(519)
         lu(595) = - lu(164) * lu(591)
         lu(596) = lu(596) - lu(165) * lu(591)
         lu(602) = lu(602) - lu(166) * lu(591)
         lu(605) = lu(605) - lu(167) * lu(591)
         lu(608) = lu(608) - lu(168) * lu(591)
         lu(667) = lu(667) - lu(164) * lu(658)
         lu(670) = lu(670) - lu(165) * lu(658)
         lu(682) = lu(682) - lu(166) * lu(658)
         lu(685) = lu(685) - lu(167) * lu(658)
         lu(688) = lu(688) - lu(168) * lu(658)
                                                                        
                                                                        
      end subroutine imp_lu_fac04
                                                                        
      subroutine imp_lu_fac05( lu )
                                                                        
      use CHEM_MODS_MOD, only : imp_nzcnt, clsze
                                                                        
      implicit none
                                                                        
!-----------------------------------------------------------------------
!       ... Dummy args
!-----------------------------------------------------------------------
      real, intent(inout) ::   lu(imp_nzcnt)
                                                                        
         lu(169) = 1. / lu(169)
         lu(170) = lu(170) * lu(169)
         lu(171) = lu(171) * lu(169)
         lu(172) = lu(172) * lu(169)
         lu(233) = lu(233) - lu(170) * lu(229)
         lu(238) = lu(238) - lu(171) * lu(229)
         lu(239) = - lu(172) * lu(229)
         lu(299) = lu(299) - lu(170) * lu(295)
         lu(301) = lu(301) - lu(171) * lu(295)
         lu(302) = - lu(172) * lu(295)
         lu(325) = lu(325) - lu(170) * lu(322)
         lu(327) = lu(327) - lu(171) * lu(322)
         lu(328) = - lu(172) * lu(322)
         lu(507) = lu(507) - lu(170) * lu(488)
         lu(515) = lu(515) - lu(171) * lu(488)
         lu(516) = lu(516) - lu(172) * lu(488)
         lu(598) = lu(598) - lu(170) * lu(592)
         lu(608) = lu(608) - lu(171) * lu(592)
         lu(609) = lu(609) - lu(172) * lu(592)
         lu(712) = lu(712) - lu(170) * lu(707)
         lu(722) = - lu(171) * lu(707)
         lu(723) = lu(723) - lu(172) * lu(707)
         lu(729) = lu(729) - lu(170) * lu(725)
         lu(739) = lu(739) - lu(171) * lu(725)
         lu(740) = - lu(172) * lu(725)
         lu(791) = lu(791) - lu(170) * lu(768)
         lu(801) = lu(801) - lu(171) * lu(768)
         lu(802) = lu(802) - lu(172) * lu(768)
         lu(818) = lu(818) - lu(170) * lu(809)
         lu(828) = lu(828) - lu(171) * lu(809)
         lu(829) = lu(829) - lu(172) * lu(809)
                                                                        
         lu(176) = 1. / lu(176)
         lu(177) = lu(177) * lu(176)
         lu(178) = lu(178) * lu(176)
         lu(179) = lu(179) * lu(176)
         lu(180) = lu(180) * lu(176)
         lu(181) = lu(181) * lu(176)
         lu(182) = lu(182) * lu(176)
         lu(183) = lu(183) * lu(176)
         lu(465) = lu(465) - lu(177) * lu(461)
         lu(475) = lu(475) - lu(178) * lu(461)
         lu(478) = lu(478) - lu(179) * lu(461)
         lu(479) = lu(479) - lu(180) * lu(461)
         lu(480) = lu(480) - lu(181) * lu(461)
         lu(481) = lu(481) - lu(182) * lu(461)
         lu(482) = lu(482) - lu(183) * lu(461)
         lu(621) = lu(621) - lu(177) * lu(615)
         lu(633) = lu(633) - lu(178) * lu(615)
         lu(639) = lu(639) - lu(179) * lu(615)
         lu(640) = lu(640) - lu(180) * lu(615)
         lu(643) = lu(643) - lu(181) * lu(615)
         lu(644) = lu(644) - lu(182) * lu(615)
         lu(645) = lu(645) - lu(183) * lu(615)
         lu(665) = lu(665) - lu(177) * lu(659)
         lu(677) = lu(677) - lu(178) * lu(659)
         lu(683) = lu(683) - lu(179) * lu(659)
         lu(684) = lu(684) - lu(180) * lu(659)
         lu(687) = lu(687) - lu(181) * lu(659)
         lu(688) = lu(688) - lu(182) * lu(659)
         lu(689) = lu(689) - lu(183) * lu(659)
         lu(777) = lu(777) - lu(177) * lu(769)
         lu(790) = lu(790) - lu(178) * lu(769)
         lu(796) = lu(796) - lu(179) * lu(769)
         lu(797) = lu(797) - lu(180) * lu(769)
         lu(800) = lu(800) - lu(181) * lu(769)
         lu(801) = lu(801) - lu(182) * lu(769)
         lu(802) = lu(802) - lu(183) * lu(769)
                                                                        
         lu(185) = 1. / lu(185)
         lu(186) = lu(186) * lu(185)
         lu(187) = lu(187) * lu(185)
         lu(188) = lu(188) * lu(185)
         lu(189) = lu(189) * lu(185)
         lu(190) = lu(190) * lu(185)
         lu(191) = lu(191) * lu(185)
         lu(192) = lu(192) * lu(185)
         lu(284) = lu(284) - lu(186) * lu(282)
         lu(286) = - lu(187) * lu(282)
         lu(290) = - lu(188) * lu(282)
         lu(291) = lu(291) - lu(189) * lu(282)
         lu(292) = lu(292) - lu(190) * lu(282)
         lu(293) = lu(293) - lu(191) * lu(282)
         lu(294) = lu(294) - lu(192) * lu(282)
         lu(621) = lu(621) - lu(186) * lu(616)
         lu(624) = lu(624) - lu(187) * lu(616)
         lu(639) = lu(639) - lu(188) * lu(616)
         lu(640) = lu(640) - lu(189) * lu(616)
         lu(643) = lu(643) - lu(190) * lu(616)
         lu(644) = lu(644) - lu(191) * lu(616)
         lu(645) = lu(645) - lu(192) * lu(616)
         lu(665) = lu(665) - lu(186) * lu(660)
         lu(668) = lu(668) - lu(187) * lu(660)
         lu(683) = lu(683) - lu(188) * lu(660)
         lu(684) = lu(684) - lu(189) * lu(660)
         lu(687) = lu(687) - lu(190) * lu(660)
         lu(688) = lu(688) - lu(191) * lu(660)
         lu(689) = lu(689) - lu(192) * lu(660)
         lu(777) = lu(777) - lu(186) * lu(770)
         lu(781) = lu(781) - lu(187) * lu(770)
         lu(796) = lu(796) - lu(188) * lu(770)
         lu(797) = lu(797) - lu(189) * lu(770)
         lu(800) = lu(800) - lu(190) * lu(770)
         lu(801) = lu(801) - lu(191) * lu(770)
         lu(802) = lu(802) - lu(192) * lu(770)
                                                                        
         lu(193) = 1. / lu(193)
         lu(194) = lu(194) * lu(193)
         lu(195) = lu(195) * lu(193)
         lu(196) = lu(196) * lu(193)
         lu(197) = lu(197) * lu(193)
         lu(377) = - lu(194) * lu(372)
         lu(381) = lu(381) - lu(195) * lu(372)
         lu(382) = lu(382) - lu(196) * lu(372)
         lu(383) = lu(383) - lu(197) * lu(372)
         lu(413) = lu(413) - lu(194) * lu(406)
         lu(418) = lu(418) - lu(195) * lu(406)
         lu(419) = lu(419) - lu(196) * lu(406)
         lu(420) = lu(420) - lu(197) * lu(406)
         lu(434) = lu(434) - lu(194) * lu(425)
         lu(439) = lu(439) - lu(195) * lu(425)
         lu(440) = lu(440) - lu(196) * lu(425)
         lu(441) = lu(441) - lu(197) * lu(425)
         lu(474) = lu(474) - lu(194) * lu(462)
         lu(479) = lu(479) - lu(195) * lu(462)
         lu(480) = lu(480) - lu(196) * lu(462)
         lu(481) = lu(481) - lu(197) * lu(462)
         lu(505) = lu(505) - lu(194) * lu(489)
         lu(513) = lu(513) - lu(195) * lu(489)
         lu(514) = lu(514) - lu(196) * lu(489)
         lu(515) = lu(515) - lu(197) * lu(489)
         lu(556) = lu(556) - lu(194) * lu(541)
         lu(564) = lu(564) - lu(195) * lu(541)
         lu(567) = lu(567) - lu(196) * lu(541)
         lu(568) = lu(568) - lu(197) * lu(541)
         lu(632) = lu(632) - lu(194) * lu(617)
         lu(640) = lu(640) - lu(195) * lu(617)
         lu(643) = lu(643) - lu(196) * lu(617)
         lu(644) = lu(644) - lu(197) * lu(617)
         lu(789) = lu(789) - lu(194) * lu(771)
         lu(797) = lu(797) - lu(195) * lu(771)
         lu(800) = lu(800) - lu(196) * lu(771)
         lu(801) = lu(801) - lu(197) * lu(771)
                                                                        
         lu(198) = 1. / lu(198)
         lu(199) = lu(199) * lu(198)
         lu(200) = lu(200) * lu(198)
         lu(201) = lu(201) * lu(198)
         lu(202) = lu(202) * lu(198)
         lu(203) = lu(203) * lu(198)
         lu(204) = lu(204) * lu(198)
         lu(205) = lu(205) * lu(198)
         lu(206) = lu(206) * lu(198)
         lu(243) = - lu(199) * lu(240)
         lu(244) = lu(244) - lu(200) * lu(240)
         lu(245) = lu(245) - lu(201) * lu(240)
         lu(248) = lu(248) - lu(202) * lu(240)
         lu(250) = - lu(203) * lu(240)
         lu(251) = lu(251) - lu(204) * lu(240)
         lu(252) = lu(252) - lu(205) * lu(240)
         lu(254) = - lu(206) * lu(240)
         lu(495) = lu(495) - lu(199) * lu(490)
         lu(498) = lu(498) - lu(200) * lu(490)
         lu(500) = lu(500) - lu(201) * lu(490)
         lu(507) = lu(507) - lu(202) * lu(490)
         lu(512) = lu(512) - lu(203) * lu(490)
         lu(513) = lu(513) - lu(204) * lu(490)
         lu(514) = lu(514) - lu(205) * lu(490)
         lu(516) = lu(516) - lu(206) * lu(490)
         lu(622) = lu(622) - lu(199) * lu(618)
         lu(625) = lu(625) - lu(200) * lu(618)
         lu(627) = lu(627) - lu(201) * lu(618)
         lu(634) = lu(634) - lu(202) * lu(618)
         lu(639) = lu(639) - lu(203) * lu(618)
         lu(640) = lu(640) - lu(204) * lu(618)
         lu(643) = lu(643) - lu(205) * lu(618)
         lu(645) = lu(645) - lu(206) * lu(618)
         lu(666) = lu(666) - lu(199) * lu(661)
         lu(669) = lu(669) - lu(200) * lu(661)
         lu(671) = lu(671) - lu(201) * lu(661)
         lu(678) = lu(678) - lu(202) * lu(661)
         lu(683) = lu(683) - lu(203) * lu(661)
         lu(684) = lu(684) - lu(204) * lu(661)
         lu(687) = lu(687) - lu(205) * lu(661)
         lu(689) = lu(689) - lu(206) * lu(661)
                                                                        
         lu(208) = 1. / lu(208)
         lu(209) = lu(209) * lu(208)
         lu(210) = lu(210) * lu(208)
         lu(211) = lu(211) * lu(208)
         lu(212) = lu(212) * lu(208)
         lu(213) = lu(213) * lu(208)
         lu(214) = lu(214) * lu(208)
         lu(220) = lu(220) - lu(209) * lu(217)
         lu(222) = lu(222) - lu(210) * lu(217)
         lu(223) = lu(223) - lu(211) * lu(217)
         lu(224) = lu(224) - lu(212) * lu(217)
         lu(225) = lu(225) - lu(213) * lu(217)
         lu(226) = lu(226) - lu(214) * lu(217)
         lu(262) = lu(262) - lu(209) * lu(256)
         lu(267) = - lu(210) * lu(256)
         lu(268) = lu(268) - lu(211) * lu(256)
         lu(269) = lu(269) - lu(212) * lu(256)
         lu(270) = lu(270) - lu(213) * lu(256)
         lu(271) = lu(271) - lu(214) * lu(256)
         lu(473) = lu(473) - lu(209) * lu(463)
         lu(478) = lu(478) - lu(210) * lu(463)
         lu(479) = lu(479) - lu(211) * lu(463)
         lu(480) = lu(480) - lu(212) * lu(463)
         lu(481) = lu(481) - lu(213) * lu(463)
         lu(482) = lu(482) - lu(214) * lu(463)
         lu(631) = lu(631) - lu(209) * lu(619)
         lu(639) = lu(639) - lu(210) * lu(619)
         lu(640) = lu(640) - lu(211) * lu(619)
         lu(643) = lu(643) - lu(212) * lu(619)
         lu(644) = lu(644) - lu(213) * lu(619)
         lu(645) = lu(645) - lu(214) * lu(619)
         lu(675) = lu(675) - lu(209) * lu(662)
         lu(683) = lu(683) - lu(210) * lu(662)
         lu(684) = lu(684) - lu(211) * lu(662)
         lu(687) = lu(687) - lu(212) * lu(662)
         lu(688) = lu(688) - lu(213) * lu(662)
         lu(689) = lu(689) - lu(214) * lu(662)
         lu(788) = lu(788) - lu(209) * lu(772)
         lu(796) = lu(796) - lu(210) * lu(772)
         lu(797) = lu(797) - lu(211) * lu(772)
         lu(800) = lu(800) - lu(212) * lu(772)
         lu(801) = lu(801) - lu(213) * lu(772)
         lu(802) = lu(802) - lu(214) * lu(772)
                                                                        
                                                                        
      end subroutine imp_lu_fac05
                                                                        
      subroutine imp_lu_fac06( lu )
                                                                        
      use CHEM_MODS_MOD, only : imp_nzcnt, clsze
                                                                        
      implicit none
                                                                        
!-----------------------------------------------------------------------
!       ... Dummy args
!-----------------------------------------------------------------------
      real, intent(inout) ::   lu(imp_nzcnt)
                                                                        
         lu(218) = 1. / lu(218)
         lu(219) = lu(219) * lu(218)
         lu(220) = lu(220) * lu(218)
         lu(221) = lu(221) * lu(218)
         lu(222) = lu(222) * lu(218)
         lu(223) = lu(223) * lu(218)
         lu(224) = lu(224) * lu(218)
         lu(225) = lu(225) * lu(218)
         lu(226) = lu(226) * lu(218)
         lu(465) = lu(465) - lu(219) * lu(464)
         lu(473) = lu(473) - lu(220) * lu(464)
         lu(475) = lu(475) - lu(221) * lu(464)
         lu(478) = lu(478) - lu(222) * lu(464)
         lu(479) = lu(479) - lu(223) * lu(464)
         lu(480) = lu(480) - lu(224) * lu(464)
         lu(481) = lu(481) - lu(225) * lu(464)
         lu(482) = lu(482) - lu(226) * lu(464)
         lu(621) = lu(621) - lu(219) * lu(620)
         lu(631) = lu(631) - lu(220) * lu(620)
         lu(633) = lu(633) - lu(221) * lu(620)
         lu(639) = lu(639) - lu(222) * lu(620)
         lu(640) = lu(640) - lu(223) * lu(620)
         lu(643) = lu(643) - lu(224) * lu(620)
         lu(644) = lu(644) - lu(225) * lu(620)
         lu(645) = lu(645) - lu(226) * lu(620)
         lu(665) = lu(665) - lu(219) * lu(663)
         lu(675) = lu(675) - lu(220) * lu(663)
         lu(677) = lu(677) - lu(221) * lu(663)
         lu(683) = lu(683) - lu(222) * lu(663)
         lu(684) = lu(684) - lu(223) * lu(663)
         lu(687) = lu(687) - lu(224) * lu(663)
         lu(688) = lu(688) - lu(225) * lu(663)
         lu(689) = lu(689) - lu(226) * lu(663)
         lu(777) = lu(777) - lu(219) * lu(773)
         lu(788) = lu(788) - lu(220) * lu(773)
         lu(790) = lu(790) - lu(221) * lu(773)
         lu(796) = lu(796) - lu(222) * lu(773)
         lu(797) = lu(797) - lu(223) * lu(773)
         lu(800) = lu(800) - lu(224) * lu(773)
         lu(801) = lu(801) - lu(225) * lu(773)
         lu(802) = lu(802) - lu(226) * lu(773)
                                                                        
         lu(230) = 1. / lu(230)
         lu(231) = lu(231) * lu(230)
         lu(232) = lu(232) * lu(230)
         lu(233) = lu(233) * lu(230)
         lu(234) = lu(234) * lu(230)
         lu(235) = lu(235) * lu(230)
         lu(236) = lu(236) * lu(230)
         lu(237) = lu(237) * lu(230)
         lu(238) = lu(238) * lu(230)
         lu(239) = lu(239) * lu(230)
         lu(521) = lu(521) - lu(231) * lu(520)
         lu(522) = lu(522) - lu(232) * lu(520)
         lu(524) = - lu(233) * lu(520)
         lu(525) = lu(525) - lu(234) * lu(520)
         lu(527) = lu(527) - lu(235) * lu(520)
         lu(528) = lu(528) - lu(236) * lu(520)
         lu(531) = lu(531) - lu(237) * lu(520)
         lu(534) = lu(534) - lu(238) * lu(520)
         lu(535) = lu(535) - lu(239) * lu(520)
         lu(573) = - lu(231) * lu(571)
         lu(574) = lu(574) - lu(232) * lu(571)
         lu(576) = lu(576) - lu(233) * lu(571)
         lu(577) = lu(577) - lu(234) * lu(571)
         lu(579) = lu(579) - lu(235) * lu(571)
         lu(580) = - lu(236) * lu(571)
         lu(583) = - lu(237) * lu(571)
         lu(586) = lu(586) - lu(238) * lu(571)
         lu(587) = lu(587) - lu(239) * lu(571)
         lu(595) = lu(595) - lu(231) * lu(593)
         lu(596) = lu(596) - lu(232) * lu(593)
         lu(598) = lu(598) - lu(233) * lu(593)
         lu(599) = - lu(234) * lu(593)
         lu(601) = - lu(235) * lu(593)
         lu(602) = lu(602) - lu(236) * lu(593)
         lu(605) = lu(605) - lu(237) * lu(593)
         lu(608) = lu(608) - lu(238) * lu(593)
         lu(609) = lu(609) - lu(239) * lu(593)
         lu(812) = - lu(231) * lu(810)
         lu(814) = lu(814) - lu(232) * lu(810)
         lu(818) = lu(818) - lu(233) * lu(810)
         lu(819) = lu(819) - lu(234) * lu(810)
         lu(821) = lu(821) - lu(235) * lu(810)
         lu(822) = lu(822) - lu(236) * lu(810)
         lu(825) = lu(825) - lu(237) * lu(810)
         lu(828) = lu(828) - lu(238) * lu(810)
         lu(829) = lu(829) - lu(239) * lu(810)
                                                                        
         lu(241) = 1. / lu(241)
         lu(242) = lu(242) * lu(241)
         lu(243) = lu(243) * lu(241)
         lu(244) = lu(244) * lu(241)
         lu(245) = lu(245) * lu(241)
         lu(246) = lu(246) * lu(241)
         lu(247) = lu(247) * lu(241)
         lu(248) = lu(248) * lu(241)
         lu(249) = lu(249) * lu(241)
         lu(250) = lu(250) * lu(241)
         lu(251) = lu(251) * lu(241)
         lu(252) = lu(252) * lu(241)
         lu(253) = lu(253) * lu(241)
         lu(254) = lu(254) * lu(241)
         lu(493) = lu(493) - lu(242) * lu(491)
         lu(495) = lu(495) - lu(243) * lu(491)
         lu(498) = lu(498) - lu(244) * lu(491)
         lu(500) = lu(500) - lu(245) * lu(491)
         lu(502) = lu(502) - lu(246) * lu(491)
         lu(505) = lu(505) - lu(247) * lu(491)
         lu(507) = lu(507) - lu(248) * lu(491)
         lu(509) = - lu(249) * lu(491)
         lu(512) = lu(512) - lu(250) * lu(491)
         lu(513) = lu(513) - lu(251) * lu(491)
         lu(514) = lu(514) - lu(252) * lu(491)
         lu(515) = lu(515) - lu(253) * lu(491)
         lu(516) = lu(516) - lu(254) * lu(491)
         lu(544) = lu(544) - lu(242) * lu(542)
         lu(546) = lu(546) - lu(243) * lu(542)
         lu(549) = lu(549) - lu(244) * lu(542)
         lu(551) = lu(551) - lu(245) * lu(542)
         lu(553) = - lu(246) * lu(542)
         lu(556) = lu(556) - lu(247) * lu(542)
         lu(558) = lu(558) - lu(248) * lu(542)
         lu(560) = lu(560) - lu(249) * lu(542)
         lu(563) = lu(563) - lu(250) * lu(542)
         lu(564) = lu(564) - lu(251) * lu(542)
         lu(567) = lu(567) - lu(252) * lu(542)
         lu(568) = lu(568) - lu(253) * lu(542)
         lu(569) = lu(569) - lu(254) * lu(542)
         lu(776) = lu(776) - lu(242) * lu(774)
         lu(778) = lu(778) - lu(243) * lu(774)
         lu(782) = lu(782) - lu(244) * lu(774)
         lu(784) = lu(784) - lu(245) * lu(774)
         lu(786) = lu(786) - lu(246) * lu(774)
         lu(789) = lu(789) - lu(247) * lu(774)
         lu(791) = lu(791) - lu(248) * lu(774)
         lu(793) = lu(793) - lu(249) * lu(774)
         lu(796) = lu(796) - lu(250) * lu(774)
         lu(797) = lu(797) - lu(251) * lu(774)
         lu(800) = lu(800) - lu(252) * lu(774)
         lu(801) = lu(801) - lu(253) * lu(774)
         lu(802) = lu(802) - lu(254) * lu(774)
                                                                        
         lu(257) = 1. / lu(257)
         lu(258) = lu(258) * lu(257)
         lu(259) = lu(259) * lu(257)
         lu(260) = lu(260) * lu(257)
         lu(261) = lu(261) * lu(257)
         lu(262) = lu(262) * lu(257)
         lu(263) = lu(263) * lu(257)
         lu(264) = lu(264) * lu(257)
         lu(265) = lu(265) * lu(257)
         lu(266) = lu(266) * lu(257)
         lu(267) = lu(267) * lu(257)
         lu(268) = lu(268) * lu(257)
         lu(269) = lu(269) * lu(257)
         lu(270) = lu(270) * lu(257)
         lu(271) = lu(271) * lu(257)
         lu(493) = lu(493) - lu(258) * lu(492)
         lu(498) = lu(498) - lu(259) * lu(492)
         lu(500) = lu(500) - lu(260) * lu(492)
         lu(502) = lu(502) - lu(261) * lu(492)
         lu(504) = lu(504) - lu(262) * lu(492)
         lu(506) = - lu(263) * lu(492)
         lu(507) = lu(507) - lu(264) * lu(492)
         lu(509) = lu(509) - lu(265) * lu(492)
         lu(510) = lu(510) - lu(266) * lu(492)
         lu(512) = lu(512) - lu(267) * lu(492)
         lu(513) = lu(513) - lu(268) * lu(492)
         lu(514) = lu(514) - lu(269) * lu(492)
         lu(515) = lu(515) - lu(270) * lu(492)
         lu(516) = lu(516) - lu(271) * lu(492)
         lu(544) = lu(544) - lu(258) * lu(543)
         lu(549) = lu(549) - lu(259) * lu(543)
         lu(551) = lu(551) - lu(260) * lu(543)
         lu(553) = lu(553) - lu(261) * lu(543)
         lu(555) = - lu(262) * lu(543)
         lu(557) = lu(557) - lu(263) * lu(543)
         lu(558) = lu(558) - lu(264) * lu(543)
         lu(560) = lu(560) - lu(265) * lu(543)
         lu(561) = lu(561) - lu(266) * lu(543)
         lu(563) = lu(563) - lu(267) * lu(543)
         lu(564) = lu(564) - lu(268) * lu(543)
         lu(567) = lu(567) - lu(269) * lu(543)
         lu(568) = lu(568) - lu(270) * lu(543)
         lu(569) = lu(569) - lu(271) * lu(543)
         lu(776) = lu(776) - lu(258) * lu(775)
         lu(782) = lu(782) - lu(259) * lu(775)
         lu(784) = lu(784) - lu(260) * lu(775)
         lu(786) = lu(786) - lu(261) * lu(775)
         lu(788) = lu(788) - lu(262) * lu(775)
         lu(790) = lu(790) - lu(263) * lu(775)
         lu(791) = lu(791) - lu(264) * lu(775)
         lu(793) = lu(793) - lu(265) * lu(775)
         lu(794) = lu(794) - lu(266) * lu(775)
         lu(796) = lu(796) - lu(267) * lu(775)
         lu(797) = lu(797) - lu(268) * lu(775)
         lu(800) = lu(800) - lu(269) * lu(775)
         lu(801) = lu(801) - lu(270) * lu(775)
         lu(802) = lu(802) - lu(271) * lu(775)
                                                                        
                                                                        
      end subroutine imp_lu_fac06
                                                                        
      subroutine imp_lu_fac07( lu )
                                                                        
      use CHEM_MODS_MOD, only : imp_nzcnt, clsze
                                                                        
      implicit none
                                                                        
!-----------------------------------------------------------------------
!       ... Dummy args
!-----------------------------------------------------------------------
      real, intent(inout) ::   lu(imp_nzcnt)
                                                                        
         lu(273) = 1. / lu(273)
         lu(274) = lu(274) * lu(273)
         lu(275) = lu(275) * lu(273)
         lu(276) = lu(276) * lu(273)
         lu(277) = lu(277) * lu(273)
         lu(278) = lu(278) * lu(273)
         lu(279) = lu(279) * lu(273)
         lu(280) = lu(280) * lu(273)
         lu(315) = lu(315) - lu(274) * lu(314)
         lu(316) = lu(316) - lu(275) * lu(314)
         lu(317) = - lu(276) * lu(314)
         lu(318) = lu(318) - lu(277) * lu(314)
         lu(319) = lu(319) - lu(278) * lu(314)
         lu(320) = - lu(279) * lu(314)
         lu(321) = lu(321) - lu(280) * lu(314)
         lu(573) = lu(573) - lu(274) * lu(572)
         lu(574) = lu(574) - lu(275) * lu(572)
         lu(579) = lu(579) - lu(276) * lu(572)
         lu(580) = lu(580) - lu(277) * lu(572)
         lu(583) = lu(583) - lu(278) * lu(572)
         lu(584) = lu(584) - lu(279) * lu(572)
         lu(586) = lu(586) - lu(280) * lu(572)
         lu(595) = lu(595) - lu(274) * lu(594)
         lu(596) = lu(596) - lu(275) * lu(594)
         lu(601) = lu(601) - lu(276) * lu(594)
         lu(602) = lu(602) - lu(277) * lu(594)
         lu(605) = lu(605) - lu(278) * lu(594)
         lu(606) = - lu(279) * lu(594)
         lu(608) = lu(608) - lu(280) * lu(594)
         lu(667) = lu(667) - lu(274) * lu(664)
         lu(670) = lu(670) - lu(275) * lu(664)
         lu(681) = lu(681) - lu(276) * lu(664)
         lu(682) = lu(682) - lu(277) * lu(664)
         lu(685) = lu(685) - lu(278) * lu(664)
         lu(686) = lu(686) - lu(279) * lu(664)
         lu(688) = lu(688) - lu(280) * lu(664)
         lu(709) = - lu(274) * lu(708)
         lu(710) = lu(710) - lu(275) * lu(708)
         lu(715) = lu(715) - lu(276) * lu(708)
         lu(716) = - lu(277) * lu(708)
         lu(719) = lu(719) - lu(278) * lu(708)
         lu(720) = lu(720) - lu(279) * lu(708)
         lu(722) = lu(722) - lu(280) * lu(708)
         lu(812) = lu(812) - lu(274) * lu(811)
         lu(814) = lu(814) - lu(275) * lu(811)
         lu(821) = lu(821) - lu(276) * lu(811)
         lu(822) = lu(822) - lu(277) * lu(811)
         lu(825) = lu(825) - lu(278) * lu(811)
         lu(826) = lu(826) - lu(279) * lu(811)
         lu(828) = lu(828) - lu(280) * lu(811)
                                                                        
         lu(283) = 1. / lu(283)
         lu(284) = lu(284) * lu(283)
         lu(285) = lu(285) * lu(283)
         lu(286) = lu(286) * lu(283)
         lu(287) = lu(287) * lu(283)
         lu(288) = lu(288) * lu(283)
         lu(289) = lu(289) * lu(283)
         lu(290) = lu(290) * lu(283)
         lu(291) = lu(291) * lu(283)
         lu(292) = lu(292) * lu(283)
         lu(293) = lu(293) * lu(283)
         lu(294) = lu(294) * lu(283)
         lu(356) = lu(356) - lu(284) * lu(355)
         lu(357) = lu(357) - lu(285) * lu(355)
         lu(358) = - lu(286) * lu(355)
         lu(362) = lu(362) - lu(287) * lu(355)
         lu(363) = - lu(288) * lu(355)
         lu(364) = lu(364) - lu(289) * lu(355)
         lu(365) = - lu(290) * lu(355)
         lu(366) = lu(366) - lu(291) * lu(355)
         lu(367) = lu(367) - lu(292) * lu(355)
         lu(368) = lu(368) - lu(293) * lu(355)
         lu(369) = - lu(294) * lu(355)
         lu(494) = lu(494) - lu(284) * lu(493)
         lu(496) = lu(496) - lu(285) * lu(493)
         lu(497) = lu(497) - lu(286) * lu(493)
         lu(506) = lu(506) - lu(287) * lu(493)
         lu(507) = lu(507) - lu(288) * lu(493)
         lu(509) = lu(509) - lu(289) * lu(493)
         lu(512) = lu(512) - lu(290) * lu(493)
         lu(513) = lu(513) - lu(291) * lu(493)
         lu(514) = lu(514) - lu(292) * lu(493)
         lu(515) = lu(515) - lu(293) * lu(493)
         lu(516) = lu(516) - lu(294) * lu(493)
         lu(545) = lu(545) - lu(284) * lu(544)
         lu(547) = lu(547) - lu(285) * lu(544)
         lu(548) = - lu(286) * lu(544)
         lu(557) = lu(557) - lu(287) * lu(544)
         lu(558) = lu(558) - lu(288) * lu(544)
         lu(560) = lu(560) - lu(289) * lu(544)
         lu(563) = lu(563) - lu(290) * lu(544)
         lu(564) = lu(564) - lu(291) * lu(544)
         lu(567) = lu(567) - lu(292) * lu(544)
         lu(568) = lu(568) - lu(293) * lu(544)
         lu(569) = lu(569) - lu(294) * lu(544)
         lu(777) = lu(777) - lu(284) * lu(776)
         lu(780) = lu(780) - lu(285) * lu(776)
         lu(781) = lu(781) - lu(286) * lu(776)
         lu(790) = lu(790) - lu(287) * lu(776)
         lu(791) = lu(791) - lu(288) * lu(776)
         lu(793) = lu(793) - lu(289) * lu(776)
         lu(796) = lu(796) - lu(290) * lu(776)
         lu(797) = lu(797) - lu(291) * lu(776)
         lu(800) = lu(800) - lu(292) * lu(776)
         lu(801) = lu(801) - lu(293) * lu(776)
         lu(802) = lu(802) - lu(294) * lu(776)
                                                                        
         lu(296) = 1. / lu(296)
         lu(297) = lu(297) * lu(296)
         lu(298) = lu(298) * lu(296)
         lu(299) = lu(299) * lu(296)
         lu(300) = lu(300) * lu(296)
         lu(301) = lu(301) * lu(296)
         lu(302) = lu(302) * lu(296)
         lu(361) = lu(361) - lu(297) * lu(356)
         lu(362) = lu(362) - lu(298) * lu(356)
         lu(363) = lu(363) - lu(299) * lu(356)
         lu(366) = lu(366) - lu(300) * lu(356)
         lu(368) = lu(368) - lu(301) * lu(356)
         lu(369) = lu(369) - lu(302) * lu(356)
         lu(473) = lu(473) - lu(297) * lu(465)
         lu(475) = lu(475) - lu(298) * lu(465)
         lu(476) = - lu(299) * lu(465)
         lu(479) = lu(479) - lu(300) * lu(465)
         lu(481) = lu(481) - lu(301) * lu(465)
         lu(482) = lu(482) - lu(302) * lu(465)
         lu(504) = lu(504) - lu(297) * lu(494)
         lu(506) = lu(506) - lu(298) * lu(494)
         lu(507) = lu(507) - lu(299) * lu(494)
         lu(513) = lu(513) - lu(300) * lu(494)
         lu(515) = lu(515) - lu(301) * lu(494)
         lu(516) = lu(516) - lu(302) * lu(494)
         lu(555) = lu(555) - lu(297) * lu(545)
         lu(557) = lu(557) - lu(298) * lu(545)
         lu(558) = lu(558) - lu(299) * lu(545)
         lu(564) = lu(564) - lu(300) * lu(545)
         lu(568) = lu(568) - lu(301) * lu(545)
         lu(569) = lu(569) - lu(302) * lu(545)
         lu(631) = lu(631) - lu(297) * lu(621)
         lu(633) = lu(633) - lu(298) * lu(621)
         lu(634) = lu(634) - lu(299) * lu(621)
         lu(640) = lu(640) - lu(300) * lu(621)
         lu(644) = lu(644) - lu(301) * lu(621)
         lu(645) = lu(645) - lu(302) * lu(621)
         lu(675) = lu(675) - lu(297) * lu(665)
         lu(677) = lu(677) - lu(298) * lu(665)
         lu(678) = lu(678) - lu(299) * lu(665)
         lu(684) = lu(684) - lu(300) * lu(665)
         lu(688) = lu(688) - lu(301) * lu(665)
         lu(689) = lu(689) - lu(302) * lu(665)
         lu(788) = lu(788) - lu(297) * lu(777)
         lu(790) = lu(790) - lu(298) * lu(777)
         lu(791) = lu(791) - lu(299) * lu(777)
         lu(797) = lu(797) - lu(300) * lu(777)
         lu(801) = lu(801) - lu(301) * lu(777)
         lu(802) = lu(802) - lu(302) * lu(777)
                                                                        
         lu(304) = 1. / lu(304)
         lu(305) = lu(305) * lu(304)
         lu(306) = lu(306) * lu(304)
         lu(307) = lu(307) * lu(304)
         lu(308) = lu(308) * lu(304)
         lu(309) = lu(309) * lu(304)
         lu(310) = lu(310) * lu(304)
         lu(311) = lu(311) * lu(304)
         lu(391) = lu(391) - lu(305) * lu(388)
         lu(397) = lu(397) - lu(306) * lu(388)
         lu(398) = - lu(307) * lu(388)
         lu(400) = lu(400) - lu(308) * lu(388)
         lu(401) = lu(401) - lu(309) * lu(388)
         lu(402) = lu(402) - lu(310) * lu(388)
         lu(403) = lu(403) - lu(311) * lu(388)
         lu(410) = - lu(305) * lu(407)
         lu(415) = lu(415) - lu(306) * lu(407)
         lu(416) = - lu(307) * lu(407)
         lu(418) = lu(418) - lu(308) * lu(407)
         lu(419) = lu(419) - lu(309) * lu(407)
         lu(420) = lu(420) - lu(310) * lu(407)
         lu(421) = lu(421) - lu(311) * lu(407)
         lu(501) = lu(501) - lu(305) * lu(495)
         lu(507) = lu(507) - lu(306) * lu(495)
         lu(509) = lu(509) - lu(307) * lu(495)
         lu(513) = lu(513) - lu(308) * lu(495)
         lu(514) = lu(514) - lu(309) * lu(495)
         lu(515) = lu(515) - lu(310) * lu(495)
         lu(516) = lu(516) - lu(311) * lu(495)
         lu(552) = lu(552) - lu(305) * lu(546)
         lu(558) = lu(558) - lu(306) * lu(546)
         lu(560) = lu(560) - lu(307) * lu(546)
         lu(564) = lu(564) - lu(308) * lu(546)
         lu(567) = lu(567) - lu(309) * lu(546)
         lu(568) = lu(568) - lu(310) * lu(546)
         lu(569) = lu(569) - lu(311) * lu(546)
         lu(628) = lu(628) - lu(305) * lu(622)
         lu(634) = lu(634) - lu(306) * lu(622)
         lu(636) = lu(636) - lu(307) * lu(622)
         lu(640) = lu(640) - lu(308) * lu(622)
         lu(643) = lu(643) - lu(309) * lu(622)
         lu(644) = lu(644) - lu(310) * lu(622)
         lu(645) = lu(645) - lu(311) * lu(622)
         lu(672) = lu(672) - lu(305) * lu(666)
         lu(678) = lu(678) - lu(306) * lu(666)
         lu(680) = lu(680) - lu(307) * lu(666)
         lu(684) = lu(684) - lu(308) * lu(666)
         lu(687) = lu(687) - lu(309) * lu(666)
         lu(688) = lu(688) - lu(310) * lu(666)
         lu(689) = lu(689) - lu(311) * lu(666)
         lu(785) = lu(785) - lu(305) * lu(778)
         lu(791) = lu(791) - lu(306) * lu(778)
         lu(793) = lu(793) - lu(307) * lu(778)
         lu(797) = lu(797) - lu(308) * lu(778)
         lu(800) = lu(800) - lu(309) * lu(778)
         lu(801) = lu(801) - lu(310) * lu(778)
         lu(802) = lu(802) - lu(311) * lu(778)
                                                                        
         lu(315) = 1. / lu(315)
         lu(316) = lu(316) * lu(315)
         lu(317) = lu(317) * lu(315)
         lu(318) = lu(318) * lu(315)
         lu(319) = lu(319) * lu(315)
         lu(320) = lu(320) * lu(315)
         lu(321) = lu(321) * lu(315)
         lu(522) = lu(522) - lu(316) * lu(521)
         lu(527) = lu(527) - lu(317) * lu(521)
         lu(528) = lu(528) - lu(318) * lu(521)
         lu(531) = lu(531) - lu(319) * lu(521)
         lu(532) = lu(532) - lu(320) * lu(521)
         lu(534) = lu(534) - lu(321) * lu(521)
         lu(574) = lu(574) - lu(316) * lu(573)
         lu(579) = lu(579) - lu(317) * lu(573)
         lu(580) = lu(580) - lu(318) * lu(573)
         lu(583) = lu(583) - lu(319) * lu(573)
         lu(584) = lu(584) - lu(320) * lu(573)
         lu(586) = lu(586) - lu(321) * lu(573)
         lu(596) = lu(596) - lu(316) * lu(595)
         lu(601) = lu(601) - lu(317) * lu(595)
         lu(602) = lu(602) - lu(318) * lu(595)
         lu(605) = lu(605) - lu(319) * lu(595)
         lu(606) = lu(606) - lu(320) * lu(595)
         lu(608) = lu(608) - lu(321) * lu(595)
         lu(670) = lu(670) - lu(316) * lu(667)
         lu(681) = lu(681) - lu(317) * lu(667)
         lu(682) = lu(682) - lu(318) * lu(667)
         lu(685) = lu(685) - lu(319) * lu(667)
         lu(686) = lu(686) - lu(320) * lu(667)
         lu(688) = lu(688) - lu(321) * lu(667)
         lu(691) = - lu(316) * lu(690)
         lu(696) = - lu(317) * lu(690)
         lu(697) = - lu(318) * lu(690)
         lu(700) = lu(700) - lu(319) * lu(690)
         lu(701) = lu(701) - lu(320) * lu(690)
         lu(703) = - lu(321) * lu(690)
         lu(710) = lu(710) - lu(316) * lu(709)
         lu(715) = lu(715) - lu(317) * lu(709)
         lu(716) = lu(716) - lu(318) * lu(709)
         lu(719) = lu(719) - lu(319) * lu(709)
         lu(720) = lu(720) - lu(320) * lu(709)
         lu(722) = lu(722) - lu(321) * lu(709)
         lu(727) = lu(727) - lu(316) * lu(726)
         lu(732) = - lu(317) * lu(726)
         lu(733) = lu(733) - lu(318) * lu(726)
         lu(736) = lu(736) - lu(319) * lu(726)
         lu(737) = - lu(320) * lu(726)
         lu(739) = lu(739) - lu(321) * lu(726)
         lu(783) = lu(783) - lu(316) * lu(779)
         lu(794) = lu(794) - lu(317) * lu(779)
         lu(795) = lu(795) - lu(318) * lu(779)
         lu(798) = lu(798) - lu(319) * lu(779)
         lu(799) = - lu(320) * lu(779)
         lu(801) = lu(801) - lu(321) * lu(779)
         lu(814) = lu(814) - lu(316) * lu(812)
         lu(821) = lu(821) - lu(317) * lu(812)
         lu(822) = lu(822) - lu(318) * lu(812)
         lu(825) = lu(825) - lu(319) * lu(812)
         lu(826) = lu(826) - lu(320) * lu(812)
         lu(828) = lu(828) - lu(321) * lu(812)
                                                                        
                                                                        
      end subroutine imp_lu_fac07
                                                                        
      subroutine imp_lu_fac08( lu )
                                                                        
      use CHEM_MODS_MOD, only : imp_nzcnt, clsze
                                                                        
      implicit none
                                                                        
!-----------------------------------------------------------------------
!       ... Dummy args
!-----------------------------------------------------------------------
      real, intent(inout) ::   lu(imp_nzcnt)
                                                                        
         lu(323) = 1. / lu(323)
         lu(324) = lu(324) * lu(323)
         lu(325) = lu(325) * lu(323)
         lu(326) = lu(326) * lu(323)
         lu(327) = lu(327) * lu(323)
         lu(328) = lu(328) * lu(323)
         lu(331) = lu(331) - lu(324) * lu(329)
         lu(332) = - lu(325) * lu(329)
         lu(333) = lu(333) - lu(326) * lu(329)
         lu(335) = lu(335) - lu(327) * lu(329)
         lu(336) = - lu(328) * lu(329)
         lu(340) = lu(340) - lu(324) * lu(337)
         lu(342) = - lu(325) * lu(337)
         lu(344) = lu(344) - lu(326) * lu(337)
         lu(346) = lu(346) - lu(327) * lu(337)
         lu(347) = - lu(328) * lu(337)
         lu(361) = lu(361) - lu(324) * lu(357)
         lu(363) = lu(363) - lu(325) * lu(357)
         lu(366) = lu(366) - lu(326) * lu(357)
         lu(368) = lu(368) - lu(327) * lu(357)
         lu(369) = lu(369) - lu(328) * lu(357)
         lu(376) = lu(376) - lu(324) * lu(373)
         lu(379) = lu(379) - lu(325) * lu(373)
         lu(381) = lu(381) - lu(326) * lu(373)
         lu(383) = lu(383) - lu(327) * lu(373)
         lu(384) = lu(384) - lu(328) * lu(373)
         lu(412) = lu(412) - lu(324) * lu(408)
         lu(415) = lu(415) - lu(325) * lu(408)
         lu(418) = lu(418) - lu(326) * lu(408)
         lu(420) = lu(420) - lu(327) * lu(408)
         lu(421) = lu(421) - lu(328) * lu(408)
         lu(433) = lu(433) - lu(324) * lu(426)
         lu(436) = lu(436) - lu(325) * lu(426)
         lu(439) = lu(439) - lu(326) * lu(426)
         lu(441) = lu(441) - lu(327) * lu(426)
         lu(442) = lu(442) - lu(328) * lu(426)
         lu(473) = lu(473) - lu(324) * lu(466)
         lu(476) = lu(476) - lu(325) * lu(466)
         lu(479) = lu(479) - lu(326) * lu(466)
         lu(481) = lu(481) - lu(327) * lu(466)
         lu(482) = lu(482) - lu(328) * lu(466)
         lu(504) = lu(504) - lu(324) * lu(496)
         lu(507) = lu(507) - lu(325) * lu(496)
         lu(513) = lu(513) - lu(326) * lu(496)
         lu(515) = lu(515) - lu(327) * lu(496)
         lu(516) = lu(516) - lu(328) * lu(496)
         lu(555) = lu(555) - lu(324) * lu(547)
         lu(558) = lu(558) - lu(325) * lu(547)
         lu(564) = lu(564) - lu(326) * lu(547)
         lu(568) = lu(568) - lu(327) * lu(547)
         lu(569) = lu(569) - lu(328) * lu(547)
         lu(631) = lu(631) - lu(324) * lu(623)
         lu(634) = lu(634) - lu(325) * lu(623)
         lu(640) = lu(640) - lu(326) * lu(623)
         lu(644) = lu(644) - lu(327) * lu(623)
         lu(645) = lu(645) - lu(328) * lu(623)
         lu(788) = lu(788) - lu(324) * lu(780)
         lu(791) = lu(791) - lu(325) * lu(780)
         lu(797) = lu(797) - lu(326) * lu(780)
         lu(801) = lu(801) - lu(327) * lu(780)
         lu(802) = lu(802) - lu(328) * lu(780)
                                                                        
         lu(330) = 1. / lu(330)
         lu(331) = lu(331) * lu(330)
         lu(332) = lu(332) * lu(330)
         lu(333) = lu(333) * lu(330)
         lu(334) = lu(334) * lu(330)
         lu(335) = lu(335) * lu(330)
         lu(336) = lu(336) * lu(330)
         lu(361) = lu(361) - lu(331) * lu(358)
         lu(363) = lu(363) - lu(332) * lu(358)
         lu(366) = lu(366) - lu(333) * lu(358)
         lu(367) = lu(367) - lu(334) * lu(358)
         lu(368) = lu(368) - lu(335) * lu(358)
         lu(369) = lu(369) - lu(336) * lu(358)
         lu(376) = lu(376) - lu(331) * lu(374)
         lu(379) = lu(379) - lu(332) * lu(374)
         lu(381) = lu(381) - lu(333) * lu(374)
         lu(382) = lu(382) - lu(334) * lu(374)
         lu(383) = lu(383) - lu(335) * lu(374)
         lu(384) = lu(384) - lu(336) * lu(374)
         lu(412) = lu(412) - lu(331) * lu(409)
         lu(415) = lu(415) - lu(332) * lu(409)
         lu(418) = lu(418) - lu(333) * lu(409)
         lu(419) = lu(419) - lu(334) * lu(409)
         lu(420) = lu(420) - lu(335) * lu(409)
         lu(421) = lu(421) - lu(336) * lu(409)
         lu(433) = lu(433) - lu(331) * lu(427)
         lu(436) = lu(436) - lu(332) * lu(427)
         lu(439) = lu(439) - lu(333) * lu(427)
         lu(440) = lu(440) - lu(334) * lu(427)
         lu(441) = lu(441) - lu(335) * lu(427)
         lu(442) = lu(442) - lu(336) * lu(427)
         lu(446) = lu(446) - lu(331) * lu(445)
         lu(449) = lu(449) - lu(332) * lu(445)
         lu(452) = lu(452) - lu(333) * lu(445)
         lu(453) = lu(453) - lu(334) * lu(445)
         lu(454) = lu(454) - lu(335) * lu(445)
         lu(455) = lu(455) - lu(336) * lu(445)
         lu(473) = lu(473) - lu(331) * lu(467)
         lu(476) = lu(476) - lu(332) * lu(467)
         lu(479) = lu(479) - lu(333) * lu(467)
         lu(480) = lu(480) - lu(334) * lu(467)
         lu(481) = lu(481) - lu(335) * lu(467)
         lu(482) = lu(482) - lu(336) * lu(467)
         lu(504) = lu(504) - lu(331) * lu(497)
         lu(507) = lu(507) - lu(332) * lu(497)
         lu(513) = lu(513) - lu(333) * lu(497)
         lu(514) = lu(514) - lu(334) * lu(497)
         lu(515) = lu(515) - lu(335) * lu(497)
         lu(516) = lu(516) - lu(336) * lu(497)
         lu(555) = lu(555) - lu(331) * lu(548)
         lu(558) = lu(558) - lu(332) * lu(548)
         lu(564) = lu(564) - lu(333) * lu(548)
         lu(567) = lu(567) - lu(334) * lu(548)
         lu(568) = lu(568) - lu(335) * lu(548)
         lu(569) = lu(569) - lu(336) * lu(548)
         lu(631) = lu(631) - lu(331) * lu(624)
         lu(634) = lu(634) - lu(332) * lu(624)
         lu(640) = lu(640) - lu(333) * lu(624)
         lu(643) = lu(643) - lu(334) * lu(624)
         lu(644) = lu(644) - lu(335) * lu(624)
         lu(645) = lu(645) - lu(336) * lu(624)
         lu(675) = lu(675) - lu(331) * lu(668)
         lu(678) = lu(678) - lu(332) * lu(668)
         lu(684) = lu(684) - lu(333) * lu(668)
         lu(687) = lu(687) - lu(334) * lu(668)
         lu(688) = lu(688) - lu(335) * lu(668)
         lu(689) = lu(689) - lu(336) * lu(668)
         lu(788) = lu(788) - lu(331) * lu(781)
         lu(791) = lu(791) - lu(332) * lu(781)
         lu(797) = lu(797) - lu(333) * lu(781)
         lu(800) = lu(800) - lu(334) * lu(781)
         lu(801) = lu(801) - lu(335) * lu(781)
         lu(802) = lu(802) - lu(336) * lu(781)
         lu(815) = lu(815) - lu(331) * lu(813)
         lu(818) = lu(818) - lu(332) * lu(813)
         lu(824) = lu(824) - lu(333) * lu(813)
         lu(827) = lu(827) - lu(334) * lu(813)
         lu(828) = lu(828) - lu(335) * lu(813)
         lu(829) = lu(829) - lu(336) * lu(813)
                                                                        
         lu(338) = 1. / lu(338)
         lu(339) = lu(339) * lu(338)
         lu(340) = lu(340) * lu(338)
         lu(341) = lu(341) * lu(338)
         lu(342) = lu(342) * lu(338)
         lu(343) = lu(343) * lu(338)
         lu(344) = lu(344) * lu(338)
         lu(345) = lu(345) * lu(338)
         lu(346) = lu(346) * lu(338)
         lu(347) = lu(347) * lu(338)
         lu(393) = - lu(339) * lu(389)
         lu(394) = lu(394) - lu(340) * lu(389)
         lu(395) = - lu(341) * lu(389)
         lu(397) = lu(397) - lu(342) * lu(389)
         lu(398) = lu(398) - lu(343) * lu(389)
         lu(400) = lu(400) - lu(344) * lu(389)
         lu(401) = lu(401) - lu(345) * lu(389)
         lu(402) = lu(402) - lu(346) * lu(389)
         lu(403) = lu(403) - lu(347) * lu(389)
         lu(432) = lu(432) - lu(339) * lu(428)
         lu(433) = lu(433) - lu(340) * lu(428)
         lu(434) = lu(434) - lu(341) * lu(428)
         lu(436) = lu(436) - lu(342) * lu(428)
         lu(437) = lu(437) - lu(343) * lu(428)
         lu(439) = lu(439) - lu(344) * lu(428)
         lu(440) = lu(440) - lu(345) * lu(428)
         lu(441) = lu(441) - lu(346) * lu(428)
         lu(442) = lu(442) - lu(347) * lu(428)
         lu(472) = lu(472) - lu(339) * lu(468)
         lu(473) = lu(473) - lu(340) * lu(468)
         lu(474) = lu(474) - lu(341) * lu(468)
         lu(476) = lu(476) - lu(342) * lu(468)
         lu(477) = - lu(343) * lu(468)
         lu(479) = lu(479) - lu(344) * lu(468)
         lu(480) = lu(480) - lu(345) * lu(468)
         lu(481) = lu(481) - lu(346) * lu(468)
         lu(482) = lu(482) - lu(347) * lu(468)
         lu(503) = lu(503) - lu(339) * lu(498)
         lu(504) = lu(504) - lu(340) * lu(498)
         lu(505) = lu(505) - lu(341) * lu(498)
         lu(507) = lu(507) - lu(342) * lu(498)
         lu(509) = lu(509) - lu(343) * lu(498)
         lu(513) = lu(513) - lu(344) * lu(498)
         lu(514) = lu(514) - lu(345) * lu(498)
         lu(515) = lu(515) - lu(346) * lu(498)
         lu(516) = lu(516) - lu(347) * lu(498)
         lu(554) = - lu(339) * lu(549)
         lu(555) = lu(555) - lu(340) * lu(549)
         lu(556) = lu(556) - lu(341) * lu(549)
         lu(558) = lu(558) - lu(342) * lu(549)
         lu(560) = lu(560) - lu(343) * lu(549)
         lu(564) = lu(564) - lu(344) * lu(549)
         lu(567) = lu(567) - lu(345) * lu(549)
         lu(568) = lu(568) - lu(346) * lu(549)
         lu(569) = lu(569) - lu(347) * lu(549)
         lu(630) = lu(630) - lu(339) * lu(625)
         lu(631) = lu(631) - lu(340) * lu(625)
         lu(632) = lu(632) - lu(341) * lu(625)
         lu(634) = lu(634) - lu(342) * lu(625)
         lu(636) = lu(636) - lu(343) * lu(625)
         lu(640) = lu(640) - lu(344) * lu(625)
         lu(643) = lu(643) - lu(345) * lu(625)
         lu(644) = lu(644) - lu(346) * lu(625)
         lu(645) = lu(645) - lu(347) * lu(625)
         lu(674) = lu(674) - lu(339) * lu(669)
         lu(675) = lu(675) - lu(340) * lu(669)
         lu(676) = lu(676) - lu(341) * lu(669)
         lu(678) = lu(678) - lu(342) * lu(669)
         lu(680) = lu(680) - lu(343) * lu(669)
         lu(684) = lu(684) - lu(344) * lu(669)
         lu(687) = lu(687) - lu(345) * lu(669)
         lu(688) = lu(688) - lu(346) * lu(669)
         lu(689) = lu(689) - lu(347) * lu(669)
         lu(787) = lu(787) - lu(339) * lu(782)
         lu(788) = lu(788) - lu(340) * lu(782)
         lu(789) = lu(789) - lu(341) * lu(782)
         lu(791) = lu(791) - lu(342) * lu(782)
         lu(793) = lu(793) - lu(343) * lu(782)
         lu(797) = lu(797) - lu(344) * lu(782)
         lu(800) = lu(800) - lu(345) * lu(782)
         lu(801) = lu(801) - lu(346) * lu(782)
         lu(802) = lu(802) - lu(347) * lu(782)
                                                                        
         lu(348) = 1. / lu(348)
         lu(349) = lu(349) * lu(348)
         lu(350) = lu(350) * lu(348)
         lu(351) = lu(351) * lu(348)
         lu(352) = lu(352) * lu(348)
         lu(353) = lu(353) * lu(348)
         lu(354) = lu(354) * lu(348)
         lu(506) = lu(506) - lu(349) * lu(499)
         lu(508) = - lu(350) * lu(499)
         lu(509) = lu(509) - lu(351) * lu(499)
         lu(511) = lu(511) - lu(352) * lu(499)
         lu(513) = lu(513) - lu(353) * lu(499)
         lu(514) = lu(514) - lu(354) * lu(499)
         lu(523) = - lu(349) * lu(522)
         lu(525) = lu(525) - lu(350) * lu(522)
         lu(526) = - lu(351) * lu(522)
         lu(528) = lu(528) - lu(352) * lu(522)
         lu(530) = lu(530) - lu(353) * lu(522)
         lu(533) = - lu(354) * lu(522)
         lu(557) = lu(557) - lu(349) * lu(550)
         lu(559) = lu(559) - lu(350) * lu(550)
         lu(560) = lu(560) - lu(351) * lu(550)
         lu(562) = - lu(352) * lu(550)
         lu(564) = lu(564) - lu(353) * lu(550)
         lu(567) = lu(567) - lu(354) * lu(550)
         lu(575) = - lu(349) * lu(574)
         lu(577) = lu(577) - lu(350) * lu(574)
         lu(578) = lu(578) - lu(351) * lu(574)
         lu(580) = lu(580) - lu(352) * lu(574)
         lu(582) = lu(582) - lu(353) * lu(574)
         lu(585) = - lu(354) * lu(574)
         lu(597) = - lu(349) * lu(596)
         lu(599) = lu(599) - lu(350) * lu(596)
         lu(600) = - lu(351) * lu(596)
         lu(602) = lu(602) - lu(352) * lu(596)
         lu(604) = - lu(353) * lu(596)
         lu(607) = - lu(354) * lu(596)
         lu(633) = lu(633) - lu(349) * lu(626)
         lu(635) = lu(635) - lu(350) * lu(626)
         lu(636) = lu(636) - lu(351) * lu(626)
         lu(638) = - lu(352) * lu(626)
         lu(640) = lu(640) - lu(353) * lu(626)
         lu(643) = lu(643) - lu(354) * lu(626)
         lu(677) = lu(677) - lu(349) * lu(670)
         lu(679) = lu(679) - lu(350) * lu(670)
         lu(680) = lu(680) - lu(351) * lu(670)
         lu(682) = lu(682) - lu(352) * lu(670)
         lu(684) = lu(684) - lu(353) * lu(670)
         lu(687) = lu(687) - lu(354) * lu(670)
         lu(692) = - lu(349) * lu(691)
         lu(694) = - lu(350) * lu(691)
         lu(695) = lu(695) - lu(351) * lu(691)
         lu(697) = lu(697) - lu(352) * lu(691)
         lu(699) = lu(699) - lu(353) * lu(691)
         lu(702) = lu(702) - lu(354) * lu(691)
         lu(711) = - lu(349) * lu(710)
         lu(713) = lu(713) - lu(350) * lu(710)
         lu(714) = - lu(351) * lu(710)
         lu(716) = lu(716) - lu(352) * lu(710)
         lu(718) = lu(718) - lu(353) * lu(710)
         lu(721) = - lu(354) * lu(710)
         lu(728) = - lu(349) * lu(727)
         lu(730) = - lu(350) * lu(727)
         lu(731) = lu(731) - lu(351) * lu(727)
         lu(733) = lu(733) - lu(352) * lu(727)
         lu(735) = lu(735) - lu(353) * lu(727)
         lu(738) = lu(738) - lu(354) * lu(727)
         lu(790) = lu(790) - lu(349) * lu(783)
         lu(792) = lu(792) - lu(350) * lu(783)
         lu(793) = lu(793) - lu(351) * lu(783)
         lu(795) = lu(795) - lu(352) * lu(783)
         lu(797) = lu(797) - lu(353) * lu(783)
         lu(800) = lu(800) - lu(354) * lu(783)
         lu(817) = lu(817) - lu(349) * lu(814)
         lu(819) = lu(819) - lu(350) * lu(814)
         lu(820) = lu(820) - lu(351) * lu(814)
         lu(822) = lu(822) - lu(352) * lu(814)
         lu(824) = lu(824) - lu(353) * lu(814)
         lu(827) = lu(827) - lu(354) * lu(814)
                                                                        
                                                                        
      end subroutine imp_lu_fac08
                                                                        
      subroutine imp_lu_fac09( lu )
                                                                        
      use CHEM_MODS_MOD, only : imp_nzcnt, clsze
                                                                        
      implicit none
                                                                        
!-----------------------------------------------------------------------
!       ... Dummy args
!-----------------------------------------------------------------------
      real, intent(inout) ::   lu(imp_nzcnt)
                                                                        
         lu(359) = 1. / lu(359)
         lu(360) = lu(360) * lu(359)
         lu(361) = lu(361) * lu(359)
         lu(362) = lu(362) * lu(359)
         lu(363) = lu(363) * lu(359)
         lu(364) = lu(364) * lu(359)
         lu(365) = lu(365) * lu(359)
         lu(366) = lu(366) * lu(359)
         lu(367) = lu(367) * lu(359)
         lu(368) = lu(368) * lu(359)
         lu(369) = lu(369) * lu(359)
         lu(393) = lu(393) - lu(360) * lu(390)
         lu(394) = lu(394) - lu(361) * lu(390)
         lu(396) = lu(396) - lu(362) * lu(390)
         lu(397) = lu(397) - lu(363) * lu(390)
         lu(398) = lu(398) - lu(364) * lu(390)
         lu(399) = lu(399) - lu(365) * lu(390)
         lu(400) = lu(400) - lu(366) * lu(390)
         lu(401) = lu(401) - lu(367) * lu(390)
         lu(402) = lu(402) - lu(368) * lu(390)
         lu(403) = lu(403) - lu(369) * lu(390)
         lu(432) = lu(432) - lu(360) * lu(429)
         lu(433) = lu(433) - lu(361) * lu(429)
         lu(435) = lu(435) - lu(362) * lu(429)
         lu(436) = lu(436) - lu(363) * lu(429)
         lu(437) = lu(437) - lu(364) * lu(429)
         lu(438) = lu(438) - lu(365) * lu(429)
         lu(439) = lu(439) - lu(366) * lu(429)
         lu(440) = lu(440) - lu(367) * lu(429)
         lu(441) = lu(441) - lu(368) * lu(429)
         lu(442) = lu(442) - lu(369) * lu(429)
         lu(472) = lu(472) - lu(360) * lu(469)
         lu(473) = lu(473) - lu(361) * lu(469)
         lu(475) = lu(475) - lu(362) * lu(469)
         lu(476) = lu(476) - lu(363) * lu(469)
         lu(477) = lu(477) - lu(364) * lu(469)
         lu(478) = lu(478) - lu(365) * lu(469)
         lu(479) = lu(479) - lu(366) * lu(469)
         lu(480) = lu(480) - lu(367) * lu(469)
         lu(481) = lu(481) - lu(368) * lu(469)
         lu(482) = lu(482) - lu(369) * lu(469)
         lu(503) = lu(503) - lu(360) * lu(500)
         lu(504) = lu(504) - lu(361) * lu(500)
         lu(506) = lu(506) - lu(362) * lu(500)
         lu(507) = lu(507) - lu(363) * lu(500)
         lu(509) = lu(509) - lu(364) * lu(500)
         lu(512) = lu(512) - lu(365) * lu(500)
         lu(513) = lu(513) - lu(366) * lu(500)
         lu(514) = lu(514) - lu(367) * lu(500)
         lu(515) = lu(515) - lu(368) * lu(500)
         lu(516) = lu(516) - lu(369) * lu(500)
         lu(554) = lu(554) - lu(360) * lu(551)
         lu(555) = lu(555) - lu(361) * lu(551)
         lu(557) = lu(557) - lu(362) * lu(551)
         lu(558) = lu(558) - lu(363) * lu(551)
         lu(560) = lu(560) - lu(364) * lu(551)
         lu(563) = lu(563) - lu(365) * lu(551)
         lu(564) = lu(564) - lu(366) * lu(551)
         lu(567) = lu(567) - lu(367) * lu(551)
         lu(568) = lu(568) - lu(368) * lu(551)
         lu(569) = lu(569) - lu(369) * lu(551)
         lu(630) = lu(630) - lu(360) * lu(627)
         lu(631) = lu(631) - lu(361) * lu(627)
         lu(633) = lu(633) - lu(362) * lu(627)
         lu(634) = lu(634) - lu(363) * lu(627)
         lu(636) = lu(636) - lu(364) * lu(627)
         lu(639) = lu(639) - lu(365) * lu(627)
         lu(640) = lu(640) - lu(366) * lu(627)
         lu(643) = lu(643) - lu(367) * lu(627)
         lu(644) = lu(644) - lu(368) * lu(627)
         lu(645) = lu(645) - lu(369) * lu(627)
         lu(674) = lu(674) - lu(360) * lu(671)
         lu(675) = lu(675) - lu(361) * lu(671)
         lu(677) = lu(677) - lu(362) * lu(671)
         lu(678) = lu(678) - lu(363) * lu(671)
         lu(680) = lu(680) - lu(364) * lu(671)
         lu(683) = lu(683) - lu(365) * lu(671)
         lu(684) = lu(684) - lu(366) * lu(671)
         lu(687) = lu(687) - lu(367) * lu(671)
         lu(688) = lu(688) - lu(368) * lu(671)
         lu(689) = lu(689) - lu(369) * lu(671)
         lu(787) = lu(787) - lu(360) * lu(784)
         lu(788) = lu(788) - lu(361) * lu(784)
         lu(790) = lu(790) - lu(362) * lu(784)
         lu(791) = lu(791) - lu(363) * lu(784)
         lu(793) = lu(793) - lu(364) * lu(784)
         lu(796) = lu(796) - lu(365) * lu(784)
         lu(797) = lu(797) - lu(366) * lu(784)
         lu(800) = lu(800) - lu(367) * lu(784)
         lu(801) = lu(801) - lu(368) * lu(784)
         lu(802) = lu(802) - lu(369) * lu(784)
                                                                        
         lu(375) = 1. / lu(375)
         lu(376) = lu(376) * lu(375)
         lu(377) = lu(377) * lu(375)
         lu(378) = lu(378) * lu(375)
         lu(379) = lu(379) * lu(375)
         lu(380) = lu(380) * lu(375)
         lu(381) = lu(381) * lu(375)
         lu(382) = lu(382) * lu(375)
         lu(383) = lu(383) * lu(375)
         lu(384) = lu(384) * lu(375)
         lu(394) = lu(394) - lu(376) * lu(391)
         lu(395) = lu(395) - lu(377) * lu(391)
         lu(396) = lu(396) - lu(378) * lu(391)
         lu(397) = lu(397) - lu(379) * lu(391)
         lu(399) = lu(399) - lu(380) * lu(391)
         lu(400) = lu(400) - lu(381) * lu(391)
         lu(401) = lu(401) - lu(382) * lu(391)
         lu(402) = lu(402) - lu(383) * lu(391)
         lu(403) = lu(403) - lu(384) * lu(391)
         lu(412) = lu(412) - lu(376) * lu(410)
         lu(413) = lu(413) - lu(377) * lu(410)
         lu(414) = lu(414) - lu(378) * lu(410)
         lu(415) = lu(415) - lu(379) * lu(410)
         lu(417) = lu(417) - lu(380) * lu(410)
         lu(418) = lu(418) - lu(381) * lu(410)
         lu(419) = lu(419) - lu(382) * lu(410)
         lu(420) = lu(420) - lu(383) * lu(410)
         lu(421) = lu(421) - lu(384) * lu(410)
         lu(433) = lu(433) - lu(376) * lu(430)
         lu(434) = lu(434) - lu(377) * lu(430)
         lu(435) = lu(435) - lu(378) * lu(430)
         lu(436) = lu(436) - lu(379) * lu(430)
         lu(438) = lu(438) - lu(380) * lu(430)
         lu(439) = lu(439) - lu(381) * lu(430)
         lu(440) = lu(440) - lu(382) * lu(430)
         lu(441) = lu(441) - lu(383) * lu(430)
         lu(442) = lu(442) - lu(384) * lu(430)
         lu(473) = lu(473) - lu(376) * lu(470)
         lu(474) = lu(474) - lu(377) * lu(470)
         lu(475) = lu(475) - lu(378) * lu(470)
         lu(476) = lu(476) - lu(379) * lu(470)
         lu(478) = lu(478) - lu(380) * lu(470)
         lu(479) = lu(479) - lu(381) * lu(470)
         lu(480) = lu(480) - lu(382) * lu(470)
         lu(481) = lu(481) - lu(383) * lu(470)
         lu(482) = lu(482) - lu(384) * lu(470)
         lu(504) = lu(504) - lu(376) * lu(501)
         lu(505) = lu(505) - lu(377) * lu(501)
         lu(506) = lu(506) - lu(378) * lu(501)
         lu(507) = lu(507) - lu(379) * lu(501)
         lu(512) = lu(512) - lu(380) * lu(501)
         lu(513) = lu(513) - lu(381) * lu(501)
         lu(514) = lu(514) - lu(382) * lu(501)
         lu(515) = lu(515) - lu(383) * lu(501)
         lu(516) = lu(516) - lu(384) * lu(501)
         lu(555) = lu(555) - lu(376) * lu(552)
         lu(556) = lu(556) - lu(377) * lu(552)
         lu(557) = lu(557) - lu(378) * lu(552)
         lu(558) = lu(558) - lu(379) * lu(552)
         lu(563) = lu(563) - lu(380) * lu(552)
         lu(564) = lu(564) - lu(381) * lu(552)
         lu(567) = lu(567) - lu(382) * lu(552)
         lu(568) = lu(568) - lu(383) * lu(552)
         lu(569) = lu(569) - lu(384) * lu(552)
         lu(631) = lu(631) - lu(376) * lu(628)
         lu(632) = lu(632) - lu(377) * lu(628)
         lu(633) = lu(633) - lu(378) * lu(628)
         lu(634) = lu(634) - lu(379) * lu(628)
         lu(639) = lu(639) - lu(380) * lu(628)
         lu(640) = lu(640) - lu(381) * lu(628)
         lu(643) = lu(643) - lu(382) * lu(628)
         lu(644) = lu(644) - lu(383) * lu(628)
         lu(645) = lu(645) - lu(384) * lu(628)
         lu(675) = lu(675) - lu(376) * lu(672)
         lu(676) = lu(676) - lu(377) * lu(672)
         lu(677) = lu(677) - lu(378) * lu(672)
         lu(678) = lu(678) - lu(379) * lu(672)
         lu(683) = lu(683) - lu(380) * lu(672)
         lu(684) = lu(684) - lu(381) * lu(672)
         lu(687) = lu(687) - lu(382) * lu(672)
         lu(688) = lu(688) - lu(383) * lu(672)
         lu(689) = lu(689) - lu(384) * lu(672)
         lu(788) = lu(788) - lu(376) * lu(785)
         lu(789) = lu(789) - lu(377) * lu(785)
         lu(790) = lu(790) - lu(378) * lu(785)
         lu(791) = lu(791) - lu(379) * lu(785)
         lu(796) = lu(796) - lu(380) * lu(785)
         lu(797) = lu(797) - lu(381) * lu(785)
         lu(800) = lu(800) - lu(382) * lu(785)
         lu(801) = lu(801) - lu(383) * lu(785)
         lu(802) = lu(802) - lu(384) * lu(785)
                                                                        
         lu(392) = 1. / lu(392)
         lu(393) = lu(393) * lu(392)
         lu(394) = lu(394) * lu(392)
         lu(395) = lu(395) * lu(392)
         lu(396) = lu(396) * lu(392)
         lu(397) = lu(397) * lu(392)
         lu(398) = lu(398) * lu(392)
         lu(399) = lu(399) * lu(392)
         lu(400) = lu(400) * lu(392)
         lu(401) = lu(401) * lu(392)
         lu(402) = lu(402) * lu(392)
         lu(403) = lu(403) * lu(392)
         lu(432) = lu(432) - lu(393) * lu(431)
         lu(433) = lu(433) - lu(394) * lu(431)
         lu(434) = lu(434) - lu(395) * lu(431)
         lu(435) = lu(435) - lu(396) * lu(431)
         lu(436) = lu(436) - lu(397) * lu(431)
         lu(437) = lu(437) - lu(398) * lu(431)
         lu(438) = lu(438) - lu(399) * lu(431)
         lu(439) = lu(439) - lu(400) * lu(431)
         lu(440) = lu(440) - lu(401) * lu(431)
         lu(441) = lu(441) - lu(402) * lu(431)
         lu(442) = lu(442) - lu(403) * lu(431)
         lu(472) = lu(472) - lu(393) * lu(471)
         lu(473) = lu(473) - lu(394) * lu(471)
         lu(474) = lu(474) - lu(395) * lu(471)
         lu(475) = lu(475) - lu(396) * lu(471)
         lu(476) = lu(476) - lu(397) * lu(471)
         lu(477) = lu(477) - lu(398) * lu(471)
         lu(478) = lu(478) - lu(399) * lu(471)
         lu(479) = lu(479) - lu(400) * lu(471)
         lu(480) = lu(480) - lu(401) * lu(471)
         lu(481) = lu(481) - lu(402) * lu(471)
         lu(482) = lu(482) - lu(403) * lu(471)
         lu(503) = lu(503) - lu(393) * lu(502)
         lu(504) = lu(504) - lu(394) * lu(502)
         lu(505) = lu(505) - lu(395) * lu(502)
         lu(506) = lu(506) - lu(396) * lu(502)
         lu(507) = lu(507) - lu(397) * lu(502)
         lu(509) = lu(509) - lu(398) * lu(502)
         lu(512) = lu(512) - lu(399) * lu(502)
         lu(513) = lu(513) - lu(400) * lu(502)
         lu(514) = lu(514) - lu(401) * lu(502)
         lu(515) = lu(515) - lu(402) * lu(502)
         lu(516) = lu(516) - lu(403) * lu(502)
         lu(554) = lu(554) - lu(393) * lu(553)
         lu(555) = lu(555) - lu(394) * lu(553)
         lu(556) = lu(556) - lu(395) * lu(553)
         lu(557) = lu(557) - lu(396) * lu(553)
         lu(558) = lu(558) - lu(397) * lu(553)
         lu(560) = lu(560) - lu(398) * lu(553)
         lu(563) = lu(563) - lu(399) * lu(553)
         lu(564) = lu(564) - lu(400) * lu(553)
         lu(567) = lu(567) - lu(401) * lu(553)
         lu(568) = lu(568) - lu(402) * lu(553)
         lu(569) = lu(569) - lu(403) * lu(553)
         lu(630) = lu(630) - lu(393) * lu(629)
         lu(631) = lu(631) - lu(394) * lu(629)
         lu(632) = lu(632) - lu(395) * lu(629)
         lu(633) = lu(633) - lu(396) * lu(629)
         lu(634) = lu(634) - lu(397) * lu(629)
         lu(636) = lu(636) - lu(398) * lu(629)
         lu(639) = lu(639) - lu(399) * lu(629)
         lu(640) = lu(640) - lu(400) * lu(629)
         lu(643) = lu(643) - lu(401) * lu(629)
         lu(644) = lu(644) - lu(402) * lu(629)
         lu(645) = lu(645) - lu(403) * lu(629)
         lu(674) = lu(674) - lu(393) * lu(673)
         lu(675) = lu(675) - lu(394) * lu(673)
         lu(676) = lu(676) - lu(395) * lu(673)
         lu(677) = lu(677) - lu(396) * lu(673)
         lu(678) = lu(678) - lu(397) * lu(673)
         lu(680) = lu(680) - lu(398) * lu(673)
         lu(683) = lu(683) - lu(399) * lu(673)
         lu(684) = lu(684) - lu(400) * lu(673)
         lu(687) = lu(687) - lu(401) * lu(673)
         lu(688) = lu(688) - lu(402) * lu(673)
         lu(689) = lu(689) - lu(403) * lu(673)
         lu(787) = lu(787) - lu(393) * lu(786)
         lu(788) = lu(788) - lu(394) * lu(786)
         lu(789) = lu(789) - lu(395) * lu(786)
         lu(790) = lu(790) - lu(396) * lu(786)
         lu(791) = lu(791) - lu(397) * lu(786)
         lu(793) = lu(793) - lu(398) * lu(786)
         lu(796) = lu(796) - lu(399) * lu(786)
         lu(797) = lu(797) - lu(400) * lu(786)
         lu(800) = lu(800) - lu(401) * lu(786)
         lu(801) = lu(801) - lu(402) * lu(786)
         lu(802) = lu(802) - lu(403) * lu(786)
                                                                        
         lu(411) = 1. / lu(411)
         lu(412) = lu(412) * lu(411)
         lu(413) = lu(413) * lu(411)
         lu(414) = lu(414) * lu(411)
         lu(415) = lu(415) * lu(411)
         lu(416) = lu(416) * lu(411)
         lu(417) = lu(417) * lu(411)
         lu(418) = lu(418) * lu(411)
         lu(419) = lu(419) * lu(411)
         lu(420) = lu(420) * lu(411)
         lu(421) = lu(421) * lu(411)
         lu(433) = lu(433) - lu(412) * lu(432)
         lu(434) = lu(434) - lu(413) * lu(432)
         lu(435) = lu(435) - lu(414) * lu(432)
         lu(436) = lu(436) - lu(415) * lu(432)
         lu(437) = lu(437) - lu(416) * lu(432)
         lu(438) = lu(438) - lu(417) * lu(432)
         lu(439) = lu(439) - lu(418) * lu(432)
         lu(440) = lu(440) - lu(419) * lu(432)
         lu(441) = lu(441) - lu(420) * lu(432)
         lu(442) = lu(442) - lu(421) * lu(432)
         lu(473) = lu(473) - lu(412) * lu(472)
         lu(474) = lu(474) - lu(413) * lu(472)
         lu(475) = lu(475) - lu(414) * lu(472)
         lu(476) = lu(476) - lu(415) * lu(472)
         lu(477) = lu(477) - lu(416) * lu(472)
         lu(478) = lu(478) - lu(417) * lu(472)
         lu(479) = lu(479) - lu(418) * lu(472)
         lu(480) = lu(480) - lu(419) * lu(472)
         lu(481) = lu(481) - lu(420) * lu(472)
         lu(482) = lu(482) - lu(421) * lu(472)
         lu(504) = lu(504) - lu(412) * lu(503)
         lu(505) = lu(505) - lu(413) * lu(503)
         lu(506) = lu(506) - lu(414) * lu(503)
         lu(507) = lu(507) - lu(415) * lu(503)
         lu(509) = lu(509) - lu(416) * lu(503)
         lu(512) = lu(512) - lu(417) * lu(503)
         lu(513) = lu(513) - lu(418) * lu(503)
         lu(514) = lu(514) - lu(419) * lu(503)
         lu(515) = lu(515) - lu(420) * lu(503)
         lu(516) = lu(516) - lu(421) * lu(503)
         lu(555) = lu(555) - lu(412) * lu(554)
         lu(556) = lu(556) - lu(413) * lu(554)
         lu(557) = lu(557) - lu(414) * lu(554)
         lu(558) = lu(558) - lu(415) * lu(554)
         lu(560) = lu(560) - lu(416) * lu(554)
         lu(563) = lu(563) - lu(417) * lu(554)
         lu(564) = lu(564) - lu(418) * lu(554)
         lu(567) = lu(567) - lu(419) * lu(554)
         lu(568) = lu(568) - lu(420) * lu(554)
         lu(569) = lu(569) - lu(421) * lu(554)
         lu(631) = lu(631) - lu(412) * lu(630)
         lu(632) = lu(632) - lu(413) * lu(630)
         lu(633) = lu(633) - lu(414) * lu(630)
         lu(634) = lu(634) - lu(415) * lu(630)
         lu(636) = lu(636) - lu(416) * lu(630)
         lu(639) = lu(639) - lu(417) * lu(630)
         lu(640) = lu(640) - lu(418) * lu(630)
         lu(643) = lu(643) - lu(419) * lu(630)
         lu(644) = lu(644) - lu(420) * lu(630)
         lu(645) = lu(645) - lu(421) * lu(630)
         lu(675) = lu(675) - lu(412) * lu(674)
         lu(676) = lu(676) - lu(413) * lu(674)
         lu(677) = lu(677) - lu(414) * lu(674)
         lu(678) = lu(678) - lu(415) * lu(674)
         lu(680) = lu(680) - lu(416) * lu(674)
         lu(683) = lu(683) - lu(417) * lu(674)
         lu(684) = lu(684) - lu(418) * lu(674)
         lu(687) = lu(687) - lu(419) * lu(674)
         lu(688) = lu(688) - lu(420) * lu(674)
         lu(689) = lu(689) - lu(421) * lu(674)
         lu(788) = lu(788) - lu(412) * lu(787)
         lu(789) = lu(789) - lu(413) * lu(787)
         lu(790) = lu(790) - lu(414) * lu(787)
         lu(791) = lu(791) - lu(415) * lu(787)
         lu(793) = lu(793) - lu(416) * lu(787)
         lu(796) = lu(796) - lu(417) * lu(787)
         lu(797) = lu(797) - lu(418) * lu(787)
         lu(800) = lu(800) - lu(419) * lu(787)
         lu(801) = lu(801) - lu(420) * lu(787)
         lu(802) = lu(802) - lu(421) * lu(787)
                                                                        
         lu(433) = 1. / lu(433)
         lu(434) = lu(434) * lu(433)
         lu(435) = lu(435) * lu(433)
         lu(436) = lu(436) * lu(433)
         lu(437) = lu(437) * lu(433)
         lu(438) = lu(438) * lu(433)
         lu(439) = lu(439) * lu(433)
         lu(440) = lu(440) * lu(433)
         lu(441) = lu(441) * lu(433)
         lu(442) = lu(442) * lu(433)
         lu(447) = lu(447) - lu(434) * lu(446)
         lu(448) = lu(448) - lu(435) * lu(446)
         lu(449) = lu(449) - lu(436) * lu(446)
         lu(450) = lu(450) - lu(437) * lu(446)
         lu(451) = lu(451) - lu(438) * lu(446)
         lu(452) = lu(452) - lu(439) * lu(446)
         lu(453) = lu(453) - lu(440) * lu(446)
         lu(454) = lu(454) - lu(441) * lu(446)
         lu(455) = lu(455) - lu(442) * lu(446)
         lu(474) = lu(474) - lu(434) * lu(473)
         lu(475) = lu(475) - lu(435) * lu(473)
         lu(476) = lu(476) - lu(436) * lu(473)
         lu(477) = lu(477) - lu(437) * lu(473)
         lu(478) = lu(478) - lu(438) * lu(473)
         lu(479) = lu(479) - lu(439) * lu(473)
         lu(480) = lu(480) - lu(440) * lu(473)
         lu(481) = lu(481) - lu(441) * lu(473)
         lu(482) = lu(482) - lu(442) * lu(473)
         lu(505) = lu(505) - lu(434) * lu(504)
         lu(506) = lu(506) - lu(435) * lu(504)
         lu(507) = lu(507) - lu(436) * lu(504)
         lu(509) = lu(509) - lu(437) * lu(504)
         lu(512) = lu(512) - lu(438) * lu(504)
         lu(513) = lu(513) - lu(439) * lu(504)
         lu(514) = lu(514) - lu(440) * lu(504)
         lu(515) = lu(515) - lu(441) * lu(504)
         lu(516) = lu(516) - lu(442) * lu(504)
         lu(556) = lu(556) - lu(434) * lu(555)
         lu(557) = lu(557) - lu(435) * lu(555)
         lu(558) = lu(558) - lu(436) * lu(555)
         lu(560) = lu(560) - lu(437) * lu(555)
         lu(563) = lu(563) - lu(438) * lu(555)
         lu(564) = lu(564) - lu(439) * lu(555)
         lu(567) = lu(567) - lu(440) * lu(555)
         lu(568) = lu(568) - lu(441) * lu(555)
         lu(569) = lu(569) - lu(442) * lu(555)
         lu(632) = lu(632) - lu(434) * lu(631)
         lu(633) = lu(633) - lu(435) * lu(631)
         lu(634) = lu(634) - lu(436) * lu(631)
         lu(636) = lu(636) - lu(437) * lu(631)
         lu(639) = lu(639) - lu(438) * lu(631)
         lu(640) = lu(640) - lu(439) * lu(631)
         lu(643) = lu(643) - lu(440) * lu(631)
         lu(644) = lu(644) - lu(441) * lu(631)
         lu(645) = lu(645) - lu(442) * lu(631)
         lu(676) = lu(676) - lu(434) * lu(675)
         lu(677) = lu(677) - lu(435) * lu(675)
         lu(678) = lu(678) - lu(436) * lu(675)
         lu(680) = lu(680) - lu(437) * lu(675)
         lu(683) = lu(683) - lu(438) * lu(675)
         lu(684) = lu(684) - lu(439) * lu(675)
         lu(687) = lu(687) - lu(440) * lu(675)
         lu(688) = lu(688) - lu(441) * lu(675)
         lu(689) = lu(689) - lu(442) * lu(675)
         lu(789) = lu(789) - lu(434) * lu(788)
         lu(790) = lu(790) - lu(435) * lu(788)
         lu(791) = lu(791) - lu(436) * lu(788)
         lu(793) = lu(793) - lu(437) * lu(788)
         lu(796) = lu(796) - lu(438) * lu(788)
         lu(797) = lu(797) - lu(439) * lu(788)
         lu(800) = lu(800) - lu(440) * lu(788)
         lu(801) = lu(801) - lu(441) * lu(788)
         lu(802) = lu(802) - lu(442) * lu(788)
         lu(816) = lu(816) - lu(434) * lu(815)
         lu(817) = lu(817) - lu(435) * lu(815)
         lu(818) = lu(818) - lu(436) * lu(815)
         lu(820) = lu(820) - lu(437) * lu(815)
         lu(823) = lu(823) - lu(438) * lu(815)
         lu(824) = lu(824) - lu(439) * lu(815)
         lu(827) = lu(827) - lu(440) * lu(815)
         lu(828) = lu(828) - lu(441) * lu(815)
         lu(829) = lu(829) - lu(442) * lu(815)
                                                                        
                                                                        
      end subroutine imp_lu_fac09
                                                                        
      subroutine imp_lu_fac10( lu )
                                                                        
      use CHEM_MODS_MOD, only : imp_nzcnt, clsze
                                                                        
      implicit none
                                                                        
!-----------------------------------------------------------------------
!       ... Dummy args
!-----------------------------------------------------------------------
      real, intent(inout) ::   lu(imp_nzcnt)
                                                                        
         lu(447) = 1. / lu(447)
         lu(448) = lu(448) * lu(447)
         lu(449) = lu(449) * lu(447)
         lu(450) = lu(450) * lu(447)
         lu(451) = lu(451) * lu(447)
         lu(452) = lu(452) * lu(447)
         lu(453) = lu(453) * lu(447)
         lu(454) = lu(454) * lu(447)
         lu(455) = lu(455) * lu(447)
         lu(475) = lu(475) - lu(448) * lu(474)
         lu(476) = lu(476) - lu(449) * lu(474)
         lu(477) = lu(477) - lu(450) * lu(474)
         lu(478) = lu(478) - lu(451) * lu(474)
         lu(479) = lu(479) - lu(452) * lu(474)
         lu(480) = lu(480) - lu(453) * lu(474)
         lu(481) = lu(481) - lu(454) * lu(474)
         lu(482) = lu(482) - lu(455) * lu(474)
         lu(506) = lu(506) - lu(448) * lu(505)
         lu(507) = lu(507) - lu(449) * lu(505)
         lu(509) = lu(509) - lu(450) * lu(505)
         lu(512) = lu(512) - lu(451) * lu(505)
         lu(513) = lu(513) - lu(452) * lu(505)
         lu(514) = lu(514) - lu(453) * lu(505)
         lu(515) = lu(515) - lu(454) * lu(505)
         lu(516) = lu(516) - lu(455) * lu(505)
         lu(557) = lu(557) - lu(448) * lu(556)
         lu(558) = lu(558) - lu(449) * lu(556)
         lu(560) = lu(560) - lu(450) * lu(556)
         lu(563) = lu(563) - lu(451) * lu(556)
         lu(564) = lu(564) - lu(452) * lu(556)
         lu(567) = lu(567) - lu(453) * lu(556)
         lu(568) = lu(568) - lu(454) * lu(556)
         lu(569) = lu(569) - lu(455) * lu(556)
         lu(633) = lu(633) - lu(448) * lu(632)
         lu(634) = lu(634) - lu(449) * lu(632)
         lu(636) = lu(636) - lu(450) * lu(632)
         lu(639) = lu(639) - lu(451) * lu(632)
         lu(640) = lu(640) - lu(452) * lu(632)
         lu(643) = lu(643) - lu(453) * lu(632)
         lu(644) = lu(644) - lu(454) * lu(632)
         lu(645) = lu(645) - lu(455) * lu(632)
         lu(677) = lu(677) - lu(448) * lu(676)
         lu(678) = lu(678) - lu(449) * lu(676)
         lu(680) = lu(680) - lu(450) * lu(676)
         lu(683) = lu(683) - lu(451) * lu(676)
         lu(684) = lu(684) - lu(452) * lu(676)
         lu(687) = lu(687) - lu(453) * lu(676)
         lu(688) = lu(688) - lu(454) * lu(676)
         lu(689) = lu(689) - lu(455) * lu(676)
         lu(790) = lu(790) - lu(448) * lu(789)
         lu(791) = lu(791) - lu(449) * lu(789)
         lu(793) = lu(793) - lu(450) * lu(789)
         lu(796) = lu(796) - lu(451) * lu(789)
         lu(797) = lu(797) - lu(452) * lu(789)
         lu(800) = lu(800) - lu(453) * lu(789)
         lu(801) = lu(801) - lu(454) * lu(789)
         lu(802) = lu(802) - lu(455) * lu(789)
         lu(817) = lu(817) - lu(448) * lu(816)
         lu(818) = lu(818) - lu(449) * lu(816)
         lu(820) = lu(820) - lu(450) * lu(816)
         lu(823) = lu(823) - lu(451) * lu(816)
         lu(824) = lu(824) - lu(452) * lu(816)
         lu(827) = lu(827) - lu(453) * lu(816)
         lu(828) = lu(828) - lu(454) * lu(816)
         lu(829) = lu(829) - lu(455) * lu(816)
                                                                        
         lu(475) = 1. / lu(475)
         lu(476) = lu(476) * lu(475)
         lu(477) = lu(477) * lu(475)
         lu(478) = lu(478) * lu(475)
         lu(479) = lu(479) * lu(475)
         lu(480) = lu(480) * lu(475)
         lu(481) = lu(481) * lu(475)
         lu(482) = lu(482) * lu(475)
         lu(507) = lu(507) - lu(476) * lu(506)
         lu(509) = lu(509) - lu(477) * lu(506)
         lu(512) = lu(512) - lu(478) * lu(506)
         lu(513) = lu(513) - lu(479) * lu(506)
         lu(514) = lu(514) - lu(480) * lu(506)
         lu(515) = lu(515) - lu(481) * lu(506)
         lu(516) = lu(516) - lu(482) * lu(506)
         lu(524) = lu(524) - lu(476) * lu(523)
         lu(526) = lu(526) - lu(477) * lu(523)
         lu(529) = lu(529) - lu(478) * lu(523)
         lu(530) = lu(530) - lu(479) * lu(523)
         lu(533) = lu(533) - lu(480) * lu(523)
         lu(534) = lu(534) - lu(481) * lu(523)
         lu(535) = lu(535) - lu(482) * lu(523)
         lu(558) = lu(558) - lu(476) * lu(557)
         lu(560) = lu(560) - lu(477) * lu(557)
         lu(563) = lu(563) - lu(478) * lu(557)
         lu(564) = lu(564) - lu(479) * lu(557)
         lu(567) = lu(567) - lu(480) * lu(557)
         lu(568) = lu(568) - lu(481) * lu(557)
         lu(569) = lu(569) - lu(482) * lu(557)
         lu(576) = lu(576) - lu(476) * lu(575)
         lu(578) = lu(578) - lu(477) * lu(575)
         lu(581) = lu(581) - lu(478) * lu(575)
         lu(582) = lu(582) - lu(479) * lu(575)
         lu(585) = lu(585) - lu(480) * lu(575)
         lu(586) = lu(586) - lu(481) * lu(575)
         lu(587) = lu(587) - lu(482) * lu(575)
         lu(598) = lu(598) - lu(476) * lu(597)
         lu(600) = lu(600) - lu(477) * lu(597)
         lu(603) = - lu(478) * lu(597)
         lu(604) = lu(604) - lu(479) * lu(597)
         lu(607) = lu(607) - lu(480) * lu(597)
         lu(608) = lu(608) - lu(481) * lu(597)
         lu(609) = lu(609) - lu(482) * lu(597)
         lu(634) = lu(634) - lu(476) * lu(633)
         lu(636) = lu(636) - lu(477) * lu(633)
         lu(639) = lu(639) - lu(478) * lu(633)
         lu(640) = lu(640) - lu(479) * lu(633)
         lu(643) = lu(643) - lu(480) * lu(633)
         lu(644) = lu(644) - lu(481) * lu(633)
         lu(645) = lu(645) - lu(482) * lu(633)
         lu(678) = lu(678) - lu(476) * lu(677)
         lu(680) = lu(680) - lu(477) * lu(677)
         lu(683) = lu(683) - lu(478) * lu(677)
         lu(684) = lu(684) - lu(479) * lu(677)
         lu(687) = lu(687) - lu(480) * lu(677)
         lu(688) = lu(688) - lu(481) * lu(677)
         lu(689) = lu(689) - lu(482) * lu(677)
         lu(693) = - lu(476) * lu(692)
         lu(695) = lu(695) - lu(477) * lu(692)
         lu(698) = - lu(478) * lu(692)
         lu(699) = lu(699) - lu(479) * lu(692)
         lu(702) = lu(702) - lu(480) * lu(692)
         lu(703) = lu(703) - lu(481) * lu(692)
         lu(704) = - lu(482) * lu(692)
         lu(712) = lu(712) - lu(476) * lu(711)
         lu(714) = lu(714) - lu(477) * lu(711)
         lu(717) = lu(717) - lu(478) * lu(711)
         lu(718) = lu(718) - lu(479) * lu(711)
         lu(721) = lu(721) - lu(480) * lu(711)
         lu(722) = lu(722) - lu(481) * lu(711)
         lu(723) = lu(723) - lu(482) * lu(711)
         lu(729) = lu(729) - lu(476) * lu(728)
         lu(731) = lu(731) - lu(477) * lu(728)
         lu(734) = - lu(478) * lu(728)
         lu(735) = lu(735) - lu(479) * lu(728)
         lu(738) = lu(738) - lu(480) * lu(728)
         lu(739) = lu(739) - lu(481) * lu(728)
         lu(740) = lu(740) - lu(482) * lu(728)
         lu(791) = lu(791) - lu(476) * lu(790)
         lu(793) = lu(793) - lu(477) * lu(790)
         lu(796) = lu(796) - lu(478) * lu(790)
         lu(797) = lu(797) - lu(479) * lu(790)
         lu(800) = lu(800) - lu(480) * lu(790)
         lu(801) = lu(801) - lu(481) * lu(790)
         lu(802) = lu(802) - lu(482) * lu(790)
         lu(818) = lu(818) - lu(476) * lu(817)
         lu(820) = lu(820) - lu(477) * lu(817)
         lu(823) = lu(823) - lu(478) * lu(817)
         lu(824) = lu(824) - lu(479) * lu(817)
         lu(827) = lu(827) - lu(480) * lu(817)
         lu(828) = lu(828) - lu(481) * lu(817)
         lu(829) = lu(829) - lu(482) * lu(817)
                                                                        
         lu(507) = 1. / lu(507)
         lu(508) = lu(508) * lu(507)
         lu(509) = lu(509) * lu(507)
         lu(510) = lu(510) * lu(507)
         lu(511) = lu(511) * lu(507)
         lu(512) = lu(512) * lu(507)
         lu(513) = lu(513) * lu(507)
         lu(514) = lu(514) * lu(507)
         lu(515) = lu(515) * lu(507)
         lu(516) = lu(516) * lu(507)
         lu(525) = lu(525) - lu(508) * lu(524)
         lu(526) = lu(526) - lu(509) * lu(524)
         lu(527) = lu(527) - lu(510) * lu(524)
         lu(528) = lu(528) - lu(511) * lu(524)
         lu(529) = lu(529) - lu(512) * lu(524)
         lu(530) = lu(530) - lu(513) * lu(524)
         lu(533) = lu(533) - lu(514) * lu(524)
         lu(534) = lu(534) - lu(515) * lu(524)
         lu(535) = lu(535) - lu(516) * lu(524)
         lu(559) = lu(559) - lu(508) * lu(558)
         lu(560) = lu(560) - lu(509) * lu(558)
         lu(561) = lu(561) - lu(510) * lu(558)
         lu(562) = lu(562) - lu(511) * lu(558)
         lu(563) = lu(563) - lu(512) * lu(558)
         lu(564) = lu(564) - lu(513) * lu(558)
         lu(567) = lu(567) - lu(514) * lu(558)
         lu(568) = lu(568) - lu(515) * lu(558)
         lu(569) = lu(569) - lu(516) * lu(558)
         lu(577) = lu(577) - lu(508) * lu(576)
         lu(578) = lu(578) - lu(509) * lu(576)
         lu(579) = lu(579) - lu(510) * lu(576)
         lu(580) = lu(580) - lu(511) * lu(576)
         lu(581) = lu(581) - lu(512) * lu(576)
         lu(582) = lu(582) - lu(513) * lu(576)
         lu(585) = lu(585) - lu(514) * lu(576)
         lu(586) = lu(586) - lu(515) * lu(576)
         lu(587) = lu(587) - lu(516) * lu(576)
         lu(599) = lu(599) - lu(508) * lu(598)
         lu(600) = lu(600) - lu(509) * lu(598)
         lu(601) = lu(601) - lu(510) * lu(598)
         lu(602) = lu(602) - lu(511) * lu(598)
         lu(603) = lu(603) - lu(512) * lu(598)
         lu(604) = lu(604) - lu(513) * lu(598)
         lu(607) = lu(607) - lu(514) * lu(598)
         lu(608) = lu(608) - lu(515) * lu(598)
         lu(609) = lu(609) - lu(516) * lu(598)
         lu(635) = lu(635) - lu(508) * lu(634)
         lu(636) = lu(636) - lu(509) * lu(634)
         lu(637) = lu(637) - lu(510) * lu(634)
         lu(638) = lu(638) - lu(511) * lu(634)
         lu(639) = lu(639) - lu(512) * lu(634)
         lu(640) = lu(640) - lu(513) * lu(634)
         lu(643) = lu(643) - lu(514) * lu(634)
         lu(644) = lu(644) - lu(515) * lu(634)
         lu(645) = lu(645) - lu(516) * lu(634)
         lu(679) = lu(679) - lu(508) * lu(678)
         lu(680) = lu(680) - lu(509) * lu(678)
         lu(681) = lu(681) - lu(510) * lu(678)
         lu(682) = lu(682) - lu(511) * lu(678)
         lu(683) = lu(683) - lu(512) * lu(678)
         lu(684) = lu(684) - lu(513) * lu(678)
         lu(687) = lu(687) - lu(514) * lu(678)
         lu(688) = lu(688) - lu(515) * lu(678)
         lu(689) = lu(689) - lu(516) * lu(678)
         lu(694) = lu(694) - lu(508) * lu(693)
         lu(695) = lu(695) - lu(509) * lu(693)
         lu(696) = lu(696) - lu(510) * lu(693)
         lu(697) = lu(697) - lu(511) * lu(693)
         lu(698) = lu(698) - lu(512) * lu(693)
         lu(699) = lu(699) - lu(513) * lu(693)
         lu(702) = lu(702) - lu(514) * lu(693)
         lu(703) = lu(703) - lu(515) * lu(693)
         lu(704) = lu(704) - lu(516) * lu(693)
         lu(713) = lu(713) - lu(508) * lu(712)
         lu(714) = lu(714) - lu(509) * lu(712)
         lu(715) = lu(715) - lu(510) * lu(712)
         lu(716) = lu(716) - lu(511) * lu(712)
         lu(717) = lu(717) - lu(512) * lu(712)
         lu(718) = lu(718) - lu(513) * lu(712)
         lu(721) = lu(721) - lu(514) * lu(712)
         lu(722) = lu(722) - lu(515) * lu(712)
         lu(723) = lu(723) - lu(516) * lu(712)
         lu(730) = lu(730) - lu(508) * lu(729)
         lu(731) = lu(731) - lu(509) * lu(729)
         lu(732) = lu(732) - lu(510) * lu(729)
         lu(733) = lu(733) - lu(511) * lu(729)
         lu(734) = lu(734) - lu(512) * lu(729)
         lu(735) = lu(735) - lu(513) * lu(729)
         lu(738) = lu(738) - lu(514) * lu(729)
         lu(739) = lu(739) - lu(515) * lu(729)
         lu(740) = lu(740) - lu(516) * lu(729)
         lu(792) = lu(792) - lu(508) * lu(791)
         lu(793) = lu(793) - lu(509) * lu(791)
         lu(794) = lu(794) - lu(510) * lu(791)
         lu(795) = lu(795) - lu(511) * lu(791)
         lu(796) = lu(796) - lu(512) * lu(791)
         lu(797) = lu(797) - lu(513) * lu(791)
         lu(800) = lu(800) - lu(514) * lu(791)
         lu(801) = lu(801) - lu(515) * lu(791)
         lu(802) = lu(802) - lu(516) * lu(791)
         lu(819) = lu(819) - lu(508) * lu(818)
         lu(820) = lu(820) - lu(509) * lu(818)
         lu(821) = lu(821) - lu(510) * lu(818)
         lu(822) = lu(822) - lu(511) * lu(818)
         lu(823) = lu(823) - lu(512) * lu(818)
         lu(824) = lu(824) - lu(513) * lu(818)
         lu(827) = lu(827) - lu(514) * lu(818)
         lu(828) = lu(828) - lu(515) * lu(818)
         lu(829) = lu(829) - lu(516) * lu(818)
                                                                        
         lu(525) = 1. / lu(525)
         lu(526) = lu(526) * lu(525)
         lu(527) = lu(527) * lu(525)
         lu(528) = lu(528) * lu(525)
         lu(529) = lu(529) * lu(525)
         lu(530) = lu(530) * lu(525)
         lu(531) = lu(531) * lu(525)
         lu(532) = lu(532) * lu(525)
         lu(533) = lu(533) * lu(525)
         lu(534) = lu(534) * lu(525)
         lu(535) = lu(535) * lu(525)
         lu(560) = lu(560) - lu(526) * lu(559)
         lu(561) = lu(561) - lu(527) * lu(559)
         lu(562) = lu(562) - lu(528) * lu(559)
         lu(563) = lu(563) - lu(529) * lu(559)
         lu(564) = lu(564) - lu(530) * lu(559)
         lu(565) = lu(565) - lu(531) * lu(559)
         lu(566) = lu(566) - lu(532) * lu(559)
         lu(567) = lu(567) - lu(533) * lu(559)
         lu(568) = lu(568) - lu(534) * lu(559)
         lu(569) = lu(569) - lu(535) * lu(559)
         lu(578) = lu(578) - lu(526) * lu(577)
         lu(579) = lu(579) - lu(527) * lu(577)
         lu(580) = lu(580) - lu(528) * lu(577)
         lu(581) = lu(581) - lu(529) * lu(577)
         lu(582) = lu(582) - lu(530) * lu(577)
         lu(583) = lu(583) - lu(531) * lu(577)
         lu(584) = lu(584) - lu(532) * lu(577)
         lu(585) = lu(585) - lu(533) * lu(577)
         lu(586) = lu(586) - lu(534) * lu(577)
         lu(587) = lu(587) - lu(535) * lu(577)
         lu(600) = lu(600) - lu(526) * lu(599)
         lu(601) = lu(601) - lu(527) * lu(599)
         lu(602) = lu(602) - lu(528) * lu(599)
         lu(603) = lu(603) - lu(529) * lu(599)
         lu(604) = lu(604) - lu(530) * lu(599)
         lu(605) = lu(605) - lu(531) * lu(599)
         lu(606) = lu(606) - lu(532) * lu(599)
         lu(607) = lu(607) - lu(533) * lu(599)
         lu(608) = lu(608) - lu(534) * lu(599)
         lu(609) = lu(609) - lu(535) * lu(599)
         lu(636) = lu(636) - lu(526) * lu(635)
         lu(637) = lu(637) - lu(527) * lu(635)
         lu(638) = lu(638) - lu(528) * lu(635)
         lu(639) = lu(639) - lu(529) * lu(635)
         lu(640) = lu(640) - lu(530) * lu(635)
         lu(641) = lu(641) - lu(531) * lu(635)
         lu(642) = lu(642) - lu(532) * lu(635)
         lu(643) = lu(643) - lu(533) * lu(635)
         lu(644) = lu(644) - lu(534) * lu(635)
         lu(645) = lu(645) - lu(535) * lu(635)
         lu(680) = lu(680) - lu(526) * lu(679)
         lu(681) = lu(681) - lu(527) * lu(679)
         lu(682) = lu(682) - lu(528) * lu(679)
         lu(683) = lu(683) - lu(529) * lu(679)
         lu(684) = lu(684) - lu(530) * lu(679)
         lu(685) = lu(685) - lu(531) * lu(679)
         lu(686) = lu(686) - lu(532) * lu(679)
         lu(687) = lu(687) - lu(533) * lu(679)
         lu(688) = lu(688) - lu(534) * lu(679)
         lu(689) = lu(689) - lu(535) * lu(679)
         lu(695) = lu(695) - lu(526) * lu(694)
         lu(696) = lu(696) - lu(527) * lu(694)
         lu(697) = lu(697) - lu(528) * lu(694)
         lu(698) = lu(698) - lu(529) * lu(694)
         lu(699) = lu(699) - lu(530) * lu(694)
         lu(700) = lu(700) - lu(531) * lu(694)
         lu(701) = lu(701) - lu(532) * lu(694)
         lu(702) = lu(702) - lu(533) * lu(694)
         lu(703) = lu(703) - lu(534) * lu(694)
         lu(704) = lu(704) - lu(535) * lu(694)
         lu(714) = lu(714) - lu(526) * lu(713)
         lu(715) = lu(715) - lu(527) * lu(713)
         lu(716) = lu(716) - lu(528) * lu(713)
         lu(717) = lu(717) - lu(529) * lu(713)
         lu(718) = lu(718) - lu(530) * lu(713)
         lu(719) = lu(719) - lu(531) * lu(713)
         lu(720) = lu(720) - lu(532) * lu(713)
         lu(721) = lu(721) - lu(533) * lu(713)
         lu(722) = lu(722) - lu(534) * lu(713)
         lu(723) = lu(723) - lu(535) * lu(713)
         lu(731) = lu(731) - lu(526) * lu(730)
         lu(732) = lu(732) - lu(527) * lu(730)
         lu(733) = lu(733) - lu(528) * lu(730)
         lu(734) = lu(734) - lu(529) * lu(730)
         lu(735) = lu(735) - lu(530) * lu(730)
         lu(736) = lu(736) - lu(531) * lu(730)
         lu(737) = lu(737) - lu(532) * lu(730)
         lu(738) = lu(738) - lu(533) * lu(730)
         lu(739) = lu(739) - lu(534) * lu(730)
         lu(740) = lu(740) - lu(535) * lu(730)
         lu(793) = lu(793) - lu(526) * lu(792)
         lu(794) = lu(794) - lu(527) * lu(792)
         lu(795) = lu(795) - lu(528) * lu(792)
         lu(796) = lu(796) - lu(529) * lu(792)
         lu(797) = lu(797) - lu(530) * lu(792)
         lu(798) = lu(798) - lu(531) * lu(792)
         lu(799) = lu(799) - lu(532) * lu(792)
         lu(800) = lu(800) - lu(533) * lu(792)
         lu(801) = lu(801) - lu(534) * lu(792)
         lu(802) = lu(802) - lu(535) * lu(792)
         lu(820) = lu(820) - lu(526) * lu(819)
         lu(821) = lu(821) - lu(527) * lu(819)
         lu(822) = lu(822) - lu(528) * lu(819)
         lu(823) = lu(823) - lu(529) * lu(819)
         lu(824) = lu(824) - lu(530) * lu(819)
         lu(825) = lu(825) - lu(531) * lu(819)
         lu(826) = lu(826) - lu(532) * lu(819)
         lu(827) = lu(827) - lu(533) * lu(819)
         lu(828) = lu(828) - lu(534) * lu(819)
         lu(829) = lu(829) - lu(535) * lu(819)
                                                                        
         lu(560) = 1. / lu(560)
         lu(561) = lu(561) * lu(560)
         lu(562) = lu(562) * lu(560)
         lu(563) = lu(563) * lu(560)
         lu(564) = lu(564) * lu(560)
         lu(565) = lu(565) * lu(560)
         lu(566) = lu(566) * lu(560)
         lu(567) = lu(567) * lu(560)
         lu(568) = lu(568) * lu(560)
         lu(569) = lu(569) * lu(560)
         lu(579) = lu(579) - lu(561) * lu(578)
         lu(580) = lu(580) - lu(562) * lu(578)
         lu(581) = lu(581) - lu(563) * lu(578)
         lu(582) = lu(582) - lu(564) * lu(578)
         lu(583) = lu(583) - lu(565) * lu(578)
         lu(584) = lu(584) - lu(566) * lu(578)
         lu(585) = lu(585) - lu(567) * lu(578)
         lu(586) = lu(586) - lu(568) * lu(578)
         lu(587) = lu(587) - lu(569) * lu(578)
         lu(601) = lu(601) - lu(561) * lu(600)
         lu(602) = lu(602) - lu(562) * lu(600)
         lu(603) = lu(603) - lu(563) * lu(600)
         lu(604) = lu(604) - lu(564) * lu(600)
         lu(605) = lu(605) - lu(565) * lu(600)
         lu(606) = lu(606) - lu(566) * lu(600)
         lu(607) = lu(607) - lu(567) * lu(600)
         lu(608) = lu(608) - lu(568) * lu(600)
         lu(609) = lu(609) - lu(569) * lu(600)
         lu(637) = lu(637) - lu(561) * lu(636)
         lu(638) = lu(638) - lu(562) * lu(636)
         lu(639) = lu(639) - lu(563) * lu(636)
         lu(640) = lu(640) - lu(564) * lu(636)
         lu(641) = lu(641) - lu(565) * lu(636)
         lu(642) = lu(642) - lu(566) * lu(636)
         lu(643) = lu(643) - lu(567) * lu(636)
         lu(644) = lu(644) - lu(568) * lu(636)
         lu(645) = lu(645) - lu(569) * lu(636)
         lu(681) = lu(681) - lu(561) * lu(680)
         lu(682) = lu(682) - lu(562) * lu(680)
         lu(683) = lu(683) - lu(563) * lu(680)
         lu(684) = lu(684) - lu(564) * lu(680)
         lu(685) = lu(685) - lu(565) * lu(680)
         lu(686) = lu(686) - lu(566) * lu(680)
         lu(687) = lu(687) - lu(567) * lu(680)
         lu(688) = lu(688) - lu(568) * lu(680)
         lu(689) = lu(689) - lu(569) * lu(680)
         lu(696) = lu(696) - lu(561) * lu(695)
         lu(697) = lu(697) - lu(562) * lu(695)
         lu(698) = lu(698) - lu(563) * lu(695)
         lu(699) = lu(699) - lu(564) * lu(695)
         lu(700) = lu(700) - lu(565) * lu(695)
         lu(701) = lu(701) - lu(566) * lu(695)
         lu(702) = lu(702) - lu(567) * lu(695)
         lu(703) = lu(703) - lu(568) * lu(695)
         lu(704) = lu(704) - lu(569) * lu(695)
         lu(715) = lu(715) - lu(561) * lu(714)
         lu(716) = lu(716) - lu(562) * lu(714)
         lu(717) = lu(717) - lu(563) * lu(714)
         lu(718) = lu(718) - lu(564) * lu(714)
         lu(719) = lu(719) - lu(565) * lu(714)
         lu(720) = lu(720) - lu(566) * lu(714)
         lu(721) = lu(721) - lu(567) * lu(714)
         lu(722) = lu(722) - lu(568) * lu(714)
         lu(723) = lu(723) - lu(569) * lu(714)
         lu(732) = lu(732) - lu(561) * lu(731)
         lu(733) = lu(733) - lu(562) * lu(731)
         lu(734) = lu(734) - lu(563) * lu(731)
         lu(735) = lu(735) - lu(564) * lu(731)
         lu(736) = lu(736) - lu(565) * lu(731)
         lu(737) = lu(737) - lu(566) * lu(731)
         lu(738) = lu(738) - lu(567) * lu(731)
         lu(739) = lu(739) - lu(568) * lu(731)
         lu(740) = lu(740) - lu(569) * lu(731)
         lu(794) = lu(794) - lu(561) * lu(793)
         lu(795) = lu(795) - lu(562) * lu(793)
         lu(796) = lu(796) - lu(563) * lu(793)
         lu(797) = lu(797) - lu(564) * lu(793)
         lu(798) = lu(798) - lu(565) * lu(793)
         lu(799) = lu(799) - lu(566) * lu(793)
         lu(800) = lu(800) - lu(567) * lu(793)
         lu(801) = lu(801) - lu(568) * lu(793)
         lu(802) = lu(802) - lu(569) * lu(793)
         lu(821) = lu(821) - lu(561) * lu(820)
         lu(822) = lu(822) - lu(562) * lu(820)
         lu(823) = lu(823) - lu(563) * lu(820)
         lu(824) = lu(824) - lu(564) * lu(820)
         lu(825) = lu(825) - lu(565) * lu(820)
         lu(826) = lu(826) - lu(566) * lu(820)
         lu(827) = lu(827) - lu(567) * lu(820)
         lu(828) = lu(828) - lu(568) * lu(820)
         lu(829) = lu(829) - lu(569) * lu(820)
                                                                        
                                                                        
      end subroutine imp_lu_fac10
                                                                        
      subroutine imp_lu_fac11( lu )
                                                                        
      use CHEM_MODS_MOD, only : imp_nzcnt, clsze
                                                                        
      implicit none
                                                                        
!-----------------------------------------------------------------------
!       ... Dummy args
!-----------------------------------------------------------------------
      real, intent(inout) ::   lu(imp_nzcnt)
                                                                        
         lu(579) = 1. / lu(579)
         lu(580) = lu(580) * lu(579)
         lu(581) = lu(581) * lu(579)
         lu(582) = lu(582) * lu(579)
         lu(583) = lu(583) * lu(579)
         lu(584) = lu(584) * lu(579)
         lu(585) = lu(585) * lu(579)
         lu(586) = lu(586) * lu(579)
         lu(587) = lu(587) * lu(579)
         lu(602) = lu(602) - lu(580) * lu(601)
         lu(603) = lu(603) - lu(581) * lu(601)
         lu(604) = lu(604) - lu(582) * lu(601)
         lu(605) = lu(605) - lu(583) * lu(601)
         lu(606) = lu(606) - lu(584) * lu(601)
         lu(607) = lu(607) - lu(585) * lu(601)
         lu(608) = lu(608) - lu(586) * lu(601)
         lu(609) = lu(609) - lu(587) * lu(601)
         lu(638) = lu(638) - lu(580) * lu(637)
         lu(639) = lu(639) - lu(581) * lu(637)
         lu(640) = lu(640) - lu(582) * lu(637)
         lu(641) = lu(641) - lu(583) * lu(637)
         lu(642) = lu(642) - lu(584) * lu(637)
         lu(643) = lu(643) - lu(585) * lu(637)
         lu(644) = lu(644) - lu(586) * lu(637)
         lu(645) = lu(645) - lu(587) * lu(637)
         lu(682) = lu(682) - lu(580) * lu(681)
         lu(683) = lu(683) - lu(581) * lu(681)
         lu(684) = lu(684) - lu(582) * lu(681)
         lu(685) = lu(685) - lu(583) * lu(681)
         lu(686) = lu(686) - lu(584) * lu(681)
         lu(687) = lu(687) - lu(585) * lu(681)
         lu(688) = lu(688) - lu(586) * lu(681)
         lu(689) = lu(689) - lu(587) * lu(681)
         lu(697) = lu(697) - lu(580) * lu(696)
         lu(698) = lu(698) - lu(581) * lu(696)
         lu(699) = lu(699) - lu(582) * lu(696)
         lu(700) = lu(700) - lu(583) * lu(696)
         lu(701) = lu(701) - lu(584) * lu(696)
         lu(702) = lu(702) - lu(585) * lu(696)
         lu(703) = lu(703) - lu(586) * lu(696)
         lu(704) = lu(704) - lu(587) * lu(696)
         lu(716) = lu(716) - lu(580) * lu(715)
         lu(717) = lu(717) - lu(581) * lu(715)
         lu(718) = lu(718) - lu(582) * lu(715)
         lu(719) = lu(719) - lu(583) * lu(715)
         lu(720) = lu(720) - lu(584) * lu(715)
         lu(721) = lu(721) - lu(585) * lu(715)
         lu(722) = lu(722) - lu(586) * lu(715)
         lu(723) = lu(723) - lu(587) * lu(715)
         lu(733) = lu(733) - lu(580) * lu(732)
         lu(734) = lu(734) - lu(581) * lu(732)
         lu(735) = lu(735) - lu(582) * lu(732)
         lu(736) = lu(736) - lu(583) * lu(732)
         lu(737) = lu(737) - lu(584) * lu(732)
         lu(738) = lu(738) - lu(585) * lu(732)
         lu(739) = lu(739) - lu(586) * lu(732)
         lu(740) = lu(740) - lu(587) * lu(732)
         lu(795) = lu(795) - lu(580) * lu(794)
         lu(796) = lu(796) - lu(581) * lu(794)
         lu(797) = lu(797) - lu(582) * lu(794)
         lu(798) = lu(798) - lu(583) * lu(794)
         lu(799) = lu(799) - lu(584) * lu(794)
         lu(800) = lu(800) - lu(585) * lu(794)
         lu(801) = lu(801) - lu(586) * lu(794)
         lu(802) = lu(802) - lu(587) * lu(794)
         lu(822) = lu(822) - lu(580) * lu(821)
         lu(823) = lu(823) - lu(581) * lu(821)
         lu(824) = lu(824) - lu(582) * lu(821)
         lu(825) = lu(825) - lu(583) * lu(821)
         lu(826) = lu(826) - lu(584) * lu(821)
         lu(827) = lu(827) - lu(585) * lu(821)
         lu(828) = lu(828) - lu(586) * lu(821)
         lu(829) = lu(829) - lu(587) * lu(821)
                                                                        
         lu(602) = 1. / lu(602)
         lu(603) = lu(603) * lu(602)
         lu(604) = lu(604) * lu(602)
         lu(605) = lu(605) * lu(602)
         lu(606) = lu(606) * lu(602)
         lu(607) = lu(607) * lu(602)
         lu(608) = lu(608) * lu(602)
         lu(609) = lu(609) * lu(602)
         lu(639) = lu(639) - lu(603) * lu(638)
         lu(640) = lu(640) - lu(604) * lu(638)
         lu(641) = lu(641) - lu(605) * lu(638)
         lu(642) = lu(642) - lu(606) * lu(638)
         lu(643) = lu(643) - lu(607) * lu(638)
         lu(644) = lu(644) - lu(608) * lu(638)
         lu(645) = lu(645) - lu(609) * lu(638)
         lu(683) = lu(683) - lu(603) * lu(682)
         lu(684) = lu(684) - lu(604) * lu(682)
         lu(685) = lu(685) - lu(605) * lu(682)
         lu(686) = lu(686) - lu(606) * lu(682)
         lu(687) = lu(687) - lu(607) * lu(682)
         lu(688) = lu(688) - lu(608) * lu(682)
         lu(689) = lu(689) - lu(609) * lu(682)
         lu(698) = lu(698) - lu(603) * lu(697)
         lu(699) = lu(699) - lu(604) * lu(697)
         lu(700) = lu(700) - lu(605) * lu(697)
         lu(701) = lu(701) - lu(606) * lu(697)
         lu(702) = lu(702) - lu(607) * lu(697)
         lu(703) = lu(703) - lu(608) * lu(697)
         lu(704) = lu(704) - lu(609) * lu(697)
         lu(717) = lu(717) - lu(603) * lu(716)
         lu(718) = lu(718) - lu(604) * lu(716)
         lu(719) = lu(719) - lu(605) * lu(716)
         lu(720) = lu(720) - lu(606) * lu(716)
         lu(721) = lu(721) - lu(607) * lu(716)
         lu(722) = lu(722) - lu(608) * lu(716)
         lu(723) = lu(723) - lu(609) * lu(716)
         lu(734) = lu(734) - lu(603) * lu(733)
         lu(735) = lu(735) - lu(604) * lu(733)
         lu(736) = lu(736) - lu(605) * lu(733)
         lu(737) = lu(737) - lu(606) * lu(733)
         lu(738) = lu(738) - lu(607) * lu(733)
         lu(739) = lu(739) - lu(608) * lu(733)
         lu(740) = lu(740) - lu(609) * lu(733)
         lu(796) = lu(796) - lu(603) * lu(795)
         lu(797) = lu(797) - lu(604) * lu(795)
         lu(798) = lu(798) - lu(605) * lu(795)
         lu(799) = lu(799) - lu(606) * lu(795)
         lu(800) = lu(800) - lu(607) * lu(795)
         lu(801) = lu(801) - lu(608) * lu(795)
         lu(802) = lu(802) - lu(609) * lu(795)
         lu(823) = lu(823) - lu(603) * lu(822)
         lu(824) = lu(824) - lu(604) * lu(822)
         lu(825) = lu(825) - lu(605) * lu(822)
         lu(826) = lu(826) - lu(606) * lu(822)
         lu(827) = lu(827) - lu(607) * lu(822)
         lu(828) = lu(828) - lu(608) * lu(822)
         lu(829) = lu(829) - lu(609) * lu(822)
                                                                        
         lu(639) = 1. / lu(639)
         lu(640) = lu(640) * lu(639)
         lu(641) = lu(641) * lu(639)
         lu(642) = lu(642) * lu(639)
         lu(643) = lu(643) * lu(639)
         lu(644) = lu(644) * lu(639)
         lu(645) = lu(645) * lu(639)
         lu(684) = lu(684) - lu(640) * lu(683)
         lu(685) = lu(685) - lu(641) * lu(683)
         lu(686) = lu(686) - lu(642) * lu(683)
         lu(687) = lu(687) - lu(643) * lu(683)
         lu(688) = lu(688) - lu(644) * lu(683)
         lu(689) = lu(689) - lu(645) * lu(683)
         lu(699) = lu(699) - lu(640) * lu(698)
         lu(700) = lu(700) - lu(641) * lu(698)
         lu(701) = lu(701) - lu(642) * lu(698)
         lu(702) = lu(702) - lu(643) * lu(698)
         lu(703) = lu(703) - lu(644) * lu(698)
         lu(704) = lu(704) - lu(645) * lu(698)
         lu(718) = lu(718) - lu(640) * lu(717)
         lu(719) = lu(719) - lu(641) * lu(717)
         lu(720) = lu(720) - lu(642) * lu(717)
         lu(721) = lu(721) - lu(643) * lu(717)
         lu(722) = lu(722) - lu(644) * lu(717)
         lu(723) = lu(723) - lu(645) * lu(717)
         lu(735) = lu(735) - lu(640) * lu(734)
         lu(736) = lu(736) - lu(641) * lu(734)
         lu(737) = lu(737) - lu(642) * lu(734)
         lu(738) = lu(738) - lu(643) * lu(734)
         lu(739) = lu(739) - lu(644) * lu(734)
         lu(740) = lu(740) - lu(645) * lu(734)
         lu(797) = lu(797) - lu(640) * lu(796)
         lu(798) = lu(798) - lu(641) * lu(796)
         lu(799) = lu(799) - lu(642) * lu(796)
         lu(800) = lu(800) - lu(643) * lu(796)
         lu(801) = lu(801) - lu(644) * lu(796)
         lu(802) = lu(802) - lu(645) * lu(796)
         lu(824) = lu(824) - lu(640) * lu(823)
         lu(825) = lu(825) - lu(641) * lu(823)
         lu(826) = lu(826) - lu(642) * lu(823)
         lu(827) = lu(827) - lu(643) * lu(823)
         lu(828) = lu(828) - lu(644) * lu(823)
         lu(829) = lu(829) - lu(645) * lu(823)
                                                                        
         lu(684) = 1. / lu(684)
         lu(685) = lu(685) * lu(684)
         lu(686) = lu(686) * lu(684)
         lu(687) = lu(687) * lu(684)
         lu(688) = lu(688) * lu(684)
         lu(689) = lu(689) * lu(684)
         lu(700) = lu(700) - lu(685) * lu(699)
         lu(701) = lu(701) - lu(686) * lu(699)
         lu(702) = lu(702) - lu(687) * lu(699)
         lu(703) = lu(703) - lu(688) * lu(699)
         lu(704) = lu(704) - lu(689) * lu(699)
         lu(719) = lu(719) - lu(685) * lu(718)
         lu(720) = lu(720) - lu(686) * lu(718)
         lu(721) = lu(721) - lu(687) * lu(718)
         lu(722) = lu(722) - lu(688) * lu(718)
         lu(723) = lu(723) - lu(689) * lu(718)
         lu(736) = lu(736) - lu(685) * lu(735)
         lu(737) = lu(737) - lu(686) * lu(735)
         lu(738) = lu(738) - lu(687) * lu(735)
         lu(739) = lu(739) - lu(688) * lu(735)
         lu(740) = lu(740) - lu(689) * lu(735)
         lu(798) = lu(798) - lu(685) * lu(797)
         lu(799) = lu(799) - lu(686) * lu(797)
         lu(800) = lu(800) - lu(687) * lu(797)
         lu(801) = lu(801) - lu(688) * lu(797)
         lu(802) = lu(802) - lu(689) * lu(797)
         lu(825) = lu(825) - lu(685) * lu(824)
         lu(826) = lu(826) - lu(686) * lu(824)
         lu(827) = lu(827) - lu(687) * lu(824)
         lu(828) = lu(828) - lu(688) * lu(824)
         lu(829) = lu(829) - lu(689) * lu(824)
                                                                        
         lu(700) = 1. / lu(700)
         lu(701) = lu(701) * lu(700)
         lu(702) = lu(702) * lu(700)
         lu(703) = lu(703) * lu(700)
         lu(704) = lu(704) * lu(700)
         lu(720) = lu(720) - lu(701) * lu(719)
         lu(721) = lu(721) - lu(702) * lu(719)
         lu(722) = lu(722) - lu(703) * lu(719)
         lu(723) = lu(723) - lu(704) * lu(719)
         lu(737) = lu(737) - lu(701) * lu(736)
         lu(738) = lu(738) - lu(702) * lu(736)
         lu(739) = lu(739) - lu(703) * lu(736)
         lu(740) = lu(740) - lu(704) * lu(736)
         lu(799) = lu(799) - lu(701) * lu(798)
         lu(800) = lu(800) - lu(702) * lu(798)
         lu(801) = lu(801) - lu(703) * lu(798)
         lu(802) = lu(802) - lu(704) * lu(798)
         lu(826) = lu(826) - lu(701) * lu(825)
         lu(827) = lu(827) - lu(702) * lu(825)
         lu(828) = lu(828) - lu(703) * lu(825)
         lu(829) = lu(829) - lu(704) * lu(825)
                                                                        
         lu(720) = 1. / lu(720)
         lu(721) = lu(721) * lu(720)
         lu(722) = lu(722) * lu(720)
         lu(723) = lu(723) * lu(720)
         lu(738) = lu(738) - lu(721) * lu(737)
         lu(739) = lu(739) - lu(722) * lu(737)
         lu(740) = lu(740) - lu(723) * lu(737)
         lu(800) = lu(800) - lu(721) * lu(799)
         lu(801) = lu(801) - lu(722) * lu(799)
         lu(802) = lu(802) - lu(723) * lu(799)
         lu(827) = lu(827) - lu(721) * lu(826)
         lu(828) = lu(828) - lu(722) * lu(826)
         lu(829) = lu(829) - lu(723) * lu(826)
                                                                        
         lu(738) = 1. / lu(738)
         lu(739) = lu(739) * lu(738)
         lu(740) = lu(740) * lu(738)
         lu(801) = lu(801) - lu(739) * lu(800)
         lu(802) = lu(802) - lu(740) * lu(800)
         lu(828) = lu(828) - lu(739) * lu(827)
         lu(829) = lu(829) - lu(740) * lu(827)
                                                                        
         lu(801) = 1. / lu(801)
         lu(802) = lu(802) * lu(801)
         lu(829) = lu(829) - lu(802) * lu(828)
                                                                        
         lu(829) = 1. / lu(829)
                                                                        
                                                                        
      end subroutine imp_lu_fac11
                                                                        
      subroutine imp_lu_fac( lu )
                                                                        
      use CHEM_MODS_MOD, only : imp_nzcnt, clsze
                                                                        
      implicit none
                                                                        
!-----------------------------------------------------------------------
!       ... Dummy args
!-----------------------------------------------------------------------
      real, intent(inout) ::   lu(imp_nzcnt)
                                                                        
      call imp_lu_fac01( lu )
      call imp_lu_fac02( lu )
      call imp_lu_fac03( lu )
      call imp_lu_fac04( lu )
      call imp_lu_fac05( lu )
      call imp_lu_fac06( lu )
      call imp_lu_fac07( lu )
      call imp_lu_fac08( lu )
      call imp_lu_fac09( lu )
      call imp_lu_fac10( lu )
      call imp_lu_fac11( lu )
                                                                        
      end subroutine imp_lu_fac
                                                                        
      end module MO_IMP_FACTOR_MOD

      module MO_ROD_FACTOR_MOD

      contains
                                                                        
      subroutine rod_lu_fac( lu )
                                                                        
      use CHEM_MODS_MOD, only : rod_nzcnt, clsze
                                                                        
      implicit none
                                                                        
!-----------------------------------------------------------------------
!       ... Dummy args
!-----------------------------------------------------------------------
      real, intent(inout) ::   lu(rod_nzcnt)
                                                                        
                                                                        
      end subroutine rod_lu_fac
                                                                        
      end module MO_ROD_FACTOR_MOD

      module MO_IMP_SOLVE_MOD

      contains
                                                                        
      subroutine imp_lu_slv01( lu, b )
                                                                        
      use CHEM_MODS_MOD, only : imp_nzcnt, clsze, clscnt4
                                                                        
      implicit none
                                                                        
!-----------------------------------------------------------------------
!       ... Dummy args
!-----------------------------------------------------------------------
      real, intent(in)    ::   lu(imp_nzcnt)
      real, intent(inout) ::   b(clscnt4)
                                                                        
!-----------------------------------------------------------------------
!       ... Local variables
!-----------------------------------------------------------------------
                                                                        
!-----------------------------------------------------------------------
!       ... Solve L * y = b
!-----------------------------------------------------------------------
                                                                        
                                                                        
                                                                        
                                                                        
         b(75) = b(75) - lu(7) * b(5)
                                                                        
         b(45) = b(45) - lu(9) * b(6)
         b(75) = b(75) - lu(10) * b(6)
                                                                        
         b(57) = b(57) - lu(12) * b(7)
         b(66) = b(66) - lu(13) * b(7)
                                                                        
         b(75) = b(75) - lu(16) * b(8)
                                                                        
         b(57) = b(57) - lu(18) * b(9)
                                                                        
         b(71) = b(71) - lu(20) * b(10)
         b(75) = b(75) - lu(21) * b(10)
                                                                        
         b(42) = b(42) - lu(23) * b(11)
         b(71) = b(71) - lu(24) * b(11)
         b(74) = b(74) - lu(25) * b(11)
                                                                        
         b(59) = b(59) - lu(27) * b(12)
         b(75) = b(75) - lu(28) * b(12)
                                                                        
         b(65) = b(65) - lu(31) * b(13)
         b(75) = b(75) - lu(32) * b(13)
         b(76) = b(76) - lu(33) * b(13)
                                                                        
         b(68) = b(68) - lu(35) * b(14)
         b(70) = b(70) - lu(36) * b(14)
         b(76) = b(76) - lu(37) * b(14)
                                                                        
         b(27) = b(27) - lu(39) * b(15)
         b(64) = b(64) - lu(40) * b(15)
         b(68) = b(68) - lu(41) * b(15)
         b(70) = b(70) - lu(42) * b(15)
         b(71) = b(71) - lu(43) * b(15)
         b(74) = b(74) - lu(44) * b(15)
         b(75) = b(75) - lu(45) * b(15)
                                                                        
         b(39) = b(39) - lu(47) * b(16)
         b(49) = b(49) - lu(48) * b(16)
         b(65) = b(65) - lu(49) * b(16)
         b(72) = b(72) - lu(50) * b(16)
                                                                        
         b(54) = b(54) - lu(52) * b(17)
         b(75) = b(75) - lu(53) * b(17)
         b(76) = b(76) - lu(54) * b(17)
                                                                        
         b(51) = b(51) - lu(56) * b(18)
         b(71) = b(71) - lu(57) * b(18)
         b(75) = b(75) - lu(58) * b(18)
                                                                        
         b(71) = b(71) - lu(60) * b(19)
         b(75) = b(75) - lu(61) * b(19)
         b(76) = b(76) - lu(62) * b(19)
                                                                        
         b(28) = b(28) - lu(64) * b(20)
         b(67) = b(67) - lu(65) * b(20)
         b(71) = b(71) - lu(66) * b(20)
         b(74) = b(74) - lu(67) * b(20)
         b(75) = b(75) - lu(68) * b(20)
                                                                        
         b(61) = b(61) - lu(70) * b(21)
         b(63) = b(63) - lu(71) * b(21)
         b(71) = b(71) - lu(72) * b(21)
         b(75) = b(75) - lu(73) * b(21)
                                                                        
         b(40) = b(40) - lu(75) * b(22)
         b(51) = b(51) - lu(76) * b(22)
         b(71) = b(71) - lu(77) * b(22)
         b(75) = b(75) - lu(78) * b(22)
                                                                        
         b(37) = b(37) - lu(80) * b(23)
         b(45) = b(45) - lu(81) * b(23)
         b(71) = b(71) - lu(82) * b(23)
         b(75) = b(75) - lu(83) * b(23)
                                                                        
         b(44) = b(44) - lu(85) * b(24)
         b(62) = b(62) - lu(86) * b(24)
         b(74) = b(74) - lu(87) * b(24)
         b(75) = b(75) - lu(88) * b(24)
                                                                        
         b(64) = b(64) - lu(90) * b(25)
         b(71) = b(71) - lu(91) * b(25)
         b(74) = b(74) - lu(92) * b(25)
         b(75) = b(75) - lu(93) * b(25)
                                                                        
         b(57) = b(57) - lu(95) * b(26)
         b(72) = b(72) - lu(96) * b(26)
                                                                        
         b(67) = b(67) - lu(98) * b(27)
         b(71) = b(71) - lu(99) * b(27)
         b(75) = b(75) - lu(100) * b(27)
                                                                        
         b(42) = b(42) - lu(103) * b(28)
         b(70) = b(70) - lu(104) * b(28)
         b(71) = b(71) - lu(105) * b(28)
         b(74) = b(74) - lu(106) * b(28)
         b(76) = b(76) - lu(107) * b(28)
                                                                        
         b(39) = b(39) - lu(109) * b(29)
         b(57) = b(57) - lu(110) * b(29)
         b(65) = b(65) - lu(111) * b(29)
         b(69) = b(69) - lu(112) * b(29)
         b(76) = b(76) - lu(113) * b(29)
                                                                        
         b(62) = b(62) - lu(115) * b(30)
         b(64) = b(64) - lu(116) * b(30)
         b(74) = b(74) - lu(117) * b(30)
         b(75) = b(75) - lu(118) * b(30)
                                                                        
         b(59) = b(59) - lu(120) * b(31)
         b(75) = b(75) - lu(121) * b(31)
                                                                        
         b(41) = b(41) - lu(123) * b(32)
         b(51) = b(51) - lu(124) * b(32)
         b(55) = b(55) - lu(125) * b(32)
         b(71) = b(71) - lu(126) * b(32)
         b(74) = b(74) - lu(127) * b(32)
         b(75) = b(75) - lu(128) * b(32)
                                                                        
         b(62) = b(62) - lu(130) * b(33)
         b(64) = b(64) - lu(131) * b(33)
         b(65) = b(65) - lu(132) * b(33)
         b(74) = b(74) - lu(133) * b(33)
         b(75) = b(75) - lu(134) * b(33)
         b(76) = b(76) - lu(135) * b(33)
                                                                        
         b(71) = b(71) - lu(137) * b(34)
         b(74) = b(74) - lu(138) * b(34)
         b(75) = b(75) - lu(139) * b(34)
                                                                        
         b(55) = b(55) - lu(141) * b(35)
         b(63) = b(63) - lu(142) * b(35)
         b(65) = b(65) - lu(143) * b(35)
         b(71) = b(71) - lu(144) * b(35)
         b(74) = b(74) - lu(145) * b(35)
         b(75) = b(75) - lu(146) * b(35)
         b(76) = b(76) - lu(147) * b(35)
                                                                        
         b(56) = b(56) - lu(149) * b(36)
         b(58) = b(58) - lu(150) * b(36)
         b(59) = b(59) - lu(151) * b(36)
         b(60) = b(60) - lu(152) * b(36)
         b(71) = b(71) - lu(153) * b(36)
         b(74) = b(74) - lu(154) * b(36)
         b(75) = b(75) - lu(155) * b(36)
                                                                        
         b(44) = b(44) - lu(157) * b(37)
         b(62) = b(62) - lu(158) * b(37)
         b(64) = b(64) - lu(159) * b(37)
         b(75) = b(75) - lu(160) * b(37)
                                                                        
         b(53) = b(53) - lu(164) * b(38)
         b(57) = b(57) - lu(165) * b(38)
         b(69) = b(69) - lu(166) * b(38)
         b(72) = b(72) - lu(167) * b(38)
         b(75) = b(75) - lu(168) * b(38)
                                                                        
         b(65) = b(65) - lu(170) * b(39)
         b(75) = b(75) - lu(171) * b(39)
         b(76) = b(76) - lu(172) * b(39)
                                                                        
         b(51) = b(51) - lu(177) * b(40)
         b(64) = b(64) - lu(178) * b(40)
         b(70) = b(70) - lu(179) * b(40)
         b(71) = b(71) - lu(180) * b(40)
         b(74) = b(74) - lu(181) * b(40)
         b(75) = b(75) - lu(182) * b(40)
         b(76) = b(76) - lu(183) * b(40)
                                                                        
         b(51) = b(51) - lu(186) * b(41)
         b(55) = b(55) - lu(187) * b(41)
         b(70) = b(70) - lu(188) * b(41)
         b(71) = b(71) - lu(189) * b(41)
         b(74) = b(74) - lu(190) * b(41)
         b(75) = b(75) - lu(191) * b(41)
         b(76) = b(76) - lu(192) * b(41)
                                                                        
         b(63) = b(63) - lu(194) * b(42)
         b(71) = b(71) - lu(195) * b(42)
         b(74) = b(74) - lu(196) * b(42)
         b(75) = b(75) - lu(197) * b(42)
                                                                        
         b(52) = b(52) - lu(199) * b(43)
         b(56) = b(56) - lu(200) * b(43)
         b(58) = b(58) - lu(201) * b(43)
         b(65) = b(65) - lu(202) * b(43)
         b(70) = b(70) - lu(203) * b(43)
         b(71) = b(71) - lu(204) * b(43)
         b(74) = b(74) - lu(205) * b(43)
         b(76) = b(76) - lu(206) * b(43)
                                                                        
         b(62) = b(62) - lu(209) * b(44)
         b(70) = b(70) - lu(210) * b(44)
         b(71) = b(71) - lu(211) * b(44)
         b(74) = b(74) - lu(212) * b(44)
         b(75) = b(75) - lu(213) * b(44)
         b(76) = b(76) - lu(214) * b(44)
                                                                        
         b(51) = b(51) - lu(219) * b(45)
         b(62) = b(62) - lu(220) * b(45)
         b(64) = b(64) - lu(221) * b(45)
         b(70) = b(70) - lu(222) * b(45)
         b(71) = b(71) - lu(223) * b(45)
         b(74) = b(74) - lu(224) * b(45)
         b(75) = b(75) - lu(225) * b(45)
         b(76) = b(76) - lu(226) * b(45)
                                                                        
         b(53) = b(53) - lu(231) * b(46)
         b(57) = b(57) - lu(232) * b(46)
         b(65) = b(65) - lu(233) * b(46)
         b(66) = b(66) - lu(234) * b(46)
         b(68) = b(68) - lu(235) * b(46)
         b(69) = b(69) - lu(236) * b(46)
         b(72) = b(72) - lu(237) * b(46)
         b(75) = b(75) - lu(238) * b(46)
         b(76) = b(76) - lu(239) * b(46)
                                                                        
         b(50) = b(50) - lu(242) * b(47)
         b(52) = b(52) - lu(243) * b(47)
         b(56) = b(56) - lu(244) * b(47)
         b(58) = b(58) - lu(245) * b(47)
         b(60) = b(60) - lu(246) * b(47)
         b(63) = b(63) - lu(247) * b(47)
         b(65) = b(65) - lu(248) * b(47)
         b(67) = b(67) - lu(249) * b(47)
         b(70) = b(70) - lu(250) * b(47)
         b(71) = b(71) - lu(251) * b(47)
         b(74) = b(74) - lu(252) * b(47)
         b(75) = b(75) - lu(253) * b(47)
         b(76) = b(76) - lu(254) * b(47)
                                                                        
         b(50) = b(50) - lu(258) * b(48)
         b(56) = b(56) - lu(259) * b(48)
         b(58) = b(58) - lu(260) * b(48)
         b(60) = b(60) - lu(261) * b(48)
         b(62) = b(62) - lu(262) * b(48)
         b(64) = b(64) - lu(263) * b(48)
         b(65) = b(65) - lu(264) * b(48)
         b(67) = b(67) - lu(265) * b(48)
         b(68) = b(68) - lu(266) * b(48)
         b(70) = b(70) - lu(267) * b(48)
         b(71) = b(71) - lu(268) * b(48)
         b(74) = b(74) - lu(269) * b(48)
         b(75) = b(75) - lu(270) * b(48)
         b(76) = b(76) - lu(271) * b(48)
                                                                        
                                                                        
      end subroutine imp_lu_slv01
                                                                        
      subroutine imp_lu_slv02( lu, b )
                                                                        
      use CHEM_MODS_MOD, only : imp_nzcnt, clsze, clscnt4
                                                                        
      implicit none
                                                                        
!-----------------------------------------------------------------------
!       ... Dummy args
!-----------------------------------------------------------------------
      real, intent(in)    ::   lu(imp_nzcnt)
      real, intent(inout) ::   b(clscnt4)
                                                                        
!-----------------------------------------------------------------------
!       ... Local variables
!-----------------------------------------------------------------------
                                                                        
!-----------------------------------------------------------------------
!       ... Solve L * y = b
!-----------------------------------------------------------------------
         b(53) = b(53) - lu(274) * b(49)
         b(57) = b(57) - lu(275) * b(49)
         b(68) = b(68) - lu(276) * b(49)
         b(69) = b(69) - lu(277) * b(49)
         b(72) = b(72) - lu(278) * b(49)
         b(73) = b(73) - lu(279) * b(49)
         b(75) = b(75) - lu(280) * b(49)
                                                                        
         b(51) = b(51) - lu(284) * b(50)
         b(54) = b(54) - lu(285) * b(50)
         b(55) = b(55) - lu(286) * b(50)
         b(64) = b(64) - lu(287) * b(50)
         b(65) = b(65) - lu(288) * b(50)
         b(67) = b(67) - lu(289) * b(50)
         b(70) = b(70) - lu(290) * b(50)
         b(71) = b(71) - lu(291) * b(50)
         b(74) = b(74) - lu(292) * b(50)
         b(75) = b(75) - lu(293) * b(50)
         b(76) = b(76) - lu(294) * b(50)
                                                                        
         b(62) = b(62) - lu(297) * b(51)
         b(64) = b(64) - lu(298) * b(51)
         b(65) = b(65) - lu(299) * b(51)
         b(71) = b(71) - lu(300) * b(51)
         b(75) = b(75) - lu(301) * b(51)
         b(76) = b(76) - lu(302) * b(51)
                                                                        
         b(59) = b(59) - lu(305) * b(52)
         b(65) = b(65) - lu(306) * b(52)
         b(67) = b(67) - lu(307) * b(52)
         b(71) = b(71) - lu(308) * b(52)
         b(74) = b(74) - lu(309) * b(52)
         b(75) = b(75) - lu(310) * b(52)
         b(76) = b(76) - lu(311) * b(52)
                                                                        
         b(57) = b(57) - lu(316) * b(53)
         b(68) = b(68) - lu(317) * b(53)
         b(69) = b(69) - lu(318) * b(53)
         b(72) = b(72) - lu(319) * b(53)
         b(73) = b(73) - lu(320) * b(53)
         b(75) = b(75) - lu(321) * b(53)
                                                                        
         b(62) = b(62) - lu(324) * b(54)
         b(65) = b(65) - lu(325) * b(54)
         b(71) = b(71) - lu(326) * b(54)
         b(75) = b(75) - lu(327) * b(54)
         b(76) = b(76) - lu(328) * b(54)
                                                                        
         b(62) = b(62) - lu(331) * b(55)
         b(65) = b(65) - lu(332) * b(55)
         b(71) = b(71) - lu(333) * b(55)
         b(74) = b(74) - lu(334) * b(55)
         b(75) = b(75) - lu(335) * b(55)
         b(76) = b(76) - lu(336) * b(55)
                                                                        
         b(61) = b(61) - lu(339) * b(56)
         b(62) = b(62) - lu(340) * b(56)
         b(63) = b(63) - lu(341) * b(56)
         b(65) = b(65) - lu(342) * b(56)
         b(67) = b(67) - lu(343) * b(56)
         b(71) = b(71) - lu(344) * b(56)
         b(74) = b(74) - lu(345) * b(56)
         b(75) = b(75) - lu(346) * b(56)
         b(76) = b(76) - lu(347) * b(56)
                                                                        
         b(64) = b(64) - lu(349) * b(57)
         b(66) = b(66) - lu(350) * b(57)
         b(67) = b(67) - lu(351) * b(57)
         b(69) = b(69) - lu(352) * b(57)
         b(71) = b(71) - lu(353) * b(57)
         b(74) = b(74) - lu(354) * b(57)
                                                                        
         b(61) = b(61) - lu(360) * b(58)
         b(62) = b(62) - lu(361) * b(58)
         b(64) = b(64) - lu(362) * b(58)
         b(65) = b(65) - lu(363) * b(58)
         b(67) = b(67) - lu(364) * b(58)
         b(70) = b(70) - lu(365) * b(58)
         b(71) = b(71) - lu(366) * b(58)
         b(74) = b(74) - lu(367) * b(58)
         b(75) = b(75) - lu(368) * b(58)
         b(76) = b(76) - lu(369) * b(58)
                                                                        
         b(62) = b(62) - lu(376) * b(59)
         b(63) = b(63) - lu(377) * b(59)
         b(64) = b(64) - lu(378) * b(59)
         b(65) = b(65) - lu(379) * b(59)
         b(70) = b(70) - lu(380) * b(59)
         b(71) = b(71) - lu(381) * b(59)
         b(74) = b(74) - lu(382) * b(59)
         b(75) = b(75) - lu(383) * b(59)
         b(76) = b(76) - lu(384) * b(59)
                                                                        
         b(61) = b(61) - lu(393) * b(60)
         b(62) = b(62) - lu(394) * b(60)
         b(63) = b(63) - lu(395) * b(60)
         b(64) = b(64) - lu(396) * b(60)
         b(65) = b(65) - lu(397) * b(60)
         b(67) = b(67) - lu(398) * b(60)
         b(70) = b(70) - lu(399) * b(60)
         b(71) = b(71) - lu(400) * b(60)
         b(74) = b(74) - lu(401) * b(60)
         b(75) = b(75) - lu(402) * b(60)
         b(76) = b(76) - lu(403) * b(60)
                                                                        
         b(62) = b(62) - lu(412) * b(61)
         b(63) = b(63) - lu(413) * b(61)
         b(64) = b(64) - lu(414) * b(61)
         b(65) = b(65) - lu(415) * b(61)
         b(67) = b(67) - lu(416) * b(61)
         b(70) = b(70) - lu(417) * b(61)
         b(71) = b(71) - lu(418) * b(61)
         b(74) = b(74) - lu(419) * b(61)
         b(75) = b(75) - lu(420) * b(61)
         b(76) = b(76) - lu(421) * b(61)
                                                                        
         b(63) = b(63) - lu(434) * b(62)
         b(64) = b(64) - lu(435) * b(62)
         b(65) = b(65) - lu(436) * b(62)
         b(67) = b(67) - lu(437) * b(62)
         b(70) = b(70) - lu(438) * b(62)
         b(71) = b(71) - lu(439) * b(62)
         b(74) = b(74) - lu(440) * b(62)
         b(75) = b(75) - lu(441) * b(62)
         b(76) = b(76) - lu(442) * b(62)
                                                                        
         b(64) = b(64) - lu(448) * b(63)
         b(65) = b(65) - lu(449) * b(63)
         b(67) = b(67) - lu(450) * b(63)
         b(70) = b(70) - lu(451) * b(63)
         b(71) = b(71) - lu(452) * b(63)
         b(74) = b(74) - lu(453) * b(63)
         b(75) = b(75) - lu(454) * b(63)
         b(76) = b(76) - lu(455) * b(63)
                                                                        
         b(65) = b(65) - lu(476) * b(64)
         b(67) = b(67) - lu(477) * b(64)
         b(70) = b(70) - lu(478) * b(64)
         b(71) = b(71) - lu(479) * b(64)
         b(74) = b(74) - lu(480) * b(64)
         b(75) = b(75) - lu(481) * b(64)
         b(76) = b(76) - lu(482) * b(64)
                                                                        
         b(66) = b(66) - lu(508) * b(65)
         b(67) = b(67) - lu(509) * b(65)
         b(68) = b(68) - lu(510) * b(65)
         b(69) = b(69) - lu(511) * b(65)
         b(70) = b(70) - lu(512) * b(65)
         b(71) = b(71) - lu(513) * b(65)
         b(74) = b(74) - lu(514) * b(65)
         b(75) = b(75) - lu(515) * b(65)
         b(76) = b(76) - lu(516) * b(65)
                                                                        
         b(67) = b(67) - lu(526) * b(66)
         b(68) = b(68) - lu(527) * b(66)
         b(69) = b(69) - lu(528) * b(66)
         b(70) = b(70) - lu(529) * b(66)
         b(71) = b(71) - lu(530) * b(66)
         b(72) = b(72) - lu(531) * b(66)
         b(73) = b(73) - lu(532) * b(66)
         b(74) = b(74) - lu(533) * b(66)
         b(75) = b(75) - lu(534) * b(66)
         b(76) = b(76) - lu(535) * b(66)
                                                                        
         b(68) = b(68) - lu(561) * b(67)
         b(69) = b(69) - lu(562) * b(67)
         b(70) = b(70) - lu(563) * b(67)
         b(71) = b(71) - lu(564) * b(67)
         b(72) = b(72) - lu(565) * b(67)
         b(73) = b(73) - lu(566) * b(67)
         b(74) = b(74) - lu(567) * b(67)
         b(75) = b(75) - lu(568) * b(67)
         b(76) = b(76) - lu(569) * b(67)
                                                                        
         b(69) = b(69) - lu(580) * b(68)
         b(70) = b(70) - lu(581) * b(68)
         b(71) = b(71) - lu(582) * b(68)
         b(72) = b(72) - lu(583) * b(68)
         b(73) = b(73) - lu(584) * b(68)
         b(74) = b(74) - lu(585) * b(68)
         b(75) = b(75) - lu(586) * b(68)
         b(76) = b(76) - lu(587) * b(68)
                                                                        
         b(70) = b(70) - lu(603) * b(69)
         b(71) = b(71) - lu(604) * b(69)
         b(72) = b(72) - lu(605) * b(69)
         b(73) = b(73) - lu(606) * b(69)
         b(74) = b(74) - lu(607) * b(69)
         b(75) = b(75) - lu(608) * b(69)
         b(76) = b(76) - lu(609) * b(69)
                                                                        
         b(71) = b(71) - lu(640) * b(70)
         b(72) = b(72) - lu(641) * b(70)
         b(73) = b(73) - lu(642) * b(70)
         b(74) = b(74) - lu(643) * b(70)
         b(75) = b(75) - lu(644) * b(70)
         b(76) = b(76) - lu(645) * b(70)
                                                                        
         b(72) = b(72) - lu(685) * b(71)
         b(73) = b(73) - lu(686) * b(71)
         b(74) = b(74) - lu(687) * b(71)
         b(75) = b(75) - lu(688) * b(71)
         b(76) = b(76) - lu(689) * b(71)
                                                                        
         b(73) = b(73) - lu(701) * b(72)
         b(74) = b(74) - lu(702) * b(72)
         b(75) = b(75) - lu(703) * b(72)
         b(76) = b(76) - lu(704) * b(72)
                                                                        
         b(74) = b(74) - lu(721) * b(73)
         b(75) = b(75) - lu(722) * b(73)
         b(76) = b(76) - lu(723) * b(73)
                                                                        
         b(75) = b(75) - lu(739) * b(74)
         b(76) = b(76) - lu(740) * b(74)
                                                                        
         b(76) = b(76) - lu(802) * b(75)
                                                                        
                                                                        
      end subroutine imp_lu_slv02
                                                                        
      subroutine imp_lu_slv03( lu, b )
                                                                        
      use CHEM_MODS_MOD, only : imp_nzcnt, clsze, clscnt4
                                                                        
      implicit none
                                                                        
!-----------------------------------------------------------------------
!       ... Dummy args
!-----------------------------------------------------------------------
      real, intent(in)    ::   lu(imp_nzcnt)
      real, intent(inout) ::   b(clscnt4)
                                                                        
!-----------------------------------------------------------------------
!       ... Local variables
!-----------------------------------------------------------------------
                                                                        
!-----------------------------------------------------------------------
!       ... Solve L * y = b
!-----------------------------------------------------------------------
                                                                        
!-----------------------------------------------------------------------
!       ... Solve U * x = y
!-----------------------------------------------------------------------
         b(76) = b(76) * lu(829)
         b(75) = b(75) - lu(828) * b(76)
         b(74) = b(74) - lu(827) * b(76)
         b(73) = b(73) - lu(826) * b(76)
         b(72) = b(72) - lu(825) * b(76)
         b(71) = b(71) - lu(824) * b(76)
         b(70) = b(70) - lu(823) * b(76)
         b(69) = b(69) - lu(822) * b(76)
         b(68) = b(68) - lu(821) * b(76)
         b(67) = b(67) - lu(820) * b(76)
         b(66) = b(66) - lu(819) * b(76)
         b(65) = b(65) - lu(818) * b(76)
         b(64) = b(64) - lu(817) * b(76)
         b(63) = b(63) - lu(816) * b(76)
         b(62) = b(62) - lu(815) * b(76)
         b(57) = b(57) - lu(814) * b(76)
         b(55) = b(55) - lu(813) * b(76)
         b(53) = b(53) - lu(812) * b(76)
         b(49) = b(49) - lu(811) * b(76)
         b(46) = b(46) - lu(810) * b(76)
         b(39) = b(39) - lu(809) * b(76)
         b(35) = b(35) - lu(808) * b(76)
         b(33) = b(33) - lu(807) * b(76)
         b(29) = b(29) - lu(806) * b(76)
         b(19) = b(19) - lu(805) * b(76)
         b(16) = b(16) - lu(804) * b(76)
         b(14) = b(14) - lu(803) * b(76)
                                                                        
         b(75) = b(75) * lu(801)
         b(74) = b(74) - lu(800) * b(75)
         b(73) = b(73) - lu(799) * b(75)
         b(72) = b(72) - lu(798) * b(75)
         b(71) = b(71) - lu(797) * b(75)
         b(70) = b(70) - lu(796) * b(75)
         b(69) = b(69) - lu(795) * b(75)
         b(68) = b(68) - lu(794) * b(75)
         b(67) = b(67) - lu(793) * b(75)
         b(66) = b(66) - lu(792) * b(75)
         b(65) = b(65) - lu(791) * b(75)
         b(64) = b(64) - lu(790) * b(75)
         b(63) = b(63) - lu(789) * b(75)
         b(62) = b(62) - lu(788) * b(75)
         b(61) = b(61) - lu(787) * b(75)
         b(60) = b(60) - lu(786) * b(75)
         b(59) = b(59) - lu(785) * b(75)
         b(58) = b(58) - lu(784) * b(75)
         b(57) = b(57) - lu(783) * b(75)
         b(56) = b(56) - lu(782) * b(75)
         b(55) = b(55) - lu(781) * b(75)
         b(54) = b(54) - lu(780) * b(75)
         b(53) = b(53) - lu(779) * b(75)
         b(52) = b(52) - lu(778) * b(75)
         b(51) = b(51) - lu(777) * b(75)
         b(50) = b(50) - lu(776) * b(75)
         b(48) = b(48) - lu(775) * b(75)
         b(47) = b(47) - lu(774) * b(75)
         b(45) = b(45) - lu(773) * b(75)
         b(44) = b(44) - lu(772) * b(75)
         b(42) = b(42) - lu(771) * b(75)
         b(41) = b(41) - lu(770) * b(75)
         b(40) = b(40) - lu(769) * b(75)
         b(39) = b(39) - lu(768) * b(75)
         b(37) = b(37) - lu(767) * b(75)
         b(36) = b(36) - lu(766) * b(75)
         b(35) = b(35) - lu(765) * b(75)
         b(34) = b(34) - lu(764) * b(75)
         b(33) = b(33) - lu(763) * b(75)
         b(32) = b(32) - lu(762) * b(75)
         b(31) = b(31) - lu(761) * b(75)
         b(30) = b(30) - lu(760) * b(75)
         b(28) = b(28) - lu(759) * b(75)
         b(27) = b(27) - lu(758) * b(75)
         b(25) = b(25) - lu(757) * b(75)
         b(24) = b(24) - lu(756) * b(75)
         b(23) = b(23) - lu(755) * b(75)
         b(22) = b(22) - lu(754) * b(75)
         b(21) = b(21) - lu(753) * b(75)
         b(20) = b(20) - lu(752) * b(75)
         b(19) = b(19) - lu(751) * b(75)
         b(18) = b(18) - lu(750) * b(75)
         b(17) = b(17) - lu(749) * b(75)
         b(13) = b(13) - lu(748) * b(75)
         b(12) = b(12) - lu(747) * b(75)
         b(10) = b(10) - lu(746) * b(75)
         b(8) = b(8) - lu(745) * b(75)
         b(6) = b(6) - lu(744) * b(75)
         b(5) = b(5) - lu(743) * b(75)
         b(4) = b(4) - lu(742) * b(75)
         b(1) = b(1) - lu(741) * b(75)
                                                                        
         b(74) = b(74) * lu(738)
         b(73) = b(73) - lu(737) * b(74)
         b(72) = b(72) - lu(736) * b(74)
         b(71) = b(71) - lu(735) * b(74)
         b(70) = b(70) - lu(734) * b(74)
         b(69) = b(69) - lu(733) * b(74)
         b(68) = b(68) - lu(732) * b(74)
         b(67) = b(67) - lu(731) * b(74)
         b(66) = b(66) - lu(730) * b(74)
         b(65) = b(65) - lu(729) * b(74)
         b(64) = b(64) - lu(728) * b(74)
         b(57) = b(57) - lu(727) * b(74)
         b(53) = b(53) - lu(726) * b(74)
         b(39) = b(39) - lu(725) * b(74)
         b(27) = b(27) - lu(724) * b(74)
                                                                        
         b(73) = b(73) * lu(720)
         b(72) = b(72) - lu(719) * b(73)
         b(71) = b(71) - lu(718) * b(73)
         b(70) = b(70) - lu(717) * b(73)
         b(69) = b(69) - lu(716) * b(73)
         b(68) = b(68) - lu(715) * b(73)
         b(67) = b(67) - lu(714) * b(73)
         b(66) = b(66) - lu(713) * b(73)
         b(65) = b(65) - lu(712) * b(73)
         b(64) = b(64) - lu(711) * b(73)
         b(57) = b(57) - lu(710) * b(73)
         b(53) = b(53) - lu(709) * b(73)
         b(49) = b(49) - lu(708) * b(73)
         b(39) = b(39) - lu(707) * b(73)
         b(26) = b(26) - lu(706) * b(73)
         b(16) = b(16) - lu(705) * b(73)
                                                                        
         b(72) = b(72) * lu(700)
         b(71) = b(71) - lu(699) * b(72)
         b(70) = b(70) - lu(698) * b(72)
         b(69) = b(69) - lu(697) * b(72)
         b(68) = b(68) - lu(696) * b(72)
         b(67) = b(67) - lu(695) * b(72)
         b(66) = b(66) - lu(694) * b(72)
         b(65) = b(65) - lu(693) * b(72)
         b(64) = b(64) - lu(692) * b(72)
         b(57) = b(57) - lu(691) * b(72)
         b(53) = b(53) - lu(690) * b(72)
                                                                        
         b(71) = b(71) * lu(684)
         b(70) = b(70) - lu(683) * b(71)
         b(69) = b(69) - lu(682) * b(71)
         b(68) = b(68) - lu(681) * b(71)
         b(67) = b(67) - lu(680) * b(71)
         b(66) = b(66) - lu(679) * b(71)
         b(65) = b(65) - lu(678) * b(71)
         b(64) = b(64) - lu(677) * b(71)
         b(63) = b(63) - lu(676) * b(71)
         b(62) = b(62) - lu(675) * b(71)
         b(61) = b(61) - lu(674) * b(71)
         b(60) = b(60) - lu(673) * b(71)
         b(59) = b(59) - lu(672) * b(71)
         b(58) = b(58) - lu(671) * b(71)
         b(57) = b(57) - lu(670) * b(71)
         b(56) = b(56) - lu(669) * b(71)
         b(55) = b(55) - lu(668) * b(71)
         b(53) = b(53) - lu(667) * b(71)
         b(52) = b(52) - lu(666) * b(71)
         b(51) = b(51) - lu(665) * b(71)
         b(49) = b(49) - lu(664) * b(71)
         b(45) = b(45) - lu(663) * b(71)
         b(44) = b(44) - lu(662) * b(71)
         b(43) = b(43) - lu(661) * b(71)
         b(41) = b(41) - lu(660) * b(71)
         b(40) = b(40) - lu(659) * b(71)
         b(38) = b(38) - lu(658) * b(71)
         b(37) = b(37) - lu(657) * b(71)
         b(36) = b(36) - lu(656) * b(71)
         b(32) = b(32) - lu(655) * b(71)
         b(30) = b(30) - lu(654) * b(71)
         b(25) = b(25) - lu(653) * b(71)
         b(24) = b(24) - lu(652) * b(71)
         b(23) = b(23) - lu(651) * b(71)
         b(22) = b(22) - lu(650) * b(71)
         b(21) = b(21) - lu(649) * b(71)
         b(19) = b(19) - lu(648) * b(71)
         b(12) = b(12) - lu(647) * b(71)
         b(10) = b(10) - lu(646) * b(71)
                                                                        
         b(70) = b(70) * lu(639)
         b(69) = b(69) - lu(638) * b(70)
         b(68) = b(68) - lu(637) * b(70)
         b(67) = b(67) - lu(636) * b(70)
         b(66) = b(66) - lu(635) * b(70)
         b(65) = b(65) - lu(634) * b(70)
         b(64) = b(64) - lu(633) * b(70)
         b(63) = b(63) - lu(632) * b(70)
         b(62) = b(62) - lu(631) * b(70)
         b(61) = b(61) - lu(630) * b(70)
         b(60) = b(60) - lu(629) * b(70)
         b(59) = b(59) - lu(628) * b(70)
         b(58) = b(58) - lu(627) * b(70)
         b(57) = b(57) - lu(626) * b(70)
         b(56) = b(56) - lu(625) * b(70)
         b(55) = b(55) - lu(624) * b(70)
         b(54) = b(54) - lu(623) * b(70)
         b(52) = b(52) - lu(622) * b(70)
         b(51) = b(51) - lu(621) * b(70)
         b(45) = b(45) - lu(620) * b(70)
         b(44) = b(44) - lu(619) * b(70)
         b(43) = b(43) - lu(618) * b(70)
         b(42) = b(42) - lu(617) * b(70)
         b(41) = b(41) - lu(616) * b(70)
         b(40) = b(40) - lu(615) * b(70)
         b(37) = b(37) - lu(614) * b(70)
         b(31) = b(31) - lu(613) * b(70)
         b(28) = b(28) - lu(612) * b(70)
         b(14) = b(14) - lu(611) * b(70)
         b(11) = b(11) - lu(610) * b(70)
                                                                        
         b(69) = b(69) * lu(602)
         b(68) = b(68) - lu(601) * b(69)
         b(67) = b(67) - lu(600) * b(69)
         b(66) = b(66) - lu(599) * b(69)
         b(65) = b(65) - lu(598) * b(69)
         b(64) = b(64) - lu(597) * b(69)
         b(57) = b(57) - lu(596) * b(69)
         b(53) = b(53) - lu(595) * b(69)
         b(49) = b(49) - lu(594) * b(69)
         b(46) = b(46) - lu(593) * b(69)
         b(39) = b(39) - lu(592) * b(69)
         b(38) = b(38) - lu(591) * b(69)
         b(29) = b(29) - lu(590) * b(69)
         b(26) = b(26) - lu(589) * b(69)
         b(9) = b(9) - lu(588) * b(69)
                                                                        
                                                                        
      end subroutine imp_lu_slv03
                                                                        
      subroutine imp_lu_slv04( lu, b )
                                                                        
      use CHEM_MODS_MOD, only : imp_nzcnt, clsze, clscnt4
                                                                        
      implicit none
                                                                        
!-----------------------------------------------------------------------
!       ... Dummy args
!-----------------------------------------------------------------------
      real, intent(in)    ::   lu(imp_nzcnt)
      real, intent(inout) ::   b(clscnt4)
                                                                        
!-----------------------------------------------------------------------
!       ... Local variables
!-----------------------------------------------------------------------
                                                                        
!-----------------------------------------------------------------------
!       ... Solve L * y = b
!-----------------------------------------------------------------------
         b(68) = b(68) * lu(579)
         b(67) = b(67) - lu(578) * b(68)
         b(66) = b(66) - lu(577) * b(68)
         b(65) = b(65) - lu(576) * b(68)
         b(64) = b(64) - lu(575) * b(68)
         b(57) = b(57) - lu(574) * b(68)
         b(53) = b(53) - lu(573) * b(68)
         b(49) = b(49) - lu(572) * b(68)
         b(46) = b(46) - lu(571) * b(68)
         b(27) = b(27) - lu(570) * b(68)
                                                                        
         b(67) = b(67) * lu(560)
         b(66) = b(66) - lu(559) * b(67)
         b(65) = b(65) - lu(558) * b(67)
         b(64) = b(64) - lu(557) * b(67)
         b(63) = b(63) - lu(556) * b(67)
         b(62) = b(62) - lu(555) * b(67)
         b(61) = b(61) - lu(554) * b(67)
         b(60) = b(60) - lu(553) * b(67)
         b(59) = b(59) - lu(552) * b(67)
         b(58) = b(58) - lu(551) * b(67)
         b(57) = b(57) - lu(550) * b(67)
         b(56) = b(56) - lu(549) * b(67)
         b(55) = b(55) - lu(548) * b(67)
         b(54) = b(54) - lu(547) * b(67)
         b(52) = b(52) - lu(546) * b(67)
         b(51) = b(51) - lu(545) * b(67)
         b(50) = b(50) - lu(544) * b(67)
         b(48) = b(48) - lu(543) * b(67)
         b(47) = b(47) - lu(542) * b(67)
         b(42) = b(42) - lu(541) * b(67)
         b(31) = b(31) - lu(540) * b(67)
         b(28) = b(28) - lu(539) * b(67)
         b(27) = b(27) - lu(538) * b(67)
         b(20) = b(20) - lu(537) * b(67)
         b(15) = b(15) - lu(536) * b(67)
                                                                        
         b(66) = b(66) * lu(525)
         b(65) = b(65) - lu(524) * b(66)
         b(64) = b(64) - lu(523) * b(66)
         b(57) = b(57) - lu(522) * b(66)
         b(53) = b(53) - lu(521) * b(66)
         b(46) = b(46) - lu(520) * b(66)
         b(38) = b(38) - lu(519) * b(66)
         b(26) = b(26) - lu(518) * b(66)
         b(7) = b(7) - lu(517) * b(66)
                                                                        
         b(65) = b(65) * lu(507)
         b(64) = b(64) - lu(506) * b(65)
         b(63) = b(63) - lu(505) * b(65)
         b(62) = b(62) - lu(504) * b(65)
         b(61) = b(61) - lu(503) * b(65)
         b(60) = b(60) - lu(502) * b(65)
         b(59) = b(59) - lu(501) * b(65)
         b(58) = b(58) - lu(500) * b(65)
         b(57) = b(57) - lu(499) * b(65)
         b(56) = b(56) - lu(498) * b(65)
         b(55) = b(55) - lu(497) * b(65)
         b(54) = b(54) - lu(496) * b(65)
         b(52) = b(52) - lu(495) * b(65)
         b(51) = b(51) - lu(494) * b(65)
         b(50) = b(50) - lu(493) * b(65)
         b(48) = b(48) - lu(492) * b(65)
         b(47) = b(47) - lu(491) * b(65)
         b(43) = b(43) - lu(490) * b(65)
         b(42) = b(42) - lu(489) * b(65)
         b(39) = b(39) - lu(488) * b(65)
         b(31) = b(31) - lu(487) * b(65)
         b(29) = b(29) - lu(486) * b(65)
         b(17) = b(17) - lu(485) * b(65)
         b(13) = b(13) - lu(484) * b(65)
         b(8) = b(8) - lu(483) * b(65)
                                                                        
         b(64) = b(64) * lu(475)
         b(63) = b(63) - lu(474) * b(64)
         b(62) = b(62) - lu(473) * b(64)
         b(61) = b(61) - lu(472) * b(64)
         b(60) = b(60) - lu(471) * b(64)
         b(59) = b(59) - lu(470) * b(64)
         b(58) = b(58) - lu(469) * b(64)
         b(56) = b(56) - lu(468) * b(64)
         b(55) = b(55) - lu(467) * b(64)
         b(54) = b(54) - lu(466) * b(64)
         b(51) = b(51) - lu(465) * b(64)
         b(45) = b(45) - lu(464) * b(64)
         b(44) = b(44) - lu(463) * b(64)
         b(42) = b(42) - lu(462) * b(64)
         b(40) = b(40) - lu(461) * b(64)
         b(37) = b(37) - lu(460) * b(64)
         b(34) = b(34) - lu(459) * b(64)
         b(31) = b(31) - lu(458) * b(64)
         b(25) = b(25) - lu(457) * b(64)
         b(18) = b(18) - lu(456) * b(64)
                                                                        
         b(63) = b(63) * lu(447)
         b(62) = b(62) - lu(446) * b(63)
         b(55) = b(55) - lu(445) * b(63)
         b(35) = b(35) - lu(444) * b(63)
         b(30) = b(30) - lu(443) * b(63)
                                                                        
         b(62) = b(62) * lu(433)
         b(61) = b(61) - lu(432) * b(62)
         b(60) = b(60) - lu(431) * b(62)
         b(59) = b(59) - lu(430) * b(62)
         b(58) = b(58) - lu(429) * b(62)
         b(56) = b(56) - lu(428) * b(62)
         b(55) = b(55) - lu(427) * b(62)
         b(54) = b(54) - lu(426) * b(62)
         b(42) = b(42) - lu(425) * b(62)
         b(33) = b(33) - lu(424) * b(62)
         b(31) = b(31) - lu(423) * b(62)
         b(30) = b(30) - lu(422) * b(62)
                                                                        
         b(61) = b(61) * lu(411)
         b(59) = b(59) - lu(410) * b(61)
         b(55) = b(55) - lu(409) * b(61)
         b(54) = b(54) - lu(408) * b(61)
         b(52) = b(52) - lu(407) * b(61)
         b(42) = b(42) - lu(406) * b(61)
         b(34) = b(34) - lu(405) * b(61)
         b(21) = b(21) - lu(404) * b(61)
                                                                        
         b(60) = b(60) * lu(392)
         b(59) = b(59) - lu(391) * b(60)
         b(58) = b(58) - lu(390) * b(60)
         b(56) = b(56) - lu(389) * b(60)
         b(52) = b(52) - lu(388) * b(60)
         b(36) = b(36) - lu(387) * b(60)
         b(34) = b(34) - lu(386) * b(60)
         b(31) = b(31) - lu(385) * b(60)
                                                                        
         b(59) = b(59) * lu(375)
         b(55) = b(55) - lu(374) * b(59)
         b(54) = b(54) - lu(373) * b(59)
         b(42) = b(42) - lu(372) * b(59)
         b(34) = b(34) - lu(371) * b(59)
         b(12) = b(12) - lu(370) * b(59)
                                                                        
         b(58) = b(58) * lu(359)
         b(55) = b(55) - lu(358) * b(58)
         b(54) = b(54) - lu(357) * b(58)
         b(51) = b(51) - lu(356) * b(58)
         b(50) = b(50) - lu(355) * b(58)
                                                                        
         b(57) = b(57) * lu(348)
                                                                        
         b(56) = b(56) * lu(338)
         b(54) = b(54) - lu(337) * b(56)
                                                                        
         b(55) = b(55) * lu(330)
         b(54) = b(54) - lu(329) * b(55)
                                                                        
         b(54) = b(54) * lu(323)
         b(39) = b(39) - lu(322) * b(54)
                                                                        
         b(53) = b(53) * lu(315)
         b(49) = b(49) - lu(314) * b(53)
         b(38) = b(38) - lu(313) * b(53)
         b(26) = b(26) - lu(312) * b(53)
                                                                        
         b(52) = b(52) * lu(304)
         b(31) = b(31) - lu(303) * b(52)
                                                                        
         b(51) = b(51) * lu(296)
         b(39) = b(39) - lu(295) * b(51)
                                                                        
         b(50) = b(50) * lu(283)
         b(41) = b(41) - lu(282) * b(50)
         b(17) = b(17) - lu(281) * b(50)
                                                                        
         b(49) = b(49) * lu(273)
         b(26) = b(26) - lu(272) * b(49)
                                                                        
         b(48) = b(48) * lu(257)
         b(44) = b(44) - lu(256) * b(48)
         b(37) = b(37) - lu(255) * b(48)
                                                                        
         b(47) = b(47) * lu(241)
         b(43) = b(43) - lu(240) * b(47)
                                                                        
         b(46) = b(46) * lu(230)
         b(39) = b(39) - lu(229) * b(46)
         b(38) = b(38) - lu(228) * b(46)
         b(9) = b(9) - lu(227) * b(46)
                                                                        
         b(45) = b(45) * lu(218)
         b(44) = b(44) - lu(217) * b(45)
         b(37) = b(37) - lu(216) * b(45)
         b(23) = b(23) - lu(215) * b(45)
                                                                        
         b(44) = b(44) * lu(208)
         b(24) = b(24) - lu(207) * b(44)
                                                                        
         b(43) = b(43) * lu(198)
                                                                        
         b(42) = b(42) * lu(193)
                                                                        
         b(41) = b(41) * lu(185)
         b(32) = b(32) - lu(184) * b(41)
                                                                        
         b(40) = b(40) * lu(176)
         b(34) = b(34) - lu(175) * b(40)
         b(22) = b(22) - lu(174) * b(40)
         b(18) = b(18) - lu(173) * b(40)
                                                                        
         b(39) = b(39) * lu(169)
                                                                        
         b(38) = b(38) * lu(163)
         b(26) = b(26) - lu(162) * b(38)
         b(9) = b(9) - lu(161) * b(38)
                                                                        
         b(37) = b(37) * lu(156)
                                                                        
         b(36) = b(36) * lu(148)
                                                                        
         b(35) = b(35) * lu(140)
                                                                        
         b(34) = b(34) * lu(136)
                                                                        
         b(33) = b(33) * lu(129)
                                                                        
         b(32) = b(32) * lu(122)
                                                                        
         b(31) = b(31) * lu(119)
                                                                        
         b(30) = b(30) * lu(114)
                                                                        
         b(29) = b(29) * lu(108)
                                                                        
         b(28) = b(28) * lu(102)
         b(11) = b(11) - lu(101) * b(28)
                                                                        
         b(27) = b(27) * lu(97)
                                                                        
         b(26) = b(26) * lu(94)
                                                                        
         b(25) = b(25) * lu(89)
                                                                        
         b(24) = b(24) * lu(84)
                                                                        
         b(23) = b(23) * lu(79)
                                                                        
         b(22) = b(22) * lu(74)
                                                                        
         b(21) = b(21) * lu(69)
                                                                        
         b(20) = b(20) * lu(63)
                                                                        
         b(19) = b(19) * lu(59)
                                                                        
         b(18) = b(18) * lu(55)
                                                                        
                                                                        
      end subroutine imp_lu_slv04
                                                                        
      subroutine imp_lu_slv05( lu, b )
                                                                        
      use CHEM_MODS_MOD, only : imp_nzcnt, clsze, clscnt4
                                                                        
      implicit none
                                                                        
!-----------------------------------------------------------------------
!       ... Dummy args
!-----------------------------------------------------------------------
      real, intent(in)    ::   lu(imp_nzcnt)
      real, intent(inout) ::   b(clscnt4)
                                                                        
!-----------------------------------------------------------------------
!       ... Local variables
!-----------------------------------------------------------------------
                                                                        
!-----------------------------------------------------------------------
!       ... Solve L * y = b
!-----------------------------------------------------------------------
         b(17) = b(17) * lu(51)
                                                                        
         b(16) = b(16) * lu(46)
                                                                        
         b(15) = b(15) * lu(38)
                                                                        
         b(14) = b(14) * lu(34)
                                                                        
         b(13) = b(13) * lu(30)
         b(8) = b(8) - lu(29) * b(13)
                                                                        
         b(12) = b(12) * lu(26)
                                                                        
         b(11) = b(11) * lu(22)
                                                                        
         b(10) = b(10) * lu(19)
                                                                        
         b(9) = b(9) * lu(17)
                                                                        
         b(8) = b(8) * lu(15)
         b(1) = b(1) - lu(14) * b(8)
                                                                        
         b(7) = b(7) * lu(11)
                                                                        
         b(6) = b(6) * lu(8)
                                                                        
         b(5) = b(5) * lu(6)
         b(3) = b(3) - lu(5) * b(5)
                                                                        
         b(4) = b(4) * lu(4)
                                                                        
         b(3) = b(3) * lu(3)
                                                                        
         b(2) = b(2) * lu(2)
                                                                        
         b(1) = b(1) * lu(1)
                                                                        
                                                                        
      end subroutine imp_lu_slv05
                                                                        
      subroutine imp_lu_slv( lu, b )
                                                                        
      use CHEM_MODS_MOD, only : imp_nzcnt, clsze, clscnt4
                                                                        
      implicit none
                                                                        
!-----------------------------------------------------------------------
!       ... Dummy args
!-----------------------------------------------------------------------
      real, intent(in)    ::   lu(imp_nzcnt)
      real, intent(inout) ::   b(clscnt4)
                                                                        
      call imp_lu_slv01( lu, b )
      call imp_lu_slv02( lu, b )
      call imp_lu_slv03( lu, b )
      call imp_lu_slv04( lu, b )
      call imp_lu_slv05( lu, b )
                                                                        
      end subroutine imp_lu_slv
                                                                        
      end module MO_IMP_SOLVE_MOD

      module MO_ROD_SOLVE_MOD

      contains
                                                                        
      subroutine rod_lu_slv( lu, b )
                                                                        
      use CHEM_MODS_MOD, only : rod_nzcnt, clsze, clscnt5
                                                                        
      implicit none
                                                                        
!-----------------------------------------------------------------------
!       ... Dummy args
!-----------------------------------------------------------------------
      real, intent(in)    ::   lu(rod_nzcnt)
      real, intent(inout) ::   b(clscnt5)
                                                                        
                                                                        
      end subroutine rod_lu_slv
                                                                        
      end module MO_ROD_SOLVE_MOD
